/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.nio.ByteBuffer;
import org.limewire.nio.DirectByteBufferCache;
import org.limewire.nio.HeapByteBufferCache;

public class ByteBufferCache {
    private final DirectByteBufferCache DIRECT = new DirectByteBufferCache();
    private final HeapByteBufferCache HEAP = new HeapByteBufferCache();

    public ByteBuffer getDirect() {
        return this.DIRECT.get();
    }

    public ByteBuffer getHeap() {
        return this.HEAP.get();
    }

    public ByteBuffer getHeap(int n) {
        return this.HEAP.get(n);
    }

    public long getHeapCacheSize() {
        return this.HEAP.getByteSize();
    }

    public void release(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            this.DIRECT.put(byteBuffer);
        } else {
            this.HEAP.put(byteBuffer);
        }
    }

    public void clearCache() {
        this.DIRECT.clear();
        this.HEAP.clear();
    }
}

