/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static Log LOG = LogFactory.getLog(XMLUtils.class);

    private XMLUtils() {
    }

    public static Document getDocument(String string) throws IOException {
        return XMLUtils.getDocument(string, null, new LogErrorHandler(LOG));
    }

    public static Document getDocument(String string, Log log) throws IOException {
        return XMLUtils.getDocument(string, null, new LogErrorHandler(log));
    }

    public static Document getDocument(String string, ErrorHandler errorHandler) throws IOException {
        return XMLUtils.getDocument(string, null, errorHandler);
    }

    public static Document getDocument(String string, EntityResolver entityResolver, ErrorHandler errorHandler) throws IOException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            if (entityResolver != null) {
                documentBuilder.setEntityResolver(entityResolver);
            }
            documentBuilder.setErrorHandler(errorHandler);
            return documentBuilder.parse(inputSource);
        }
        catch (IOException iOException) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Unable to parse: " + string), (Throwable)iOException);
            }
            throw iOException;
        }
        catch (SAXException sAXException) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Unable to parse: " + string), (Throwable)sAXException);
            }
            throw (IOException)new IOException().initCause(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOG.error((Object)"Unable to create parser", (Throwable)parserConfigurationException);
            throw (IOException)new IOException().initCause(parserConfigurationException);
        }
    }

    public static class LogErrorHandler
    implements ErrorHandler {
        private final Log log;

        public LogErrorHandler(Log log) {
            this.log = log;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.log.error((Object)"Parse error", (Throwable)sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.log.error((Object)"Parse fatal error", (Throwable)sAXParseException);
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.log.error((Object)"Parse warning", (Throwable)sAXParseException);
        }
    }
}

