/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.listener.BlockingEvent;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.ExceptionUtils;
import org.limewire.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerList<E>
implements ListenerSupport<E>,
EventBroadcaster<E> {
    private final List<ListenerProxy<E>> listenerList = new CopyOnWriteArrayList<ListenerProxy<E>>();
    private final Log log;
    private final EventListenerListContext context;

    public EventListenerList() {
        this(null, new EventListenerListContext());
    }

    public EventListenerList(Class clazz) {
        this(LogFactory.getLog(clazz), new EventListenerListContext());
    }

    public EventListenerList(Log log) {
        this(log, new EventListenerListContext());
    }

    public EventListenerList(EventListenerListContext eventListenerListContext) {
        this(null, eventListenerListContext);
    }

    public EventListenerList(Log log, EventListenerListContext eventListenerListContext) {
        this.log = log;
        this.context = eventListenerListContext;
    }

    public static <E> void dispatch(EventListener<E> eventListener, E e, EventListenerListContext eventListenerListContext) {
        ListenerProxy<E> listenerProxy = new ListenerProxy<E>(null, Objects.nonNull(eventListener, "listener"), eventListenerListContext);
        listenerProxy.handleEvent(e);
    }

    public EventListenerListContext getContext() {
        return this.context;
    }

    @Override
    public void addListener(EventListener<E> eventListener) {
        if (this.log != null) {
            this.log.debugf("adding listener {0} to {1}", (Object)eventListener, (Object)this);
        }
        this.listenerList.add(new ListenerProxy<E>(this.log, Objects.nonNull(eventListener, "listener"), this.context));
    }

    @Override
    public boolean removeListener(EventListener<E> eventListener) {
        if (this.log != null) {
            this.log.debugf("removing listener {0} from {1}", (Object)eventListener, (Object)this);
        }
        Objects.nonNull(eventListener, "listener");
        for (ListenerProxy<E> listenerProxy : this.listenerList) {
            if (!((ListenerProxy)listenerProxy).delegate.equals(eventListener)) continue;
            return this.listenerList.remove(listenerProxy);
        }
        return false;
    }

    public void dispatch(EventListener<E> eventListener, E e) {
        EventListenerList.dispatch(eventListener, e, this.context);
    }

    @Override
    public void broadcast(E e) {
        Objects.nonNull(e, "event");
        if (this.log != null) {
            this.log.debugf("broadcasting event {0} from {1}", (Object)e, (Object)this);
        }
        Throwable throwable = null;
        for (ListenerProxy<E> listenerProxy : this.listenerList) {
            try {
                listenerProxy.handleEvent(e);
            }
            catch (Throwable throwable2) {
                Throwable throwable3;
                if (this.log != null) {
                    this.log.error("error dispatching " + e, throwable2);
                }
                if ((throwable3 = ExceptionUtils.reportOrReturn(throwable2)) == null || throwable != null) continue;
                throwable = throwable3;
            }
        }
        if (throwable != null) {
            ExceptionUtils.reportOrRethrow(throwable);
        }
    }

    public int size() {
        return this.listenerList.size();
    }

    public static final class EventListenerListContext {
        private final AtomicReference<ConcurrentMap<String, Executor>> eventExecutorsRef = new AtomicReference();

        private Executor getOrCreateExecutor(String string) {
            if (string != null && !string.equals("")) {
                Executor executor;
                ConcurrentMap<String, Executor> concurrentMap = this.eventExecutorsRef.get();
                if (concurrentMap == null) {
                    this.eventExecutorsRef.compareAndSet(null, new ConcurrentHashMap());
                    concurrentMap = this.eventExecutorsRef.get();
                }
                if ((executor = (Executor)concurrentMap.get(string)) == null) {
                    concurrentMap.putIfAbsent(string, ExecutorsHelper.newProcessingQueue("BlockingEventQueue-" + string));
                    executor = (Executor)concurrentMap.get(string);
                }
                return executor;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutorDispatchStrategy
    extends DispatchStrategy {
        private final Executor executor;

        public ExecutorDispatchStrategy(Executor executor) {
            this.executor = executor;
        }

        @Override
        <E> void dispatch(final EventListener<E> eventListener, final E e) {
            Runnable runnable = new Runnable(){

                public void run() {
                    eventListener.handleEvent(e);
                }
            };
            this.executor.execute(runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DispatchStrategy {
        public static DispatchStrategy UNKNOWN = new DispatchStrategy(){

            @Override
            <E> void dispatch(EventListener<E> eventListener, E e) {
                throw new IllegalStateException("unknown dispatch!");
            }
        };
        public static DispatchStrategy INLINE = new DispatchStrategy(){

            @Override
            <E> void dispatch(EventListener<E> eventListener, E e) {
                eventListener.handleEvent(e);
            }
        };
        public static DispatchStrategy SWING = new DispatchStrategy(){

            @Override
            <E> void dispatch(final EventListener<E> eventListener, final E e) {
                if (EventQueue.isDispatchThread()) {
                    eventListener.handleEvent(e);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            eventListener.handleEvent(e);
                        }
                    });
                }
            }
        };
        public static DispatchStrategy NEW_THREAD = new DispatchStrategy(){

            @Override
            <E> void dispatch(final EventListener<E> eventListener, final E e) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        eventListener.handleEvent(e);
                    }
                };
                ThreadExecutor.startThread(runnable, "BlockingEvent");
            }
        };

        private DispatchStrategy() {
        }

        abstract <E> void dispatch(EventListener<E> var1, E var2);

        public static DispatchStrategy getBlockingStrategy(EventListenerListContext eventListenerListContext, BlockingEvent blockingEvent) {
            if (eventListenerListContext == null) {
                return NEW_THREAD;
            }
            Executor executor = eventListenerListContext.getOrCreateExecutor(blockingEvent.queueName());
            if (executor == null) {
                return NEW_THREAD;
            }
            return new ExecutorDispatchStrategy(executor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListenerProxy<E>
    implements EventListener<E> {
        private final Log log;
        private final EventListener<E> delegate;
        private final EventListenerListContext context;
        private volatile DispatchStrategy strategy = DispatchStrategy.UNKNOWN;

        public ListenerProxy(Log log, EventListener<E> eventListener, EventListenerListContext eventListenerListContext) {
            this.log = log;
            this.delegate = eventListener;
            this.context = eventListenerListContext;
        }

        @Override
        public void handleEvent(E e) {
            if (this.strategy == DispatchStrategy.UNKNOWN) {
                this.strategy = this.analyze(this.delegate, e);
            }
            if (this.log != null) {
                this.log.tracef("Dispatching event {0} to {1} with strategy {2}", (Object)e, (Object)this.delegate, (Object)this.strategy);
            }
            this.strategy.dispatch(this.delegate, e);
        }

        private DispatchStrategy analyze(EventListener<E> eventListener, E e) {
            Method method = null;
            for (Class<?> clazz = e.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    method = eventListener.getClass().getMethod("handleEvent", clazz);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (method == null) {
                throw new IllegalStateException("Unable to find method!");
            }
            if (method.getAnnotation(SwingEDTEvent.class) != null) {
                return DispatchStrategy.SWING;
            }
            BlockingEvent blockingEvent = method.getAnnotation(BlockingEvent.class);
            if (blockingEvent != null) {
                return DispatchStrategy.getBlockingStrategy(this.context, blockingEvent);
            }
            return DispatchStrategy.INLINE;
        }
    }
}

