/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.util.concurrent.Executor;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.EventMulticaster;
import org.limewire.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousMulticaster<E>
implements EventMulticaster<E> {
    private final EventListenerList<E> listeners;
    private final Executor executor;

    public AsynchronousMulticaster(Executor executor) {
        this.listeners = new EventListenerList();
        this.executor = executor;
    }

    public AsynchronousMulticaster(Executor executor, Class clazz) {
        this.listeners = new EventListenerList(clazz);
        this.executor = executor;
    }

    public AsynchronousMulticaster(Executor executor, Log log) {
        this.listeners = new EventListenerList(log);
        this.executor = executor;
    }

    @Override
    public void addListener(EventListener<E> eventListener) {
        this.listeners.addListener(eventListener);
    }

    @Override
    public boolean removeListener(EventListener<E> eventListener) {
        return this.listeners.removeListener(eventListener);
    }

    @Override
    public void handleEvent(E e) {
        this.broadcast(e);
    }

    @Override
    public void broadcast(final E e) {
        this.executor.execute(new Runnable(){

            public void run() {
                AsynchronousMulticaster.this.listeners.broadcast(e);
            }
        });
    }

    @Override
    public EventListenerList.EventListenerListContext getListenerContext() {
        return this.listeners.getContext();
    }
}

