/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentNodeImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleXMLParserDocumentImpl
implements SimpleXMLParserDocument {
    private static DocumentBuilderFactory dbf_singleton;
    protected Document document;
    protected SimpleXMLParserDocumentNodeImpl root_node;

    public SimpleXMLParserDocumentImpl(File file) throws SimpleXMLParserDocumentException {
        try {
            this.create(new FileInputStream(file));
        }
        catch (Throwable throwable) {
            throw new SimpleXMLParserDocumentException(throwable);
        }
    }

    public SimpleXMLParserDocumentImpl(String string) throws SimpleXMLParserDocumentException {
        try {
            this.create(new ByteArrayInputStream(string.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public SimpleXMLParserDocumentImpl(InputStream inputStream) throws SimpleXMLParserDocumentException {
        this.create(inputStream);
    }

    protected static synchronized DocumentBuilderFactory getDBF() {
        if (dbf_singleton == null) {
            dbf_singleton = DocumentBuilderFactory.newInstance();
            dbf_singleton.setNamespaceAware(true);
            dbf_singleton.setValidating(false);
            dbf_singleton.setIgnoringComments(true);
            dbf_singleton.setIgnoringElementContentWhitespace(true);
            dbf_singleton.setCoalescing(true);
            dbf_singleton.setExpandEntityReferences(true);
        }
        return dbf_singleton;
    }

    protected void create(InputStream inputStream) throws SimpleXMLParserDocumentException {
        try {
            DocumentBuilderFactory documentBuilderFactory = SimpleXMLParserDocumentImpl.getDBF();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.err);
            MyErrorHandler myErrorHandler = new MyErrorHandler(new PrintWriter((Writer)outputStreamWriter, true));
            documentBuilder.setErrorHandler(myErrorHandler);
            this.document = documentBuilder.parse(inputStream);
            SimpleXMLParserDocumentNodeImpl[] simpleXMLParserDocumentNodeImplArray = this.parseNode(this.document, false);
            int n = 0;
            for (int i = 0; i < simpleXMLParserDocumentNodeImplArray.length; ++i) {
                SimpleXMLParserDocumentNodeImpl simpleXMLParserDocumentNodeImpl = simpleXMLParserDocumentNodeImplArray[i];
                if (simpleXMLParserDocumentNodeImpl.getNode().getNodeType() == 7) continue;
                this.root_node = simpleXMLParserDocumentNodeImpl;
                ++n;
            }
            if (n != 1) {
                throw new SimpleXMLParserDocumentException("invalid document - " + simpleXMLParserDocumentNodeImplArray.length + " root elements");
            }
        }
        catch (Throwable throwable) {
            throw new SimpleXMLParserDocumentException(throwable);
        }
    }

    public String getName() {
        return this.root_node.getName();
    }

    public String getFullName() {
        return this.root_node.getFullName();
    }

    public String getNameSpaceURI() {
        return this.root_node.getNameSpaceURI();
    }

    public String getValue() {
        return this.root_node.getValue();
    }

    public SimpleXMLParserDocumentNode[] getChildren() {
        return this.root_node.getChildren();
    }

    public SimpleXMLParserDocumentNode getChild(String string) {
        return this.root_node.getChild(string);
    }

    public SimpleXMLParserDocumentAttribute[] getAttributes() {
        return this.root_node.getAttributes();
    }

    public SimpleXMLParserDocumentAttribute getAttribute(String string) {
        return this.root_node.getAttribute(string);
    }

    public void print() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.print(printWriter);
        printWriter.flush();
    }

    public void print(PrintWriter printWriter) {
        this.root_node.print(printWriter, "");
    }

    protected SimpleXMLParserDocumentNodeImpl[] parseNode(Node node, boolean bl) {
        Object object;
        short s = node.getNodeType();
        if (!(s != 1 && s != 7 || bl)) {
            return new SimpleXMLParserDocumentNodeImpl[]{new SimpleXMLParserDocumentNodeImpl(this, node)};
        }
        Vector<SimpleXMLParserDocumentNodeImpl> vector = new Vector<SimpleXMLParserDocumentNodeImpl>();
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            SimpleXMLParserDocumentNodeImpl[] simpleXMLParserDocumentNodeImplArray = this.parseNode((Node)object, false);
            for (int i = 0; i < simpleXMLParserDocumentNodeImplArray.length; ++i) {
                vector.addElement(simpleXMLParserDocumentNodeImplArray[i]);
            }
        }
        object = new SimpleXMLParserDocumentNodeImpl[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer(1024);
            FileInputStream fileInputStream = new FileInputStream("C:\\temp\\upnp_trace3.log");
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            while ((string = lineNumberReader.readLine()) != null) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c < ' ') {
                        stringBuffer.append(' ');
                        continue;
                    }
                    stringBuffer.append(c);
                }
                stringBuffer.append("\n");
            }
            string = stringBuffer.toString();
            new SimpleXMLParserDocumentImpl(string).print();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler(PrintWriter printWriter) {
        }

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string, sAXParseException);
        }
    }
}

