/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderTimeoutImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    protected ResourceDownloaderBaseImpl delegate;
    protected int timeout_millis;
    protected boolean cancelled;
    protected ResourceDownloaderBaseImpl current_downloader;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTimeout");
    protected long size = -2L;

    public ResourceDownloaderTimeoutImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, ResourceDownloader resourceDownloader, int n) {
        super(resourceDownloaderBaseImpl);
        this.delegate = (ResourceDownloaderBaseImpl)resourceDownloader;
        this.delegate.setParent(this);
        this.timeout_millis = n;
    }

    public String getName() {
        return this.delegate.getName() + ": timeout=" + this.timeout_millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size != -2L) {
            return this.size;
        }
        try {
            ResourceDownloaderTimeoutImpl resourceDownloaderTimeoutImpl = new ResourceDownloaderTimeoutImpl(this.getParent(), this.delegate.getClone(this), this.timeout_millis);
            this.addReportListener(resourceDownloaderTimeoutImpl);
            this.size = resourceDownloaderTimeoutImpl.getSizeSupport();
            this.setProperties(resourceDownloaderTimeoutImpl);
            Object var3_2 = null;
            if (this.size == -2L) {
                this.size = -1L;
            }
            this.setSize(this.size);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.size == -2L) {
                this.size = -1L;
            }
            this.setSize(this.size);
            throw throwable;
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    public void setProperty(String string, Object object) throws ResourceDownloaderException {
        this.setPropertySupport(string, object);
        this.delegate.setProperty(string, object);
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloaderTimeoutImpl resourceDownloaderTimeoutImpl = new ResourceDownloaderTimeoutImpl(this.getParent(), this.delegate.getClone(resourceDownloaderBaseImpl), this.timeout_millis);
        resourceDownloaderTimeoutImpl.setSize(this.size);
        resourceDownloaderTimeoutImpl.setProperties(this);
        return resourceDownloaderTimeoutImpl;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (!this.cancelled) {
                this.current_downloader = this.delegate.getClone(this);
                this.informActivity(this.getLogIndent() + "Downloading: " + this.getName());
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
                AEThread aEThread = new AEThread("ResourceDownloaderTimeout"){

                    public void runSupport() {
                        try {
                            Thread.sleep(ResourceDownloaderTimeoutImpl.this.timeout_millis);
                            ResourceDownloaderTimeoutImpl.this.cancel(new ResourceDownloaderException(ResourceDownloaderTimeoutImpl.this, "Download timeout"));
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                };
                aEThread.setDaemon(true);
                aEThread.start();
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected long getSizeSupport() throws ResourceDownloaderException {
        this.asyncGetSize();
        this.done_sem.reserve();
        if (this.result instanceof Long) {
            return (Long)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncGetSize() {
        try {
            this.this_mon.enter();
            if (!this.cancelled) {
                this.current_downloader = this.delegate.getClone(this);
                AEThread aEThread = new AEThread("ResourceDownloader:size getter"){

                    public void runSupport() {
                        try {
                            long l = ResourceDownloaderTimeoutImpl.this.current_downloader.getSize();
                            ResourceDownloaderTimeoutImpl.this.result = new Long(l);
                            ResourceDownloaderTimeoutImpl.this.setProperties(ResourceDownloaderTimeoutImpl.this.current_downloader);
                            ResourceDownloaderTimeoutImpl.this.done_sem.release();
                        }
                        catch (ResourceDownloaderException resourceDownloaderException) {
                            ResourceDownloaderTimeoutImpl.this.failed(ResourceDownloaderTimeoutImpl.this.current_downloader, resourceDownloaderException);
                        }
                    }
                };
                aEThread.setDaemon(true);
                aEThread.start();
                AEThread aEThread2 = new AEThread("ResourceDownloaderTimeout"){

                    public void runSupport() {
                        try {
                            Thread.sleep(ResourceDownloaderTimeoutImpl.this.timeout_millis);
                            ResourceDownloaderTimeoutImpl.this.cancel(new ResourceDownloaderException(ResourceDownloaderTimeoutImpl.this, "getSize timeout"));
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                };
                aEThread2.setDaemon(true);
                aEThread2.start();
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void cancel() {
        this.cancel(new ResourceDownloaderCancelledException(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(ResourceDownloaderException resourceDownloaderException) {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = resourceDownloaderException;
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        if (this.informComplete(inputStream)) {
            this.result = inputStream;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.result = resourceDownloaderException;
        this.done_sem.release();
        this.informFailed(resourceDownloaderException);
    }
}

