/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateCheckerListener;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateProgressListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;

public class UpdateCheckerImpl
implements UpdateChecker {
    protected UpdateCheckInstanceImpl check_instance;
    protected UpdatableComponentImpl component;
    protected AESemaphore semaphore;
    protected boolean completed;
    protected boolean failed;
    protected boolean cancelled;
    protected boolean sem_released;
    protected List listeners = new ArrayList();
    protected List progress_listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("UpdateChecker");

    protected UpdateCheckerImpl(UpdateCheckInstanceImpl updateCheckInstanceImpl, UpdatableComponentImpl updatableComponentImpl, AESemaphore aESemaphore) {
        this.check_instance = updateCheckInstanceImpl;
        this.component = updatableComponentImpl;
        this.semaphore = aESemaphore;
    }

    public UpdateCheckInstance getCheckInstance() {
        return this.check_instance;
    }

    public Update addUpdate(String string, String[] stringArray, String string2, ResourceDownloader resourceDownloader, int n) {
        return this.addUpdate(string, stringArray, string2, new ResourceDownloader[]{resourceDownloader}, n);
    }

    public Update addUpdate(String string, String[] stringArray, String string2, ResourceDownloader[] resourceDownloaderArray, int n) {
        this.reportProgress("Adding update: " + string);
        return this.check_instance.addUpdate(this.component, string, stringArray, string2, resourceDownloaderArray, n);
    }

    public UpdateInstaller createInstaller() throws UpdateException {
        return this.check_instance.createInstaller();
    }

    public UpdatableComponent getComponent() {
        return this.component.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed() {
        try {
            this.this_mon.enter();
            if (!this.sem_released) {
                this.completed = true;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        ((UpdateCheckerListener)this.listeners.get(i)).completed(this);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                this.sem_released = true;
                this.semaphore.release();
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed() {
        try {
            this.this_mon.enter();
            if (!this.sem_released) {
                this.failed = true;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        ((UpdateCheckerListener)this.listeners.get(i)).failed(this);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                this.sem_released = true;
                this.semaphore.release();
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected boolean getFailed() {
        return this.failed;
    }

    protected void cancel() {
        this.cancelled = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UpdateCheckerListener)this.listeners.get(i)).cancelled(this);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UpdateCheckerListener updateCheckerListener) {
        try {
            this.this_mon.enter();
            this.listeners.add(updateCheckerListener);
            if (this.failed) {
                updateCheckerListener.failed(this);
            } else if (this.completed) {
                updateCheckerListener.completed(this);
            }
            if (this.cancelled) {
                updateCheckerListener.cancelled(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UpdateCheckerListener updateCheckerListener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(updateCheckerListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void reportProgress(String string) {
        List list = this.progress_listeners;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((UpdateProgressListener)list.get(i)).reportProgress(string);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(UpdateProgressListener updateProgressListener) {
        try {
            this.this_mon.enter();
            ArrayList<UpdateProgressListener> arrayList = new ArrayList<UpdateProgressListener>(this.progress_listeners);
            arrayList.add(updateProgressListener);
            this.progress_listeners = arrayList;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(UpdateProgressListener updateProgressListener) {
        try {
            this.this_mon.enter();
            ArrayList arrayList = new ArrayList(this.progress_listeners);
            arrayList.remove(updateProgressListener);
            this.progress_listeners = arrayList;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }
}

