/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.config.ConfigParameterListener;
import org.gudy.azureus2.plugins.ui.config.EnablerParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterGroupImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImplListener;

public class ParameterImpl
implements EnablerParameter,
org.gudy.azureus2.core3.config.ParameterListener {
    protected PluginConfigImpl config;
    private String key;
    private String labelKey;
    private String label;
    private int mode = 0;
    private boolean enabled = true;
    private boolean visible = true;
    private boolean generate_intermediate_events = true;
    private List toDisable = new ArrayList();
    private List toEnable = new ArrayList();
    private List listeners = new ArrayList();
    private List impl_listeners = new ArrayList();
    private ParameterGroupImpl parameter_group;

    public ParameterImpl(PluginConfigImpl pluginConfigImpl, String string, String string2) {
        this.config = pluginConfigImpl;
        this.key = string;
        this.labelKey = string2;
        if ("_blank".equals(this.labelKey)) {
            this.labelKey = "!!";
        }
        this.label = MessageText.getString(this.labelKey);
    }

    public String getKey() {
        return this.key;
    }

    public void addDisabledOnSelection(Parameter parameter) {
        this.toDisable.add(parameter);
    }

    public void addEnabledOnSelection(Parameter parameter) {
        this.toEnable.add(parameter);
    }

    public List getDisabledOnSelectionParameters() {
        return this.toDisable;
    }

    public List getEnabledOnSelectionParameters() {
        return this.toEnable;
    }

    public void parameterChanged(String string) {
        this.fireParameterChanged();
    }

    protected void fireParameterChanged() {
        Object[] objectArray = this.listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                Object object = objectArray[i];
                if (object instanceof ParameterListener) {
                    ((ParameterListener)object).parameterChanged(this);
                    continue;
                }
                ((ConfigParameterListener)object).configParameterChanged(this);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        Object[] objectArray = this.impl_listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                ParameterImplListener parameterImplListener = (ParameterImplListener)objectArray[i];
                parameterImplListener.enabledChanged(this);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMinimumRequiredUserMode() {
        return this.mode;
    }

    public void setMinimumRequiredUserMode(int n) {
        this.mode = n;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setGenerateIntermediateEvents(boolean bl) {
        this.generate_intermediate_events = bl;
    }

    public boolean getGenerateIntermediateEvents() {
        return this.generate_intermediate_events;
    }

    public void setGroup(ParameterGroupImpl parameterGroupImpl) {
        this.parameter_group = parameterGroupImpl;
    }

    public ParameterGroupImpl getGroup() {
        return this.parameter_group;
    }

    public void addListener(ParameterListener parameterListener) {
        this.listeners.add(parameterListener);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, (org.gudy.azureus2.core3.config.ParameterListener)this);
        }
    }

    public void removeListener(ParameterListener parameterListener) {
        this.listeners.remove(parameterListener);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    public void addImplListener(ParameterImplListener parameterImplListener) {
        this.impl_listeners.add(parameterImplListener);
    }

    public void removeImplListener(ParameterImplListener parameterImplListener) {
        this.impl_listeners.remove(parameterImplListener);
    }

    public void addConfigParameterListener(ConfigParameterListener configParameterListener) {
        this.listeners.add(configParameterListener);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, (org.gudy.azureus2.core3.config.ParameterListener)this);
        }
    }

    public void removeConfigParameterListener(ConfigParameterListener configParameterListener) {
        this.listeners.remove(configParameterListener);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    public String getLabelText() {
        return this.label;
    }

    public void setLabelText(String string) {
        this.labelKey = null;
        this.label = string;
        this.triggerLabelChanged(string, false);
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public void setLabelKey(String string) {
        this.labelKey = string;
        this.label = MessageText.getString(string);
        this.triggerLabelChanged(this.labelKey, true);
    }

    private void triggerLabelChanged(String string, boolean bl) {
        Object[] objectArray = this.impl_listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                ParameterImplListener parameterImplListener = (ParameterImplListener)objectArray[i];
                parameterImplListener.labelChanged(this, string, bl);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void destroy() {
        this.listeners.clear();
        this.impl_listeners.clear();
        this.toDisable.clear();
        this.toEnable.clear();
        COConfigurationManager.removeParameterListener(this.key, this);
    }
}

