/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.components;

import java.io.File;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeListener;
import org.gudy.azureus2.plugins.ui.components.UITextArea;
import org.gudy.azureus2.pluginsimpl.local.ui.components.UIComponentImpl;

public class UITextAreaImpl
extends UIComponentImpl
implements UITextArea {
    private int max_size = 60000;
    private int max_file_size = 20 * this.max_size;
    PoopWriter pw;
    int current_file_size;
    File poop_file;
    boolean useFile = true;
    AEMonitor file_mon = new AEMonitor("filemon");
    LinkedList<String> delay_text = new LinkedList();
    int delay_size = 0;
    FrequencyLimitedDispatcher dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            UITextAreaImpl.this.delayAppend();
        }
    }, 500);

    public UITextAreaImpl() {
        this.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        if (this.useFile) {
            try {
                this.file_mon.enter();
                if (this.pw == null) {
                    this.pw = new PoopWriter();
                    this.pw.print(string);
                    this.current_file_size = string.length();
                    Object var3_2 = null;
                    this.file_mon.exit();
                    return;
                }
                Object var3_3 = null;
                this.file_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.file_mon.exit();
                throw throwable;
            }
        }
        if (string.length() > this.max_size) {
            int n = this.max_size - 10000;
            if (n < 0) {
                n = this.max_size;
            }
            string = string.substring(string.length() - n);
        }
        this.setProperty("value", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendText(String string) {
        if (this.useFile && this.pw != null) {
            try {
                this.file_mon.enter();
                if (this.current_file_size > this.max_file_size) {
                    this.current_file_size = this.getFileText().length();
                }
                this.pw.print(string);
                this.current_file_size += string.length();
                Object var3_2 = null;
                this.file_mon.exit();
                return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.file_mon.exit();
                throw throwable;
            }
        }
        UITextAreaImpl uITextAreaImpl = this;
        synchronized (uITextAreaImpl) {
            this.delay_text.addLast(string);
            this.delay_size += string.length();
            while (this.delay_size > this.max_size && this.delay_text.size() != 0) {
                String string2 = this.delay_text.removeFirst();
                this.delay_size -= string2.length();
            }
        }
        this.dispatcher.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delayAppend() {
        String string;
        String string2 = this.getText();
        UITextAreaImpl uITextAreaImpl = this;
        synchronized (uITextAreaImpl) {
            if (this.delay_text.size() == 1) {
                string = this.delay_text.get(0);
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.delay_size);
                Iterator iterator = this.delay_text.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append((String)iterator.next());
                }
                string = stringBuffer.toString();
            }
            this.delay_text.clear();
            this.delay_size = 0;
        }
        if (string2 == null) {
            this.setText(string);
        } else {
            this.setText(string2 + string);
        }
    }

    public String getText() {
        if (this.useFile && this.pw != null) {
            return this.getFileText();
        }
        return (String)this.getProperty("value");
    }

    public void setMaximumSize(int n) {
        this.max_size = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileText() {
        try {
            this.file_mon.enter();
            String string = null;
            if (this.pw != null) {
                this.pw.close();
                string = this.pw.getText();
            }
            if (string == null) {
                string = "";
            }
            this.pw = null;
            if (this.useFile) {
                this.pw = new PoopWriter();
                this.pw.print(string);
                this.current_file_size = string.length();
            }
            String string2 = string;
            Object var4_3 = null;
            this.file_mon.exit();
            return string2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.file_mon.exit();
            throw throwable;
        }
    }

    public void addPropertyChangeListener(UIPropertyChangeListener uIPropertyChangeListener) {
        if (this.useFile) {
            this.useFile = false;
            this.setText(this.getFileText());
        }
        super.addPropertyChangeListener(uIPropertyChangeListener);
    }

    protected class PoopWriter {
        private StringBuffer buffer = new StringBuffer(256);
        private PrintWriter pw;

        protected PoopWriter() {
        }

        public void print(String string) {
            if (this.pw == null) {
                this.buffer.append(string);
                if (this.buffer.length() > 8192) {
                    if (UITextAreaImpl.this.poop_file == null) {
                        try {
                            UITextAreaImpl.this.poop_file = AETemporaryFileHandler.createTempFile();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (UITextAreaImpl.this.poop_file != null) {
                        try {
                            this.pw = new PrintWriter(UITextAreaImpl.this.poop_file);
                            this.pw.print(this.buffer.toString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.buffer.setLength(0);
                }
            } else {
                this.pw.print(string);
            }
        }

        public String getText() {
            if (UITextAreaImpl.this.poop_file == null) {
                return this.buffer.toString();
            }
            try {
                return FileUtil.readFileEndAsString(UITextAreaImpl.this.poop_file, UITextAreaImpl.this.max_size);
            }
            catch (Throwable throwable) {
                return "";
            }
        }

        public void close() {
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
        }
    }
}

