/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebPageRequestImpl;

public class TrackerWebPageResponseImpl
implements TrackerWebPageResponse {
    private static final String NL = "\r\n";
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private String content_type = "text/html";
    private int reply_status = 200;
    private Map<String, String> header_map = new LinkedHashMap<String, String>();
    private TrackerWebPageRequestImpl request;
    private boolean is_async;
    private int explicit_gzip = 0;
    private boolean is_gzipped;

    protected TrackerWebPageResponseImpl(TrackerWebPageRequestImpl trackerWebPageRequestImpl) {
        this.request = trackerWebPageRequestImpl;
        String string = TimeFormatter.getHTTPDate(SystemTime.getCurrentTime());
        this.setHeader("Last-Modified", string);
        this.setHeader("Expires", string);
    }

    public void setLastModified(long l) {
        String string = TimeFormatter.getHTTPDate(l);
        this.setHeader("Last-Modified", string);
    }

    public void setExpires(long l) {
        String string = TimeFormatter.getHTTPDate(l);
        this.setHeader("Expires", string);
    }

    public void setContentType(String string) {
        this.content_type = string;
    }

    public void setReplyStatus(int n) {
        this.reply_status = n;
    }

    public void setHeader(String string, String string2) {
        this.addHeader(string, string2, true);
    }

    public void setGZIP(boolean bl) {
        this.explicit_gzip = bl ? 1 : 2;
    }

    protected String addHeader(String string, String string2, boolean bl) {
        Iterator<String> iterator = this.header_map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            if (!string3.equalsIgnoreCase(string)) continue;
            if (bl) {
                iterator.remove();
                continue;
            }
            return this.header_map.get(string3);
        }
        this.header_map.put(string, string2);
        return string2;
    }

    public OutputStream getOutputStream() {
        return this.baos;
    }

    protected void complete() throws IOException {
        Object object;
        Object object2;
        String object32;
        if (this.is_async) {
            return;
        }
        byte[] byArray = this.baos.toByteArray();
        String string = "BAD";
        if (this.reply_status == 200) {
            string = "OK";
        } else if (this.reply_status == 204) {
            string = "No Content";
        } else if (this.reply_status == 206) {
            string = "Partial Content";
        } else if (this.reply_status == 401) {
            string = "Unauthorized";
        } else if (this.reply_status == 404) {
            string = "Not Found";
        } else if (this.reply_status == 501) {
            string = "Not Implemented";
        }
        String string2 = "HTTP/1.1 " + this.reply_status + " " + string + NL;
        this.addHeader("Server", "Azureus 4.5.0.4", false);
        if (this.request.canKeepAlive()) {
            String string3 = this.addHeader("Connection", "keep-alive", false);
            if (string3.equalsIgnoreCase("keep-alive")) {
                this.request.setKeepAlive(true);
            }
        } else {
            this.addHeader("Connection", "close", true);
        }
        this.addHeader("Content-Type", this.content_type, false);
        boolean bl = false;
        if (this.explicit_gzip == 1 && !this.is_gzipped && HTTPUtils.canGZIP(object32 = (String)(object2 = this.request.getHeaders()).get("accept-encoding"))) {
            bl = true;
            this.is_gzipped = true;
            this.header_map.put("Content-Encoding", "gzip");
        }
        for (String string3 : this.header_map.keySet()) {
            object = this.header_map.get(string3);
            string2 = string2 + string3 + ": " + (String)object + NL;
        }
        if (bl && byArray.length < 524288) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            object = new GZIPOutputStream(byteArrayOutputStream);
            ((FilterOutputStream)object).write(byArray);
            ((GZIPOutputStream)object).finish();
            byArray = byteArrayOutputStream.toByteArray();
            bl = false;
        }
        string2 = string2 + "Content-Length: " + byArray.length + NL + NL;
        OutputStream outputStream = this.request.getOutputStream();
        outputStream.write(string2.getBytes());
        if (bl) {
            object = new GZIPOutputStream(outputStream);
            ((FilterOutputStream)object).write(byArray);
            ((GZIPOutputStream)object).finish();
        } else {
            outputStream.write(byArray);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useFile(String string, String string2) throws IOException {
        String string3 = string + string2.replace('/', File.separatorChar);
        File file = new File(string3).getCanonicalFile();
        if (!file.toString().toLowerCase().startsWith(string.toLowerCase())) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        if (file.canRead()) {
            boolean bl;
            block7: {
                String string4 = file.toString().toLowerCase();
                int n = string4.lastIndexOf(".");
                if (n == -1) {
                    return false;
                }
                String string5 = string4.substring(n + 1);
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    this.useStream(string5, fileInputStream);
                    bl = true;
                    Object var11_10 = null;
                    if (fileInputStream == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    throw throwable;
                }
                fileInputStream.close();
            }
            return bl;
        }
        return false;
    }

    public void useStream(String string, InputStream inputStream) throws IOException {
        int n;
        Object object;
        String string2;
        OutputStream outputStream = this.getOutputStream();
        String string3 = HTTPUtils.guessContentTypeFromFileType(string);
        if (this.explicit_gzip != 2 && HTTPUtils.useCompressionForFileType(string3) && HTTPUtils.canGZIP(string2 = (String)(object = (Object)this.request.getHeaders()).get("accept-encoding"))) {
            this.is_gzipped = true;
            outputStream = new GZIPOutputStream(outputStream);
            this.header_map.put("Content-Encoding", "gzip");
        }
        this.setContentType(string3);
        object = new byte[4096];
        while ((n = inputStream.read((byte[])object)) > 0) {
            outputStream.write((byte[])object, 0, n);
        }
        if (outputStream instanceof GZIPOutputStream) {
            ((GZIPOutputStream)outputStream).finish();
        }
    }

    public void writeTorrent(TrackerTorrent trackerTorrent) throws IOException {
        try {
            TRHostTorrent tRHostTorrent = ((TrackerTorrentImpl)trackerTorrent).getHostTorrent();
            TOTorrent tOTorrent = tRHostTorrent.getTorrent();
            TOTorrent tOTorrent2 = TOTorrentFactory.deserialiseFromMap(tOTorrent.serialiseToMap());
            tOTorrent2.removeAdditionalProperties();
            if (!TorrentUtils.isDecentralised(tOTorrent2)) {
                URL[][] uRLArray = TRTrackerUtils.getAnnounceURLs();
                if (tRHostTorrent.getStatus() != 3 && uRLArray.length > 0 && COConfigurationManager.getBooleanParameter("Tracker Host Add Our Announce URLs")) {
                    String string = tOTorrent2.getAnnounceURL().getProtocol();
                    for (int i = 0; i < uRLArray.length; ++i) {
                        URL[] uRLArray2 = uRLArray[i];
                        if (!uRLArray2[0].getProtocol().equalsIgnoreCase(string)) continue;
                        tOTorrent2.setAnnounceURL(uRLArray2[0]);
                        tOTorrent2.getAnnounceURLGroup().setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                        for (int j = 1; j < uRLArray2.length; ++j) {
                            TorrentUtils.announceGroupsInsertLast(tOTorrent2, new URL[]{uRLArray2[j]});
                        }
                        break;
                    }
                }
            }
            this.baos.write(BEncoder.encode(tOTorrent2.serialiseToMap()));
            this.setContentType("application/x-bittorrent");
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            throw new IOException(tOTorrentException.toString());
        }
    }

    public void setAsynchronous(boolean bl) throws IOException {
        AsyncController asyncController = this.request.getAsyncController();
        if (asyncController == null) {
            throw new IOException("Request is not non-blocking");
        }
        if (bl) {
            this.is_async = true;
            asyncController.setAsyncStart();
        } else {
            this.is_async = false;
            this.complete();
            asyncController.setAsyncComplete();
        }
    }

    public boolean getAsynchronous() {
        return this.is_async;
    }
}

