/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.network;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import java.util.HashMap;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageStreamEncoder;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueue;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueueListener;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageStreamEncoderAdapter;

public class OutgoingMessageQueueImpl
implements OutgoingMessageQueue {
    private final com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue core_queue;
    private final HashMap registrations = new HashMap();

    protected OutgoingMessageQueueImpl(com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue outgoingMessageQueue) {
        this.core_queue = outgoingMessageQueue;
    }

    public void setEncoder(MessageStreamEncoder messageStreamEncoder) {
        this.core_queue.setEncoder(new MessageStreamEncoderAdapter(messageStreamEncoder));
    }

    public void sendMessage(Message message) {
        if (message instanceof MessageAdapter) {
            this.core_queue.addMessage(((MessageAdapter)message).getCoreMessage(), false);
            return;
        }
        this.core_queue.addMessage(new MessageAdapter(message), false);
    }

    public void registerListener(final OutgoingMessageQueueListener outgoingMessageQueueListener) {
        OutgoingMessageQueue.MessageQueueListener messageQueueListener = new OutgoingMessageQueue.MessageQueueListener(){

            public boolean messageAdded(com.aelitis.azureus.core.peermanager.messaging.Message message) {
                if (message instanceof MessageAdapter) {
                    return outgoingMessageQueueListener.messageAdded(((MessageAdapter)message).getPluginMessage());
                }
                return outgoingMessageQueueListener.messageAdded(new MessageAdapter(message));
            }

            public void messageQueued(com.aelitis.azureus.core.peermanager.messaging.Message message) {
            }

            public void messageRemoved(com.aelitis.azureus.core.peermanager.messaging.Message message) {
            }

            public void messageSent(com.aelitis.azureus.core.peermanager.messaging.Message message) {
                if (message instanceof MessageAdapter) {
                    outgoingMessageQueueListener.messageSent(((MessageAdapter)message).getPluginMessage());
                    return;
                }
                outgoingMessageQueueListener.messageSent(new MessageAdapter(message));
            }

            public void protocolBytesSent(int n) {
                outgoingMessageQueueListener.bytesSent(n);
            }

            public void dataBytesSent(int n) {
                outgoingMessageQueueListener.bytesSent(n);
            }

            public void flush() {
            }
        };
        this.registrations.put(outgoingMessageQueueListener, messageQueueListener);
        this.core_queue.registerQueueListener(messageQueueListener);
    }

    public void deregisterListener(OutgoingMessageQueueListener outgoingMessageQueueListener) {
        OutgoingMessageQueue.MessageQueueListener messageQueueListener = (OutgoingMessageQueue.MessageQueueListener)this.registrations.remove(outgoingMessageQueueListener);
        if (messageQueueListener != null) {
            this.core_queue.cancelQueueListener(messageQueueListener);
        }
    }

    public void notifyOfExternalSend(Message message) {
        if (message instanceof MessageAdapter) {
            this.core_queue.notifyOfExternallySentMessage(((MessageAdapter)message).getCoreMessage());
            return;
        }
        this.core_queue.notifyOfExternallySentMessage(new MessageAdapter(message));
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.core_queue.getPercentDoneOfCurrentMessage();
    }

    public int getDataQueuedBytes() {
        return this.core_queue.getDataQueuedBytes();
    }

    public int getProtocolQueuedBytes() {
        return this.core_queue.getProtocolQueuedBytes();
    }

    public boolean isBlocked() {
        return this.core_queue.isBlocked();
    }
}

