/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.messaging.MessageManagerListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionDirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionIndirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageDecoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEncoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;

public class MessageManagerImpl
implements MessageManager,
NATTraversalHandler {
    private static MessageManagerImpl instance;
    private final HashMap compat_checks = new HashMap();
    private final DownloadManagerListener download_manager_listener = new DownloadManagerListener(){

        public void downloadAdded(Download download) {
            download.addPeerListener(new DownloadPeerListener(){

                public void peerManagerAdded(final Download download, PeerManager peerManager) {
                    peerManager.addListener(new PeerManagerListener(){

                        public void peerAdded(PeerManager peerManager, final Peer peer) {
                            peer.addListener(new PeerListener(){

                                public void stateChanged(int n) {
                                    if (n == 30 && peer.supportsMessaging()) {
                                        Message[] messageArray = peer.getSupportedMessages();
                                        for (int i = 0; i < messageArray.length; ++i) {
                                            Message message = messageArray[i];
                                            for (Map.Entry entry : MessageManagerImpl.this.compat_checks.entrySet()) {
                                                Message message2 = (Message)entry.getKey();
                                                if (!message.getID().equals(message2.getID())) continue;
                                                MessageManagerListener messageManagerListener = (MessageManagerListener)entry.getValue();
                                                messageManagerListener.compatiblePeerFound(download, peer, message2);
                                            }
                                        }
                                    }
                                }

                                public void sentBadChunk(int n, int n2) {
                                }
                            });
                        }

                        public void peerRemoved(PeerManager peerManager, Peer peer) {
                            for (MessageManagerListener messageManagerListener : MessageManagerImpl.this.compat_checks.values()) {
                                messageManagerListener.peerRemoved(download, peer);
                            }
                        }
                    });
                }

                public void peerManagerRemoved(Download download, PeerManager peerManager) {
                }
            });
        }

        public void downloadRemoved(Download download) {
        }
    };
    private AzureusCore core;
    private Map message_handlers = new HashMap();

    public static synchronized MessageManagerImpl getSingleton(AzureusCore azureusCore) {
        if (instance == null) {
            instance = new MessageManagerImpl(azureusCore);
        }
        return instance;
    }

    private MessageManagerImpl(AzureusCore azureusCore) {
        this.core = azureusCore;
        this.core.getNATTraverser().registerHandler(this);
    }

    public NATTraverser getNATTraverser() {
        return this.core.getNATTraverser();
    }

    public void registerMessageType(Message message) throws MessageException {
        try {
            com.aelitis.azureus.core.peermanager.messaging.MessageManager.getSingleton().registerMessageType(new MessageAdapter(message));
        }
        catch (com.aelitis.azureus.core.peermanager.messaging.MessageException messageException) {
            throw new MessageException(messageException.getMessage());
        }
    }

    public void deregisterMessageType(Message message) {
        com.aelitis.azureus.core.peermanager.messaging.MessageManager.getSingleton().deregisterMessageType(new MessageAdapter(message));
    }

    public void locateCompatiblePeers(PluginInterface pluginInterface, Message message, MessageManagerListener messageManagerListener) {
        this.compat_checks.put(message, messageManagerListener);
        if (this.compat_checks.size() == 1) {
            pluginInterface.getDownloadManager().addListener(this.download_manager_listener);
        }
    }

    public void cancelCompatiblePeersLocation(MessageManagerListener messageManagerListener) {
        Iterator iterator = this.compat_checks.values().iterator();
        while (iterator.hasNext()) {
            MessageManagerListener messageManagerListener2 = (MessageManagerListener)iterator.next();
            if (messageManagerListener2 != messageManagerListener) continue;
            iterator.remove();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericMessageRegistration registerGenericMessageType(String string, final String string2, final int n, final GenericMessageHandler genericMessageHandler) throws MessageException {
        final String string3 = "AEGEN:" + string;
        final byte[] byArray = string3.getBytes();
        final byte[][] byArrayArray = new byte[][]{new SHA1Simple().calculateHash(byArray)};
        Object object = this.message_handlers;
        synchronized (object) {
            this.message_handlers.put(string3, genericMessageHandler);
        }
        object = new NetworkManager.ByteMatcher(){

            public int matchThisSizeOrBigger() {
                return this.maxSize();
            }

            public int maxSize() {
                return byArray.length;
            }

            public int minSize() {
                return this.maxSize();
            }

            public Object matches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                int n2 = byteBuffer.limit();
                byteBuffer.limit(byteBuffer.position() + this.maxSize());
                boolean bl = byteBuffer.equals(ByteBuffer.wrap(byArray));
                byteBuffer.limit(n2);
                return bl ? "" : null;
            }

            public Object minMatches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                return this.matches(transportHelper, byteBuffer, n);
            }

            public byte[][] getSharedSecrets() {
                return byArrayArray;
            }

            public int getSpecificPort() {
                return -1;
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting((NetworkManager.ByteMatcher)object, new NetworkManager.RoutingListener(){

            public void connectionRouted(NetworkConnection networkConnection, Object object) {
                try {
                    ByteBuffer[] byteBufferArray = new ByteBuffer[]{ByteBuffer.allocate(byArray.length)};
                    networkConnection.getTransport().read(byteBufferArray, 0, 1);
                    if (byteBufferArray[0].remaining() != 0) {
                        Debug.out("incomplete read");
                    }
                    GenericMessageEndpointImpl genericMessageEndpointImpl = new GenericMessageEndpointImpl(networkConnection.getEndpoint());
                    GenericMessageConnectionDirect genericMessageConnectionDirect = GenericMessageConnectionDirect.receive(genericMessageEndpointImpl, string3, string2, n, byArrayArray);
                    GenericMessageConnectionImpl genericMessageConnectionImpl = new GenericMessageConnectionImpl(MessageManagerImpl.this, genericMessageConnectionDirect);
                    genericMessageConnectionDirect.connect(networkConnection);
                    if (genericMessageHandler.accept(genericMessageConnectionImpl)) {
                        genericMessageConnectionImpl.accepted();
                    } else {
                        networkConnection.close();
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    networkConnection.close();
                }
            }

            public boolean autoCryptoFallback() {
                return n != 3;
            }
        }, new MessageStreamFactory(){

            public MessageStreamEncoder createEncoder() {
                return new GenericMessageEncoder();
            }

            public MessageStreamDecoder createDecoder() {
                return new GenericMessageDecoder(string3, string2);
            }
        });
        return new GenericMessageRegistration((NetworkManager.ByteMatcher)object){
            final /* synthetic */ NetworkManager.ByteMatcher val$matcher;
            {
                this.val$matcher = byteMatcher;
            }

            public GenericMessageEndpoint createEndpoint(InetSocketAddress inetSocketAddress) {
                return new GenericMessageEndpointImpl(inetSocketAddress);
            }

            public GenericMessageConnection createConnection(GenericMessageEndpoint genericMessageEndpoint) throws MessageException {
                return new GenericMessageConnectionImpl(MessageManagerImpl.this, string3, string2, (GenericMessageEndpointImpl)genericMessageEndpoint, n, byArrayArray);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                NetworkManager.getSingleton().cancelIncomingConnectionRouting(this.val$matcher);
                Map map = MessageManagerImpl.this.message_handlers;
                synchronized (map) {
                    MessageManagerImpl.this.message_handlers.remove(string3);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericMessageHandler getHandler(String string) {
        Map map = this.message_handlers;
        synchronized (map) {
            return (GenericMessageHandler)this.message_handlers.get(string);
        }
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return "Generic Messaging";
    }

    public Map process(InetSocketAddress inetSocketAddress, Map map) {
        return GenericMessageConnectionIndirect.receive(this, inetSocketAddress, map);
    }
}

