/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;

public class GenericMessageDecoder
implements MessageStreamDecoder {
    public static final int MAX_MESSAGE_LENGTH = 262144;
    private final ByteBuffer length_buffer = ByteBuffer.allocate(4);
    private final ByteBuffer[] buffers = new ByteBuffer[]{this.length_buffer, null};
    private final String msg_type;
    private final String msg_desc;
    private List messages = new ArrayList();
    private int protocol_bytes_last_read = 0;
    private int data_bytes_last_read = 0;
    private volatile boolean destroyed;

    protected GenericMessageDecoder(String string, String string2) {
        this.msg_type = string;
        this.msg_desc = string2;
    }

    public int performStreamDecode(Transport transport, int n) throws IOException {
        long l;
        long l2;
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        for (l = 0L; l < (long)n; l += l2) {
            int n2;
            int n3;
            int n4 = (int)((long)n - l);
            ByteBuffer byteBuffer = this.buffers[1];
            if (byteBuffer == null) {
                n3 = this.length_buffer.remaining();
                n2 = this.length_buffer.limit();
                if (n3 > n4) {
                    this.length_buffer.limit(this.length_buffer.position() + n4);
                }
                l2 = transport.read(this.buffers, 0, 1);
                this.length_buffer.limit(n2);
                this.protocol_bytes_last_read = (int)((long)this.protocol_bytes_last_read + l2);
                if (this.length_buffer.hasRemaining()) {
                    l += l2;
                    break;
                }
                this.length_buffer.flip();
                int n5 = this.length_buffer.getInt();
                if (n5 > 262144) {
                    Debug.out("Message too large for generic payload");
                    throw new IOException("message too large");
                }
                this.buffers[1] = ByteBuffer.allocate(n5);
                this.length_buffer.flip();
                continue;
            }
            n3 = byteBuffer.remaining();
            n2 = byteBuffer.limit();
            if (n3 > n4) {
                byteBuffer.limit(byteBuffer.position() + n4);
            }
            l2 = transport.read(this.buffers, 1, 1);
            byteBuffer.limit(n2);
            this.data_bytes_last_read = (int)((long)this.data_bytes_last_read + l2);
            if (byteBuffer.hasRemaining()) {
                l += l2;
                break;
            }
            byteBuffer.flip();
            this.messages.add(new GenericMessage(this.msg_type, this.msg_desc, new DirectByteBuffer(byteBuffer), false));
            this.buffers[1] = null;
        }
        if (this.destroyed) {
            throw new IOException("decoder has been destroyed");
        }
        return (int)l;
    }

    public Message[] removeDecodedMessages() {
        if (this.messages.isEmpty()) {
            return null;
        }
        Message[] messageArray = this.messages.toArray(new Message[this.messages.size()]);
        this.messages.clear();
        return messageArray;
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    public int getPercentDoneOfCurrentMessage() {
        return 0;
    }

    public void pauseDecoding() {
    }

    public void resumeDecoding() {
    }

    public ByteBuffer destroy() {
        this.destroyed = true;
        return null;
    }
}

