/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.pluginsimpl.local.FailedPlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.launch.PluginLauncherImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInitializer
implements GlobalManagerListener,
AEDiagnosticsEvidenceGenerator {
    public static final boolean DISABLE_PLUGIN_VERIFICATION = false;
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String INTERNAL_PLUGIN_ID = "<internal>";
    private String[][] builtin_plugins = new String[][]{{"Torrent Removal Rules", "com.aelitis.azureus.plugins.removerules.DownloadRemoveRulesPlugin", "azbpremovalrules", "", "true", "false"}, {"UPnP", "com.aelitis.azureus.plugins.upnp.UPnPPlugin", "azbpupnp", "UPnP", "true", "false"}, {"DHT", "com.aelitis.azureus.plugins.dht.DHTPlugin", "azbpdht", "DHT", "true", "false"}, {"DHT Tracker", "com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin", "azbpdhdtracker", "DHT Tracker", "true", "false"}, {"Magnet URI Handler", "com.aelitis.azureus.plugins.magnet.MagnetPlugin", "azbpmagnet", "Magnet URI Handler", "true", "false"}, {"Platform Checker", "org.gudy.azureus2.platform.PlatformManagerPluginDelegate", "azplatform2", "azplatform2", "true", "false"}, {"External Seed", "com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin", "azextseed", "azextseed", "true", "false"}, {"Local Tracker", "com.aelitis.azureus.plugins.tracker.local.LocalTrackerPlugin", "azlocaltracker", "azlocaltracker", "true", "false"}, {"Network Status", "com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin", "aznetstat", "aznetstat", "true", "false"}};
    static VerifiedPluginHolder verified_plugin_holder;
    private static String[][] default_version_details;
    private static PluginInitializer singleton;
    private static AEMonitor class_mon;
    private static List registration_queue;
    private static List initThreads;
    private static AsyncDispatcher async_dispatcher;
    private static List<PluginEvent> plugin_event_history;
    private AzureusCoreOperation core_operation;
    private AzureusCore azureus_core;
    private PluginInterfaceImpl default_plugin;
    private PluginManager plugin_manager;
    private ClassLoader root_class_loader = this.getClass().getClassLoader();
    private List loaded_pi_list = new ArrayList();
    private static boolean loading_builtin;
    private List s_plugins = new ArrayList();
    private List s_plugin_interfaces = new ArrayList();
    private boolean initialisation_complete;
    private volatile boolean plugins_initialised;
    private Set<String> vc_disabled_plugins = VersionCheckClient.getSingleton().getDisabledPluginIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginInitializer getSingleton(AzureusCore azureusCore, AzureusCoreOperation azureusCoreOperation) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new PluginInitializer(azureusCore, azureusCoreOperation);
            }
            PluginInitializer pluginInitializer = singleton;
            Object var4_3 = null;
            class_mon.exit();
            return pluginInitializer;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PluginInitializer peekSingleton() {
        try {
            class_mon.enter();
            PluginInitializer pluginInitializer = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return pluginInitializer;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void queueRegistration(Class clazz) {
        try {
            class_mon.enter();
            if (singleton == null) {
                registration_queue.add(clazz);
            } else {
                try {
                    singleton.initializePluginFromClass(clazz, INTERNAL_PLUGIN_ID, clazz.getName(), false, false, true);
                }
                catch (PluginException pluginException) {
                }
            }
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void queueRegistration(Plugin plugin, String string) {
        try {
            class_mon.enter();
            if (singleton == null) {
                registration_queue.add(new Object[]{plugin, string});
            } else {
                try {
                    singleton.initializePluginFromInstance(plugin, string, plugin.getClass().getName());
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected static boolean isLoadingBuiltin() {
        return loading_builtin;
    }

    public static void checkAzureusVersion(String string, Properties properties, boolean bl) throws PluginException {
        String string2 = (String)properties.get("plugin.azureus.min_version");
        if (string2 == null) {
            return;
        }
        if (Constants.compareVersions("4.5.0.4", string2) < 0) {
            String string3 = string.length() > 0 ? string + " " : "";
            String string4 = "Plugin " + string3 + "requires " + Constants.APP_NAME + " version " + string2 + " or higher";
            if (bl) {
                Logger.log(new LogAlert(true, 3, string4));
            }
            throw new PluginException(string4);
        }
    }

    public static void checkJDKVersion(String string, Properties properties, boolean bl) throws PluginException {
        String string2 = (String)properties.get("plugin.jdk.min_version");
        if (string2 != null) {
            String string3 = System.getProperty("java.version");
            string2 = PluginInitializer.normaliseJDK(string2);
            string3 = PluginInitializer.normaliseJDK(string3);
            if (string2.length() == 0 || string3.length() == 0) {
                return;
            }
            if (Constants.compareVersions(string3, string2) < 0) {
                String string4 = "Plugin " + (string.length() > 0 ? string + " " : "") + "requires Java version " + string2 + " or higher";
                if (bl) {
                    Logger.log(new LogAlert(true, 3, string4));
                }
                throw new PluginException(string4);
            }
        }
    }

    protected static String normaliseJDK(String string) {
        try {
            char c;
            String string2 = "";
            for (int i = 0; i < string.length() && ((c = string.charAt(i)) == '.' || Character.isDigit(c)); ++i) {
                string2 = string2 + c;
            }
            if (Integer.parseInt("" + string2.charAt(0)) > 1) {
                string2 = "1." + string2;
            }
            return string2;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    protected PluginInitializer(AzureusCore azureusCore, AzureusCoreOperation azureusCoreOperation) {
        this.azureus_core = azureusCore;
        AEDiagnostics.addEvidenceGenerator(this);
        this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void componentCreated(AzureusCore azureusCore, AzureusCoreComponent azureusCoreComponent) {
                if (azureusCoreComponent instanceof GlobalManager) {
                    GlobalManager globalManager = (GlobalManager)azureusCoreComponent;
                    globalManager.addListener(PluginInitializer.this);
                }
            }
        });
        this.core_operation = azureusCoreOperation;
        UpdateManagerImpl.getSingleton(this.azureus_core);
        this.plugin_manager = PluginManagerImpl.getSingleton(this);
        String string = System.getProperty("azureus.dynamic.plugins", null);
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                try {
                    PluginInitializer.queueRegistration(Class.forName(string2));
                }
                catch (Throwable throwable) {
                    Debug.out("Registration of dynamic plugin '" + string2 + "' failed", throwable);
                }
            }
        }
    }

    protected void fireCreated(PluginInterfaceImpl pluginInterfaceImpl) {
        this.azureus_core.triggerLifeCycleComponentCreated(pluginInterfaceImpl);
    }

    protected void fireOperational(PluginInterfaceImpl pluginInterfaceImpl, boolean bl) {
        this.fireEventSupport(bl ? 8 : 9, pluginInterfaceImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitThread() {
        List list = initThreads;
        synchronized (list) {
            if (initThreads.contains(Thread.currentThread())) {
                Debug.out("Already added");
            }
            initThreads.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInitThread() {
        List list = initThreads;
        synchronized (list) {
            initThreads.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInitialisationThread() {
        List list = initThreads;
        synchronized (list) {
            return initThreads.contains(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadPlugins(AzureusCore azureusCore, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        GenericDeclaration genericDeclaration;
        Object object2;
        int n;
        Object object3;
        ArrayList arrayList;
        if (bl) {
            List list = this.s_plugin_interfaces;
            synchronized (list) {
                arrayList = new ArrayList(this.s_plugin_interfaces);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object3 = (PluginInterfaceImpl)arrayList.get(i);
                Plugin plugin = ((PluginInterfaceImpl)object3).getPlugin();
                if (!(plugin instanceof FailedPlugin)) continue;
                this.unloadPlugin((PluginInterfaceImpl)object3);
            }
        }
        arrayList = new ArrayList();
        PluginManagerImpl.setStartDetails(azureusCore);
        this.getRootClassLoader();
        File file = FileUtil.getUserFile("plugins");
        object3 = FileUtil.getApplicationFile("plugins");
        int n2 = 0;
        int n3 = 0;
        if (file.exists() && file.isDirectory()) {
            n2 = file.listFiles().length;
        }
        if (((File)object3).exists() && ((File)object3).isDirectory()) {
            n3 = ((File)object3).listFiles().length;
        }
        if (bl2) {
            arrayList.addAll(this.loadPluginsFromDir(file, 0, n2 + n3, bl, bl3, bl4));
            if (!file.equals(object3)) {
                arrayList.addAll(this.loadPluginsFromDir((File)object3, n2, n2 + n3, bl, bl3, bl4));
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading of external plugins skipped"));
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading built-in plugins"));
        }
        PluginManagerDefaults pluginManagerDefaults = PluginManager.getDefaults();
        for (n = 0; n < this.builtin_plugins.length; ++n) {
            if (pluginManagerDefaults.isDefaultPluginEnabled(this.builtin_plugins[n][0])) {
                if (this.core_operation != null) {
                    this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin") + this.builtin_plugins[n][0]);
                }
                try {
                    try {
                        loading_builtin = true;
                        object2 = this.root_class_loader.loadClass(this.builtin_plugins[n][1]);
                        genericDeclaration = ((Class)object2).getMethod("load", PluginInterface.class);
                        ((Method)genericDeclaration).invoke(null, this.getDefaultInterfaceSupport());
                        Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + this.builtin_plugins[n][0] + "' ok"));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        object = null;
                        loading_builtin = false;
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (this.builtin_plugins[n][4].equalsIgnoreCase("true")) {
                            Debug.printStackTrace(throwable);
                            Logger.log(new LogAlert(false, "Load of built in plugin '" + this.builtin_plugins[n][2] + "' fails", throwable));
                        }
                        object = null;
                        loading_builtin = false;
                        continue;
                    }
                    object = null;
                    loading_builtin = false;
                    continue;
                }
                catch (Throwable throwable) {
                    object = null;
                    loading_builtin = false;
                    throw throwable;
                }
            }
            if (!Logger.isEnabled()) continue;
            Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + this.builtin_plugins[n][2] + "' is disabled"));
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading dynamically registered plugins"));
        }
        for (n = 0; n < registration_queue.size(); ++n) {
            String string;
            object2 = registration_queue.get(n);
            if (object2 instanceof Class) {
                genericDeclaration = (Class<?>)object2;
                string = ((Class)genericDeclaration).getName();
            } else {
                object = (Object[])object2;
                Plugin plugin = (Plugin)object[0];
                genericDeclaration = plugin.getClass();
                string = (String)object[1];
            }
            try {
                object = ((Class)genericDeclaration).getMethod("load", PluginInterface.class);
                ((Method)object).invoke(null, this.getDefaultInterfaceSupport());
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Logger.log(new LogAlert(false, "Load of dynamic plugin '" + string + "' fails", throwable));
            }
        }
        return arrayList;
    }

    private void getRootClassLoader() {
        File file = FileUtil.getUserFile("shared");
        this.getRootClassLoader(file);
        File file2 = FileUtil.getApplicationFile("shared");
        if (!file.equals(file2)) {
            this.getRootClassLoader(file2);
        }
    }

    private void getRootClassLoader(File file) {
        File[] fileArray;
        if ((file = new File(file, "lib")).exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
            fileArray = PluginLauncherImpl.getHighestJarVersions(fileArray, new String[]{null}, new String[]{null}, false);
            for (int i = 0; i < fileArray.length; ++i) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Share class loader extended by " + fileArray[i].toString()));
                }
                this.root_class_loader = PluginLauncherImpl.addFileToClassPath(PluginInitializer.class.getClassLoader(), this.root_class_loader, fileArray[i]);
            }
        }
    }

    private List loadPluginsFromDir(File file, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Plugin Directory is " + file));
        }
        if (!file.exists()) {
            FileUtil.mkdirs(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].getName().equals("CVS")) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent(LOGID, "Skipping plugin " + fileArray[i].getName()));
                    continue;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading plugin " + fileArray[i].getName()));
                }
                if (this.core_operation != null) {
                    this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin") + fileArray[i].getName());
                }
                try {
                    List list = this.loadPluginFromDir(fileArray[i], bl, bl2, bl3);
                    this.loaded_pi_list.add(list);
                    arrayList.addAll(list);
                }
                catch (PluginException pluginException) {
                    // empty catch block
                }
                if (this.core_operation == null) continue;
                this.core_operation.reportPercent(100 * (i + n) / n2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List loadPluginFromDir(File file, boolean bl, boolean bl2, boolean bl3) throws PluginException {
        Object object;
        Serializable serializable;
        String[] stringArray;
        ArrayList<PluginInterfaceImpl> arrayList = new ArrayList<PluginInterfaceImpl>();
        ClassLoader classLoader = this.root_class_loader;
        if (!file.isDirectory()) {
            return arrayList;
        }
        String string = file.getName();
        File[] fileArray = file.listFiles();
        if (fileArray == null) return arrayList;
        if (fileArray.length == 0) {
            return arrayList;
        }
        boolean bl4 = false;
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray = fileArray[i].getName().toLowerCase();
            if (!stringArray.endsWith(".jar") && !stringArray.equals("plugin.properties")) continue;
            bl4 = true;
            break;
        }
        if (!bl4) {
            if (!Logger.isEnabled()) return arrayList;
            Logger.log(new LogEvent(LOGID, 1, "Plugin directory '" + file + "' has no plugin.properties " + "or .jar files, skipping"));
            return arrayList;
        }
        String[] stringArray2 = new String[]{null};
        stringArray = new String[]{null};
        fileArray = PluginLauncherImpl.getHighestJarVersions(fileArray, stringArray2, stringArray, true);
        for (int i = 0; i < fileArray.length; ++i) {
            serializable = fileArray[i];
            if (fileArray.length > 1 && ((String)(object = ((File)serializable).getName())).startsWith("i18nPlugin_")) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "renaming '" + (String)object + "' to conform with versioning system"));
                }
                ((File)serializable).renameTo(new File(((File)serializable).getParent(), "i18nAZ_0.1.jar  "));
                continue;
            }
            classLoader = PluginLauncherImpl.addFileToClassPath(this.root_class_loader, classLoader, (File)serializable);
        }
        String string2 = null;
        try {
            int n;
            Object object2;
            block47: {
                serializable = new Properties();
                object = new File(file.toString() + File.separator + "plugin.properties");
                try {
                    URLConnection uRLConnection;
                    if (((File)object).exists()) {
                        object2 = null;
                        try {
                            object2 = new FileInputStream((File)object);
                            ((Properties)serializable).load((InputStream)object2);
                            uRLConnection = null;
                            if (object2 == null) break block47;
                        }
                        catch (Throwable throwable) {
                            Object var17_21 = null;
                            if (object2 == null) throw throwable;
                            ((FileInputStream)object2).close();
                            throw throwable;
                        }
                        ((FileInputStream)object2).close();
                        break block47;
                    }
                    if (!(classLoader instanceof URLClassLoader)) throw new Exception("failed to load plugin.properties from dir or jars");
                    object2 = (URLClassLoader)classLoader;
                    URL uRL = ((URLClassLoader)object2).findResource("plugin.properties");
                    if (uRL == null) throw new Exception("failed to load plugin.properties from jars");
                    uRLConnection = uRL.openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    ((Properties)serializable).load(inputStream);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    String string3 = "Can't read 'plugin.properties' for plugin '" + string + "': file may be missing";
                    Logger.log(new LogAlert(false, 3, string3));
                    System.out.println(string3);
                    throw new PluginException(string3, throwable);
                }
            }
            PluginInitializer.checkJDKVersion(string, (Properties)serializable, true);
            PluginInitializer.checkAzureusVersion(string, (Properties)serializable, true);
            string2 = (String)((Properties)serializable).get("plugin.class");
            if (string2 == null && (string2 = (String)((Properties)serializable).get("plugin.classes")) == null) {
                string2 = "";
            }
            if ((object2 = (String)((Properties)serializable).get("plugin.name")) == null) {
                object2 = (String)((Properties)serializable).get("plugin.names");
            }
            int n2 = 0;
            int n3 = 0;
            do {
                Serializable serializable2;
                Object object3;
                String string4;
                if ((n = string2.indexOf(";", n2)) == -1) {
                    string4 = string2.substring(n2).trim();
                } else {
                    string4 = string2.substring(n2, n).trim();
                    n2 = n + 1;
                }
                PluginInterfaceImpl pluginInterfaceImpl = this.getPluginFromClass(string4);
                if (pluginInterfaceImpl != null) {
                    if (bl) {
                        return arrayList;
                    }
                    object3 = file.getParentFile();
                    serializable2 = null;
                    if (pluginInterfaceImpl.getInitializerKey() instanceof File) {
                        serializable2 = ((File)pluginInterfaceImpl.getInitializerKey()).getParentFile();
                    }
                    if (((File)object3).equals(FileUtil.getApplicationFile("plugins")) && serializable2 != null && ((File)serializable2).equals(FileUtil.getUserFile("plugins"))) {
                        if (!Logger.isEnabled()) return new ArrayList();
                        Logger.log(new LogEvent(LOGID, "Plugin '" + (String)object2 + "/" + string4 + ": shared version overridden by user-specific one"));
                        return new ArrayList();
                    }
                    Logger.log(new LogAlert(false, 1, "Error loading '" + (String)object2 + "', plugin class '" + string4 + "' is already loaded"));
                    continue;
                }
                object3 = null;
                if (object2 != null) {
                    int n4 = ((String)object2).indexOf(";", n3);
                    if (n4 == -1) {
                        object3 = ((String)object2).substring(n3).trim();
                    } else {
                        object3 = ((String)object2).substring(n3, n4).trim();
                        n3 = n4 + 1;
                    }
                }
                serializable2 = (Properties)((Properties)serializable).clone();
                for (int i = 0; i < default_version_details.length; ++i) {
                    if (!string4.equals(default_version_details[i][0])) continue;
                    if (((Properties)serializable2).get("plugin.id") == null) {
                        ((Properties)serializable2).put("plugin.id", default_version_details[i][1]);
                    }
                    if (object3 == null) {
                        object3 = default_version_details[i][2];
                    }
                    if (((Properties)serializable2).get("plugin.version") != null) continue;
                    if (stringArray2[0] != null) {
                        ((Properties)serializable2).put("plugin.version", stringArray2[0]);
                        continue;
                    }
                    ((Properties)serializable2).put("plugin.version", default_version_details[i][3]);
                }
                ((Properties)serializable2).put("plugin.class", string4);
                if (object3 != null) {
                    ((Properties)serializable2).put("plugin.name", object3);
                }
                Throwable throwable = null;
                String string5 = stringArray[0] == null ? file.getName() : stringArray[0];
                ArrayList<File> arrayList2 = null;
                Plugin plugin = null;
                if (this.vc_disabled_plugins.contains(string5)) {
                    this.log("Plugin '" + string5 + "' has been administratively disabled");
                    continue;
                }
                if (string5.endsWith("_v")) {
                    arrayList2 = new ArrayList<File>();
                    this.log("Re-verifying " + string5);
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file2 = fileArray[i];
                        if (!file2.getName().endsWith(".jar")) continue;
                        try {
                            this.log("    verifying " + file2);
                            AEVerifier.verifyData(file2);
                            arrayList2.add(file2);
                            this.log("    OK");
                            continue;
                        }
                        catch (Throwable throwable2) {
                            String string6 = "Error loading plugin '" + string + "' / '" + string2 + "'";
                            Logger.log(new LogAlert(false, string6, throwable2));
                            plugin = new FailedPlugin((String)object3, file.getAbsolutePath());
                        }
                    }
                }
                if (plugin == null) {
                    plugin = PluginLauncherImpl.getPreloadedPlugin(string4);
                    if (plugin == null) {
                        try {
                            Class<?> clazz = classLoader.loadClass(string4);
                            plugin = (Plugin)clazz.newInstance();
                        }
                        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                            plugin = new FailedPlugin((String)object3, file.getAbsolutePath());
                            throwable = new UnsupportedClassVersionError(unsupportedClassVersionError.getMessage());
                        }
                        catch (Throwable throwable3) {
                            if (!(throwable3 instanceof ClassNotFoundException) || !((Properties)serializable).getProperty("plugin.install_if_missing", "no").equalsIgnoreCase("yes")) {
                                throwable = throwable3;
                            }
                            plugin = new FailedPlugin((String)object3, file.getAbsolutePath());
                        }
                    } else {
                        classLoader = plugin.getClass().getClassLoader();
                    }
                }
                MessageText.integratePluginMessages((String)((Properties)serializable).get("plugin.langfile"), classLoader);
                PluginInterfaceImpl pluginInterfaceImpl2 = new PluginInterfaceImpl(plugin, this, file, classLoader, arrayList2, file.getName(), (Properties)serializable2, file.getAbsolutePath(), string5, stringArray2[0]);
                boolean bl5 = bl2 ? pluginInterfaceImpl2.getPluginState().isLoadedAtStartup() : bl3;
                pluginInterfaceImpl2.getPluginState().setDisabled(!bl5);
                try {
                    Method method = plugin.getClass().getMethod("load", PluginInterface.class);
                    method.invoke((Object)plugin, pluginInterfaceImpl2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                }
                arrayList.add(pluginInterfaceImpl2);
                if (throwable == null) continue;
                pluginInterfaceImpl2.setAsFailed();
            } while (n != -1);
            return arrayList;
        }
        catch (Throwable throwable) {
            if (throwable instanceof PluginException) {
                throw (PluginException)throwable;
            }
            Debug.printStackTrace(throwable);
            object = "Error loading plugin '" + string + "' / '" + string2 + "'";
            Logger.log(new LogAlert(false, (String)object, throwable));
            System.out.println((String)object + ": " + throwable);
            throw new PluginException((String)object, throwable);
        }
    }

    private void log(String string) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialisePlugins() {
        try {
            int n;
            int n2;
            PluginInitializer.addInitThread();
            final LinkedList<Runnable> linkedList = new LinkedList<Runnable>();
            int n3 = 0;
            while (n3 < this.loaded_pi_list.size()) {
                n2 = n3++;
                linkedList.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        block10: {
                            try {
                                block9: {
                                    try {
                                        List list = (List)PluginInitializer.this.loaded_pi_list.get(n2);
                                        if (list.size() <= 0) break block9;
                                        PluginInterfaceImpl pluginInterfaceImpl = (PluginInterfaceImpl)list.get(0);
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(LOGID, "Initializing plugin '" + pluginInterfaceImpl.getPluginName() + "'"));
                                        }
                                        if (PluginInitializer.this.core_operation != null) {
                                            PluginInitializer.this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin.init") + " " + pluginInterfaceImpl.getPluginName());
                                        }
                                        PluginInitializer.this.initialisePlugin(list);
                                        if (!Logger.isEnabled()) break block9;
                                        Logger.log(new LogEvent(LOGID, "Initialization of plugin '" + pluginInterfaceImpl.getPluginName() + "' complete"));
                                    }
                                    catch (Throwable throwable) {
                                        Object var4_5 = null;
                                        if (PluginInitializer.this.core_operation != null) {
                                            PluginInitializer.this.core_operation.reportPercent(100 * (n2 + 1) / PluginInitializer.this.loaded_pi_list.size());
                                        }
                                        break block10;
                                    }
                                }
                                Object var4_4 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                if (PluginInitializer.this.core_operation != null) {
                                    PluginInitializer.this.core_operation.reportPercent(100 * (n2 + 1) / PluginInitializer.this.loaded_pi_list.size());
                                }
                                throw throwable;
                            }
                            if (PluginInitializer.this.core_operation != null) {
                                PluginInitializer.this.core_operation.reportPercent(100 * (n2 + 1) / PluginInitializer.this.loaded_pi_list.size());
                            }
                        }
                        Logger.doRedirects();
                    }
                });
            }
            linkedList.add(new Runnable(){

                public void run() {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Initializing built-in plugins"));
                    }
                }
            });
            final PluginManagerDefaults pluginManagerDefaults = PluginManager.getDefaults();
            n2 = 0;
            while (n2 < this.builtin_plugins.length) {
                n = n2++;
                linkedList.add(new Runnable(){

                    public void run() {
                        block9: {
                            if (pluginManagerDefaults.isDefaultPluginEnabled(PluginInitializer.this.builtin_plugins[n][0])) {
                                String string = PluginInitializer.this.builtin_plugins[n][2];
                                String string2 = PluginInitializer.this.builtin_plugins[n][3];
                                try {
                                    Class<?> clazz = PluginInitializer.this.root_class_loader.loadClass(PluginInitializer.this.builtin_plugins[n][1]);
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, "Initializing built-in plugin '" + PluginInitializer.this.builtin_plugins[n][2] + "'"));
                                    }
                                    PluginInitializer.this.initializePluginFromClass(clazz, string, string2, "true".equals(PluginInitializer.this.builtin_plugins[n][5]), true, true);
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, 1, "Initialization of built in plugin '" + PluginInitializer.this.builtin_plugins[n][2] + "' complete"));
                                    }
                                    break block9;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        PluginInitializer.this.initializePluginFromClass(FailedPlugin.class, string, string2, false, false, true);
                                    }
                                    catch (Throwable throwable2) {
                                        // empty catch block
                                    }
                                    if (PluginInitializer.this.builtin_plugins[n][4].equalsIgnoreCase("true")) {
                                        Debug.printStackTrace(throwable);
                                        Logger.log(new LogAlert(false, "Initialization of built in plugin '" + PluginInitializer.this.builtin_plugins[n][2] + "' fails", throwable));
                                    }
                                    break block9;
                                }
                            }
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + PluginInitializer.this.builtin_plugins[n][2] + "' is disabled"));
                            }
                        }
                    }
                });
            }
            linkedList.add(new Runnable(){

                public void run() {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Initializing dynamically registered plugins"));
                    }
                }
            });
            n2 = 0;
            while (n2 < registration_queue.size()) {
                n = n2++;
                linkedList.add(new Runnable(){

                    public void run() {
                        try {
                            Object e = registration_queue.get(n);
                            if (e instanceof Class) {
                                Class clazz = (Class)e;
                                singleton.initializePluginFromClass(clazz, PluginInitializer.INTERNAL_PLUGIN_ID, clazz.getName(), false, true, true);
                            } else {
                                Object[] objectArray = (Object[])e;
                                Plugin plugin = (Plugin)objectArray[0];
                                singleton.initializePluginFromInstance(plugin, (String)objectArray[1], plugin.getClass().getName());
                            }
                        }
                        catch (PluginException pluginException) {
                            // empty catch block
                        }
                    }
                });
            }
            AEThread2 aEThread2 = new AEThread2("2nd PluginInitializer Thread", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        PluginInitializer.addInitThread();
                        while (true) {
                            Runnable runnable;
                            LinkedList linkedList2 = linkedList;
                            synchronized (linkedList2) {
                                if (linkedList.isEmpty()) {
                                    break;
                                }
                                runnable = (Runnable)linkedList.remove(0);
                            }
                            try {
                                runnable.run();
                            }
                            catch (Throwable throwable) {
                                Debug.out(throwable);
                            }
                        }
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        PluginInitializer.removeInitThread();
                        throw throwable;
                    }
                    PluginInitializer.removeInitThread();
                }
            };
            aEThread2.start();
            while (true) {
                Runnable runnable;
                LinkedList<Runnable> linkedList2 = linkedList;
                synchronized (linkedList2) {
                    if (linkedList.isEmpty()) {
                        break;
                    }
                    runnable = (Runnable)linkedList.remove(0);
                }
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
            aEThread2.join();
            registration_queue.clear();
            this.plugins_initialised = true;
            PluginInitializer.fireEvent(7);
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            PluginInitializer.removeInitThread();
            throw throwable;
        }
        PluginInitializer.removeInitThread();
    }

    protected void checkPluginsInitialised() {
        if (!this.plugins_initialised) {
            Debug.out("Wait until plugin initialisation is complete until doing this!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialisePlugin(List list) throws PluginException {
        PluginException pluginException = null;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            final PluginInterfaceImpl pluginInterfaceImpl = (PluginInterfaceImpl)list.get(i);
            if (pluginInterfaceImpl.getPluginState().isDisabled()) {
                object = this.s_plugin_interfaces;
                synchronized (object) {
                    this.s_plugin_interfaces.add(pluginInterfaceImpl);
                    continue;
                }
            }
            if (pluginInterfaceImpl.getPluginState().isOperational()) continue;
            object = null;
            final Plugin plugin = pluginInterfaceImpl.getPlugin();
            try {
                UtilitiesImpl.callWithPluginThreadContext((PluginInterface)pluginInterfaceImpl, new UtilitiesImpl.runnableWithException<PluginException>(){

                    @Override
                    public void run() throws PluginException {
                        PluginInitializer.this.fireCreated(pluginInterfaceImpl);
                        plugin.initialize(pluginInterfaceImpl);
                        if (!(plugin instanceof FailedPlugin)) {
                            pluginInterfaceImpl.getPluginStateImpl().setOperational(true, false);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            Object object2 = this.s_plugin_interfaces;
            synchronized (object2) {
                this.s_plugins.add(plugin);
                this.s_plugin_interfaces.add(pluginInterfaceImpl);
            }
            if (object == null) continue;
            Debug.printStackTrace((Throwable)object);
            object2 = "Error initializing plugin '" + pluginInterfaceImpl.getPluginName() + "'";
            Logger.log(new LogAlert(false, (String)object2, (Throwable)object));
            System.out.println((String)object2 + " : " + object);
            pluginException = new PluginException((String)object2, (Throwable)object);
        }
        if (pluginException != null) {
            throw pluginException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePluginFromClass(final Class clazz, final String string, String string2, boolean bl, boolean bl2, boolean bl3) throws PluginException {
        if (clazz != FailedPlugin.class && this.getPluginFromClass(clazz) != null) {
            Logger.log(new LogAlert(false, 1, "Error loading '" + string + "', plugin class '" + clazz.getName() + "' is already loaded"));
            return;
        }
        try {
            boolean bl4;
            String string3;
            final Plugin plugin = (Plugin)clazz.newInstance();
            if (string2.length() == 0) {
                string3 = clazz.getName();
                int n = string3.lastIndexOf(".");
                if (n != -1) {
                    string3 = string3.substring(n + 1);
                }
            } else {
                string3 = string2;
            }
            Properties properties = new Properties();
            properties.put("plugin.name", string3);
            final PluginInterfaceImpl pluginInterfaceImpl = new PluginInterfaceImpl(plugin, this, clazz, clazz.getClassLoader(), null, string2, properties, "", string, null);
            boolean bl5 = bl4 = bl2 ? pluginInterfaceImpl.getPluginState().isLoadedAtStartup() : bl3;
            if (bl && !bl4) {
                pluginInterfaceImpl.getPluginState().setLoadedAtStartup(true);
                bl4 = true;
                Logger.log(new LogAlert(false, 1, MessageText.getString("plugins.init.force_enabled", new String[]{string})));
            }
            pluginInterfaceImpl.getPluginState().setDisabled(!bl4);
            final boolean bl6 = bl4;
            UtilitiesImpl.callWithPluginThreadContext((PluginInterface)pluginInterfaceImpl, new UtilitiesImpl.runnableWithException<PluginException>(){

                @Override
                public void run() throws PluginException {
                    try {
                        Method method = clazz.getMethod("load", PluginInterface.class);
                        method.invoke((Object)plugin, pluginInterfaceImpl);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        Logger.log(new LogAlert(false, "Load of built in plugin '" + string + "' fails", throwable));
                    }
                    if (bl6) {
                        if (PluginInitializer.this.core_operation != null) {
                            PluginInitializer.this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin.init") + " " + pluginInterfaceImpl.getPluginName());
                        }
                        PluginInitializer.this.fireCreated(pluginInterfaceImpl);
                        plugin.initialize(pluginInterfaceImpl);
                        if (!(plugin instanceof FailedPlugin)) {
                            pluginInterfaceImpl.getPluginStateImpl().setOperational(true, false);
                        }
                    }
                }
            });
            List list = this.s_plugin_interfaces;
            synchronized (list) {
                this.s_plugins.add(plugin);
                this.s_plugin_interfaces.add(pluginInterfaceImpl);
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            String string4 = "Error loading internal plugin '" + clazz.getName() + "'";
            Logger.log(new LogAlert(false, string4, throwable));
            System.out.println(string4 + " : " + throwable);
            throw new PluginException(string4, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePluginFromInstance(final Plugin plugin, String string, String string2) throws PluginException {
        try {
            final PluginInterfaceImpl pluginInterfaceImpl = new PluginInterfaceImpl(plugin, this, plugin.getClass(), plugin.getClass().getClassLoader(), null, string2, new Properties(), "", string, null);
            UtilitiesImpl.callWithPluginThreadContext((PluginInterface)pluginInterfaceImpl, new UtilitiesImpl.runnableWithException<PluginException>(){

                @Override
                public void run() throws PluginException {
                    PluginInitializer.this.fireCreated(pluginInterfaceImpl);
                    plugin.initialize(pluginInterfaceImpl);
                    if (!(plugin instanceof FailedPlugin)) {
                        pluginInterfaceImpl.getPluginStateImpl().setOperational(true, false);
                    }
                }
            });
            List list = this.s_plugin_interfaces;
            synchronized (list) {
                this.s_plugins.add(plugin);
                this.s_plugin_interfaces.add(pluginInterfaceImpl);
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            String string3 = "Error loading internal plugin '" + plugin.getClass().getName() + "'";
            Logger.log(new LogAlert(false, string3, throwable));
            System.out.println(string3 + " : " + throwable);
            throw new PluginException(string3, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadPlugin(PluginInterfaceImpl pluginInterfaceImpl) {
        List list = this.s_plugin_interfaces;
        synchronized (list) {
            this.s_plugins.remove(pluginInterfaceImpl.getPlugin());
            this.s_plugin_interfaces.remove(pluginInterfaceImpl);
        }
        pluginInterfaceImpl.unloadSupport();
        for (int i = 0; i < this.loaded_pi_list.size(); ++i) {
            List list2 = (List)this.loaded_pi_list.get(i);
            if (!list2.remove(pluginInterfaceImpl)) continue;
            if (list2.size() == 0) {
                this.loaded_pi_list.remove(i);
            }
            return;
        }
    }

    protected void reloadPlugin(PluginInterfaceImpl pluginInterfaceImpl) throws PluginException {
        this.reloadPlugin(pluginInterfaceImpl, false, true);
    }

    protected void reloadPlugin(PluginInterfaceImpl pluginInterfaceImpl, boolean bl, boolean bl2) throws PluginException {
        this.unloadPlugin(pluginInterfaceImpl);
        Object object = pluginInterfaceImpl.getInitializerKey();
        String string = pluginInterfaceImpl.getPluginConfigKey();
        if (object instanceof File) {
            List list = this.loadPluginFromDir((File)object, false, bl, bl2);
            this.initialisePlugin(list);
        } else {
            this.initializePluginFromClass((Class)object, pluginInterfaceImpl.getPluginID(), string, false, bl, bl2);
        }
    }

    protected AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    protected GlobalManager getGlobalManager() {
        return this.azureus_core.getGlobalManager();
    }

    public static PluginInterface getDefaultInterface() {
        if (singleton == null) {
            throw new AzureusCoreException("PluginInitializer not instantiated by AzureusCore.create yet");
        }
        return singleton.getDefaultInterfaceSupport();
    }

    protected PluginInterface getDefaultInterfaceSupport() {
        if (this.default_plugin == null) {
            try {
                this.default_plugin = new PluginInterfaceImpl(new Plugin(){

                    public void initialize(PluginInterface pluginInterface) {
                    }
                }, this, this.getClass(), this.getClass().getClassLoader(), null, "default", new Properties(), null, INTERNAL_PLUGIN_ID, null);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        return this.default_plugin;
    }

    @Override
    public void downloadManagerAdded(DownloadManager downloadManager) {
    }

    @Override
    public void downloadManagerRemoved(DownloadManager downloadManager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyInitiated() {
        ArrayList arrayList;
        List list = this.s_plugin_interfaces;
        synchronized (list) {
            arrayList = new ArrayList(this.s_plugin_interfaces);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((PluginInterfaceImpl)arrayList.get(i)).closedownInitiated();
        }
        if (this.default_plugin != null) {
            this.default_plugin.closedownInitiated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyed() {
        ArrayList arrayList;
        List list = this.s_plugin_interfaces;
        synchronized (list) {
            arrayList = new ArrayList(this.s_plugin_interfaces);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((PluginInterfaceImpl)arrayList.get(i)).closedownComplete();
        }
        if (this.default_plugin != null) {
            this.default_plugin.closedownComplete();
        }
    }

    @Override
    public void seedingStatusChanged(boolean bl, boolean bl2) {
    }

    protected void runPEVTask(AERunnable aERunnable) {
        async_dispatcher.dispatch(aERunnable);
    }

    protected List<PluginEvent> getPEVHistory() {
        return plugin_event_history;
    }

    protected void fireEventSupport(final int n, final Object object) {
        async_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                ArrayList arrayList;
                PluginEvent pluginEvent = new PluginEvent(){

                    public int getType() {
                        return n;
                    }

                    public Object getValue() {
                        return object;
                    }
                };
                if (n == 1 || n == 2 || n == 5 || n == 6 || n == 7) {
                    plugin_event_history.add(pluginEvent);
                    if (plugin_event_history.size() > 1024) {
                        Debug.out("Plugin event history too large!!!!");
                        plugin_event_history.remove(0);
                    }
                }
                List list = PluginInitializer.this.s_plugin_interfaces;
                synchronized (list) {
                    arrayList = new ArrayList(PluginInitializer.this.s_plugin_interfaces);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        ((PluginInterfaceImpl)arrayList.get(i)).firePluginEventSupport(pluginEvent);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                if (PluginInitializer.this.default_plugin != null) {
                    PluginInitializer.this.default_plugin.firePluginEventSupport(pluginEvent);
                }
            }
        });
    }

    private void waitForEvents() {
        if (async_dispatcher.isDispatchThread()) {
            Debug.out("Deadlock - recode this monkey boy");
        } else {
            final AESemaphore aESemaphore = new AESemaphore("waiter");
            async_dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    aESemaphore.release();
                }
            });
            if (!aESemaphore.reserve(10000L)) {
                Debug.out("Timeout waiting for event dispatch");
            }
        }
    }

    public static void fireEvent(int n) {
        singleton.fireEventSupport(n, null);
    }

    public static void fireEvent(int n, Object object) {
        singleton.fireEventSupport(n, object);
    }

    public static void waitForPluginEvents() {
        singleton.waitForEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialisationComplete() {
        ArrayList arrayList;
        this.initialisation_complete = true;
        UIManagerImpl.initialisationComplete();
        List list = this.s_plugin_interfaces;
        synchronized (list) {
            arrayList = new ArrayList(this.s_plugin_interfaces);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((PluginInterfaceImpl)arrayList.get(i)).initialisationComplete();
        }
        if (this.default_plugin != null) {
            this.default_plugin.initialisationComplete();
        }
    }

    protected boolean isInitialisationComplete() {
        return this.initialisation_complete;
    }

    public static List getPluginInterfaces() {
        return singleton.getPluginInterfacesSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getPluginInterfacesSupport() {
        this.checkPluginsInitialised();
        List list = this.s_plugin_interfaces;
        synchronized (list) {
            return new ArrayList(this.s_plugin_interfaces);
        }
    }

    public PluginInterface[] getPlugins() {
        List list = this.getPluginInterfacesSupport();
        PluginInterface[] pluginInterfaceArray = new PluginInterface[list.size()];
        list.toArray(pluginInterfaceArray);
        return pluginInterfaceArray;
    }

    protected PluginManager getPluginManager() {
        return this.plugin_manager;
    }

    protected PluginInterfaceImpl getPluginFromClass(Class clazz) {
        return this.getPluginFromClass(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PluginInterfaceImpl getPluginFromClass(String string) {
        Object object;
        int n;
        ArrayList arrayList;
        List list = this.s_plugin_interfaces;
        synchronized (list) {
            arrayList = new ArrayList(this.s_plugin_interfaces);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (PluginInterfaceImpl)arrayList.get(n);
            if (!((PluginInterfaceImpl)object).getPlugin().getClass().getName().equals(string)) continue;
            return object;
        }
        for (n = 0; n < this.loaded_pi_list.size(); ++n) {
            object = (List)this.loaded_pi_list.get(n);
            for (int i = 0; i < object.size(); ++i) {
                PluginInterfaceImpl pluginInterfaceImpl = (PluginInterfaceImpl)object.get(i);
                if (!pluginInterfaceImpl.getPlugin().getClass().getName().equals(string)) continue;
                return pluginInterfaceImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Plugins");
        try {
            ArrayList arrayList;
            indentWriter.indent();
            List list = this.s_plugin_interfaces;
            synchronized (list) {
                arrayList = new ArrayList(this.s_plugin_interfaces);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                PluginInterfaceImpl pluginInterfaceImpl = (PluginInterfaceImpl)arrayList.get(i);
                pluginInterfaceImpl.generateEvidence(indentWriter);
            }
            Object var6_7 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    protected static void setVerified(PluginInterfaceImpl pluginInterfaceImpl, Plugin plugin, boolean bl, boolean bl2) throws PluginException {
        Object[] objectArray = (Object[])verified_plugin_holder.setValue(pluginInterfaceImpl, new Object[]{plugin, bl});
        if (objectArray != null && (objectArray[0] != plugin || (Boolean)objectArray[1] != bl)) {
            throw new PluginException("Verified status change not permitted");
        }
        if (bl2) {
            throw new RuntimeException("Plugin verification failed");
        }
    }

    public static boolean isVerified(PluginInterface pluginInterface, Plugin plugin) {
        if (!(pluginInterface instanceof PluginInterfaceImpl)) {
            return false;
        }
        VerifiedPluginHolder verifiedPluginHolder = verified_plugin_holder;
        if (verifiedPluginHolder.getClass() != VerifiedPluginHolder.class) {
            Debug.out("class mismatch");
            return false;
        }
        Object[] objectArray = (Object[])verified_plugin_holder.getValue(pluginInterface);
        return objectArray != null && objectArray[0] == plugin && (Boolean)objectArray[1] != false;
    }

    public static boolean isCoreOrVerifiedPlugin() {
        Class[] classArray = SESecurityManager.getClassContext();
        ClassLoader classLoader = PluginInitializer.class.getClassLoader();
        PluginInitializer pluginInitializer = PluginInitializer.peekSingleton();
        PluginInterface[] pluginInterfaceArray = pluginInitializer == null ? new PluginInterface[]{} : pluginInitializer.getPlugins();
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>();
        hashSet.add(classLoader);
        for (Class clazz : classArray) {
            ClassLoader classLoader2 = clazz.getClassLoader();
            if (classLoader2 == null || hashSet.contains(classLoader2)) continue;
            boolean bl = false;
            for (PluginInterface pluginInterface : pluginInterfaceArray) {
                Plugin plugin = pluginInterface.getPlugin();
                if (plugin.getClass().getClassLoader() != classLoader2 || !PluginInitializer.isVerified(pluginInterface, plugin)) continue;
                hashSet.add(classLoader2);
                bl = true;
                break;
            }
            if (bl) continue;
            Debug.out("Class " + clazz.getCanonicalName() + " with loader " + classLoader2 + " isn't trusted");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<PluginInitializer> clazz = PluginInitializer.class;
        synchronized (PluginInitializer.class) {
            verified_plugin_holder = new VerifiedPluginHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            default_version_details = new String[][]{{"org.cneclipse.multiport.MultiPortPlugin", "multi-ports", "Mutli-Port Trackers", "1.0"}};
            class_mon = new AEMonitor("PluginInitializer");
            registration_queue = new ArrayList();
            initThreads = new ArrayList(1);
            async_dispatcher = new AsyncDispatcher();
            plugin_event_history = new ArrayList<PluginEvent>();
            return;
        }
    }

    private static final class VerifiedPluginHolder {
        private volatile boolean initialised;
        private AESemaphore request_sem = new AESemaphore("ValueHolder");
        private List<Object[]> request_queue = new ArrayList<Object[]>();

        private VerifiedPluginHolder() {
            Class[] classArray = SESecurityManager.getClassContext();
            AEThread2 aEThread2 = new AEThread2("PluginVerifier"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
                    while (true) {
                        Object[] objectArray;
                        VerifiedPluginHolder.this.request_sem.reserve();
                        List<Object> list = VerifiedPluginHolder.this.request_queue;
                        synchronized (list) {
                            objectArray = (Object[])VerifiedPluginHolder.this.request_queue.remove(0);
                        }
                        if (objectArray[1] == null) {
                            objectArray[1] = identityHashMap.get(objectArray[0]);
                        } else {
                            list = identityHashMap.get(objectArray[0]);
                            if (list != null) {
                                objectArray[1] = list;
                            } else {
                                identityHashMap.put(objectArray[0], objectArray[1]);
                            }
                        }
                        ((AESemaphore)objectArray[2]).release();
                    }
                }
            };
            aEThread2.start();
            this.initialised = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object setValue(Object object, Object object2) {
            if (!this.initialised) {
                return null;
            }
            AESemaphore aESemaphore = new AESemaphore("ValueHolder:set");
            Object[] objectArray = new Object[]{object, object2, aESemaphore};
            List<Object[]> list = this.request_queue;
            synchronized (list) {
                this.request_queue.add(objectArray);
            }
            this.request_sem.release();
            aESemaphore.reserve();
            return objectArray[1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(Object object) {
            if (!this.initialised) {
                return null;
            }
            AESemaphore aESemaphore = new AESemaphore("ValueHolder:get");
            Object[] objectArray = new Object[]{object, null, aESemaphore};
            List<Object[]> list = this.request_queue;
            synchronized (list) {
                this.request_queue.add(objectArray);
            }
            this.request_sem.release();
            aESemaphore.reserve();
            return objectArray[1];
        }
    }
}

