/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx.access.jnilib;

import com.aelitis.azureus.core.drivedetector.DriveDetectorFactory;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.Map;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.macosx.access.jnilib.OSXDriveDetectListener;

public class OSXAccess {
    private static boolean bLoaded = false;
    private static boolean DEBUG = false;

    private static boolean loadLibrary(String string) {
        try {
            OSXAccess.SystemLoadLibrary(string);
            System.out.println(string + " v" + OSXAccess.getVersion() + " Load complete!");
            bLoaded = true;
            OSXAccess.initDriveDetection();
        }
        catch (Throwable throwable) {
            Debug.outNoStack("Could not find lib" + string + ".jnilib; " + throwable.toString());
        }
        return bLoaded;
    }

    private static void SystemLoadLibrary(String string) throws Throwable {
        try {
            System.loadLibrary(string);
        }
        catch (Throwable throwable) {
            try {
                File file = new File("Azureus.app/Contents/Resources/Java/dll/lib" + string + ".jnilib");
                System.load(file.getAbsolutePath());
            }
            catch (Throwable throwable2) {
                throw throwable;
            }
        }
    }

    private static void initDriveDetection() {
        try {
            OSXAccess.initializeDriveDetection(new OSXDriveDetectListener(){

                public void driveRemoved(File file, Map map) {
                    if (DEBUG) {
                        System.out.println("UNMounted " + file);
                        for (Object k : map.keySet()) {
                            Object v = map.get(k);
                            System.out.println("\t" + k + "\t:\t" + v);
                        }
                    }
                    DriveDetectorFactory.getDeviceDetector().driveRemoved(file);
                }

                public void driveDetected(File file, Map map) {
                    if (DEBUG) {
                        System.out.println("Mounted " + file);
                        for (Object k : map.keySet()) {
                            Object v = map.get(k);
                            System.out.println("\t" + k + "\t:\t" + v);
                        }
                    }
                    boolean bl = MapUtils.getMapLong(map, "isOptical", 0L) != 0L;
                    boolean bl2 = MapUtils.getMapLong(map, "Removable", 0L) != 0L;
                    boolean bl3 = MapUtils.getMapLong(map, "Writable", 0L) != 0L;
                    boolean bl4 = bl2 && bl3 && !bl;
                    map.put("isWritableUSB", bl4);
                    DriveDetectorFactory.getDeviceDetector().driveDetected(file, map);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final native int AEGetParamDesc(int var0, int var1, int var2, Object var3);

    public static final native String getVersion();

    public static final native String getDocDir();

    public static final native void memmove(byte[] var0, int var1, int var2);

    public static final native void initializeDriveDetection(OSXDriveDetectListener var0);

    public static boolean isLoaded() {
        return bLoaded;
    }

    static {
        if (!Constants.isOSX_10_5_OrHigher || !OSXAccess.loadLibrary("OSXAccess_10.5")) {
            OSXAccess.loadLibrary("OSXAccess");
        }
    }
}

