/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class PlatformManagerUpdateChecker
implements Plugin,
UpdatableComponent {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String UPDATE_NAME = "Platform-specific support";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    protected PluginInterface plugin_interface;

    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Platform-Specific Support");
        String string = "1.0";
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        if (platformManager.getPlatformType() == 3) {
            if (platformManager.hasCapability(PlatformManagerCapabilities.GetVersion)) {
                try {
                    string = platformManager.getVersion();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, false);
        } else {
            this.plugin_interface.getPluginProperties().setProperty("plugin.version.info", "Not required for this platform");
        }
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", string);
    }

    public String getName() {
        return UPDATE_NAME;
    }

    public int getMaximumCheckTime() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdate(final UpdateChecker updateChecker) {
        try {
            block12: {
                try {
                    Object object;
                    String string;
                    String string2;
                    SFPluginDetails sFPluginDetails = SFPluginDetailsLoaderFactory.getSingleton().getPluginDetails(this.plugin_interface.getPluginID());
                    String string3 = this.plugin_interface.getPluginVersion();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "PlatformManager:OSX update check starts: current = " + string3));
                    }
                    boolean bl = Constants.isCVSVersion();
                    String string4 = string2 = sFPluginDetails.getVersion();
                    if (bl && (string = sFPluginDetails.getCVSVersion()).length() > 0) {
                        string2 = string;
                        string4 = string2.substring(0, string2.length() - 4);
                    }
                    string = null;
                    if (string4.length() == 0 || !Character.isDigit(string4.charAt(0))) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "PlatformManager:OSX no valid version to check against (" + string4 + ")"));
                        }
                    } else if (Constants.compareVersions(string3, string4) < 0) {
                        string = string4;
                    }
                    updateChecker.reportProgress("OSX: current = " + string3 + ", latest = " + string4);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "PlatformManager:OSX update required = " + (string != null)));
                    }
                    if (string == null) break block12;
                    String string5 = sFPluginDetails.getDownloadURL();
                    if (bl && ((String)(object = sFPluginDetails.getCVSVersion())).length() > 0) {
                        string5 = sFPluginDetails.getCVSDownloadURL();
                    }
                    object = ResourceDownloaderFactoryImpl.getSingleton();
                    ResourceDownloader resourceDownloader = object.create(new URL(string5));
                    String string6 = "http://torrent.vuze.com/torrents/";
                    int n = string5.lastIndexOf("/");
                    string6 = n == -1 ? string6 + string5 : string6 + string5.substring(n + 1);
                    string6 = string6 + ".torrent";
                    ResourceDownloader resourceDownloader2 = object.create(new URL(string6));
                    resourceDownloader2 = object.getSuffixBasedDownloader(resourceDownloader2);
                    ResourceDownloader resourceDownloader3 = object.getAlternateDownloader(new ResourceDownloader[]{resourceDownloader2, resourceDownloader});
                    object.getTimeoutDownloader(object.getRetryDownloader(resourceDownloader3, 3), 10000).getSize();
                    ArrayList arrayList = new ArrayList();
                    List list = HTMLUtils.convertHTMLToText("", sFPluginDetails.getDescription());
                    arrayList.addAll(list);
                    List list2 = HTMLUtils.convertHTMLToText("    ", sFPluginDetails.getComment());
                    arrayList.addAll(list2);
                    String[] stringArray = new String[arrayList.size()];
                    arrayList.toArray(stringArray);
                    final Update update = updateChecker.addUpdate(UPDATE_NAME, stringArray, string, resourceDownloader3, 2);
                    update.setDescriptionURL(sFPluginDetails.getInfoURL());
                    resourceDownloader3.addListener(new ResourceDownloaderAdapter(){

                        public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
                            PlatformManagerUpdateChecker.this.installUpdate(updateChecker, update, resourceDownloader, inputStream);
                            return true;
                        }

                        public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
                            Debug.out(resourceDownloader.getName() + " failed", resourceDownloaderException);
                            update.complete(false);
                        }
                    });
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    updateChecker.reportProgress("Failed to load plugin details for the platform manager: " + Debug.getNestedExceptionMessage(throwable));
                    updateChecker.failed();
                    Object var21_22 = null;
                    updateChecker.completed();
                }
            }
            Object var21_21 = null;
            updateChecker.completed();
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            updateChecker.completed();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void installUpdate(UpdateChecker updateChecker, Update update, ResourceDownloader resourceDownloader, InputStream inputStream) {
        ZipInputStream zipInputStream = null;
        inputStream = update.verifyData(inputStream, true);
        resourceDownloader.reportActivity("Data verified successfully");
        UpdateInstaller updateInstaller = updateChecker.createInstaller();
        zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (!string.toLowerCase().startsWith("osx/") || (string = string.substring(4)).length() <= 0) continue;
            resourceDownloader.reportActivity("Adding update action for '" + string + "'");
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "PlatformManager:OSX adding action for '" + string + "'"));
            }
            String string2 = string.replaceAll("/", "-");
            updateInstaller.addResource(string2, zipInputStream, false);
            String string3 = updateInstaller.getInstallDir() + File.separator + SystemProperties.getApplicationName() + ".app" + File.separator + string;
            updateInstaller.addMoveAction(string2, string3);
            if (!string.endsWith(".jnilib") && !string.endsWith("JavaApplicationStub")) continue;
            updateInstaller.addChangeRightsAction("755", string3);
        }
        update.complete(true);
        Object var12_12 = null;
        if (zipInputStream == null) return;
        try {
            zipInputStream.close();
            return;
        }
        catch (Throwable throwable) {}
        return;
        {
            catch (Throwable throwable) {
                update.complete(false);
                resourceDownloader.reportActivity("Update install failed:" + throwable.getMessage());
                Object var12_13 = null;
                if (zipInputStream == null) return;
                try {
                    zipInputStream.close();
                    return;
                }
                catch (Throwable throwable2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected List splitMultiLine(String string, String string2) {
        int n;
        int n2 = 0;
        String string3 = string2.toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            String string4;
            if ((n = string3.indexOf("<br>", n2)) == -1) {
                string4 = string2.substring(n2);
            } else {
                string4 = string2.substring(n2, n);
                n2 = n + 4;
            }
            arrayList.add(string + string4);
        } while (n != -1);
        return arrayList;
    }
}

