/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform;

import java.util.Properties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.macosx.PlatformManagerUpdateChecker;
import org.gudy.azureus2.platform.unix.PlatformManagerUnixPlugin;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateChecker;

public class PlatformManagerPluginDelegate
implements Plugin,
UpdatableComponent {
    public void initialize(PluginInterface pluginInterface) throws PluginException {
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        int n = platformManager.getPlatformType();
        if (n != 1) {
            if (n == 3) {
                PlatformManagerUpdateChecker platformManagerUpdateChecker = new PlatformManagerUpdateChecker();
                platformManagerUpdateChecker.initialize(pluginInterface);
            } else if (n == 4) {
                PlatformManagerUnixPlugin platformManagerUnixPlugin = new PlatformManagerUnixPlugin();
                platformManagerUnixPlugin.initialize(pluginInterface);
            } else {
                Properties properties = pluginInterface.getPluginProperties();
                properties.setProperty("plugin.name", "Platform-Specific Support");
                properties.setProperty("plugin.version", "1.0");
                properties.setProperty("plugin.version.info", "Not required for this platform");
            }
        }
    }

    public String getName() {
        return "Mixin only";
    }

    public int getMaximumCheckTime() {
        return 0;
    }

    public void checkForUpdate(UpdateChecker updateChecker) {
    }
}

