/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class DebugWeakList {
    static final boolean DEBUG = Constants.isCVSVersion();
    private String name;
    private List list;

    public DebugWeakList(String string) {
        this.name = string;
        this.list = new ArrayList();
    }

    public DebugWeakList(String string, DebugWeakList debugWeakList) {
        this.name = string;
        this.list = new ArrayList(debugWeakList.list);
    }

    public void add(Object object) {
        if (DEBUG) {
            this.list.add(new Object[]{object.getClass(), new WeakReference<Object>(object)});
        } else {
            this.list.add(object);
        }
    }

    public void remove(Object object) {
        if (DEBUG) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                WeakReference weakReference = (WeakReference)objectArray[1];
                Object t = weakReference.get();
                if (t == null) {
                    iterator.remove();
                    this.logRemoved((Class)objectArray[0]);
                    continue;
                }
                if (t != object) continue;
                iterator.remove();
                return;
            }
        } else {
            this.list.remove(object);
        }
    }

    public boolean contains(Object object) {
        if (DEBUG) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                WeakReference weakReference = (WeakReference)objectArray[1];
                Object t = weakReference.get();
                if (t == null) {
                    iterator.remove();
                    this.logRemoved((Class)objectArray[0]);
                    continue;
                }
                if (t != object) continue;
                return true;
            }
            return false;
        }
        return this.list.contains(object);
    }

    protected void logRemoved(Class clazz) {
        Debug.out("Object '" + clazz + "' was not removed correctly from " + this.name);
    }

    public Iterator iterator() {
        if (DEBUG) {
            return new WeakListIterator();
        }
        return this.list.iterator();
    }

    public int estimatedSize() {
        return this.list.size();
    }

    protected class WeakListIterator
    implements Iterator {
        private Iterator it;
        private Object pending_result;
        private Object last_result;

        protected WeakListIterator() {
            this.it = DebugWeakList.this.list.iterator();
        }

        public boolean hasNext() {
            if (this.pending_result != null) {
                return true;
            }
            while (this.it.hasNext()) {
                Object[] objectArray = (Object[])this.it.next();
                WeakReference weakReference = (WeakReference)objectArray[1];
                Object t = weakReference.get();
                if (t == null) {
                    this.it.remove();
                    DebugWeakList.this.logRemoved((Class)objectArray[0]);
                    continue;
                }
                this.pending_result = t;
                return true;
            }
            return false;
        }

        public Object next() throws NoSuchElementException {
            if (this.pending_result == null) {
                this.hasNext();
            }
            if (this.pending_result == null) {
                throw new NoSuchElementException();
            }
            this.last_result = this.pending_result;
            this.pending_result = null;
            return this.last_result;
        }

        public void remove() {
            Object object = this.last_result;
            if (object == null) {
                throw new NoSuchElementException();
            }
            this.last_result = null;
            if (this.pending_result == null) {
                this.it.remove();
            } else {
                Iterator iterator = DebugWeakList.this.list.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    WeakReference weakReference = (WeakReference)objectArray[1];
                    Object t = weakReference.get();
                    if (t != object) continue;
                    this.it = iterator;
                    this.it.remove();
                    return;
                }
            }
        }
    }
}

