/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class AEMonSem {
    protected static boolean DEBUG = false;
    protected static boolean DEBUG_CHECK_DUPLICATES = false;
    protected static long DEBUG_TIMER = 30000L;
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return new Stack();
        }
    };
    private static long monitor_id_next;
    private static long semaphore_id_next;
    private static Map debug_traces;
    private static List debug_recursions;
    private static List debug_reciprocals;
    private static Map debug_name_mapping;
    private static Map debug_monitors;
    private static Map debug_semaphores;
    protected long entry_count;
    protected long last_entry_count;
    protected String last_trace_key;
    protected String name;
    protected boolean is_monitor;
    protected int waiting = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void check(AEDiagnosticsLogger aEDiagnosticsLogger) {
        ArrayList<AEMonSem> arrayList = new ArrayList<AEMonSem>();
        ArrayList<AEMonitor> arrayList2 = new ArrayList<AEMonitor>();
        ArrayList<AEMonitor> arrayList3 = new ArrayList<AEMonitor>();
        ArrayList<AEMonSem> arrayList4 = new ArrayList<AEMonSem>();
        AEMonSem[] aEMonSemArray = AEMonSem.class;
        synchronized (AEMonSem.class) {
            Thread thread;
            int n;
            aEDiagnosticsLogger.log("AEMonSem: mid = " + monitor_id_next + ", sid = " + semaphore_id_next + ", monitors = " + debug_monitors.size() + ", semaphores = " + debug_semaphores.size() + ", names = " + debug_name_mapping.size() + ", traces = " + debug_traces.size());
            Object object = debug_monitors.keySet().iterator();
            long l = 0L;
            while (object.hasNext()) {
                AEMonitor aEMonitor = (AEMonitor)object.next();
                long l2 = aEMonitor.entry_count - aEMonitor.last_entry_count;
                if (l2 != 0L) {
                    arrayList.add(aEMonitor);
                    l += l2;
                }
                if (aEMonitor.waiting > 0) {
                    arrayList2.add(aEMonitor);
                    continue;
                }
                if (aEMonitor.owner == null) continue;
                arrayList3.add(aEMonitor);
            }
            object = debug_semaphores.keySet().iterator();
            long l3 = 0L;
            while (object.hasNext()) {
                AEMonSem aEMonSem = (AEMonSem)object.next();
                long l4 = aEMonSem.entry_count - aEMonSem.last_entry_count;
                if (l4 != 0L) {
                    arrayList.add(aEMonSem);
                    l3 += l4;
                }
                if (aEMonSem.waiting <= 0) continue;
                arrayList4.add(aEMonSem);
            }
            aEDiagnosticsLogger.log("    activity: monitors = " + l + " - " + l / (DEBUG_TIMER / 1000L) + "/sec, semaphores = " + l3 + " - " + l3 / (DEBUG_TIMER / 1000L) + "/sec ");
            // ** MonitorExit[var5_5] (shouldn't be in output)
            aEMonSemArray = new AEMonSem[arrayList.size()];
            arrayList.toArray(aEMonSemArray);
            Arrays.sort(aEMonSemArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    AEMonSem aEMonSem = (AEMonSem)object;
                    AEMonSem aEMonSem2 = (AEMonSem)object2;
                    return aEMonSem.name.compareTo(aEMonSem2.name);
                }
            });
            object = null;
            l = 0L;
            Object[][] objectArrayArray = new Object[aEMonSemArray.length][];
            int n2 = 0;
            for (int i = 0; i < aEMonSemArray.length; ++i) {
                AEMonSem aEMonSem = aEMonSemArray[i];
                long l5 = aEMonSem.entry_count - aEMonSem.last_entry_count;
                if (object == null) {
                    object = aEMonSem;
                    continue;
                }
                if (((AEMonSem)object).name.equals(aEMonSem.name)) {
                    l += l5;
                    continue;
                }
                objectArrayArray[n2++] = new Object[]{((AEMonSem)object).name, new Long(l)};
                object = aEMonSem;
                l = l5;
            }
            if (object != null) {
                objectArrayArray[n2++] = new Object[]{((AEMonSem)object).name, new Long(l)};
            }
            Arrays.sort(objectArrayArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = (Object[])object2;
                    if (objectArray == null && objectArray2 == null) {
                        return 0;
                    }
                    if (objectArray == null) {
                        return 1;
                    }
                    if (objectArray2 == null) {
                        return -1;
                    }
                    long l = (Long)objectArray[1];
                    long l2 = (Long)objectArray2[1];
                    return (int)(l2 - l);
                }
            });
            String string = "    top activity: ";
            for (n = 0; n < Math.min(10, objectArrayArray.length); ++n) {
                if (objectArrayArray[n] == null) continue;
                string = string + (n == 0 ? "" : ", ") + objectArrayArray[n][0] + " = " + objectArrayArray[n][1];
            }
            aEDiagnosticsLogger.log(string);
            if (arrayList2.size() > 0) {
                aEDiagnosticsLogger.log("    waiting monitors");
                for (n = 0; n < arrayList2.size(); ++n) {
                    AEMonSem aEMonSem = (AEMonSem)arrayList2.get(n);
                    thread = ((AEMonitor)aEMonSem).last_waiter;
                    aEDiagnosticsLogger.log("        [" + (thread == null ? "<waiter lost>" : thread.getName()) + "] " + aEMonSem.name + " - " + aEMonSem.last_trace_key);
                }
            }
            if (arrayList3.size() > 0) {
                aEDiagnosticsLogger.log("    busy monitors");
                for (n = 0; n < arrayList3.size(); ++n) {
                    AEMonSem aEMonSem = (AEMonSem)arrayList3.get(n);
                    thread = ((AEMonitor)aEMonSem).owner;
                    aEDiagnosticsLogger.log("        [" + (thread == null ? "<owner lost>" : thread.getName()) + "] " + aEMonSem.name + " - " + aEMonSem.last_trace_key);
                }
            }
            if (arrayList4.size() > 0) {
                aEDiagnosticsLogger.log("    waiting semaphores");
                for (n = 0; n < arrayList4.size(); ++n) {
                    AEMonSem aEMonSem = (AEMonSem)arrayList4.get(n);
                    thread = ((AESemaphore)aEMonSem).latest_waiter;
                    aEDiagnosticsLogger.log("        [" + (thread == null ? "<waiter lost>" : thread.getName()) + "] " + aEMonSem.name + " - " + aEMonSem.last_trace_key);
                }
            }
            for (n = 0; n < aEMonSemArray.length; ++n) {
                AEMonSem aEMonSem = aEMonSemArray[n];
                aEMonSem.last_entry_count = aEMonSem.entry_count;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AEMonSem(String string, boolean bl) {
        this.is_monitor = bl;
        this.name = this.is_monitor ? string : StringInterner.intern("(S)" + string);
        if (!DEBUG) return;
        Class<AEMonSem> clazz = AEMonSem.class;
        synchronized (AEMonSem.class) {
            if (this.is_monitor) {
                ++monitor_id_next;
            } else {
                ++semaphore_id_next;
            }
            StackTraceElement stackTraceElement = new Exception().getStackTrace()[2];
            String string2 = stackTraceElement.getClassName();
            int n = stackTraceElement.getLineNumber();
            monSemData monSemData2 = new monSemData(string2, n);
            if (this.is_monitor) {
                debug_monitors.put(this, monSemData2);
            } else {
                debug_semaphores.put(this, monSemData2);
            }
            if (!DEBUG_CHECK_DUPLICATES) return;
            monSemData monSemData3 = (monSemData)debug_name_mapping.get(this.name);
            if (monSemData3 == null) {
                debug_name_mapping.put(this.name, monSemData2);
            } else {
                if (monSemData3.class_name.equals(string2) && monSemData3.line_number == n) return;
                Debug.out(new Exception("Duplicate AEMonSem name '" + this.name + "'"));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void debugEntry() {
        block23: {
            try {
                CharSequence charSequence;
                Stack stack = (Stack)tls.get();
                if (stack.size() > 64) {
                    charSequence = new StringBuffer(1024);
                    for (int i = 0; i < stack.size(); ++i) {
                        AEMonSem aEMonSem = (AEMonSem)stack.get(i);
                        ((StringBuffer)charSequence).append("$" + aEMonSem.name);
                    }
                    Debug.out("**** Whoaaaaaa, AEMonSem debug stack is getting too large!!!! **** " + charSequence);
                }
                if (!stack.isEmpty()) {
                    Object object;
                    charSequence = "";
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = this.is_monitor && !debug_recursions.contains(this.name);
                    String string = null;
                    for (int i = 0; i < stack.size(); ++i) {
                        AEMonSem aEMonSem = (AEMonSem)stack.get(i);
                        if (bl && aEMonSem.name.equals(this.name) && aEMonSem != this) {
                            charSequence = (String)charSequence + (((String)charSequence).length() == 0 ? "" : "\r\n") + "Recursive locks on different instances: " + this.name;
                            debug_recursions.add(this.name);
                        }
                        if (string == null || !aEMonSem.name.equals(string)) {
                            stringBuffer.append("$");
                            stringBuffer.append(aEMonSem.name);
                        }
                        string = aEMonSem.name;
                    }
                    stringBuffer.append("$");
                    stringBuffer.append(this.name);
                    stringBuffer.append("$");
                    String string2 = stringBuffer.toString();
                    if (((String)charSequence).length() > 0) {
                        Debug.outNoStack((String)charSequence + "\r\n    " + string2);
                    }
                    this.last_trace_key = string2;
                    if (!this.is_monitor) {
                        boolean bl2 = false;
                        for (int i = 0; i < stack.size(); ++i) {
                            object = (AEMonSem)stack.get(i);
                            if (!((AEMonSem)object).name.equals(this.name)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            stack.push(this);
                        }
                    } else {
                        stack.push(this);
                    }
                    Map map = debug_traces;
                    synchronized (map) {
                        if (debug_traces.get(string2) == null) {
                            Thread thread = Thread.currentThread();
                            object = thread.getName() + "[" + thread.hashCode() + "]";
                            String string3 = Debug.getStackTrace(true, false);
                            for (String string4 : debug_traces.keySet()) {
                                Object object2;
                                int n;
                                String[] stringArray = (String[])debug_traces.get(string4);
                                String string5 = stringArray[0];
                                String string6 = stringArray[1];
                                if (((String)object).equals(string5)) continue;
                                int n2 = stack.size();
                                int n3 = 0;
                                for (n = 0; n < stack.size(); ++n) {
                                    object2 = ((AEMonSem)stack.get((int)n)).name;
                                    int n4 = string4.indexOf("$" + (String)object2 + "$");
                                    if (n4 == -1) continue;
                                    ++n3;
                                    n2 = Math.min(n2, n + 1);
                                }
                                if (n3 < 2) continue;
                                for (n = 0; n < n2; ++n) {
                                    object2 = (AEMonSem)stack.get(n);
                                    if (!((AEMonSem)object2).is_monitor) continue;
                                    String string7 = ((AEMonSem)object2).name;
                                    for (int i = n + 1; i < stack.size(); ++i) {
                                        String string8;
                                        String string9;
                                        AEMonSem aEMonSem = (AEMonSem)stack.get(i);
                                        if (!aEMonSem.is_monitor || string7.equals(string9 = aEMonSem.name)) continue;
                                        int n5 = string4.indexOf("$" + string7 + "$");
                                        int n6 = string4.indexOf("$" + string9 + "$");
                                        if (n5 == -1 || n6 == -1 || n5 <= n6 || debug_reciprocals.contains(string8 = string2 + " / " + string4)) continue;
                                        debug_reciprocals.add(string8);
                                        Debug.outNoStack("AEMonSem: Reciprocal usage:\r\n    " + string2 + "\r\n" + "        [" + (String)object + "] " + string3 + "\r\n" + "    " + string4 + "\r\n" + "        [" + string5 + "] " + string6);
                                    }
                                }
                            }
                            debug_traces.put(string2, new String[]{object, string3});
                        }
                        break block23;
                    }
                }
                this.last_trace_key = "$" + this.name + "$";
                stack.push(this);
            }
            catch (Throwable throwable) {
                try {
                    Debug.printStackTrace(throwable);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
    }

    protected void debugExit() {
        try {
            Stack stack = (Stack)tls.get();
            if (this.is_monitor) {
                while (stack.peek() != this) {
                    stack.pop();
                }
                stack.pop();
            } else if (!stack.isEmpty() && stack.peek() == this) {
                stack.pop();
            }
        }
        catch (Throwable throwable) {
            try {
                Debug.printStackTrace(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.name;
    }

    static {
        debug_traces = new HashMap();
        debug_recursions = new ArrayList();
        debug_reciprocals = new ArrayList();
        debug_name_mapping = new WeakHashMap();
        debug_monitors = new WeakHashMap();
        debug_semaphores = new WeakHashMap();
        if (DEBUG) {
            Thread thread = new Thread("AEMonSem:delay debug init"){

                public void run() {
                    debug_recursions.add("ResourceDownloader");
                    debug_recursions.add("ConnectionPool:CP");
                    debug_recursions.add("(S)RDRretry");
                    try {
                        Thread.sleep(DEBUG_TIMER);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    TimerEventPerformer timerEventPerformer = new TimerEventPerformer(){
                        AEDiagnosticsLogger diag_logger;

                        public void perform(TimerEvent timerEvent2) {
                            if (this.diag_logger == null) {
                                this.diag_logger = AEDiagnostics.getLogger("monsem");
                            }
                            AEMonSem.check(this.diag_logger);
                        }
                    };
                    timerEventPerformer.perform(null);
                    new Timer("AEMonSem").addPeriodicEvent(DEBUG_TIMER, timerEventPerformer);
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    protected static class monSemData {
        protected String class_name;
        protected int line_number;

        protected monSemData(String string, int n) {
            this.class_name = string;
            this.line_number = n;
        }
    }
}

