/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class TRNonBlockingServerProcessor
extends TRTrackerServerProcessorTCP {
    private static final int READ_BUFFER_INITIAL = 1024;
    private static final int READ_BUFFER_INCREMENT = 1024;
    private static final int READ_BUFFER_LIMIT = 32768;
    private SocketChannel socket_channel;
    private long start_time;
    private ByteBuffer read_buffer;
    private String request_header;
    private ByteBuffer write_buffer;

    protected TRNonBlockingServerProcessor(TRTrackerServerTCP tRTrackerServerTCP, SocketChannel socketChannel) {
        super(tRTrackerServerTCP);
        this.socket_channel = socketChannel;
        this.start_time = SystemTime.getCurrentTime();
        this.read_buffer = ByteBuffer.allocate(1024);
    }

    protected int processRead() {
        byte[] byArray;
        int n;
        if (this.read_buffer.remaining() == 0) {
            n = this.read_buffer.capacity();
            if (n == 32768) {
                return -1;
            }
            this.read_buffer.position(0);
            byArray = new byte[n];
            this.read_buffer.get(byArray);
            this.read_buffer = ByteBuffer.allocate(n + 1024);
            this.read_buffer.put(byArray);
        }
        try {
            n = this.socket_channel.read(this.read_buffer);
            if (n < 0) {
                return -1;
            }
            if (n == 0) {
                return 2;
            }
            byArray = this.read_buffer.array();
            for (int i = this.read_buffer.position() - 4; i >= 0; --i) {
                if (byArray[i] != 13 || byArray[i + 1] != 10 || byArray[i + 2] != 13 || byArray[i + 3] != 10) continue;
                this.request_header = new String(byArray, 0, this.read_buffer.position());
                this.getServer().runProcessor(this);
                return 0;
            }
            return 1;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    protected int processWrite() {
        if (this.write_buffer == null) {
            return -1;
        }
        if (!this.write_buffer.hasRemaining()) {
            return 0;
        }
        try {
            int n = this.socket_channel.write(this.write_buffer);
            if (n == 0) {
                return 2;
            }
            if (this.write_buffer.hasRemaining()) {
                return 1;
            }
            return 0;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSupport() {
        boolean bl = false;
        try {
            try {
                String string = this.request_header.substring(4).trim();
                int n = string.indexOf(" ");
                string = string.substring(0, n);
                final AESemaphore[] aESemaphoreArray = new AESemaphore[]{null};
                final ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[]{null};
                AsyncController asyncController = new AsyncController(){

                    public void setAsyncStart() {
                        aESemaphoreArray[0] = new AESemaphore("async");
                    }

                    public void setAsyncComplete() {
                        aESemaphoreArray[0].reserve();
                        TRNonBlockingServerProcessor.this.asyncProcessComplete(byteArrayOutputStreamArray[0]);
                    }
                };
                try {
                    ByteArrayOutputStream byteArrayOutputStream = this.process(this.request_header, this.request_header.toLowerCase(), string, (InetSocketAddress)this.socket_channel.socket().getRemoteSocketAddress(), TRTrackerServerImpl.restrict_non_blocking_requests, new ByteArrayInputStream(new byte[0]), asyncController);
                    if (byteArrayOutputStream == null) {
                        bl = true;
                    } else if (aESemaphoreArray[0] != null) {
                        byteArrayOutputStreamArray[0] = byteArrayOutputStream;
                        bl = true;
                    } else {
                        this.write_buffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (aESemaphoreArray[0] != null) {
                        aESemaphoreArray[0].release();
                    }
                    throw throwable;
                }
                if (aESemaphoreArray[0] != null) {
                    aESemaphoreArray[0].release();
                }
                Object var11_12 = null;
                if (!bl) {
                    ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (!bl) {
                    ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!bl) {
                ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
            }
            throw throwable;
        }
    }

    protected abstract ByteArrayOutputStream process(String var1, String var2, String var3, InetSocketAddress var4, boolean var5, InputStream var6, AsyncController var7) throws IOException;

    protected void asyncProcessComplete(ByteArrayOutputStream byteArrayOutputStream) {
        this.write_buffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
    }

    protected SocketChannel getSocketChannel() {
        return this.socket_channel;
    }

    protected long getStartTime() {
        return this.start_time;
    }

    public void interruptTask() {
    }

    protected void failed() {
    }

    protected void completed() {
    }

    protected void closed() {
    }
}

