/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelectorFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessorFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRNonBlockingServer
extends TRTrackerServerTCP
implements VirtualServerChannelSelector.SelectListener {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int TIMEOUT_CHECK_INTERVAL = 10000;
    private static final int CLOSE_DELAY = 5000;
    private TRNonBlockingServerProcessorFactory processor_factory;
    private final VirtualChannelSelector read_selector;
    private final VirtualChannelSelector write_selector;
    private List connections_to_close = new ArrayList();
    private List processors = new ArrayList();
    private InetAddress current_bind_ip;
    private long total_timeouts;
    private long total_connections;
    public static final int MAX_CONCURRENT_CONNECTIONS = COConfigurationManager.getIntParameter("Tracker TCP NonBlocking Conc Max");
    private final AEMonitor this_mon = new AEMonitor("TRNonBlockingServer");
    private VirtualServerChannelSelector accept_server;
    private boolean immediate_close = COConfigurationManager.getBooleanParameter("Tracker TCP NonBlocking Immediate Close");
    private volatile boolean closed;

    public TRNonBlockingServer(String string, int n, InetAddress inetAddress, boolean bl, TRNonBlockingServerProcessorFactory tRNonBlockingServerProcessorFactory) throws TRTrackerServerException {
        this(string, n, inetAddress, bl, true, tRNonBlockingServerProcessorFactory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TRNonBlockingServer(String string, int n, InetAddress inetAddress, boolean bl, boolean bl2, TRNonBlockingServerProcessorFactory tRNonBlockingServerProcessorFactory) throws TRTrackerServerException {
        super(string, n, false, bl, bl2);
        this.processor_factory = tRNonBlockingServerProcessorFactory;
        this.read_selector = new VirtualChannelSelector(string + ":" + n, 1, false);
        this.write_selector = new VirtualChannelSelector(string + ":" + n, 4, true);
        boolean bl3 = false;
        if (n == 0) {
            throw new TRTrackerServerException("port of 0 not currently supported");
        }
        try {
            try {
                InetSocketAddress inetSocketAddress;
                if (inetAddress == null) {
                    inetAddress = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                    if (inetAddress == null) {
                        inetSocketAddress = new InetSocketAddress(n);
                    } else {
                        this.current_bind_ip = inetAddress;
                        inetSocketAddress = new InetSocketAddress(inetAddress, n);
                    }
                } else {
                    this.current_bind_ip = inetAddress;
                    inetSocketAddress = new InetSocketAddress(inetAddress, n);
                }
                this.accept_server = VirtualServerChannelSelectorFactory.createBlocking(inetSocketAddress, 0, this);
                this.accept_server.start();
                AEThread aEThread = new AEThread("TRTrackerServer:readSelector"){

                    public void runSupport() {
                        TRNonBlockingServer.this.selectLoop(TRNonBlockingServer.this.read_selector);
                    }
                };
                aEThread.setDaemon(true);
                aEThread.start();
                AEThread aEThread2 = new AEThread("TRTrackerServer:writeSelector"){

                    public void runSupport() {
                        TRNonBlockingServer.this.selectLoop(TRNonBlockingServer.this.write_selector);
                    }
                };
                aEThread2.setDaemon(true);
                aEThread2.start();
                AEThread aEThread3 = new AEThread("TRTrackerServer:closeScheduler"){

                    public void runSupport() {
                        TRNonBlockingServer.this.closeLoop();
                    }
                };
                aEThread3.setDaemon(true);
                aEThread3.start();
                Logger.log(new LogEvent(LOGID, "TRTrackerServer: Non-blocking listener established on port " + this.getPort()));
                return;
            }
            catch (Throwable throwable) {
                Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
                throw new TRTrackerServerException("TRTrackerServer: accept fails", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (bl3) throw throwable;
            this.destroySupport();
            throw throwable;
        }
    }

    public InetAddress getBindIP() {
        return this.current_bind_ip;
    }

    public void setImmediateClose(boolean bl) {
        this.immediate_close = bl;
    }

    protected void selectLoop(VirtualChannelSelector virtualChannelSelector) {
        long l = 0L;
        while (!this.closed) {
            try {
                virtualChannelSelector.select(100L);
                if (virtualChannelSelector != this.read_selector) continue;
                long l2 = SystemTime.getCurrentTime();
                if (l2 < l) {
                    l = l2;
                    continue;
                }
                if (l2 - l < 10000L) continue;
                l = l2;
                this.checkTimeouts(l2);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newConnectionAccepted(ServerSocketChannel serverSocketChannel, SocketChannel socketChannel) {
        int n;
        final TRNonBlockingServerProcessor tRNonBlockingServerProcessor = this.processor_factory.create(this, socketChannel);
        try {
            this.this_mon.enter();
            ++this.total_connections;
            this.processors.add(tRNonBlockingServerProcessor);
            n = this.processors.size();
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (MAX_CONCURRENT_CONNECTIONS != 0 && n > MAX_CONCURRENT_CONNECTIONS) {
            this.removeAndCloseConnection(tRNonBlockingServerProcessor);
        } else if (this.isIPFilterEnabled() && this.ip_filter.isInRange(socketChannel.socket().getInetAddress().getHostAddress(), "Tracker", null)) {
            this.removeAndCloseConnection(tRNonBlockingServerProcessor);
        } else {
            VirtualChannelSelector.VirtualSelectorListener virtualSelectorListener = new VirtualChannelSelector.VirtualSelectorListener(){
                private boolean selector_registered;

                public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                    try {
                        int n = tRNonBlockingServerProcessor.processRead();
                        if (n == 0) {
                            if (this.selector_registered) {
                                TRNonBlockingServer.this.read_selector.pauseSelects(socketChannel);
                            }
                        } else if (n < 0) {
                            TRNonBlockingServer.this.removeAndCloseConnection(tRNonBlockingServerProcessor);
                        } else if (!this.selector_registered) {
                            this.selector_registered = true;
                            TRNonBlockingServer.this.read_selector.register(socketChannel, this, null);
                        }
                        return n != 2;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        TRNonBlockingServer.this.removeAndCloseConnection(tRNonBlockingServerProcessor);
                        return false;
                    }
                }

                public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                    TRNonBlockingServer.this.removeAndCloseConnection(tRNonBlockingServerProcessor);
                }
            };
            virtualSelectorListener.selectSuccess(this.read_selector, socketChannel, null);
        }
    }

    protected void readyToWrite(final TRNonBlockingServerProcessor tRNonBlockingServerProcessor) {
        VirtualChannelSelector.VirtualSelectorListener virtualSelectorListener = new VirtualChannelSelector.VirtualSelectorListener(){
            private boolean selector_registered;

            public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                try {
                    int n = tRNonBlockingServerProcessor.processWrite();
                    if (n > 0) {
                        if (this.selector_registered) {
                            TRNonBlockingServer.this.write_selector.resumeSelects(socketChannel);
                        } else {
                            this.selector_registered = true;
                            TRNonBlockingServer.this.write_selector.register(socketChannel, this, null);
                        }
                    } else if (n == 0) {
                        TRNonBlockingServer.this.removeAndCloseConnection(tRNonBlockingServerProcessor);
                    } else if (n < 0) {
                        tRNonBlockingServerProcessor.failed();
                        TRNonBlockingServer.this.removeAndCloseConnection(tRNonBlockingServerProcessor);
                    }
                    return n != 2;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    TRNonBlockingServer.this.removeAndCloseConnection(tRNonBlockingServerProcessor);
                    return false;
                }
            }

            public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                TRNonBlockingServer.this.removeAndCloseConnection(tRNonBlockingServerProcessor);
            }
        };
        virtualSelectorListener.selectSuccess(this.write_selector, tRNonBlockingServerProcessor.getSocketChannel(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAndCloseConnection(TRNonBlockingServerProcessor tRNonBlockingServerProcessor) {
        tRNonBlockingServerProcessor.completed();
        try {
            this.this_mon.enter();
            if (this.processors.remove(tRNonBlockingServerProcessor)) {
                this.read_selector.cancel(tRNonBlockingServerProcessor.getSocketChannel());
                this.write_selector.cancel(tRNonBlockingServerProcessor.getSocketChannel());
                if (this.immediate_close) {
                    try {
                        tRNonBlockingServerProcessor.closed();
                        tRNonBlockingServerProcessor.getSocketChannel().close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.connections_to_close.add(tRNonBlockingServerProcessor);
                }
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeouts(long l) {
        try {
            this.this_mon.enter();
            ArrayList<TRNonBlockingServerProcessor> arrayList = new ArrayList<TRNonBlockingServerProcessor>(this.processors.size());
            for (int i = 0; i < this.processors.size(); ++i) {
                TRNonBlockingServerProcessor tRNonBlockingServerProcessor = (TRNonBlockingServerProcessor)this.processors.get(i);
                if (l - tRNonBlockingServerProcessor.getStartTime() > PROCESSING_GET_LIMIT) {
                    this.read_selector.cancel(tRNonBlockingServerProcessor.getSocketChannel());
                    this.write_selector.cancel(tRNonBlockingServerProcessor.getSocketChannel());
                    this.connections_to_close.add(tRNonBlockingServerProcessor);
                    ++this.total_timeouts;
                    continue;
                }
                arrayList.add(tRNonBlockingServerProcessor);
            }
            this.processors = arrayList;
            Object var7_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLoop() {
        long l;
        List list = new ArrayList();
        long l2 = l = 3333L;
        while (!this.closed) {
            Object var11_10;
            if (l2 > 0L) {
                try {
                    Thread.sleep(l2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            long l3 = SystemTime.getCurrentTime();
            for (int i = 0; i < list.size(); ++i) {
                try {
                    TRNonBlockingServerProcessor tRNonBlockingServerProcessor = (TRNonBlockingServerProcessor)list.get(i);
                    tRNonBlockingServerProcessor.closed();
                    tRNonBlockingServerProcessor.getSocketChannel().close();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.this_mon.enter();
                list = this.connections_to_close;
                this.connections_to_close = new ArrayList();
                var11_10 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var11_10 = null;
                this.this_mon.exit();
                throw throwable;
            }
            long l4 = SystemTime.getCurrentTime() - l3;
            if (l4 < 0L) {
                l4 = 0L;
            }
            l2 = l - l4;
        }
    }

    protected void closeSupport() {
        this.closed = true;
        this.accept_server.stop();
        this.destroySupport();
    }
}

