/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerStats;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerFactoryImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerRequestImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerStatsImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public abstract class TRTrackerServerImpl
implements TRTrackerServer {
    public static final int RETRY_MINIMUM_SECS = 60;
    public static final int RETRY_MINIMUM_MILLIS = 60000;
    public static final int CLIENT_TIMEOUT_MULTIPLIER = 3;
    public static final int TIMEOUT_CHECK = 180000;
    public static int max_peers_to_send = 0;
    public static boolean send_peer_ids = true;
    public static int announce_cache_period = 500;
    public static int scrape_cache_period = 5000;
    public static int announce_cache_threshold = 500;
    public static int max_seed_retention = 0;
    public static int seed_limit = 0;
    public static boolean full_scrape_enable = true;
    public static boolean restrict_non_blocking_requests = true;
    public static boolean all_networks_permitted = true;
    public static String[] permitted_networks = new String[0];
    public static boolean support_experimental_extensions;
    public static String redirect_on_not_found;
    private static Map torrent_map;
    private static Map link_map;
    protected AEMonitor class_mon = new AEMonitor("TRTrackerServer:class");
    protected IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private long current_announce_retry_interval;
    private long current_scrape_retry_interval;
    private long current_total_clients;
    private int current_min_poll_interval;
    private int current_min_seed_announce_mult;
    private TRTrackerServerStatsImpl stats = new TRTrackerServerStatsImpl(this);
    private String name;
    private boolean web_password_enabled;
    private boolean web_password_https_only;
    private boolean tracker_password_enabled;
    private String password_user;
    private byte[] password_pw;
    private boolean compact_enabled;
    private boolean key_enabled;
    private boolean enabled = true;
    private boolean keep_alive_enabled = false;
    protected CopyOnWriteList<TRTrackerServerListener> listeners = new CopyOnWriteList();
    protected CopyOnWriteList<TRTrackerServerListener2> listeners2 = new CopyOnWriteList();
    private List<TRTrackerServerAuthenticationListener> auth_listeners = new ArrayList<TRTrackerServerAuthenticationListener>();
    private Vector<TRTrackerServerRequestListener> request_listeners = new Vector();
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServer");
    private COConfigurationListener config_listener;
    private boolean destroyed;
    private Set biased_peers;
    private boolean is_ready;

    protected static void readConfig() {
        send_peer_ids = COConfigurationManager.getBooleanParameter("Tracker Send Peer IDs");
        max_peers_to_send = COConfigurationManager.getIntParameter("Tracker Max Peers Returned");
        scrape_cache_period = COConfigurationManager.getIntParameter("Tracker Scrape Cache", 5000);
        announce_cache_period = COConfigurationManager.getIntParameter("Tracker Announce Cache", 500);
        announce_cache_threshold = COConfigurationManager.getIntParameter("Tracker Announce Cache Min Peers", 500);
        max_seed_retention = COConfigurationManager.getIntParameter("Tracker Max Seeds Retained", 0);
        seed_limit = COConfigurationManager.getIntParameter("Tracker Max Seeds", 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
            String string = AENetworkClassifier.AT_NETWORKS[i];
            boolean bl = COConfigurationManager.getBooleanParameter("Tracker Network Selection Default." + string);
            if (!bl) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        permitted_networks = stringArray;
        all_networks_permitted = stringArray.length == AENetworkClassifier.AT_NETWORKS.length;
        full_scrape_enable = COConfigurationManager.getBooleanParameter("Tracker Server Full Scrape Enable");
        redirect_on_not_found = COConfigurationManager.getStringParameter("Tracker Server Not Found Redirect").trim();
        support_experimental_extensions = COConfigurationManager.getBooleanParameter("Tracker Server Support Experimental Extensions");
        restrict_non_blocking_requests = COConfigurationManager.getBooleanParameter("Tracker TCP NonBlocking Restrict Request Types");
    }

    protected static boolean getSendPeerIds() {
        return send_peer_ids;
    }

    protected static int getMaxPeersToSend() {
        return max_peers_to_send;
    }

    protected static int getScrapeCachePeriod() {
        return scrape_cache_period;
    }

    protected static int getAnnounceCachePeriod() {
        return announce_cache_period;
    }

    protected static int getAnnounceCachePeerThreshold() {
        return announce_cache_threshold;
    }

    protected static int getMaxSeedRetention() {
        return max_seed_retention;
    }

    protected static int getSeedLimit() {
        return seed_limit;
    }

    public static boolean isFullScrapeEnabled() {
        return full_scrape_enable;
    }

    protected static boolean getAllNetworksSupported() {
        return all_networks_permitted;
    }

    protected static String[] getPermittedNetworks() {
        return permitted_networks;
    }

    public static boolean supportsExtensions() {
        return support_experimental_extensions;
    }

    public TRTrackerServerImpl(String string, boolean bl) {
        this.name = string == null ? DEFAULT_NAME : string;
        this.is_ready = bl;
        this.config_listener = new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerServerImpl.this.readConfigSettings();
            }
        };
        COConfigurationManager.addListener(this.config_listener);
        this.readConfigSettings();
        this.current_min_poll_interval = COConfigurationManager.getIntParameter("Tracker Poll Interval Min", 120);
        if (this.current_min_poll_interval < 60) {
            this.current_min_poll_interval = 60;
        }
        this.current_min_seed_announce_mult = COConfigurationManager.getIntParameter("Tracker Poll Seed Interval Mult");
        this.current_announce_retry_interval = this.current_min_poll_interval;
        int n = COConfigurationManager.getIntParameter("Tracker Scrape Retry Percentage", 200);
        this.current_scrape_retry_interval = this.current_announce_retry_interval * (long)n / 100L;
        AEThread aEThread = new AEThread("TrackerServer:timer.loop"){

            public void runSupport() {
                TRTrackerServerImpl.this.timerLoop();
            }
        };
        aEThread.setDaemon(true);
        aEThread.start();
    }

    protected void readConfigSettings() {
        this.web_password_enabled = COConfigurationManager.getBooleanParameter("Tracker Password Enable Web");
        this.tracker_password_enabled = COConfigurationManager.getBooleanParameter("Tracker Password Enable Torrent");
        this.web_password_https_only = COConfigurationManager.getBooleanParameter("Tracker Password Web HTTPS Only");
        if (this.web_password_enabled || this.tracker_password_enabled) {
            this.password_user = COConfigurationManager.getStringParameter("Tracker Username", "");
            this.password_pw = COConfigurationManager.getByteParameter("Tracker Password", new byte[0]);
        }
        this.compact_enabled = COConfigurationManager.getBooleanParameter("Tracker Compact Enable");
        this.key_enabled = COConfigurationManager.getBooleanParameter("Tracker Key Enable Server");
    }

    public void setReady() {
        this.is_ready = true;
    }

    public final boolean isReady() {
        return this.is_ready;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnableKeepAlive(boolean bl) {
        this.keep_alive_enabled = this.enabled;
    }

    public boolean isKeepAliveEnabled() {
        return this.keep_alive_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrent addLink(String string, TRTrackerServerTorrent tRTrackerServerTorrent) {
        try {
            this.class_mon.enter();
            TRTrackerServerTorrent tRTrackerServerTorrent2 = link_map.put(string, tRTrackerServerTorrent);
            Object var5_4 = null;
            this.class_mon.exit();
            return tRTrackerServerTorrent2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLink(String string, TRTrackerServerTorrent tRTrackerServerTorrent) {
        try {
            this.class_mon.enter();
            link_map.remove(string);
            Object var4_3 = null;
            this.class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBiasedPeers(Set set) {
        if (this.biased_peers != null && ((Object)set).equals(this.biased_peers)) {
            return;
        }
        String string = "";
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = string + " " + iterator.next();
        }
        System.out.println("biased peers: " + string);
        try {
            this.class_mon.enter();
            this.biased_peers = new HashSet(set);
            for (TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl : torrent_map.values()) {
                tRTrackerServerTorrentImpl.updateBiasedPeers(this.biased_peers);
            }
            Object var7_6 = null;
            this.class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    protected Set getBiasedPeers() {
        return this.biased_peers;
    }

    public boolean isWebPasswordEnabled() {
        return this.web_password_enabled || this.auth_listeners.size() > 0;
    }

    public boolean isTrackerPasswordEnabled() {
        return this.tracker_password_enabled || this.auth_listeners.size() > 0;
    }

    public boolean isWebPasswordHTTPSOnly() {
        return this.web_password_https_only;
    }

    public boolean hasExternalAuthorisation() {
        return this.auth_listeners.size() > 0;
    }

    public boolean hasInternalAuthorisation() {
        return this.web_password_enabled || this.tracker_password_enabled;
    }

    public boolean performExternalAuthorisation(InetSocketAddress inetSocketAddress, String string, URL uRL, String string2, String string3) {
        string = string.trim() + "\r\nX-Real-IP: " + inetSocketAddress.getAddress().getHostAddress() + "\r\n\r\n";
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                if (!this.auth_listeners.get(i).authenticate(string, uRL, string2, string3)) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return false;
    }

    public byte[] performExternalAuthorisation(URL uRL, String string) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                byte[] byArray = this.auth_listeners.get(i).authenticate(uRL, string);
                if (byArray == null) continue;
                return byArray;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCompactEnabled() {
        return this.compact_enabled;
    }

    public boolean isKeyEnabled() {
        return this.key_enabled;
    }

    public String getUsername() {
        return this.password_user;
    }

    public byte[] getPassword() {
        return this.password_pw;
    }

    public long getMinAnnounceRetryInterval() {
        return this.current_min_poll_interval;
    }

    public long getAnnounceRetryInterval(TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl) {
        long l = this.current_total_clients;
        if (l == 0L) {
            return this.current_announce_retry_interval;
        }
        long l2 = (long)tRTrackerServerTorrentImpl.getPeerCount() * this.current_announce_retry_interval / l;
        if (l2 < (long)this.current_min_poll_interval) {
            l2 = this.current_min_poll_interval;
        }
        return l2;
    }

    public long getSeedAnnounceIntervalMultiplier() {
        return this.current_min_seed_announce_mult;
    }

    public long getScrapeRetryInterval(TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl) {
        long l = this.current_total_clients;
        if (tRTrackerServerTorrentImpl == null || l == 0L) {
            return this.current_scrape_retry_interval;
        }
        long l2 = (long)tRTrackerServerTorrentImpl.getPeerCount() * this.current_scrape_retry_interval / l;
        if (l2 < (long)this.current_min_poll_interval) {
            l2 = this.current_min_poll_interval;
        }
        return l2;
    }

    public long getMinScrapeRetryInterval() {
        return this.current_min_poll_interval;
    }

    public TRTrackerServerStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(int n, TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl, int n2, int n3) {
        this.stats.update(n, n2, n3);
        if (tRTrackerServerTorrentImpl != null) {
            tRTrackerServerTorrentImpl.updateXferStats(n2, n3);
        } else {
            int n4 = torrent_map.size();
            if (n4 < 256) {
                try {
                    this.class_mon.enter();
                    if (n4 > 0) {
                        int n5 = n2 / n4;
                        int n6 = n3 / n4;
                        int n7 = n2 - n5 * n4;
                        int n8 = n3 - n6 * n4;
                        Iterator iterator = torrent_map.values().iterator();
                        while (iterator.hasNext()) {
                            TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl2 = (TRTrackerServerTorrentImpl)iterator.next();
                            if (iterator.hasNext()) {
                                tRTrackerServerTorrentImpl2.updateXferStats(n5, n6);
                                continue;
                            }
                            tRTrackerServerTorrentImpl2.updateXferStats(n5 + n7, n6 + n8);
                        }
                    }
                    Object var13_12 = null;
                    this.class_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    this.class_mon.exit();
                    throw throwable;
                }
            }
        }
    }

    protected void updateTime(int n, long l) {
        this.stats.updateTime(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timerLoop() {
        long l = 180000L;
        while (!this.destroyed) {
            try {
                Object var15_13;
                Object var13_12;
                Thread.sleep(60000L);
                l -= 60000L;
                this.current_min_poll_interval = COConfigurationManager.getIntParameter("Tracker Poll Interval Min", 120);
                if (this.current_min_poll_interval < 60) {
                    this.current_min_poll_interval = 60;
                }
                int n = this.current_min_poll_interval;
                int n2 = COConfigurationManager.getIntParameter("Tracker Poll Interval Max", 3600);
                int n3 = COConfigurationManager.getIntParameter("Tracker Poll Inc By", 60);
                int n4 = COConfigurationManager.getIntParameter("Tracker Poll Inc Per", 10);
                int n5 = COConfigurationManager.getIntParameter("Tracker Scrape Retry Percentage", 200);
                int n6 = n;
                int n7 = 0;
                try {
                    this.class_mon.enter();
                    for (TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl : torrent_map.values()) {
                        n7 += tRTrackerServerTorrentImpl.getPeerCount();
                    }
                    var13_12 = null;
                    this.class_mon.exit();
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    this.class_mon.exit();
                    throw throwable;
                }
                if (n3 > 0 && n4 > 0) {
                    n6 += n3 * (n7 / n4);
                }
                if (n2 > 0 && n6 > n2) {
                    n6 = n2;
                }
                if (n6 < 60) {
                    n6 = 60;
                }
                this.current_announce_retry_interval = n6;
                this.current_scrape_retry_interval = this.current_announce_retry_interval * (long)n5 / 100L;
                this.current_total_clients = n7;
                if (l > 0L) continue;
                l = 180000L;
                try {
                    this.class_mon.enter();
                    for (TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl : torrent_map.values()) {
                        tRTrackerServerTorrentImpl.checkTimeouts();
                    }
                    var15_13 = null;
                    this.class_mon.exit();
                }
                catch (Throwable throwable) {
                    var15_13 = null;
                    this.class_mon.exit();
                    throw throwable;
                }
            }
            catch (InterruptedException interruptedException) {
                Debug.printStackTrace(interruptedException);
            }
        }
    }

    public TRTrackerServerTorrent permit(String string, byte[] byArray, boolean bl) throws TRTrackerServerException {
        return this.permit(string, byArray, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrent permit(String string, byte[] byArray, boolean bl, boolean bl2) throws TRTrackerServerException {
        TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl;
        HashWrapper hashWrapper = new HashWrapper(byArray);
        try {
            this.class_mon.enter();
            tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)torrent_map.get(hashWrapper);
            Object var8_7 = null;
            this.class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.class_mon.exit();
            throw throwable;
        }
        if (tRTrackerServerTorrentImpl == null) {
            Iterator<TRTrackerServerListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().permitted(string, byArray, bl)) continue;
                throw new TRTrackerServerException("operation denied");
            }
            try {
                this.class_mon.enter();
                tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)torrent_map.get(hashWrapper);
                if (tRTrackerServerTorrentImpl == null) {
                    tRTrackerServerTorrentImpl = new TRTrackerServerTorrentImpl(this, hashWrapper, bl2);
                    torrent_map.put(hashWrapper, tRTrackerServerTorrentImpl);
                }
                Object var10_11 = null;
                this.class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.class_mon.exit();
                throw throwable;
            }
        }
        return tRTrackerServerTorrentImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deny(byte[] byArray, boolean bl) throws TRTrackerServerException {
        HashWrapper hashWrapper = new HashWrapper(byArray);
        Iterator<TRTrackerServerListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().denied(byArray, bl)) continue;
            throw new TRTrackerServerException("operation denied");
        }
        try {
            this.class_mon.enter();
            TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)torrent_map.get(hashWrapper);
            if (tRTrackerServerTorrentImpl != null) {
                tRTrackerServerTorrentImpl.delete();
            }
            torrent_map.remove(hashWrapper);
            Object var7_6 = null;
            this.class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrentImpl getTorrent(byte[] byArray) {
        try {
            this.class_mon.enter();
            TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)torrent_map.get(new HashWrapper(byArray));
            Object var4_3 = null;
            this.class_mon.exit();
            return tRTrackerServerTorrentImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrentImpl getTorrent(String string) {
        try {
            this.class_mon.enter();
            TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)link_map.get(string);
            Object var4_3 = null;
            this.class_mon.exit();
            return tRTrackerServerTorrentImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrentImpl[] getTorrents() {
        try {
            this.class_mon.enter();
            TRTrackerServerTorrentImpl[] tRTrackerServerTorrentImplArray = new TRTrackerServerTorrentImpl[torrent_map.size()];
            torrent_map.values().toArray(tRTrackerServerTorrentImplArray);
            TRTrackerServerTorrentImpl[] tRTrackerServerTorrentImplArray2 = tRTrackerServerTorrentImplArray;
            Object var4_3 = null;
            this.class_mon.exit();
            return tRTrackerServerTorrentImplArray2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    public int getTorrentCount() {
        return torrent_map.size();
    }

    public TRTrackerServerTorrentStats getStats(byte[] byArray) {
        TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = this.getTorrent(byArray);
        if (tRTrackerServerTorrentImpl == null) {
            return null;
        }
        return tRTrackerServerTorrentImpl.getStats();
    }

    public TRTrackerServerPeer[] getPeers(byte[] byArray) {
        TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = this.getTorrent(byArray);
        if (tRTrackerServerTorrentImpl == null) {
            return null;
        }
        return tRTrackerServerTorrentImpl.getPeers();
    }

    public void addListener(TRTrackerServerListener tRTrackerServerListener) {
        this.listeners.add(tRTrackerServerListener);
    }

    public void removeListener(TRTrackerServerListener tRTrackerServerListener) {
        this.listeners.remove(tRTrackerServerListener);
    }

    public void addListener2(TRTrackerServerListener2 tRTrackerServerListener2) {
        this.listeners2.add(tRTrackerServerListener2);
    }

    public void removeListener2(TRTrackerServerListener2 tRTrackerServerListener2) {
        this.listeners2.remove(tRTrackerServerListener2);
    }

    public void addAuthenticationListener(TRTrackerServerAuthenticationListener tRTrackerServerAuthenticationListener) {
        this.auth_listeners.add(tRTrackerServerAuthenticationListener);
    }

    public void removeAuthenticationListener(TRTrackerServerAuthenticationListener tRTrackerServerAuthenticationListener) {
        this.auth_listeners.remove(tRTrackerServerAuthenticationListener);
    }

    public void preProcess(TRTrackerServerPeer tRTrackerServerPeer, TRTrackerServerTorrent tRTrackerServerTorrent, int n, String string, Map map) throws TRTrackerServerException {
        if (this.request_listeners.size() > 0) {
            int n2;
            if (n == 2) {
                try {
                    int n3 = 10;
                    while (true) {
                        String string2;
                        if ((n2 = string.indexOf("info_hash=", n3)) == -1) {
                            if (n3 == 10) break;
                            string2 = string.substring(n3);
                        } else {
                            string2 = string.substring(n3, n2);
                        }
                        int n4 = string2.indexOf(38);
                        String string3 = n4 == -1 ? string2 : string2.substring(0, n4);
                        string3 = URLDecoder.decode(string3, "ISO-8859-1");
                        byte[] byArray = string3.getBytes("ISO-8859-1");
                        if (Arrays.equals(byArray, tRTrackerServerTorrent.getHash().getBytes())) {
                            string = "info_hash=" + string2;
                            if (string.endsWith("&")) {
                                string = string.substring(0, string.length() - 1);
                            }
                        } else if (n2 != -1) {
                            n3 = n2 + 10;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            TRTrackerServerRequestImpl tRTrackerServerRequestImpl = new TRTrackerServerRequestImpl(this, tRTrackerServerPeer, tRTrackerServerTorrent, n, string, map);
            for (n2 = 0; n2 < this.request_listeners.size(); ++n2) {
                try {
                    this.request_listeners.elementAt(n2).preProcess(tRTrackerServerRequestImpl);
                    continue;
                }
                catch (TRTrackerServerException tRTrackerServerException) {
                    throw tRTrackerServerException;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public void postProcess(TRTrackerServerPeer tRTrackerServerPeer, TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl, int n, String string, Map map) throws TRTrackerServerException {
        if (this.request_listeners.size() > 0) {
            TRTrackerServerRequestImpl tRTrackerServerRequestImpl = new TRTrackerServerRequestImpl(this, tRTrackerServerPeer, tRTrackerServerTorrentImpl, n, string, map);
            for (int i = 0; i < this.request_listeners.size(); ++i) {
                try {
                    this.request_listeners.elementAt(i).postProcess(tRTrackerServerRequestImpl);
                    continue;
                }
                catch (TRTrackerServerException tRTrackerServerException) {
                    throw tRTrackerServerException;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public void addRequestListener(TRTrackerServerRequestListener tRTrackerServerRequestListener) {
        this.request_listeners.addElement(tRTrackerServerRequestListener);
    }

    public void removeRequestListener(TRTrackerServerRequestListener tRTrackerServerRequestListener) {
        this.request_listeners.removeElement(tRTrackerServerRequestListener);
    }

    public void close() {
        TRTrackerServerFactoryImpl.close(this);
    }

    protected abstract void closeSupport();

    protected void destroySupport() {
        this.destroyed = true;
        COConfigurationManager.removeListener(this.config_listener);
    }

    static {
        redirect_on_not_found = "";
        torrent_map = new HashMap();
        link_map = new HashMap();
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerServerImpl.readConfig();
            }
        });
        TRTrackerServerImpl.readConfig();
    }
}

