/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;

public class PRUDPPacketRequestScrape
extends PRUDPPacketRequest {
    protected List hashes = new ArrayList();

    public PRUDPPacketRequestScrape(long l, byte[] byArray) {
        super(2, l);
        this.hashes.add(byArray);
    }

    public PRUDPPacketRequestScrape(long l, List list) {
        super(2, l);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.hashes.add(((HashWrapper)iterator.next()).getBytes());
        }
    }

    protected PRUDPPacketRequestScrape(DataInputStream dataInputStream, long l, int n) throws IOException {
        super(2, l, n);
        byte[] byArray;
        while (dataInputStream.read(byArray = new byte[20]) == 20) {
            this.hashes.add(byArray);
        }
    }

    public List getHashes() {
        return this.hashes;
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        Iterator iterator = this.hashes.iterator();
        while (iterator.hasNext()) {
            dataOutputStream.write((byte[])iterator.next());
        }
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.getString());
        stringBuffer.append("[");
        Iterator iterator = this.hashes.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(ByteFormatter.nicePrint((byte[])iterator.next(), true));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(";");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

