/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.gudy.azureus2.core3.util.ByteFormatter;

public class PRUDPPacketRequestAnnounce2
extends PRUDPPacketRequest {
    public static final int EV_STARTED = 2;
    public static final int EV_STOPPED = 3;
    public static final int EV_COMPLETED = 1;
    public static final int EV_UPDATE = 0;
    protected byte[] hash;
    protected byte[] peer_id;
    protected long downloaded;
    protected int event;
    protected int key;
    protected int num_want;
    protected long left;
    protected short port;
    protected long uploaded;
    protected int ip_address;

    public PRUDPPacketRequestAnnounce2(long l) {
        super(1, l);
    }

    protected PRUDPPacketRequestAnnounce2(DataInputStream dataInputStream, long l, int n) throws IOException {
        super(1, l, n);
        this.hash = new byte[20];
        this.peer_id = new byte[20];
        dataInputStream.read(this.hash);
        dataInputStream.read(this.peer_id);
        this.downloaded = dataInputStream.readLong();
        this.left = dataInputStream.readLong();
        this.uploaded = dataInputStream.readLong();
        this.event = dataInputStream.readInt();
        this.ip_address = dataInputStream.readInt();
        this.key = dataInputStream.readInt();
        this.num_want = dataInputStream.readInt();
        this.port = dataInputStream.readShort();
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getPeerId() {
        return this.peer_id;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public int getEvent() {
        return this.event;
    }

    public int getNumWant() {
        return this.num_want;
    }

    public long getLeft() {
        return this.left;
    }

    public int getPort() {
        return this.port & 0xFFFF;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public int getIPAddress() {
        return this.ip_address;
    }

    public int getKey() {
        return this.key;
    }

    public void setDetails(byte[] byArray, byte[] byArray2, long l, int n, int n2, int n3, int n4, long l2, short s, long l3) {
        this.hash = byArray;
        this.peer_id = byArray2;
        this.downloaded = l;
        this.event = n;
        this.ip_address = n2;
        this.key = n3;
        this.num_want = n4;
        this.left = l2;
        this.port = s;
        this.uploaded = l3;
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        dataOutputStream.write(this.hash);
        dataOutputStream.write(this.peer_id);
        dataOutputStream.writeLong(this.downloaded);
        dataOutputStream.writeLong(this.left);
        dataOutputStream.writeLong(this.uploaded);
        dataOutputStream.writeInt(this.event);
        dataOutputStream.writeInt(this.ip_address);
        dataOutputStream.writeInt(this.key);
        dataOutputStream.writeInt(this.num_want);
        dataOutputStream.writeShort(this.port);
    }

    public String getString() {
        return super.getString().concat("[").concat("hash=" + ByteFormatter.nicePrint(this.hash, true) + "peer=" + ByteFormatter.nicePrint(this.peer_id, true) + "dl=" + this.downloaded + "ev=" + this.event + "ip=" + this.ip_address + "key=" + this.key + "nw=" + this.num_want + "left=" + this.left + "port=" + this.port + "ul=" + this.uploaded + "]");
    }
}

