/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PRUDPPacketReplyScrape2
extends PRUDPPacketReply {
    protected static final int BYTES_PER_ENTRY = 12;
    protected int[] complete;
    protected int[] incomplete;
    protected int[] downloaded;

    public PRUDPPacketReplyScrape2(int n) {
        super(2, n);
    }

    protected PRUDPPacketReplyScrape2(DataInputStream dataInputStream, int n) throws IOException {
        super(2, n);
        this.complete = new int[dataInputStream.available() / 12];
        this.incomplete = new int[this.complete.length];
        this.downloaded = new int[this.complete.length];
        for (int i = 0; i < this.complete.length; ++i) {
            this.complete[i] = dataInputStream.readInt();
            this.downloaded[i] = dataInputStream.readInt();
            this.incomplete[i] = dataInputStream.readInt();
        }
    }

    public void setDetails(int[] nArray, int[] nArray2, int[] nArray3) {
        this.complete = nArray;
        this.downloaded = nArray2;
        this.incomplete = nArray3;
    }

    public int[] getComplete() {
        return this.complete;
    }

    public int[] getDownloaded() {
        return this.downloaded;
    }

    public int[] getIncomplete() {
        return this.incomplete;
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        if (this.complete != null) {
            for (int i = 0; i < this.complete.length; ++i) {
                dataOutputStream.writeInt(this.complete[i]);
                dataOutputStream.writeInt(this.downloaded[i]);
                dataOutputStream.writeInt(this.incomplete[i]);
            }
        }
    }

    public String getString() {
        String string = "";
        for (int i = 0; i < this.complete.length; ++i) {
            string = string + (i == 0 ? "" : ",") + this.complete[i] + "/" + this.incomplete[i] + "/" + this.downloaded[i];
        }
        return super.getString() + "[entries=" + this.complete.length + "=" + string + "]";
    }
}

