/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import java.net.URL;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerChecker;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class TRTrackerBTScraperImpl {
    protected static TRTrackerBTScraperImpl singleton;
    protected static AEMonitor class_mon;
    private TRTrackerScraperImpl scraper;
    private TrackerChecker tracker_checker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerBTScraperImpl create(TRTrackerScraperImpl tRTrackerScraperImpl) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerBTScraperImpl(tRTrackerScraperImpl);
            }
            TRTrackerBTScraperImpl tRTrackerBTScraperImpl = singleton;
            Object var3_2 = null;
            class_mon.exit();
            return tRTrackerBTScraperImpl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected TRTrackerBTScraperImpl(TRTrackerScraperImpl tRTrackerScraperImpl) {
        this.scraper = tRTrackerScraperImpl;
        this.tracker_checker = new TrackerChecker(this);
    }

    protected TRTrackerScraperImpl getScraper() {
        return this.scraper;
    }

    public void setScrape(TOTorrent tOTorrent, URL uRL, DownloadScrapeResult downloadScrapeResult) {
        TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl;
        if (tOTorrent != null && downloadScrapeResult != null && (tRTrackerScraperResponseImpl = this.tracker_checker.getHashData(tOTorrent, uRL)) != null && tRTrackerScraperResponseImpl.getStatus() == 1) {
            tRTrackerScraperResponseImpl.setScrapeStartTime(downloadScrapeResult.getScrapeStartTime());
            tRTrackerScraperResponseImpl.setStatus(downloadScrapeResult.getResponseType() == 1 ? 2 : 1, downloadScrapeResult.getStatus() + " (" + downloadScrapeResult.getURL() + ")");
            tRTrackerScraperResponseImpl.setSeedsPeers(downloadScrapeResult.getSeedCount(), downloadScrapeResult.getNonSeedCount());
            this.scraper.scrapeReceived(tRTrackerScraperResponseImpl);
        }
    }

    public TRTrackerScraperResponse scrape(TOTorrent tOTorrent, URL uRL, boolean bl) {
        if (tOTorrent == null) {
            return null;
        }
        if (bl) {
            this.tracker_checker.syncUpdate(tOTorrent, uRL);
        }
        TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = this.tracker_checker.getHashData(tOTorrent, uRL);
        return tRTrackerScraperResponseImpl;
    }

    public TRTrackerScraperResponse scrape(TRTrackerAnnouncer tRTrackerAnnouncer) {
        TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = this.tracker_checker.getHashData(tRTrackerAnnouncer);
        return tRTrackerScraperResponseImpl;
    }

    public void remove(TOTorrent tOTorrent) {
        this.tracker_checker.removeHash(tOTorrent);
    }

    static {
        class_mon = new AEMonitor("TRTrackerBTScraper");
    }
}

