/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.StringInterner;

public abstract class TRTrackerScraperResponseImpl
implements TRTrackerScraperResponse {
    private HashWrapper hash;
    private int seeds;
    private int peers;
    private int completed;
    private long scrapeStartTime;
    private long nextScrapeStartTime;
    private String sStatus = "";
    private String sLastStatus = "";
    private int status;
    private int last_status;
    private static final int scrapeFuzzAdd = (int)(Math.random() * 3.0 * 60.0);

    protected TRTrackerScraperResponseImpl(HashWrapper hashWrapper) {
        this(hashWrapper, -1, -1, -1, -1L);
    }

    protected TRTrackerScraperResponseImpl(HashWrapper hashWrapper, int n, int n2, int n3, long l) {
        this.hash = hashWrapper;
        this.seeds = n;
        this.completed = n3;
        this.peers = n2;
        this.scrapeStartTime = l;
        this.status = !this.isValid() ? 0 : 2;
        this.nextScrapeStartTime = -1L;
    }

    public int getCompleted() {
        return this.completed;
    }

    public void setCompleted(int n) {
        this.completed = n;
    }

    public HashWrapper getHash() {
        return this.hash;
    }

    public int getSeeds() {
        return this.seeds;
    }

    public void setSeeds(int n) {
        this.seeds = n;
    }

    public int getPeers() {
        return this.peers;
    }

    public void setPeers(int n) {
        this.peers = n;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    protected void setStatus(String string) {
        this.sStatus = string;
    }

    public void setStatus(int n, String string) {
        if (this.last_status != this.status && n != this.status) {
            this.last_status = this.status;
        }
        this.status = n == 2 ? (!this.isValid() ? 0 : 2) : n;
        if (string == null) {
            return;
        }
        if (!this.sLastStatus.equals(this.sStatus)) {
            this.sLastStatus = this.sStatus;
        }
        this.sStatus = StringInterner.intern(string);
    }

    public void revertStatus() {
        this.status = this.last_status;
        this.sStatus = this.sLastStatus;
    }

    public void setScrapeStartTime(long l) {
        this.scrapeStartTime = l;
    }

    public long getScrapeStartTime() {
        return this.scrapeStartTime;
    }

    public long getNextScrapeStartTime() {
        return this.nextScrapeStartTime;
    }

    public void setNextScrapeStartTime(long l) {
        this.nextScrapeStartTime = l;
    }

    public String getStatusString() {
        return this.sStatus;
    }

    public boolean isValid() {
        return this.seeds != -1 || this.peers != -1;
    }

    public static int calcScrapeIntervalSecs(int n, int n2) {
        int n3 = 900 + n2 * 10;
        if (n > n3) {
            n3 = n;
        }
        if ((n3 += scrapeFuzzAdd) > 10800) {
            n3 = 10800;
        }
        return n3;
    }

    public String getString() {
        return this.getURL() + ": " + ByteFormatter.encodeString(this.hash.getBytes()) + ",seeds=" + this.seeds + ",peers=" + this.peers + ",state=" + this.status + "/" + this.sStatus + ",last=" + this.last_status + "/" + this.sLastStatus + ",start=" + this.scrapeStartTime + ",next=" + this.nextScrapeStartTime;
    }
}

