/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerFactoryImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerHelper;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.dht.TRTrackerDHTAnnouncerImpl;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;

public class TRTrackerAnnouncerMuxer
extends TRTrackerAnnouncerImpl {
    private static final int ACT_CHECK_INIT_DELAY = 2500;
    private static final int ACT_CHECK_INTERIM_DELAY = 10000;
    private static final int ACT_CHECK_IDLE_DELAY = 30000;
    private static final int ACT_CHECK_SEEDING_SHORT_DELAY = 60000;
    private static final int ACT_CHECK_SEEDING_LONG_DELAY = 180000;
    private String[] networks;
    private boolean is_manual;
    private long create_time = SystemTime.getMonotonousTime();
    private CopyOnWriteList<TRTrackerAnnouncerHelper> announcers = new CopyOnWriteList();
    private Set<TRTrackerAnnouncerHelper> activated = new HashSet<TRTrackerAnnouncerHelper>();
    private long last_activation_time;
    private Set<String> failed_urls = new HashSet<String>();
    private volatile TimerEvent event;
    private TRTrackerAnnouncerDataProvider provider;
    private String ip_override;
    private boolean complete;
    private boolean stopped;
    private boolean destroyed;
    private TRTrackerAnnouncerHelper last_best_active;
    private long last_best_active_set_time;
    private Map<String, StatusSummary> recent_responses = new HashMap<String, StatusSummary>();

    protected TRTrackerAnnouncerMuxer(TOTorrent tOTorrent, String[] stringArray, boolean bl) throws TRTrackerAnnouncerException {
        super(tOTorrent);
        this.networks = stringArray;
        this.is_manual = bl;
        this.split();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void split() throws TRTrackerAnnouncerException {
        TRTrackerAnnouncer tRTrackerAnnouncer = null;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            Object object;
            Object object2;
            if (this.stopped || this.destroyed) {
                return;
            }
            TOTorrent tOTorrent = this.getTorrent();
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (tOTorrentAnnounceURLSetArray.length == 0) {
                tOTorrentAnnounceURLSetArray = new TOTorrentAnnounceURLSet[]{tOTorrent.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{tOTorrent.getAnnounceURL()})};
            } else {
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray2 = tOTorrentAnnounceURLSetArray[i];
                    URL[] uRLArray = (URL[])tOTorrentAnnounceURLSetArray2.getAnnounceURLs().clone();
                    for (int j = 0; j < uRLArray.length; ++j) {
                        URL object42 = uRLArray[j];
                        if (object42 == null || !TorrentUtils.isDecentralised(object42)) continue;
                        if (bl) {
                            bl2 = true;
                            uRLArray[j] = null;
                            continue;
                        }
                        bl = true;
                    }
                }
                if (bl2) {
                    ArrayList<TOTorrentAnnounceURLSet> arrayList = new ArrayList<TOTorrentAnnounceURLSet>();
                    for (TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet : tOTorrentAnnounceURLSetArray) {
                        URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                        ArrayList<URL> arrayList2 = new ArrayList<URL>(uRLArray.length);
                        object2 = uRLArray;
                        int n = ((URL[])object2).length;
                        for (int i = 0; i < n; ++i) {
                            object = object2[i];
                            if (object == null) continue;
                            arrayList2.add((URL)object);
                        }
                        if (arrayList2.size() <= 0) continue;
                        arrayList.add(tOTorrent.getAnnounceURLGroup().createAnnounceURLSet(arrayList2.toArray(new URL[arrayList2.size()])));
                    }
                    tOTorrentAnnounceURLSetArray = arrayList.toArray(new TOTorrentAnnounceURLSet[arrayList.size()]);
                }
            }
            ArrayList<TOTorrentAnnounceURLSet[]> arrayList = new ArrayList<TOTorrentAnnounceURLSet[]>();
            if (this.is_manual || tOTorrentAnnounceURLSetArray.length < 2) {
                arrayList.add(tOTorrentAnnounceURLSetArray);
            } else {
                ArrayList<TOTorrentAnnounceURLSet> arrayList3 = new ArrayList<TOTorrentAnnounceURLSet>(Arrays.asList(tOTorrentAnnounceURLSetArray));
                while (arrayList3.size() > 0) {
                    TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = (TOTorrentAnnounceURLSet)arrayList3.remove(0);
                    boolean bl = false;
                    URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                    if (uRLArray.length == 1) {
                        URL uRL = uRLArray[0];
                        String string = uRL.getProtocol().toLowerCase();
                        String string2 = uRL.getHost();
                        for (int i = 0; i < arrayList3.size(); ++i) {
                            object2 = (TOTorrentAnnounceURLSet)arrayList3.get(i);
                            URL[] uRLArray2 = object2.getAnnounceURLs();
                            if (uRLArray2.length != 1) continue;
                            URL uRL2 = uRLArray2[0];
                            object = uRL2.getProtocol().toLowerCase();
                            String string3 = uRL2.getHost();
                            if (!string2.equals(string3) || (!string.equals("udp") || !((String)object).startsWith("http")) && (!((String)object).equals("udp") || !string.startsWith("http"))) continue;
                            arrayList3.remove(i);
                            arrayList.add(new TOTorrentAnnounceURLSet[]{tOTorrentAnnounceURLSet, object2});
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    arrayList.add(new TOTorrentAnnounceURLSet[]{tOTorrentAnnounceURLSet});
                }
            }
            Iterator iterator = arrayList.iterator();
            List<TRTrackerAnnouncerHelper> list = this.announcers.getList();
            ArrayList<TRTrackerAnnouncer> arrayList4 = new ArrayList<TRTrackerAnnouncer>();
            block11: while (iterator.hasNext()) {
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray3 = (TOTorrentAnnounceURLSet[])iterator.next();
                Iterator<TRTrackerAnnouncerHelper> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = iterator2.next();
                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray2 = tRTrackerAnnouncerHelper.getAnnounceSets();
                    if (!this.same(tOTorrentAnnounceURLSetArray3, tOTorrentAnnounceURLSetArray2)) continue;
                    iterator.remove();
                    iterator2.remove();
                    arrayList4.add(tRTrackerAnnouncerHelper);
                    continue block11;
                }
            }
            TRTrackerAnnouncer object5 = null;
            TOTorrentAnnounceURLSet[] object6 = null;
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray3 = (TOTorrentAnnounceURLSet[])iterator.next();
                if (!TorrentUtils.isDecentralised(tOTorrentAnnounceURLSetArray3[0].getAnnounceURLs()[0])) continue;
                object6 = tOTorrentAnnounceURLSetArray3;
                iterator.remove();
                break;
            }
            Iterator<TRTrackerAnnouncerHelper> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = iterator2.next();
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray4 = tRTrackerAnnouncerHelper.getAnnounceSets();
                if (!TorrentUtils.isDecentralised(tOTorrentAnnounceURLSetArray4[0].getAnnounceURLs()[0])) continue;
                object5 = tRTrackerAnnouncerHelper;
                iterator2.remove();
                break;
            }
            if (object5 != null && object6 != null) {
                arrayList4.add(object5);
            } else if (object5 != null) {
                this.activated.remove(object5);
                object5.destroy();
            } else if (object6 != null) {
                TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = this.create(tOTorrent, object6);
                arrayList4.add(tRTrackerAnnouncerHelper);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext() && list.size() > 0) {
                TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = list.remove(0);
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray5 = (TOTorrentAnnounceURLSet[])iterator.next();
                iterator.remove();
                if (this.activated.contains(tRTrackerAnnouncerHelper) && tOTorrent.getPrivate() && tRTrackerAnnouncerHelper instanceof TRTrackerBTAnnouncerImpl && (object2 = tRTrackerAnnouncerHelper.getTrackerURL()) != null) {
                    this.forceStop((TRTrackerBTAnnouncerImpl)tRTrackerAnnouncerHelper, (URL)object2);
                }
                tRTrackerAnnouncerHelper.setAnnounceSets(tOTorrentAnnounceURLSetArray5);
                arrayList4.add(tRTrackerAnnouncerHelper);
            }
            for (TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray6 : arrayList) {
                TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = this.create(tOTorrent, tOTorrentAnnounceURLSetArray6);
                arrayList4.add(tRTrackerAnnouncerHelper);
            }
            Iterator<TRTrackerAnnouncerHelper> iterator3 = this.announcers.iterator();
            while (iterator3.hasNext()) {
                Object var20_68;
                TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = iterator3.next();
                if (arrayList4.contains(tRTrackerAnnouncerHelper)) continue;
                iterator3.remove();
                try {
                    if (this.activated.contains(tRTrackerAnnouncerHelper) && tOTorrent.getPrivate() && tRTrackerAnnouncerHelper instanceof TRTrackerBTAnnouncerImpl && (object2 = tRTrackerAnnouncerHelper.getTrackerURL()) != null) {
                        this.forceStop((TRTrackerBTAnnouncerImpl)tRTrackerAnnouncerHelper, (URL)object2);
                    }
                    var20_68 = null;
                }
                catch (Throwable throwable) {
                    var20_68 = null;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.getTorrent(), LOGID, "Deactivating " + this.getString(tRTrackerAnnouncerHelper.getAnnounceSets())));
                    }
                    this.activated.remove(tRTrackerAnnouncerHelper);
                    tRTrackerAnnouncerHelper.destroy();
                    throw throwable;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.getTorrent(), LOGID, "Deactivating " + this.getString(tRTrackerAnnouncerHelper.getAnnounceSets())));
                }
                this.activated.remove(tRTrackerAnnouncerHelper);
                tRTrackerAnnouncerHelper.destroy();
                {
                }
            }
            for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : arrayList4) {
                if (this.announcers.contains(tRTrackerAnnouncerHelper)) continue;
                this.announcers.add(tRTrackerAnnouncerHelper);
            }
            if (!this.is_manual && this.announcers.size() > 0) {
                if (this.activated.size() == 0) {
                    TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = this.announcers.get(0);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.getTorrent(), LOGID, "Activating " + this.getString(tRTrackerAnnouncerHelper.getAnnounceSets())));
                    }
                    this.activated.add(tRTrackerAnnouncerHelper);
                    this.last_activation_time = SystemTime.getMonotonousTime();
                    if (this.provider != null) {
                        tRTrackerAnnouncer = tRTrackerAnnouncerHelper;
                    }
                }
                this.setupActivationCheck(2500);
            }
        }
        if (tRTrackerAnnouncer != null) {
            if (this.complete) {
                tRTrackerAnnouncer.complete(true);
            } else {
                tRTrackerAnnouncer.update(false);
            }
        }
    }

    protected void setupActivationCheck(int n) {
        if (this.announcers.size() > this.activated.size()) {
            this.event = SimpleTimer.addEvent("TRMuxer:check", SystemTime.getOffsetTime(n), new TimerEventPerformer(){

                public void perform(TimerEvent timerEvent2) {
                    TRTrackerAnnouncerMuxer.this.checkActivation(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkActivation(boolean bl) {
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            int n;
            if (this.destroyed || this.stopped || this.announcers.size() <= this.activated.size()) {
                return;
            }
            if (this.provider == null) {
                n = 2500;
            } else {
                int n2;
                boolean bl2;
                boolean bl3 = bl;
                boolean bl4 = bl2 = this.provider.getRemaining() == 0L;
                if (bl2 && this.activated.size() > 0) {
                    n2 = this.provider.getConnectedConnectionCount();
                    if (n2 < 1) {
                        bl3 = SystemTime.getMonotonousTime() - this.last_activation_time >= 60000L;
                        n = 60000;
                    } else {
                        n = n2 < 3 ? 180000 : 0;
                    }
                } else {
                    n2 = this.provider.getMaxNewConnectionsAllowed();
                    int n3 = this.provider.getPendingConnectionCount();
                    int n4 = this.provider.getConnectedConnectionCount();
                    int n5 = 0;
                    for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : this.activated) {
                        TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse = tRTrackerAnnouncerHelper.getLastResponse();
                        if (tRTrackerAnnouncerResponse == null || tRTrackerAnnouncerResponse.getStatus() != 2) continue;
                        ++n5;
                    }
                    if (n5 == 0) {
                        bl3 = true;
                        n = 2500;
                    } else {
                        int n6 = n4 + n3;
                        if (n6 < 10) {
                            bl3 = true;
                            n = 2500;
                        } else if (n2 >= 5 && n3 < 3 * n2 / 4) {
                            bl3 = true;
                            n = 10000;
                        } else {
                            n = 30000;
                        }
                    }
                }
                if (bl3) {
                    for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : this.announcers) {
                        if (this.activated.contains(tRTrackerAnnouncerHelper)) continue;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.getTorrent(), LOGID, "Activating " + this.getString(tRTrackerAnnouncerHelper.getAnnounceSets())));
                        }
                        this.activated.add(tRTrackerAnnouncerHelper);
                        this.last_activation_time = SystemTime.getMonotonousTime();
                        if (this.complete) {
                            tRTrackerAnnouncerHelper.complete(true);
                            break;
                        }
                        tRTrackerAnnouncerHelper.update(false);
                        break;
                    }
                }
            }
            if (n > 0) {
                this.setupActivationCheck(n);
            }
        }
    }

    private String getString(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        for (TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet : tOTorrentAnnounceURLSetArray) {
            if (n++ > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("[");
            URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
            int n2 = 0;
            for (URL uRL : uRLArray) {
                if (n2++ > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(uRL.toExternalForm());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private boolean same(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray, TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray2) {
        boolean bl = this.sameSupport(tOTorrentAnnounceURLSetArray, tOTorrentAnnounceURLSetArray2);
        return bl;
    }

    private boolean sameSupport(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray, TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray2) {
        if (tOTorrentAnnounceURLSetArray.length != tOTorrentAnnounceURLSetArray2.length) {
            return false;
        }
        for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
            URL[] uRLArray;
            URL[] uRLArray2 = tOTorrentAnnounceURLSetArray[i].getAnnounceURLs();
            if (uRLArray2.length != (uRLArray = tOTorrentAnnounceURLSetArray2[i].getAnnounceURLs()).length) {
                return false;
            }
            if (uRLArray2.length == 1) {
                return uRLArray2[0].toExternalForm().equals(uRLArray[0].toExternalForm());
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (URL uRL : uRLArray2) {
                hashSet.add(uRL.toExternalForm());
            }
            HashSet hashSet2 = new HashSet();
            for (URL uRL : uRLArray) {
                hashSet2.add(uRL.toExternalForm());
            }
            if (((Object)hashSet).equals(hashSet2)) continue;
            return false;
        }
        return true;
    }

    protected void forceStop(final TRTrackerBTAnnouncerImpl tRTrackerBTAnnouncerImpl, final URL uRL) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getTorrent(), LOGID, "Force stopping " + uRL + " as private torrent"));
        }
        new AEThread2("TRMux:fs", true){

            public void run() {
                try {
                    TRTrackerBTAnnouncerImpl tRTrackerBTAnnouncerImpl2 = new TRTrackerBTAnnouncerImpl(TRTrackerAnnouncerMuxer.this.getTorrent(), new TOTorrentAnnounceURLSet[0], TRTrackerAnnouncerMuxer.this.networks, true, TRTrackerAnnouncerMuxer.this.getHelper());
                    tRTrackerBTAnnouncerImpl2.cloneFrom(tRTrackerBTAnnouncerImpl);
                    tRTrackerBTAnnouncerImpl2.setTrackerURL(uRL);
                    tRTrackerBTAnnouncerImpl2.stop(false);
                    tRTrackerBTAnnouncerImpl2.destroy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }.start();
    }

    protected TRTrackerAnnouncerHelper create(TOTorrent tOTorrent, TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) throws TRTrackerAnnouncerException {
        boolean bl = tOTorrentAnnounceURLSetArray.length == 0 ? TorrentUtils.isDecentralised(tOTorrent.getAnnounceURL()) : TorrentUtils.isDecentralised(tOTorrentAnnounceURLSetArray[0].getAnnounceURLs()[0]);
        TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = bl ? new TRTrackerDHTAnnouncerImpl(tOTorrent, this.networks, this.is_manual, this.getHelper()) : new TRTrackerBTAnnouncerImpl(tOTorrent, tOTorrentAnnounceURLSetArray, this.networks, this.is_manual, this.getHelper());
        for (TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet : tOTorrentAnnounceURLSetArray) {
            URL[] uRLArray;
            for (URL uRL : uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs()) {
                String string = uRL.toExternalForm();
                StatusSummary statusSummary = this.recent_responses.get(string);
                if (statusSummary == null) {
                    statusSummary = new StatusSummary(tRTrackerAnnouncerHelper, uRL);
                    this.recent_responses.put(string, statusSummary);
                    continue;
                }
                statusSummary.setHelper(tRTrackerAnnouncerHelper);
            }
        }
        if (this.provider != null) {
            tRTrackerAnnouncerHelper.setAnnounceDataProvider(this.provider);
        }
        if (this.ip_override != null) {
            tRTrackerAnnouncerHelper.setIPOverride(this.ip_override);
        }
        return tRTrackerAnnouncerHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informResponse(TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper, TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
        Object object;
        String string;
        Object object2;
        URL uRL = tRTrackerAnnouncerResponse.getURL();
        if (uRL != null) {
            object2 = this;
            synchronized (object2) {
                string = uRL.toExternalForm();
                object = this.recent_responses.get(string);
                if (object != null) {
                    ((StatusSummary)object).updateFrom(tRTrackerAnnouncerResponse);
                }
            }
        }
        super.informResponse(tRTrackerAnnouncerHelper, tRTrackerAnnouncerResponse);
        if (tRTrackerAnnouncerResponse.getStatus() != 2) {
            object2 = tRTrackerAnnouncerResponse.getURL();
            if (object2 != null) {
                string = ((URL)object2).toExternalForm();
                object = this.failed_urls;
                synchronized (object) {
                    if (this.failed_urls.contains(string)) {
                        return;
                    }
                    this.failed_urls.add(string);
                }
            }
            this.checkActivation(true);
        }
    }

    public boolean isManual() {
        return this.is_manual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider tRTrackerAnnouncerDataProvider) {
        List<TRTrackerAnnouncerHelper> list;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            this.provider = tRTrackerAnnouncerDataProvider;
            list = this.announcers.getList();
        }
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : list) {
            tRTrackerAnnouncerHelper.setAnnounceDataProvider(this.provider);
        }
    }

    protected TRTrackerAnnouncerHelper getBestActive() {
        long l = SystemTime.getMonotonousTime();
        if (l - this.last_best_active_set_time < 1000L) {
            return this.last_best_active;
        }
        this.last_best_active = this.getBestActiveSupport();
        this.last_best_active_set_time = l;
        return this.last_best_active;
    }

    protected TRTrackerAnnouncerHelper getBestActiveSupport() {
        List<TRTrackerAnnouncerHelper> list = this.announcers.getList();
        TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = null;
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper2 : list) {
            TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse = tRTrackerAnnouncerHelper2.getLastResponse();
            if (tRTrackerAnnouncerResponse == null) continue;
            int n = tRTrackerAnnouncerResponse.getStatus();
            if (n == 2) {
                return tRTrackerAnnouncerHelper2;
            }
            if (tRTrackerAnnouncerHelper != null || n != 1) continue;
            tRTrackerAnnouncerHelper = tRTrackerAnnouncerHelper2;
        }
        if (tRTrackerAnnouncerHelper != null) {
            return tRTrackerAnnouncerHelper;
        }
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public URL getTrackerURL() {
        TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = this.getBestActive();
        if (tRTrackerAnnouncerHelper != null) {
            return tRTrackerAnnouncerHelper.getTrackerURL();
        }
        return null;
    }

    public void setTrackerURL(URL uRL) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(uRL.toExternalForm());
        arrayList.add(arrayList2);
        TorrentUtils.listToAnnounceGroups(arrayList, this.getTorrent());
        this.resetTrackerUrl(false);
    }

    public void resetTrackerUrl(boolean bl) {
        try {
            this.split();
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : this.announcers) {
            tRTrackerAnnouncerHelper.resetTrackerUrl(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIPOverride(String string) {
        List<TRTrackerAnnouncerHelper> list;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            list = this.announcers.getList();
            this.ip_override = string;
        }
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : list) {
            tRTrackerAnnouncerHelper.setIPOverride(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIPOverride() {
        List<TRTrackerAnnouncerHelper> list;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            list = this.announcers.getList();
            this.ip_override = null;
        }
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : list) {
            tRTrackerAnnouncerHelper.clearIPOverride();
        }
    }

    public void setRefreshDelayOverrides(int n) {
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : this.announcers) {
            tRTrackerAnnouncerHelper.setRefreshDelayOverrides(n);
        }
    }

    public int getTimeUntilNextUpdate() {
        TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = this.getBestActive();
        if (tRTrackerAnnouncerHelper != null) {
            return tRTrackerAnnouncerHelper.getTimeUntilNextUpdate();
        }
        return Integer.MAX_VALUE;
    }

    public int getLastUpdateTime() {
        TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = this.getBestActive();
        if (tRTrackerAnnouncerHelper != null) {
            return tRTrackerAnnouncerHelper.getLastUpdateTime();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean bl) {
        List<TRTrackerAnnouncerHelper> list;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            list = this.is_manual ? this.announcers.getList() : new ArrayList<TRTrackerAnnouncerHelper>(this.activated);
        }
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : list) {
            tRTrackerAnnouncerHelper.update(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(boolean bl) {
        List<TRTrackerAnnouncerHelper> list;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            this.complete = true;
            list = this.is_manual ? this.announcers.getList() : new ArrayList<TRTrackerAnnouncerHelper>(this.activated);
        }
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : list) {
            tRTrackerAnnouncerHelper.complete(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl) {
        List<TRTrackerAnnouncerHelper> list;
        TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = this;
        synchronized (tRTrackerAnnouncerMuxer) {
            this.stopped = true;
            list = this.is_manual ? this.announcers.getList() : new ArrayList<TRTrackerAnnouncerHelper>(this.activated);
            this.activated.clear();
        }
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : list) {
            tRTrackerAnnouncerHelper.stop(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        List<TRTrackerAnnouncerHelper> list;
        TRTrackerAnnouncerFactoryImpl.destroy(this);
        Object object = this;
        synchronized (object) {
            this.destroyed = true;
            list = this.announcers.getList();
        }
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : list) {
            tRTrackerAnnouncerHelper.destroy();
        }
        object = this.event;
        if (object != null) {
            ((TimerEvent)object).cancel();
        }
    }

    public int getStatus() {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getBestAnnouncer();
        return tRTrackerAnnouncer == null ? -1 : tRTrackerAnnouncer.getStatus();
    }

    public String getStatusString() {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getBestAnnouncer();
        return tRTrackerAnnouncer == null ? "" : tRTrackerAnnouncer.getStatusString();
    }

    public TRTrackerAnnouncer getBestAnnouncer() {
        int n = -1;
        TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper = null;
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper2 : this.announcers) {
            int n2 = tRTrackerAnnouncerHelper2.getStatus();
            if (n2 <= n) continue;
            tRTrackerAnnouncerHelper = tRTrackerAnnouncerHelper2;
            n = n2;
        }
        return tRTrackerAnnouncerHelper == null ? this : tRTrackerAnnouncerHelper;
    }

    public void refreshListeners() {
        this.informURLRefresh();
    }

    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : this.announcers) {
            if (!(tRTrackerAnnouncerHelper instanceof TRTrackerDHTAnnouncerImpl)) continue;
            tRTrackerAnnouncerHelper.setAnnounceResult(downloadAnnounceResult);
            return;
        }
        List<TRTrackerAnnouncerHelper> list = this.announcers.getList();
        if (list.size() > 0) {
            ((TRTrackerAnnouncerHelper)list.get(0)).setAnnounceResult(downloadAnnounceResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPeerCacheLimit() {
        TRTrackerAnnouncer tRTrackerAnnouncer = this;
        synchronized (tRTrackerAnnouncer) {
            if (this.activated.size() < this.announcers.size()) {
                return 0;
            }
        }
        if (SystemTime.getMonotonousTime() - this.create_time < 15000L) {
            return 0;
        }
        tRTrackerAnnouncer = this.getBestActive();
        if (tRTrackerAnnouncer != null && this.provider != null && tRTrackerAnnouncer.getStatus() == 2) {
            if (this.provider.getMaxNewConnectionsAllowed() > 0 && this.provider.getPendingConnectionCount() == 0) {
                return 5;
            }
            return 0;
        }
        return 10;
    }

    public TrackerPeerSource getTrackerPeerSource(TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet) {
        URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
        final String[] stringArray = new String[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            stringArray[i] = uRLArray[i].toExternalForm();
        }
        return new TrackerPeerSource(){
            private StatusSummary _summary;
            private boolean enabled;
            private long fixup_time;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private StatusSummary fixup() {
                long l = SystemTime.getMonotonousTime();
                if (l - this.fixup_time > 1000L) {
                    long l2 = 0L;
                    StatusSummary statusSummary = null;
                    TRTrackerAnnouncerMuxer tRTrackerAnnouncerMuxer = TRTrackerAnnouncerMuxer.this;
                    synchronized (tRTrackerAnnouncerMuxer) {
                        for (String string : stringArray) {
                            StatusSummary statusSummary2 = (StatusSummary)TRTrackerAnnouncerMuxer.this.recent_responses.get(string);
                            if (statusSummary2 == null || statusSummary != null && statusSummary2.getTime() <= l2) continue;
                            statusSummary = statusSummary2;
                            l2 = statusSummary2.getTime();
                        }
                    }
                    if (TRTrackerAnnouncerMuxer.this.provider != null) {
                        this.enabled = TRTrackerAnnouncerMuxer.this.provider.isPeerSourceEnabled("Tracker");
                    }
                    if (statusSummary != null) {
                        this._summary = statusSummary;
                    }
                    this.fixup_time = l;
                }
                return this._summary;
            }

            public int getType() {
                return 1;
            }

            public String getName() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null) {
                    String string = statusSummary.getURL().toExternalForm();
                    int n = string.indexOf(63);
                    if (n != -1) {
                        string = string.substring(0, n);
                    }
                    return string;
                }
                return stringArray[0];
            }

            public int getStatus() {
                StatusSummary statusSummary = this.fixup();
                if (!this.enabled) {
                    return 1;
                }
                if (statusSummary != null) {
                    return statusSummary.getStatus();
                }
                return 3;
            }

            public String getStatusString() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null && this.enabled) {
                    return statusSummary.getStatusString();
                }
                return null;
            }

            public int getSeedCount() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null) {
                    return statusSummary.getSeedCount();
                }
                return -1;
            }

            public int getLeecherCount() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null) {
                    return statusSummary.getLeecherCount();
                }
                return -1;
            }

            public int getPeers() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null) {
                    return statusSummary.getPeers();
                }
                return -1;
            }

            public int getSecondsToUpdate() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null) {
                    return statusSummary.getSecondsToUpdate();
                }
                return -1;
            }

            public int getInterval() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null) {
                    return statusSummary.getInterval();
                }
                return -1;
            }

            public int getMinInterval() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null && this.enabled) {
                    return statusSummary.getMinInterval();
                }
                return -1;
            }

            public boolean isUpdating() {
                StatusSummary statusSummary = this.fixup();
                if (statusSummary != null && this.enabled) {
                    return statusSummary.isUpdating();
                }
                return false;
            }
        };
    }

    public void generateEvidence(IndentWriter indentWriter) {
        for (TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper : this.announcers) {
            tRTrackerAnnouncerHelper.generateEvidence(indentWriter);
        }
    }

    private static class StatusSummary {
        private TRTrackerAnnouncerHelper helper;
        private long time;
        private URL url;
        private int status;
        private String status_str;
        private int seeds = -1;
        private int leechers = -1;
        private int peers = -1;
        private int interval;
        private int min_interval;

        protected StatusSummary(TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper, URL uRL) {
            this.helper = tRTrackerAnnouncerHelper;
            this.url = uRL;
            this.status = 3;
        }

        protected void setHelper(TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper) {
            this.helper = tRTrackerAnnouncerHelper;
        }

        protected void updateFrom(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
            this.time = SystemTime.getMonotonousTime();
            int n = tRTrackerAnnouncerResponse.getStatus();
            if (n == 2) {
                this.status = 5;
                this.seeds = tRTrackerAnnouncerResponse.getScrapeCompleteCount();
                this.leechers = tRTrackerAnnouncerResponse.getScrapeIncompleteCount();
                this.peers = tRTrackerAnnouncerResponse.getPeers().length;
            } else {
                this.status = 6;
                this.status_str = tRTrackerAnnouncerResponse.getStatusString();
            }
            this.interval = (int)this.helper.getInterval();
            this.min_interval = (int)this.helper.getMinInterval();
        }

        public long getTime() {
            return this.time;
        }

        public URL getURL() {
            return this.url;
        }

        public int getStatus() {
            return this.status;
        }

        public String getStatusString() {
            return this.status_str;
        }

        public int getSeedCount() {
            return this.seeds;
        }

        public int getLeecherCount() {
            return this.leechers;
        }

        public int getPeers() {
            return this.peers;
        }

        public boolean isUpdating() {
            return this.helper.isUpdating();
        }

        public int getInterval() {
            return this.interval;
        }

        public int getMinInterval() {
            return this.min_interval;
        }

        public int getSecondsToUpdate() {
            return this.helper.getTimeUntilNextUpdate();
        }
    }
}

