/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerHelper;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public abstract class TRTrackerAnnouncerImpl
implements TRTrackerAnnouncer {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    protected static final int LDT_TRACKER_RESPONSE = 1;
    protected static final int LDT_URL_CHANGED = 2;
    protected static final int LDT_URL_REFRESH = 3;
    private static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int key_id_length = 8;
    protected ListenerManager<TRTrackerAnnouncerListener> listeners = ListenerManager.createManager("TrackerClient:ListenDispatcher", new ListenerManagerDispatcher<TRTrackerAnnouncerListener>(){

        @Override
        public void dispatch(TRTrackerAnnouncerListener tRTrackerAnnouncerListener, int n, Object object) {
            if (n == 1) {
                tRTrackerAnnouncerListener.receivedTrackerResponse((TRTrackerAnnouncerResponse)object);
            } else if (n == 2) {
                Object[] objectArray = (Object[])object;
                URL uRL = (URL)objectArray[0];
                URL uRL2 = (URL)objectArray[1];
                boolean bl = (Boolean)objectArray[2];
                tRTrackerAnnouncerListener.urlChanged(TRTrackerAnnouncerImpl.this, uRL, uRL2, bl);
            } else {
                tRTrackerAnnouncerListener.urlRefresh();
            }
        }
    });
    private Map tracker_peer_cache = new LinkedHashMap();
    private AEMonitor tracker_peer_cache_mon = new AEMonitor("TRTrackerClientClassic:PC");
    private int cache_peers_used;
    private final TOTorrent torrent;
    private final byte[] peer_id;
    private final String tracker_key;
    private final int udp_key;
    private TRTrackerAnnouncerResponse last_response;

    private static String createKeyID() {
        String string = "";
        for (int i = 0; i < 8; ++i) {
            int n = (int)(Math.random() * (double)chars.length());
            string = string + chars.charAt(n);
        }
        return string;
    }

    protected TRTrackerAnnouncerImpl(TOTorrent tOTorrent) throws TRTrackerAnnouncerException {
        this.torrent = tOTorrent;
        this.tracker_key = TRTrackerAnnouncerImpl.createKeyID();
        this.udp_key = (int)(Math.random() * 4.294967295E9);
        try {
            this.last_response = new TRTrackerAnnouncerResponseImpl(null, this.torrent.getHashWrapper(), 0, 60L, "Initialising");
        }
        catch (TOTorrentException tOTorrentException) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "Torrent hash retrieval fails", (Throwable)tOTorrentException));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        try {
            this.peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, false);
        }
        catch (ClientIDException clientIDException) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", clientIDException);
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public Helper getHelper() {
        return new Helper(){

            public byte[] getPeerID() {
                return TRTrackerAnnouncerImpl.this.peer_id;
            }

            public String getTrackerKey() {
                return TRTrackerAnnouncerImpl.this.tracker_key;
            }

            public int getUDPKey() {
                return TRTrackerAnnouncerImpl.this.udp_key;
            }

            public void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] tRTrackerAnnouncerResponsePeerImplArray) {
                TRTrackerAnnouncerImpl.this.addToTrackerCache(tRTrackerAnnouncerResponsePeerImplArray);
            }

            public TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int n) {
                return TRTrackerAnnouncerImpl.this.getPeersFromCache(n);
            }

            public void setTrackerResponseCache(Map map) {
                TRTrackerAnnouncerImpl.this.setTrackerResponseCache(map);
            }

            public void removeFromTrackerResponseCache(String string, int n) {
                TRTrackerAnnouncerImpl.this.removeFromTrackerResponseCache(string, n);
            }

            public Map getTrackerResponseCache() {
                return TRTrackerAnnouncerImpl.this.getTrackerResponseCache();
            }

            public void informResponse(TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper, TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
                TRTrackerAnnouncerImpl.this.informResponse(tRTrackerAnnouncerHelper, tRTrackerAnnouncerResponse);
            }

            public void informURLChange(URL uRL, URL uRL2, boolean bl) {
                TRTrackerAnnouncerImpl.this.listeners.dispatch(2, new Object[]{uRL, uRL2, new Boolean(bl)});
            }

            public void informURLRefresh() {
                TRTrackerAnnouncerImpl.this.informURLRefresh();
            }

            public void addListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
                TRTrackerAnnouncerImpl.this.addListener(tRTrackerAnnouncerListener);
            }

            public void removeListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
                TRTrackerAnnouncerImpl.this.removeListener(tRTrackerAnnouncerListener);
            }
        };
    }

    public byte[] getPeerId() {
        return this.peer_id;
    }

    public static byte[] getAnonymousPeerId(String string, int n) {
        byte[] byArray = new byte[20];
        byArray[0] = 91;
        byArray[1] = 93;
        try {
            byte[] byArray2 = string.getBytes("UTF8");
            int n2 = byArray2.length;
            if (n2 > 18) {
                n2 = 18;
            }
            System.arraycopy(byArray2, 0, byArray, 2, n2);
            int n3 = n;
            for (int i = 2 + n2; i < 20; ++i) {
                byArray[i] = (byte)(n3 & 0xFF);
                n3 >>= 8;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
        }
        return byArray;
    }

    public Map getTrackerResponseCache() {
        return this.exportTrackerCache();
    }

    public void setTrackerResponseCache(Map map) {
        int n = this.importTrackerCache(map);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: imported " + n + " cached peers"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map exportTrackerCache() {
        LightHashMap lightHashMap = new LightHashMap(1);
        ArrayList arrayList = new ArrayList();
        lightHashMap.put("tracker_peers", arrayList);
        try {
            this.tracker_peer_cache_mon.enter();
            for (TRTrackerAnnouncerResponsePeer tRTrackerAnnouncerResponsePeer : this.tracker_peer_cache.values()) {
                int n;
                LightHashMap lightHashMap2 = new LightHashMap();
                lightHashMap2.put("ip", tRTrackerAnnouncerResponsePeer.getAddress().getBytes());
                lightHashMap2.put("src", tRTrackerAnnouncerResponsePeer.getSource().getBytes());
                lightHashMap2.put("port", new Long(tRTrackerAnnouncerResponsePeer.getPort()));
                int n2 = tRTrackerAnnouncerResponsePeer.getUDPPort();
                if (n2 != 0) {
                    lightHashMap2.put("udpport", new Long(n2));
                }
                if ((n = tRTrackerAnnouncerResponsePeer.getHTTPPort()) != 0) {
                    lightHashMap2.put("httpport", new Long(n));
                }
                lightHashMap2.put("prot", new Long(tRTrackerAnnouncerResponsePeer.getProtocol()));
                byte by = tRTrackerAnnouncerResponsePeer.getAZVersion();
                if (by != 1) {
                    lightHashMap2.put("azver", new Long(by));
                }
                lightHashMap2.compactify(0.9f);
                arrayList.add(lightHashMap2);
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: exported " + this.tracker_peer_cache.size() + " cached peers"));
            }
            Object var10_9 = null;
            this.tracker_peer_cache_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
        return lightHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int importTrackerCache(Map map) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return 0;
        }
        if (map == null) {
            return 0;
        }
        List list = (List)map.get("tracker_peers");
        if (list == null) {
            return 0;
        }
        try {
            int n;
            this.tracker_peer_cache_mon.enter();
            for (n = 0; n < list.size(); ++n) {
                Map map2 = (Map)list.get(n);
                byte[] byArray = (byte[])map2.get("src");
                String string = byArray == null ? "Tracker" : new String(byArray);
                String string2 = new String((byte[])map2.get("ip"));
                int n2 = ((Long)map2.get("port")).intValue();
                byte[] byArray2 = TRTrackerAnnouncerImpl.getAnonymousPeerId(string2, n2);
                Long l = (Long)map2.get("prot");
                short s = l == null ? (short)1 : l.shortValue();
                Long l2 = (Long)map2.get("udpport");
                int n3 = l2 == null ? 0 : l2.intValue();
                Long l3 = (Long)map2.get("httpport");
                int n4 = l3 == null ? 0 : l3.intValue();
                Long l4 = (Long)map2.get("azver");
                byte by = l4 == null ? (byte)1 : l4.byteValue();
                TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl(string, byArray2, string2, n2, n3, n4, s, by, 0);
                this.tracker_peer_cache.put(tRTrackerAnnouncerResponsePeerImpl.getKey(), tRTrackerAnnouncerResponsePeerImpl);
            }
            n = this.tracker_peer_cache.size();
            {
                Object var20_20 = null;
                this.tracker_peer_cache_mon.exit();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                Object var20_21 = null;
                this.tracker_peer_cache_mon.exit();
                throw throwable;
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
                return this.tracker_peer_cache.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] tRTrackerAnnouncerResponsePeerImplArray) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return;
        }
        int n = COConfigurationManager.getIntParameter("File.save.peers.max", 512);
        try {
            this.tracker_peer_cache_mon.enter();
            for (int i = 0; i < tRTrackerAnnouncerResponsePeerImplArray.length; ++i) {
                TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = tRTrackerAnnouncerResponsePeerImplArray[i];
                this.tracker_peer_cache.remove(tRTrackerAnnouncerResponsePeerImpl.getKey());
                this.tracker_peer_cache.put(tRTrackerAnnouncerResponsePeerImpl.getKey(), tRTrackerAnnouncerResponsePeerImpl);
            }
            Iterator iterator = this.tracker_peer_cache.keySet().iterator();
            if (n > 0) {
                while (this.tracker_peer_cache.size() > n) {
                    iterator.next();
                    iterator.remove();
                }
            }
            Object var6_6 = null;
            this.tracker_peer_cache_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromTrackerResponseCache(String string, int n) {
        try {
            this.tracker_peer_cache_mon.enter();
            TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl("", new byte[0], string, n, 0, 0, 0, 0, 0);
            if (this.tracker_peer_cache.remove(tRTrackerAnnouncerResponsePeerImpl.getKey()) != null && Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "Explicit removal of peer cache for " + string + ":" + n));
            }
            Object var5_4 = null;
            this.tracker_peer_cache_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
    }

    public static Map mergeResponseCache(Map map, Map map2) {
        List list;
        if (map == null && map2 == null) {
            return new HashMap();
        }
        if (map == null) {
            return map2;
        }
        if (map2 == null) {
            return map;
        }
        HashMap hashMap = new HashMap();
        ArrayList arrayList = (ArrayList)map.get("tracker_peers");
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if ((list = (List)map2.get("tracker_peers")) != null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TRTrackerClient: merged peer sets: p1 = " + arrayList.size() + ", p2 = " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
        }
        hashMap.put("tracker_peers", arrayList);
        return hashMap;
    }

    protected abstract int getPeerCacheLimit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int n) {
        int n2 = this.getPeerCacheLimit();
        if (n2 <= 0) {
            return new TRTrackerAnnouncerResponsePeer[0];
        }
        n = Math.min(n2, n);
        try {
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray;
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray2;
            this.tracker_peer_cache_mon.enter();
            if (this.tracker_peer_cache.size() <= n) {
                tRTrackerAnnouncerResponsePeerArray2 = new TRTrackerAnnouncerResponsePeerImpl[this.tracker_peer_cache.size()];
                this.tracker_peer_cache.values().toArray(tRTrackerAnnouncerResponsePeerArray2);
            } else {
                int n3;
                tRTrackerAnnouncerResponsePeerArray2 = new TRTrackerAnnouncerResponsePeerImpl[n];
                tRTrackerAnnouncerResponsePeerArray = this.tracker_peer_cache.keySet().iterator();
                for (n3 = 0; n3 < n; ++n3) {
                    String string = (String)tRTrackerAnnouncerResponsePeerArray.next();
                    tRTrackerAnnouncerResponsePeerArray2[n3] = (TRTrackerAnnouncerResponsePeerImpl)this.tracker_peer_cache.get(string);
                    tRTrackerAnnouncerResponsePeerArray.remove();
                }
                for (n3 = 0; n3 < n; ++n3) {
                    this.tracker_peer_cache.put(tRTrackerAnnouncerResponsePeerArray2[n3].getKey(), tRTrackerAnnouncerResponsePeerArray2[n3]);
                }
            }
            if (Logger.isEnabled()) {
                for (int i = 0; i < tRTrackerAnnouncerResponsePeerArray2.length; ++i) {
                    Logger.log(new LogEvent(this.getTorrent(), LOGID, "CACHED PEER: " + ((TRTrackerAnnouncerResponsePeerImpl)tRTrackerAnnouncerResponsePeerArray2[i]).getString()));
                }
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: returned " + tRTrackerAnnouncerResponsePeerArray2.length + " cached peers"));
            }
            this.cache_peers_used += tRTrackerAnnouncerResponsePeerArray2.length;
            tRTrackerAnnouncerResponsePeerArray = tRTrackerAnnouncerResponsePeerArray2;
            Object var8_8 = null;
            this.tracker_peer_cache_mon.exit();
            return tRTrackerAnnouncerResponsePeerArray;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
    }

    public TrackerPeerSource getCacheTrackerPeerSource() {
        return new TrackerPeerSourceAdapter(){

            public String getName() {
                return MessageText.getString("tps.tracker.cache1", new String[]{String.valueOf(TRTrackerAnnouncerImpl.this.tracker_peer_cache.size())});
            }

            public int getPeers() {
                return TRTrackerAnnouncerImpl.this.cache_peers_used;
            }
        };
    }

    public TRTrackerAnnouncerResponse getLastResponse() {
        return this.last_response;
    }

    protected void informResponse(TRTrackerAnnouncerHelper tRTrackerAnnouncerHelper, TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
        this.last_response = tRTrackerAnnouncerResponse;
        this.listeners.dispatch(1, tRTrackerAnnouncerResponse);
    }

    protected void informURLRefresh() {
        this.listeners.dispatch(3, null);
    }

    public void addListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
        this.listeners.addListener(tRTrackerAnnouncerListener);
    }

    public void removeListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
        this.listeners.removeListener(tRTrackerAnnouncerListener);
    }

    public static interface Helper {
        public byte[] getPeerID();

        public String getTrackerKey();

        public int getUDPKey();

        public void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] var1);

        public TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int var1);

        public void setTrackerResponseCache(Map var1);

        public void removeFromTrackerResponseCache(String var1, int var2);

        public Map getTrackerResponseCache();

        public void informResponse(TRTrackerAnnouncerHelper var1, TRTrackerAnnouncerResponse var2);

        public void informURLChange(URL var1, URL var2, boolean var3);

        public void informURLRefresh();

        public void addListener(TRTrackerAnnouncerListener var1);

        public void removeListener(TRTrackerAnnouncerListener var1);
    }
}

