/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection2;

public class TorrentDownloaderImpl
extends AEThread
implements TorrentDownloader {
    private String original_url;
    private String url_str;
    private String referrer;
    private Map request_properties;
    private String file_str;
    private URL url;
    private HttpURLConnection con;
    private String error = "Ok";
    private String status = "";
    private TorrentDownloaderCallBackInterface iface;
    private int state = -1;
    private int percentDone = 0;
    private int readTotal = 0;
    private boolean cancel = false;
    private String filename;
    private String directoryname;
    private File file = null;
    private byte[] buf = new byte[1020];
    private int bufBytes = 0;
    private boolean deleteFileOnCancel = true;
    private boolean ignoreReponseCode = false;
    private AEMonitor this_mon = new AEMonitor("TorrentDownloader");
    private int errCode;

    public TorrentDownloaderImpl() {
        super("Torrent Downloader");
        this.setDaemon(true);
    }

    public void init(TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string, String string2, Map map, String string3) {
        this.iface = torrentDownloaderCallBackInterface;
        this.original_url = string;
        string = string.replace('\\', '/');
        string = string.replaceAll(" ", "%20");
        this.setName("TorrentDownloader: " + string);
        this.url_str = string;
        this.referrer = string2;
        this.request_properties = map;
        this.file_str = string3;
    }

    public void notifyListener() {
        if (this.iface != null) {
            this.iface.TorrentDownloaderEvent(this.state, this);
        } else if (this.state == 4) {
            System.err.println(this.error);
        }
    }

    private void cleanUpFile() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(int n, String string) {
        try {
            this.this_mon.enter();
            this.state = 4;
            this.setError(n, string);
            this.cleanUpFile();
            this.notifyListener();
            Object var4_3 = null;
            this.this_mon.exit();
            this.closeConnection();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            this.closeConnection();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void runSupport() {
        Object object;
        block63: {
            try {
                new URL(this.url_str);
            }
            catch (Throwable throwable) {
                String string = UrlUtils.normaliseMagnetURI(this.url_str);
                if (string == null) break block63;
                this.url_str = string;
            }
        }
        try {
            block67: {
                Object object3;
                block65: {
                    block66: {
                        int n;
                        this.url = AddressUtils.adjustURL(new URL(this.url_str));
                        object = this.url.getProtocol().toLowerCase();
                        if (((String)object).equals("magnet") || ((String)object).equals("dht")) {
                            this.url = AddressUtils.adjustURL(new URL(this.url_str + "&pause_on_error=true"));
                        }
                        for (n = 0; n < 2; ++n) {
                            try {
                                if (((String)object).equals("https")) {
                                    object3 = (HttpsURLConnection)this.url.openConnection();
                                    ((HttpsURLConnection)object3).setHostnameVerifier(new HostnameVerifier(){

                                        public boolean verify(String string, SSLSession sSLSession) {
                                            return true;
                                        }
                                    });
                                    this.con = object3;
                                } else {
                                    this.con = (HttpURLConnection)this.url.openConnection();
                                }
                                this.con.setRequestProperty("User-Agent", "Azureus 4.5.0.4");
                                if (this.referrer != null && this.referrer.length() > 0) {
                                    this.con.setRequestProperty("Referer", this.referrer);
                                }
                                if (this.request_properties != null) {
                                    for (Map.Entry entry : this.request_properties.entrySet()) {
                                        String bl = (String)entry.getKey();
                                        String throwable = (String)entry.getValue();
                                        if (bl.equalsIgnoreCase("Accept-Encoding")) continue;
                                        this.con.setRequestProperty(bl, throwable);
                                    }
                                }
                                this.con.connect();
                                break;
                            }
                            catch (SSLException sSLException) {
                                if (n != 0) throw sSLException;
                                if (SESecurityManager.installServerCertificates(this.url) == null) throw sSLException;
                                continue;
                            }
                            catch (IOException iOException) {
                                if (n == 0) {
                                    URL object22 = UrlUtils.getIPV4Fallback(this.url);
                                    if (object22 == null) throw iOException;
                                    this.url = object22;
                                }
                                if (!(iOException instanceof UnknownHostException)) continue;
                                throw iOException;
                            }
                        }
                        n = this.con.getResponseCode();
                        if (!this.ignoreReponseCode && n != 202 && n != 200) {
                            this.error(n, Integer.toString(n) + ": " + this.con.getResponseMessage());
                            return;
                        }
                        this.filename = this.con.getHeaderField("Content-Disposition");
                        if (this.filename != null && this.filename.toLowerCase().matches(".*attachment.*")) {
                            while (this.filename.toLowerCase().charAt(0) != 'a') {
                                this.filename = this.filename.substring(1);
                            }
                        }
                        if (this.filename != null && this.filename.toLowerCase().startsWith("attachment") && this.filename.indexOf(61) != -1) break block65;
                        object3 = this.url.getFile();
                        if (((String)object3).length() != 0 && !((String)object3).equals("/")) break block66;
                        this.filename = this.url.getHost();
                        break block67;
                    }
                    if (((String)object3).startsWith("?")) {
                        int fileOutputStream;
                        String file = ((String)object3).toUpperCase();
                        int n2 = file.indexOf("XT=URN:SHA1:");
                        if (n2 == -1) {
                            n2 = file.indexOf("XT=URN:BTIH:");
                        }
                        this.filename = n2 != -1 ? ((fileOutputStream = file.indexOf("&", n2 += 12)) == -1 ? file.substring(n2) : file.substring(n2, fileOutputStream)) : "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        this.filename = this.filename + ".tmp";
                        break block67;
                    } else {
                        int fileNotFoundException;
                        while (((String)object3).endsWith("/")) {
                            object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
                        }
                        if (((String)object3).lastIndexOf(47) != -1) {
                            object3 = ((String)object3).substring(((String)object3).lastIndexOf(47) + 1);
                        }
                        if ((fileNotFoundException = ((String)object3).indexOf(63)) != -1) {
                            object3 = ((String)object3).substring(0, fileNotFoundException);
                        }
                        this.filename = URLDecoder.decode((String)object3, "UTF8");
                        if (this.filename.length() == 0) {
                            this.filename = "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        }
                    }
                    break block67;
                }
                this.filename = this.filename.substring(this.filename.indexOf(61) + 1);
                if (this.filename.startsWith("\"") && this.filename.endsWith("\"")) {
                    this.filename = this.filename.substring(1, this.filename.lastIndexOf(34));
                }
                this.filename = URLDecoder.decode(this.filename, "UTF8");
                object3 = new File(this.filename);
                this.filename = ((File)object3).getName();
            }
            this.filename = FileUtil.convertOSSpecificChars(this.filename, false);
            this.directoryname = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
            boolean bl = COConfigurationManager.getBooleanParameter("Save Torrent Files");
            if (this.file_str != null) {
                File string = new File(this.file_str);
                if (!bl || this.directoryname.length() == 0) {
                    this.directoryname = string.isDirectory() ? string.getCanonicalPath() : string.getCanonicalFile().getParent();
                }
                if (!string.isDirectory()) {
                    this.filename = string.getName();
                }
            }
            this.state = 0;
            this.notifyListener();
        }
        catch (MalformedURLException malformedURLException) {
            this.error(0, "Exception while parsing URL '" + this.url + "':" + malformedURLException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            this.error(0, "Exception while initializing download of '" + this.url + "': Unknown Host '" + unknownHostException.getMessage() + "'");
        }
        catch (IOException iOException) {
            this.error(0, "I/O Exception while initializing download of '" + this.url + "':" + iOException.toString());
        }
        catch (Throwable throwable) {
            this.error(0, "Exception while initializing download of '" + this.url + "':" + throwable.toString());
        }
        if (this.state == 4) {
            return;
        }
        try {
            File file;
            TOTorrent iOException;
            InputStream inputStream;
            block64: {
                object = new boolean[]{true};
                this.state = 1;
                this.notifyListener();
                this.state = 2;
                this.notifyListener();
                AEThread aEThread = new AEThread("TorrentDownloader:statusreader", (boolean[])object){
                    final /* synthetic */ boolean[] val$status_reader_run;
                    {
                        this.val$status_reader_run = blArray;
                        super(string);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        boolean bl = false;
                        String string = "";
                        boolean bl2 = false;
                        long l = SystemTime.getMonotonousTime();
                        try {
                            while (true) {
                                String string2;
                                if (bl2) {
                                    Thread.sleep(50L);
                                    bl2 = false;
                                }
                                try {
                                    TorrentDownloaderImpl.this.this_mon.enter();
                                    if (!this.val$status_reader_run[0]) {
                                        string2 = null;
                                        TorrentDownloaderImpl.this.this_mon.exit();
                                        break;
                                    }
                                    string2 = null;
                                    TorrentDownloaderImpl.this.this_mon.exit();
                                }
                                catch (Throwable throwable) {
                                    string2 = null;
                                    TorrentDownloaderImpl.this.this_mon.exit();
                                    throw throwable;
                                }
                                String string3 = TorrentDownloaderImpl.this.con.getResponseMessage();
                                if (string3.equals(string)) {
                                    bl2 = true;
                                    continue;
                                }
                                string = string3;
                                string2 = string3.toLowerCase();
                                if (!string2.startsWith("error:")) {
                                    if (string3.toLowerCase().indexOf("alive") != -1 && TorrentDownloaderImpl.this.percentDone < 10) {
                                        TorrentDownloaderImpl.this.percentDone++;
                                    }
                                    boolean bl3 = false;
                                    int n = string3.indexOf(37);
                                    if (n != -1) {
                                        int n2;
                                        for (n2 = n - 1; n2 >= 0; --n2) {
                                            char c = string3.charAt(n2);
                                            if (Character.isDigit(c) || c == ' ') continue;
                                            ++n2;
                                            break;
                                        }
                                        try {
                                            TorrentDownloaderImpl.this.percentDone = Integer.parseInt(string3.substring(n2, n).trim());
                                            bl3 = true;
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                    if (string2.startsWith("received")) {
                                        bl3 = true;
                                    }
                                    if (bl3) {
                                        long l2 = SystemTime.getMonotonousTime();
                                        if (l2 - l < 250L) continue;
                                        l = l2;
                                    }
                                    TorrentDownloaderImpl.this.setStatus(string3);
                                } else {
                                    TorrentDownloaderImpl.this.error(TorrentDownloaderImpl.this.con.getResponseCode(), string3.substring(6));
                                }
                                bl = true;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (bl) {
                            TorrentDownloaderImpl.this.setStatus("");
                        }
                    }
                };
                aEThread.setDaemon(true);
                aEThread.start();
                try {
                    try {
                        inputStream = this.con.getInputStream();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (!this.ignoreReponseCode) throw fileNotFoundException;
                        inputStream = this.con.getErrorStream();
                        iOException = null;
                        try {}
                        catch (Throwable string3) {
                            Object file2 = null;
                            this.this_mon.exit();
                            throw string3;
                        }
                        this.this_mon.enter();
                        object[0] = false;
                        file = null;
                        this.this_mon.exit();
                        break block64;
                    }
                    iOException = null;
                    try {
                        this.this_mon.enter();
                        object[0] = false;
                        file = null;
                        this.this_mon.exit();
                    }
                    catch (Throwable throwable2) {
                        Object var10_36 = null;
                        this.this_mon.exit();
                        throw throwable2;
                    }
                }
                catch (Throwable throwable) {
                    Object throwable2 = null;
                    try {}
                    catch (Throwable throwable3) {
                        Object var10_39 = null;
                        this.this_mon.exit();
                        throw throwable3;
                    }
                    this.this_mon.enter();
                    object[0] = false;
                    Object var10_38 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            String string = this.con.getHeaderField("content-encoding");
            if (string != null) {
                if (string.equalsIgnoreCase("gzip")) {
                    inputStream = new GZIPInputStream(inputStream);
                } else if (string.equalsIgnoreCase("deflate")) {
                    inputStream = new InflaterInputStream(inputStream);
                }
            }
            if (this.state == 4) return;
            this.file = new File(this.directoryname, this.filename);
            boolean bl = false;
            try {
                this.file.createNewFile();
                bl = !this.file.exists();
            }
            catch (Throwable throwable) {
                bl = true;
            }
            if (bl) {
                this.file = File.createTempFile("AZU", ".torrent", new File(this.directoryname));
                this.file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.file, false);
            this.bufBytes = 0;
            int n = (int)UrlUtils.getContentLength(this.con);
            this.percentDone = -1;
            while (!this.cancel) {
                try {
                    this.bufBytes = inputStream.read(this.buf);
                    this.readTotal += this.bufBytes;
                    if (n > 0) {
                        this.percentDone = 100 * this.readTotal / n;
                    }
                    this.notifyListener();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                if (this.bufBytes > 0) {
                    fileOutputStream.write(this.buf, 0, this.bufBytes);
                }
                if (this.bufBytes > 0) continue;
            }
            inputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
            if (this.cancel) {
                this.state = 6;
                if (this.deleteFileOnCancel) {
                    this.cleanUpFile();
                }
            } else {
                if (this.readTotal <= 0) {
                    this.error(0, "No data contained in '" + this.url.toString() + "'");
                    return;
                }
                try {
                    String string2;
                    if (!this.filename.toLowerCase().endsWith(".torrent") && this.file.renameTo(file = new File(this.directoryname, string2 = TorrentUtils.getLocalisedName(iOException = TorrentUtils.readFromFile(this.file, false)) + ".torrent"))) {
                        this.filename = string2;
                        this.file = file;
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                TorrentUtils.setObtainedFrom(this.file, this.original_url);
                this.state = 3;
            }
            this.notifyListener();
            return;
        }
        catch (Exception exception) {
            if (!this.cancel) {
                Debug.out("'" + this.directoryname + "' '" + this.filename + "'", exception);
            }
            this.error(0, "Exception while downloading '" + this.url.toString() + "':" + exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TorrentDownloaderImpl) {
            TorrentDownloaderImpl torrentDownloaderImpl = (TorrentDownloaderImpl)object;
            if (torrentDownloaderImpl.getURL().equals(this.url.toString())) {
                File file;
                File file2 = torrentDownloaderImpl.getFile();
                if (file2 == (file = this.file)) {
                    return true;
                }
                if (file2 == null || file == null) {
                    return false;
                }
                return file2.getAbsolutePath().equals(file.getAbsolutePath());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String getError() {
        return this.error;
    }

    public void setError(int n, String string) {
        this.error = string;
        this.errCode = n;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    protected void setStatus(String string) {
        this.status = string;
        this.notifyListener();
    }

    public String getStatus() {
        return this.status;
    }

    public File getFile() {
        if (!this.isAlive() || this.file == null) {
            this.file = new File(this.directoryname, this.filename);
        }
        return this.file;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public int getDownloadState() {
        return this.state;
    }

    public void setDownloadState(int n) {
        this.state = n;
    }

    public String getURL() {
        return this.url.toString();
    }

    public void cancel() {
        this.cancel = true;
        this.closeConnection();
    }

    protected void closeConnection() {
        if (this.con instanceof MagnetConnection || this.con instanceof MagnetConnection2) {
            this.con.disconnect();
        }
    }

    public void setDownloadPath(String string, String string2) {
        if (!this.isAlive()) {
            if (string != null) {
                this.directoryname = string;
            }
            if (string2 != null) {
                this.filename = string2;
            }
        }
    }

    public int getTotalRead() {
        return this.readTotal;
    }

    public byte[] getLastReadBytes() {
        if (this.bufBytes <= 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.bufBytes];
        System.arraycopy(this.buf, 0, byArray, 0, this.bufBytes);
        return byArray;
    }

    public int getLastReadCount() {
        return this.bufBytes;
    }

    public void setDeleteFileOnCancel(boolean bl) {
        this.deleteFileOnCancel = bl;
    }

    public boolean getDeleteFileOnCancel() {
        return this.deleteFileOnCancel;
    }

    public boolean isIgnoreReponseCode() {
        return this.ignoreReponseCode;
    }

    public void setIgnoreReponseCode(boolean bl) {
        this.ignoreReponseCode = bl;
    }
}

