/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;

public class StatsWriterImpl
extends XUXmlWriter {
    AzureusCore core;

    protected StatsWriterImpl(AzureusCore azureusCore) {
        this.core = azureusCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String string) throws IOException {
        try {
            this.setOutputStream(new FileOutputStream(string));
            this.writeSupport();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.closeOutputStream();
            throw throwable;
        }
        this.closeOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(OutputStream outputStream) throws IOException {
        try {
            this.setOutputStream(outputStream);
            this.writeSupport();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.flushOutputStream();
            throw throwable;
        }
        this.flushOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeSupport() {
        this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        boolean bl = COConfigurationManager.getBooleanParameter("Stats Export Peer Details");
        boolean bl2 = COConfigurationManager.getBooleanParameter("Stats Export File Details");
        String string = COConfigurationManager.getStringParameter("Stats XSL File");
        if (string.length() > 0) {
            this.writeLineRaw("<?xml-stylesheet type=\"text/xsl\" href=\"" + string + "\"?>");
        }
        this.writeLineRaw("<STATS>");
        GlobalManager globalManager = this.core.getGlobalManager();
        try {
            Object object;
            this.indent();
            this.writeTag("AZUREUS_VERSION", "4.5.0.4");
            this.writeLineRaw("<GLOBAL>");
            try {
                this.indent();
                object = globalManager.getStats();
                this.writeRawCookedAverageTag("DOWNLOAD_SPEED", object.getDataReceiveRate() + object.getProtocolReceiveRate());
                this.writeRawCookedAverageTag("UPLOAD_SPEED", object.getDataSendRate() + object.getProtocolSendRate());
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.exdent();
                throw throwable;
            }
            this.exdent();
            this.writeLineRaw("</GLOBAL>");
            this.writeLineRaw("<DOWNLOADS>");
            try {
                this.indent();
                object = globalManager.getDownloadManagers();
                DownloadManager[] downloadManagerArray = new DownloadManager[object.size()];
                object.toArray(downloadManagerArray);
                Arrays.sort(downloadManagerArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        DownloadManager downloadManager = (DownloadManager)object;
                        DownloadManager downloadManager2 = (DownloadManager)object2;
                        int n = downloadManager.getPosition();
                        int n2 = downloadManager2.getPosition();
                        if (downloadManager.isDownloadComplete(false)) {
                            n += 1000000;
                        }
                        if (downloadManager2.isDownloadComplete(false)) {
                            n2 += 1000000;
                        }
                        return n - n2;
                    }
                });
                for (int i = 0; i < downloadManagerArray.length; ++i) {
                    Object var24_30;
                    DownloadManager downloadManager = downloadManagerArray[i];
                    DownloadManagerStats downloadManagerStats = downloadManager.getStats();
                    this.writeLineRaw("<DOWNLOAD>");
                    try {
                        String string2;
                        PEPeerStats pEPeerStats;
                        Object object2;
                        List<PEPeer> list;
                        this.indent();
                        this.writeLineRaw("<TORRENT>");
                        TOTorrent tOTorrent = downloadManager.getTorrent();
                        try {
                            this.indent();
                            this.writeTag("NAME", downloadManager.getDisplayName());
                            this.writeTag("TORRENT_FILE", downloadManager.getTorrentFileName());
                            if (tOTorrent != null) {
                                this.writeTag("HASH", TorrentUtils.nicePrintTorrentHash(tOTorrent, true));
                                this.writeRawCookedTag("SIZE", tOTorrent.getSize());
                                this.writeTag("PIECE_LENGTH", tOTorrent.getPieceLength());
                                this.writeTag("PIECE_COUNT", tOTorrent.getNumberOfPieces());
                                this.writeTag("FILE_COUNT", tOTorrent.getFiles().length);
                                this.writeTag("COMMENT", downloadManager.getTorrentComment());
                                this.writeTag("CREATED_BY", downloadManager.getTorrentCreatedBy());
                                this.writeTag("CREATION_DATE", tOTorrent.getCreationDate());
                            }
                            list = null;
                        }
                        catch (Throwable throwable) {
                            list = null;
                            this.exdent();
                            throw throwable;
                        }
                        this.exdent();
                        this.writeLineRaw("</TORRENT>");
                        this.writeTag("DOWNLOAD_STATUS", DisplayFormatters.formatDownloadStatusDefaultLocale(downloadManager));
                        this.writeTag("DOWNLOAD_DIR", downloadManager.getSaveLocation().toString());
                        if (tOTorrent != null) {
                            if (tOTorrent.isSimpleTorrent()) {
                                this.writeTag("TARGET_FILE", downloadManager.getSaveLocation().toString());
                            } else {
                                this.writeTag("TARGET_DIR", downloadManager.getSaveLocation().toString());
                            }
                        }
                        this.writeTag("TRACKER_STATUS", downloadManager.getTrackerStatus());
                        this.writeTag("COMPLETED", downloadManagerStats.getCompleted());
                        this.writeTag("NON_DND_COMPLETED", downloadManager.isDownloadComplete(false));
                        this.writeRawCookedTag("DOWNLOADED", downloadManagerStats.getTotalDataBytesReceived());
                        this.writeRawCookedTag("UPLOADED", downloadManagerStats.getTotalDataBytesSent());
                        this.writeRawCookedTag("DISCARDED", downloadManagerStats.getDiscarded());
                        this.writeRawCookedAverageTag("DOWNLOAD_SPEED", downloadManagerStats.getDataReceiveRate());
                        this.writeRawCookedAverageTag("UPLOAD_SPEED", downloadManagerStats.getDataSendRate());
                        this.writeRawCookedAverageTag("TOTAL_SPEED", downloadManagerStats.getTotalAverage());
                        this.writeTag("ELAPSED", downloadManagerStats.getElapsedTime());
                        this.writeTag("ETA", DisplayFormatters.formatETA(downloadManagerStats.getETA()));
                        this.writeTag("HASH_FAILS", downloadManagerStats.getHashFailCount());
                        this.writeTag("SHARE_RATIO", downloadManagerStats.getShareRatio());
                        this.writeTag("TOTAL_SEEDS", downloadManager.getNbSeeds());
                        this.writeTag("TOTAL_LEECHERS", downloadManager.getNbPeers());
                        if (bl2) {
                            try {
                                this.writeLineRaw("<FILES>");
                                this.indent();
                                object2 = downloadManager.getDiskManagerFileInfo();
                                for (int j = 0; j < ((DiskManagerFileInfo[])object2).length; ++j) {
                                    Object object3 = object2[j];
                                    try {
                                        this.writeLineRaw("<FILE>");
                                        this.indent();
                                        this.writeTag("NAME", object3.getTorrentFile().getRelativePath());
                                        this.writeTag("DND", object3.isSkipped());
                                        this.writeRawCookedTag("SIZE", object3.getLength());
                                        this.writeRawCookedTag("DOWNLOADED", object3.getDownloaded());
                                        pEPeerStats = null;
                                    }
                                    catch (Throwable throwable) {
                                        pEPeerStats = null;
                                        this.exdent();
                                        this.writeLineRaw("</FILE>");
                                        throw throwable;
                                    }
                                    this.exdent();
                                    this.writeLineRaw("</FILE>");
                                }
                                string2 = null;
                            }
                            catch (Throwable throwable) {
                                string2 = null;
                                this.exdent();
                                this.writeLineRaw("</FILES>");
                                throw throwable;
                            }
                            this.exdent();
                            this.writeLineRaw("</FILES>");
                        }
                        if (bl) {
                            Object var22_29;
                            try {
                                this.writeLineRaw("<PEERS>");
                                this.indent();
                                object2 = downloadManager.getPeerManager();
                                if (object2 != null) {
                                    list = object2.getPeers();
                                    for (int j = 0; j < list.size(); ++j) {
                                        Object var20_28;
                                        PEPeer pEPeer = list.get(j);
                                        pEPeerStats = pEPeer.getStats();
                                        byte[] byArray = pEPeer.getId();
                                        if (byArray == null) continue;
                                        try {
                                            try {
                                                string2 = PeerClassifier.getPrintablePeerID(byArray);
                                                string2 = StatsWriterImpl.escapeXML(string2);
                                                String string3 = StatsWriterImpl.escapeXML(pEPeer.getClient());
                                                this.writeLineRaw("<PEER hex_id=\"" + ByteFormatter.encodeString(byArray) + "\" printable_id=\"" + string2 + "\" type=\"" + string3 + "\">");
                                                this.indent();
                                                this.writeTag("IP", pEPeer.getIp());
                                                this.writeTag("IS_SEED", pEPeer.isSeed());
                                                this.writeRawCookedTag("DOWNLOADED", pEPeerStats.getTotalDataBytesReceived());
                                                this.writeRawCookedTag("UPLOADED", pEPeerStats.getTotalDataBytesSent());
                                                this.writeRawCookedAverageTag("DOWNLOAD_SPEED", pEPeerStats.getDataReceiveRate());
                                                this.writeRawCookedAverageTag("UPLOAD_SPEED", pEPeerStats.getDataSendRate());
                                            }
                                            catch (Throwable throwable) {
                                                Debug.printStackTrace(throwable);
                                                var20_28 = null;
                                                this.exdent();
                                                this.writeLineRaw("</PEER>");
                                                continue;
                                            }
                                            var20_28 = null;
                                        }
                                        catch (Throwable throwable) {
                                            var20_28 = null;
                                            this.exdent();
                                            this.writeLineRaw("</PEER>");
                                            throw throwable;
                                        }
                                        this.exdent();
                                        this.writeLineRaw("</PEER>");
                                    }
                                }
                                var22_29 = null;
                            }
                            catch (Throwable throwable) {
                                var22_29 = null;
                                this.exdent();
                                this.writeLineRaw("</PEERS>");
                                throw throwable;
                            }
                            this.exdent();
                            this.writeLineRaw("</PEERS>");
                        }
                        var24_30 = null;
                    }
                    catch (Throwable throwable) {
                        var24_30 = null;
                        this.exdent();
                        throw throwable;
                    }
                    this.exdent();
                    this.writeLineRaw("</DOWNLOAD>");
                }
                Object var26_34 = null;
            }
            catch (Throwable throwable) {
                Object var26_35 = null;
                this.exdent();
                throw throwable;
            }
            this.exdent();
            this.writeLineRaw("</DOWNLOADS>");
            Object var28_37 = null;
        }
        catch (Throwable throwable) {
            Object var28_38 = null;
            this.exdent();
            throw throwable;
        }
        this.exdent();
        this.writeLineRaw("</STATS>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRawCookedTag(String string, long l) {
        this.writeLineRaw("<" + string + ">");
        try {
            this.indent();
            this.writeTag("TEXT", DisplayFormatters.formatByteCountToKiBEtc(l));
            this.writeTag("RAW", l);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.exdent();
            throw throwable;
        }
        this.exdent();
        this.writeLineRaw("</" + string + ">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRawCookedAverageTag(String string, long l) {
        this.writeLineRaw("<" + string + ">");
        try {
            this.indent();
            this.writeTag("TEXT", DisplayFormatters.formatByteCountToKiBEtcPerSec(l));
            this.writeTag("RAW", l);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.exdent();
            throw throwable;
        }
        this.exdent();
        this.writeLineRaw("</" + string + ">");
    }
}

