/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.Permission;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEKeyDetails;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerBC;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;

public class SESecurityManagerImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    protected static SESecurityManagerImpl singleton = new SESecurityManagerImpl();
    protected static String KEYSTORE_TYPE;
    protected String keystore_name;
    protected String truststore_name;
    protected List certificate_listeners = new ArrayList();
    protected CopyOnWriteList password_listeners = new CopyOnWriteList();
    private static ThreadLocal tls;
    protected Map password_handlers = new HashMap();
    protected Map certificate_handlers = new HashMap();
    protected boolean exit_vm_permitted = true;
    private AzureusSecurityManager my_sec_man;
    protected AEMonitor this_mon = new AEMonitor("SESecurityManager");
    private boolean initialized = false;
    private List stoppable_threads = new ArrayList();

    public static SESecurityManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        String[] stringArray = this;
        synchronized (this) {
            if (this.initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.keystore_name = FileUtil.getUserFile(".keystore").getAbsolutePath();
            this.truststore_name = FileUtil.getUserFile(".certs").getAbsolutePath();
            System.setProperty("javax.net.ssl.trustStore", this.truststore_name);
            System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
            this.installAuthenticator();
            stringArray = new String[]{"com.sun.net.ssl.internal.ssl.Provider", "org.metastatic.jessie.provider.Jessie"};
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Class.forName(stringArray[i]).newInstance();
                    string = stringArray[i];
                    break;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            if (string == null) {
                Debug.out("No SSL provider available");
            }
            try {
                SESecurityManagerBC.initialise();
            }
            catch (Throwable throwable) {
                Logger.log(new LogEvent(LOGID, 3, "Bouncy Castle not available"));
            }
            this.installSecurityManager();
            this.ensureStoreExists(this.keystore_name);
            this.ensureStoreExists(this.truststore_name);
            super.initEmptyTrustStore();
            return;
        }
    }

    private void initEmptyTrustStore() {
        try {
            File file;
            File file2 = new File(this.truststore_name);
            if (file2.exists() && file2.length() > 2048L) {
                return;
            }
            KeyStore keyStore = this.getTrustStore();
            if (keyStore.size() == 0 && (file = new File(new File(new File(System.getProperty("java.home"), "lib"), "security"), "cacerts")).exists()) {
                FileUtil.copyFile(file, file2);
                try {
                    this.getTrustStore();
                }
                catch (Throwable throwable) {
                    file2.delete();
                    this.ensureStoreExists(this.truststore_name);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getKeystoreName() {
        return this.keystore_name;
    }

    public String getKeystorePassword() {
        return "changeit";
    }

    protected void installSecurityManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread(Thread thread) {
        List list;
        List list2 = this.stoppable_threads;
        synchronized (list2) {
            this.stoppable_threads.add(Thread.currentThread());
        }
        try {
            thread.stop();
            Object var5_4 = null;
            list = this.stoppable_threads;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            List list3 = this.stoppable_threads;
            synchronized (list3) {
                this.stoppable_threads.remove(Thread.currentThread());
            }
            throw throwable;
        }
        synchronized (list) {
            this.stoppable_threads.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitVM(int n) {
        try {
            this.exit_vm_permitted = true;
            try {
                System.exit(n);
            }
            catch (Throwable throwable) {
            }
            Object var4_3 = null;
            this.exit_vm_permitted = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.exit_vm_permitted = false;
            throw throwable;
        }
    }

    public void installAuthenticator() {
        Authenticator.setDefault(new Authenticator(){
            protected AEMonitor auth_mon = new AEMonitor("SESecurityManager:auth");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected PasswordAuthentication getPasswordAuthentication() {
                try {
                    PasswordAuthentication passwordAuthentication;
                    this.auth_mon.enter();
                    PasswordAuthentication passwordAuthentication2 = passwordAuthentication = SESecurityManagerImpl.this.getAuthentication(this.getRequestingPrompt(), this.getRequestingProtocol(), this.getRequestingHost(), this.getRequestingPort());
                    Object var4_3 = null;
                    this.auth_mon.exit();
                    return passwordAuthentication2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.auth_mon.exit();
                    throw throwable;
                }
            }
        });
    }

    public PasswordAuthentication getAuthentication(String string, String string2, String string3, int n) {
        if (string2.toLowerCase().startsWith("socks")) {
            String string4 = COConfigurationManager.getStringParameter("Proxy.Username").trim();
            String string5 = COConfigurationManager.getStringParameter("Proxy.Password").trim();
            if (string4.equalsIgnoreCase("<none>")) {
                return new PasswordAuthentication("", "".toCharArray());
            }
            if (string4.length() == 0) {
                Logger.log(new LogAlert(false, 1, "Socks server is requesting authentication, please setup user and password in config"));
            }
            return new PasswordAuthentication(string4, string5.toCharArray());
        }
        try {
            URL uRL = new URL(string2 + "://" + string3 + ":" + n + "/");
            return this.getPasswordAuthentication(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.printStackTrace(malformedURLException);
            return null;
        }
    }

    protected boolean checkKeyStoreHasEntry() {
        File file = new File(this.keystore_name);
        if (!file.exists()) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
            return false;
        }
        try {
            KeyStore keyStore = this.loadKeyStore();
            Enumeration<String> enumeration = keyStore.aliases();
            if (!enumeration.hasMoreElements()) {
                Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
                return false;
            }
        }
        catch (Throwable throwable) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.corrupt"), new String[]{this.keystore_name});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean ensureStoreExists(String string) {
        boolean bl;
        try {
            try {
                this.this_mon.enter();
                KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
                if (!new File(string).exists()) {
                    block8: {
                        keyStore.load(null, null);
                        FileOutputStream fileOutputStream = null;
                        try {
                            fileOutputStream = new FileOutputStream(string);
                            keyStore.store(fileOutputStream, "changeit".toCharArray());
                            Object var5_7 = null;
                            if (fileOutputStream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            if (fileOutputStream == null) throw throwable;
                            fileOutputStream.close();
                            throw throwable;
                        }
                        fileOutputStream.close();
                    }
                    boolean bl2 = true;
                    Object var7_11 = null;
                    this.this_mon.exit();
                    return bl2;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                boolean bl3 = false;
                Object var7_13 = null;
                this.this_mon.exit();
                return bl3;
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var7_12 = null;
        this.this_mon.exit();
        return bl;
    }

    public KeyStore getKeyStore() throws Exception {
        return this.loadKeyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeyStore getTrustStore() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        if (!new File(this.truststore_name).exists()) {
            keyStore.load(null, null);
            return keyStore;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.truststore_name);
            keyStore.load(fileInputStream, "changeit".toCharArray());
            Object var4_3 = null;
            if (fileInputStream == null) return keyStore;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return keyStore;
    }

    protected KeyStore loadKeyStore() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        return this.loadKeyStore(keyManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected KeyStore loadKeyStore(KeyManagerFactory keyManagerFactory) throws Exception {
        KeyStore keyStore;
        block5: {
            keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            if (!new File(this.keystore_name).exists()) {
                keyStore.load(null, null);
            } else {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(this.keystore_name);
                    keyStore.load(fileInputStream, "changeit".toCharArray());
                    Object var5_4 = null;
                    if (fileInputStream == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
            }
        }
        keyManagerFactory.init(keyStore, "changeit".toCharArray());
        return keyStore;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() throws Exception {
        if (!this.checkKeyStoreHasEntry()) {
            return null;
        }
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.loadKeyStore(keyManagerFactory);
        sSLContext.init(keyManagerFactory.getKeyManagers(), null, RandomUtils.SECURE_RANDOM);
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        return sSLServerSocketFactory;
    }

    public SEKeyDetails getKeyDetails(String string) throws Exception {
        KeyStore keyStore = this.loadKeyStore();
        final Key key = keyStore.getKey(string, "changeit".toCharArray());
        if (key == null) {
            return null;
        }
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        final X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            if (!(certificateArray[i] instanceof X509Certificate)) {
                throw new Exception("Certificate chain must be comprised of X509Certificate entries");
            }
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        return new SEKeyDetails(){

            public Key getKey() {
                return key;
            }

            public X509Certificate[] getCertificateChain() {
                return x509CertificateArray;
            }
        };
    }

    public Certificate createSelfSignedCertificate(String string, String string2, int n) throws Exception {
        return SESecurityManagerBC.createSelfSignedCertificate(this, string, string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLSocketFactory sSLSocketFactory;
            this.this_mon.enter();
            KeyStore keyStore = this.getTrustStore();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
            SSLSocketFactory sSLSocketFactory2 = sSLSocketFactory = sSLContext.getSocketFactory();
            Object var7_8 = null;
            this.this_mon.exit();
            return sSLSocketFactory2;
        }
        catch (Throwable throwable) {
            try {
                Debug.printStackTrace(throwable);
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var7_9 = null;
                this.this_mon.exit();
                return sSLSocketFactory;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                this.this_mon.exit();
                throw throwable2;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public SSLSocketFactory installServerCertificates(URL var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public SSLSocketFactory installServerCertificates(String string, String string2, int n) {
        Object object;
        SSLContext sSLContext;
        Socket socket;
        block17: {
            try {
                Certificate[] certificateArray;
                block15: {
                    SSLSocketFactory sSLSocketFactory;
                    block16: {
                        this.this_mon.enter();
                        socket = null;
                        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                            public X509Certificate[] getAcceptedIssuers() {
                                return null;
                            }

                            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                            }

                            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                            }
                        }};
                        sSLContext = SSLContext.getInstance("SSL");
                        sSLContext.init(null, trustManagerArray, RandomUtils.SECURE_RANDOM);
                        SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                        socket = (SSLSocket)sSLSocketFactory2.createSocket(string2, n);
                        ((SSLSocket)socket).startHandshake();
                        certificateArray = ((SSLSocket)socket).getSession().getPeerCertificates();
                        if (certificateArray.length != 0) break block15;
                        sSLSocketFactory = null;
                        Object var13_12 = null;
                        if (socket == null) break block16;
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                    Object var16_20 = null;
                    this.this_mon.exit();
                    return sSLSocketFactory;
                }
                Certificate certificate = certificateArray[0];
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                } else {
                    object = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(certificate.getEncoded()));
                }
                object = this.addCertToTrustStore(string, certificate, false);
                Object var13_13 = null;
                if (socket == null) break block17;
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        Object var16_21 = null;
        this.this_mon.exit();
        {
            return object;
            catch (Throwable throwable) {
                block18: {
                    try {
                        Debug.printStackTrace(throwable);
                        sSLContext = null;
                        Object var13_14 = null;
                        if (socket == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        Object var13_15 = null;
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable3) {
                                Debug.printStackTrace(throwable3);
                            }
                        }
                        throw throwable2;
                    }
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable4) {
                        Debug.printStackTrace(throwable4);
                    }
                }
                Object var16_22 = null;
                this.this_mon.exit();
                return sSLContext;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addCertToKeyStore(String string, Key key, Certificate[] certificateArray) throws Exception {
        try {
            block8: {
                this.this_mon.enter();
                KeyStore keyStore = this.loadKeyStore();
                if (keyStore.containsAlias(string)) {
                    keyStore.deleteEntry(string);
                }
                keyStore.setKeyEntry(string, key, "changeit".toCharArray(), certificateArray);
                FileOutputStream fileOutputStream = null;
                try {
                    try {
                        fileOutputStream = new FileOutputStream(this.keystore_name);
                        keyStore.store(fileOutputStream, "changeit".toCharArray());
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        Object var8_7 = null;
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block8;
                    }
                    Object var8_6 = null;
                    if (fileOutputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (fileOutputStream == null) throw throwable;
                    fileOutputStream.close();
                    throw throwable;
                }
                fileOutputStream.close();
            }
            Object var10_11 = null;
            this.this_mon.exit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SSLSocketFactory addCertToTrustStore(String string, Certificate certificate, boolean bl) throws Exception {
        try {
            SSLSocketFactory sSLSocketFactory;
            Object object;
            KeyStore keyStore;
            block7: {
                this.this_mon.enter();
                keyStore = this.getTrustStore();
                if (certificate != null) {
                    if (keyStore.containsAlias(string)) {
                        keyStore.deleteEntry(string);
                    }
                    keyStore.setCertificateEntry(string, certificate);
                    object = null;
                    try {
                        object = new FileOutputStream(this.truststore_name);
                        keyStore.store((OutputStream)object, "changeit".toCharArray());
                        sSLSocketFactory = null;
                        if (object == null) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (object == null) throw throwable;
                        ((FileOutputStream)object).close();
                        throw throwable;
                    }
                    ((FileOutputStream)object).close();
                }
            }
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, ((TrustManagerFactory)object).getTrustManagers(), null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            if (bl) {
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            }
            SSLSocketFactory sSLSocketFactory2 = sSLSocketFactory;
            Object var10_11 = null;
            this.this_mon.exit();
            return sSLSocketFactory2;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public PasswordAuthentication getPasswordAuthentication(String string, URL uRL) {
        SEPasswordListener sEPasswordListener = (SEPasswordListener)tls.get();
        if (sEPasswordListener != null) {
            return sEPasswordListener.getAuthentication(string, uRL);
        }
        Object[] objectArray = (Object[])this.password_handlers.get(uRL.toString());
        if (objectArray != null) {
            try {
                return ((SEPasswordListener)objectArray[0]).getAuthentication(string, (URL)objectArray[1]);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        Iterator iterator = this.password_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                PasswordAuthentication passwordAuthentication = ((SEPasswordListener)iterator.next()).getAuthentication(string, uRL);
                if (passwordAuthentication == null) continue;
                return passwordAuthentication;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    public void setPasswordAuthenticationOutcome(String string, URL uRL, boolean bl) {
        SEPasswordListener sEPasswordListener = (SEPasswordListener)tls.get();
        if (sEPasswordListener != null) {
            sEPasswordListener.setAuthenticationOutcome(string, uRL, bl);
        }
        Iterator iterator = this.password_listeners.iterator();
        while (iterator.hasNext()) {
            ((SEPasswordListener)iterator.next()).setAuthenticationOutcome(string, uRL, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPasswordListener(SEPasswordListener sEPasswordListener) {
        try {
            this.this_mon.enter();
            this.password_listeners.add(sEPasswordListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePasswordListener(SEPasswordListener sEPasswordListener) {
        try {
            this.this_mon.enter();
            this.password_listeners.remove(sEPasswordListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void clearPasswords() {
        SEPasswordListener sEPasswordListener = (SEPasswordListener)tls.get();
        if (sEPasswordListener != null) {
            sEPasswordListener.clearPasswords();
        }
        Iterator iterator = this.password_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((SEPasswordListener)iterator.next()).clearPasswords();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void setThreadPasswordHandler(SEPasswordListener sEPasswordListener) {
        tls.set(sEPasswordListener);
    }

    public void unsetThreadPasswordHandler() {
        tls.set(null);
    }

    public void setPasswordHandler(URL uRL, SEPasswordListener sEPasswordListener) {
        String string = uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort() + "/";
        if (sEPasswordListener == null) {
            this.password_handlers.remove(string);
        } else {
            this.password_handlers.put(string, new Object[]{sEPasswordListener, uRL});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificateListener(SECertificateListener sECertificateListener) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.add(sECertificateListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void setCertificateHandler(URL uRL, SECertificateListener sECertificateListener) {
        String string = uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort() + "/";
        if (sECertificateListener == null) {
            this.certificate_handlers.remove(string);
        } else {
            this.certificate_handlers.put(string, new Object[]{sECertificateListener, uRL});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificateListener(SECertificateListener sECertificateListener) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.remove(sECertificateListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public Class[] getClassContext() {
        if (this.my_sec_man == null) {
            return new Class[0];
        }
        return this.my_sec_man.getClassContext();
    }

    public static void main(String[] stringArray) {
        SESecurityManagerImpl sESecurityManagerImpl = SESecurityManagerImpl.getSingleton();
        sESecurityManagerImpl.initialise();
        try {
            sESecurityManagerImpl.createSelfSignedCertificate("SomeAlias", "CN=fred,OU=wap,O=wip,L=here,ST=there,C=GB", 1000);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    static {
        String[] stringArray = new String[]{"JKS", "GKR"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                KeyStore.getInstance(stringArray[i]);
                KEYSTORE_TYPE = stringArray[i];
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        if (KEYSTORE_TYPE == null) {
            KEYSTORE_TYPE = "JKS";
        }
        Logger.log(new LogEvent(LOGID, "Keystore type is " + KEYSTORE_TYPE));
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }

    private final class AzureusSecurityManager
    extends SecurityManager {
        private SecurityManager old_sec_man;

        private AzureusSecurityManager(SecurityManager securityManager) {
            this.old_sec_man = securityManager;
        }

        public void checkAccept(String string, int n) {
        }

        public void checkRead(String string) {
        }

        public void checkWrite(String string) {
        }

        public void checkConnect(String string, int n) {
        }

        public void checkExit(int n) {
            String string;
            if (this.old_sec_man != null) {
                this.old_sec_man.checkExit(n);
            }
            if (!SESecurityManagerImpl.this.exit_vm_permitted && (string = System.getProperty("azureus.security.manager.permitexit", "0")).equals("0")) {
                throw new SecurityException("VM exit operation prohibited");
            }
        }

        public void checkPermission(Permission permission) {
            this.checkPermission(permission, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkPermission(Permission permission, Object object) {
            if (permission instanceof RuntimePermission) {
                String string = permission.getName();
                if (string.equals("stopThread")) {
                    List list = SESecurityManagerImpl.this.stoppable_threads;
                    synchronized (list) {
                        if (SESecurityManagerImpl.this.stoppable_threads.contains(Thread.currentThread())) {
                            return;
                        }
                    }
                    throw new SecurityException("Thread.stop operation prohibited");
                }
                if (string.equals("setSecurityManager")) {
                    throw new SecurityException("Permission Denied");
                }
            }
            if (this.old_sec_man != null) {
                if (object == null) {
                    this.old_sec_man.checkPermission(permission);
                } else {
                    this.old_sec_man.checkPermission(permission, object);
                }
            }
        }

        public Class[] getClassContext() {
            Class<?>[] classArray = super.getClassContext();
            if (classArray.length <= 3) {
                return new Class[0];
            }
            Class[] classArray2 = new Class[classArray.length - 3];
            System.arraycopy(classArray, 3, classArray2, 0, classArray2.length);
            return classArray2;
        }
    }
}

