/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.util;

import java.util.HashSet;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.util.Constants;

public class PeerUtils {
    private static final String CONFIG_MAX_CONN_PER_TORRENT = "Max.Peer.Connections.Per.Torrent";
    private static final String CONFIG_MAX_CONN_TOTAL = "Max.Peer.Connections.Total";
    public static int MAX_CONNECTIONS_PER_TORRENT;
    public static int MAX_CONNECTIONS_TOTAL;
    private static Set ignore_peer_ports;
    static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static int numNewConnectionsAllowed(PeerIdentityDataID peerIdentityDataID, int n) {
        int n2;
        int n3;
        int n4 = PeerIdentityManager.getIdentityCount(peerIdentityDataID);
        int n5 = PeerIdentityManager.getTotalIdentityCount();
        int n6 = n;
        int n7 = -1;
        if (n6 != 0) {
            n3 = n6 - n4;
            if (n3 < 0) {
                n3 = 0;
            }
            n7 = n3;
        }
        n3 = -1;
        if (MAX_CONNECTIONS_TOTAL != 0) {
            n2 = MAX_CONNECTIONS_TOTAL - n5;
            if (n2 < 0) {
                n2 = 0;
            }
            n3 = n2;
        }
        n2 = -1;
        if (n7 > -1 && n3 > -1) {
            n2 = Math.min(n7, n3);
        } else if (n7 == -1 || n3 == -1) {
            n2 = Math.max(n7, n3);
        }
        return n2;
    }

    private static void readIgnorePeerPorts() {
        String[] stringArray;
        String string = COConfigurationManager.getStringParameter("Ignore.peer.ports").trim();
        ignore_peer_ports.clear();
        if (string.length() > 0 && (stringArray = string.split("\\;")) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = string2.indexOf(45);
                if (n > 0 && n < string2.length() - 1) {
                    try {
                        int n2 = Integer.parseInt(string2.substring(0, n).trim());
                        int n3 = Integer.parseInt(string2.substring(n + 1).trim());
                        for (int j = n2; j <= n3; ++j) {
                            ignore_peer_ports.add("" + j);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                ignore_peer_ports.add(string2.trim());
            }
        }
    }

    public static boolean ignorePeerPort(int n) {
        return ignore_peer_ports.contains("" + n);
    }

    public static byte[] createPeerID() {
        int n;
        byte[] byArray = new byte[20];
        byte[] byArray2 = Constants.VERSION_ID;
        for (n = 0; n < 8; ++n) {
            byArray[n] = byArray2[n];
        }
        for (n = 8; n < 20; ++n) {
            int n2 = (int)(Math.random() * (double)chars.length());
            byArray[n] = (byte)chars.charAt(n2);
        }
        return byArray;
    }

    public static byte[] createWebSeedPeerID() {
        byte[] byArray = new byte[20];
        byArray[0] = 45;
        byArray[1] = 87;
        byArray[2] = 83;
        for (int i = 3; i < 20; ++i) {
            int n = (int)(Math.random() * (double)chars.length());
            byArray[i] = (byte)chars.charAt(n);
        }
        return byArray;
    }

    static {
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_PER_TORRENT, new ParameterListener(){

            public void parameterChanged(String string) {
                MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_PER_TORRENT);
            }
        });
        MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_PER_TORRENT);
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_TOTAL, new ParameterListener(){

            public void parameterChanged(String string) {
                MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_TOTAL);
            }
        });
        MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_TOTAL);
        ignore_peer_ports = new HashSet();
        COConfigurationManager.addParameterListener("Ignore.peer.ports", new ParameterListener(){

            public void parameterChanged(String string) {
                PeerUtils.readIgnorePeerPorts();
            }
        });
        PeerUtils.readIgnorePeerPorts();
    }
}

