/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Ignore;
import org.gudy.azureus2.core3.util.SystemTime;

public class SuperSeedPiece {
    private int pieceNumber;
    private int level;
    private long timeFirstDistributed;
    private PEPeer firstReceiver;
    private int timeToReachAnotherPeer;
    private static AEMonitor class_mon = new AEMonitor("SuperSeedPiece:class");

    public SuperSeedPiece(PEPeerControl pEPeerControl, int n) {
        Ignore.ignore(pEPeerControl);
        this.pieceNumber = n;
        this.level = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerHasPiece(PEPeer pEPeer) {
        try {
            class_mon.enter();
            if (this.level < 2) {
                this.firstReceiver = pEPeer;
                this.timeFirstDistributed = SystemTime.getCurrentTime();
            } else if (pEPeer != null && this.firstReceiver != null) {
                this.timeToReachAnotherPeer = (int)(SystemTime.getCurrentTime() - this.timeFirstDistributed);
                this.firstReceiver.setUploadHint(this.timeToReachAnotherPeer);
            }
            this.level = 2;
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public int getLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pieceRevealedToPeer() {
        try {
            class_mon.enter();
            this.level = 1;
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public void peerLeft() {
        if (this.level == 1) {
            this.level = 0;
        }
    }

    public void updateTime() {
        if (this.level < 2) {
            return;
        }
        if (this.timeToReachAnotherPeer > 0) {
            return;
        }
        if (this.firstReceiver == null) {
            return;
        }
        int n = (int)(SystemTime.getCurrentTime() - this.timeFirstDistributed);
        if (n > this.firstReceiver.getUploadHint()) {
            this.firstReceiver.setUploadHint(n);
        }
    }
}

