/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.natchecker;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatCheckerServer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;

public class NatChecker {
    private static final LogIDs LOGID = LogIDs.NET;
    public static final int NAT_OK = 1;
    public static final int NAT_KO = 2;
    public static final int NAT_UNABLE = 3;
    private int result;
    private String additional_info = "";
    private InetAddress ip_address;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NatChecker(AzureusCore azureusCore, InetAddress inetAddress, int n, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        NatCheckerServer natCheckerServer;
        String string = "azureus_rand_" + String.valueOf((int)(Math.random() * 100000.0));
        if (n < 0 || n > 65535 || n == 6880) {
            this.result = 3;
            this.additional_info = "Invalid port";
            return;
        }
        try {
            natCheckerServer = new NatCheckerServer(inetAddress, n, string, bl);
        }
        catch (Throwable throwable) {
            this.result = 3;
            this.additional_info = "Can't initialise server: " + Debug.getNestedExceptionMessage(throwable);
            return;
        }
        PluginInterface pluginInterface = azureusCore.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        UPnPMapping uPnPMapping = null;
        String string2 = null;
        if (pluginInterface != null) {
            object4 = (UPnPPlugin)pluginInterface.getPlugin();
            object3 = ((UPnPPlugin)object4).getMapping(true, n);
            if (object3 == null) {
                object3 = ((UPnPPlugin)object4).addMapping("NAT Tester", true, n, true);
                uPnPMapping = object3;
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            if (((UPnPPluginService[])(object2 = ((UPnPPlugin)object4).getServices())).length > 0) {
                string2 = "";
                for (int i = 0; i < ((UPnPPluginService[])object2).length; ++i) {
                    object = object2[i];
                    string2 = string2 + (i == 0 ? "" : ",") + ((UPnPPluginService)object).getInfo();
                }
            }
        }
        try {
            try {
                Object object5;
                int n2;
                natCheckerServer.start();
                object4 = "http://nettest.vuze.com/" + (bl ? "httptest" : "nattest") + "?port=" + String.valueOf(n) + "&check=" + string;
                if (string2 != null) {
                    object4 = (String)object4 + "&upnp=" + URLEncoder.encode(string2, "UTF8");
                }
                object3 = NetworkAdmin.getSingleton().getCurrentASN();
                object2 = object3.getAS();
                String string3 = object3.getASName();
                if (((String)object2).length() > 0) {
                    object4 = (String)object4 + "&as=" + URLEncoder.encode((String)object2, "UTF8");
                    object4 = (String)object4 + "&asn=" + URLEncoder.encode(string3, "UTF8");
                }
                object4 = (String)object4 + "&locale=" + MessageText.getCurrentLocale().toString();
                object = TRTrackerUtils.getPublicIPOverride();
                if (object != null) {
                    object4 = (String)object4 + "&ip=" + (String)object;
                }
                URL uRL = new URL((String)object4);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                InputStream inputStream = httpURLConnection.getInputStream();
                byte[] byArray = new byte[1024];
                int n3 = -1;
                while ((n2 = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                    if (n3 == -1 && byteArrayOutputStream.size() >= 4) {
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        object5 = ByteBuffer.wrap(byArray2);
                        n3 = ((ByteBuffer)object5).getInt();
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        if (byArray2.length > 4) {
                            byteArrayOutputStream.write(byArray2, 4, byArray2.length - 4);
                        }
                    }
                    if (n3 == -1 || byteArrayOutputStream.size() != n3) continue;
                    break;
                }
                Map map = BDecoder.decode(byteArrayOutputStream.toByteArray());
                int n4 = ((Long)map.get("result")).intValue();
                switch (n4) {
                    case 0: {
                        object5 = (byte[])map.get("reason");
                        if (object5 != null) {
                            Logger.log(new LogEvent(LOGID, 3, "NAT CHECK FAILED: " + new String((byte[])object5)));
                        }
                        this.result = 2;
                        this.additional_info = object5 == null ? "Unknown" : new String((byte[])object5, "UTF8");
                        break;
                    }
                    case 1: {
                        this.result = 1;
                        object5 = (byte[])map.get("reply");
                        if (object5 == null) break;
                        this.additional_info = new String((byte[])object5, "UTF8");
                        break;
                    }
                    default: {
                        this.result = 3;
                        this.additional_info = "Invalid response";
                    }
                }
                object5 = (byte[])map.get("ip_address");
                if (object5 != null) {
                    try {
                        this.ip_address = InetAddress.getByAddress((byte[])object5);
                    }
                    catch (Throwable throwable) {
                    }
                }
                Object var26_31 = null;
                natCheckerServer.stopIt();
                if (uPnPMapping != null) {
                    uPnPMapping.destroy();
                }
            }
            catch (Exception exception) {
                this.result = 3;
                this.additional_info = "Error: " + Debug.getNestedExceptionMessage(exception);
                Object var26_32 = null;
                natCheckerServer.stopIt();
                if (uPnPMapping != null) {
                    uPnPMapping.destroy();
                }
            }
        }
        catch (Throwable throwable) {
            Object var26_33 = null;
            natCheckerServer.stopIt();
            if (uPnPMapping != null) {
                uPnPMapping.destroy();
            }
            throw throwable;
        }
    }

    public int getResult() {
        return this.result;
    }

    public InetAddress getExternalAddress() {
        return this.ip_address;
    }

    public String getAdditionalInfo() {
        return this.additional_info;
    }
}

