/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerReadRequestImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.SystemTime;

public class DMReaderImpl
implements DMReader {
    private static final LogIDs LOGID = LogIDs.DISK;
    private DiskManagerHelper disk_manager;
    private DiskAccessController disk_access;
    private int async_reads;
    private Set read_requests = new HashSet();
    private AESemaphore async_read_sem = new AESemaphore("DMReader:asyncReads");
    private boolean started;
    private boolean stopped;
    private long total_read_ops;
    private long total_read_bytes;
    protected AEMonitor this_mon = new AEMonitor("DMReader");

    public DMReaderImpl(DiskManagerHelper diskManagerHelper) {
        this.disk_manager = diskManagerHelper;
        this.disk_access = this.disk_manager.getDiskAccessController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("can't start twice");
            }
            if (this.stopped) {
                throw new RuntimeException("already been stopped");
            }
            this.started = true;
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int n;
        try {
            block11: {
                block10: {
                    this.this_mon.enter();
                    if (this.stopped) break block10;
                    if (this.started) break block11;
                }
                Object var3_1 = null;
                this.this_mon.exit();
                return;
            }
            this.stopped = true;
            n = this.async_reads;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var3_2 = null;
        this.this_mon.exit();
        long l = SystemTime.getCurrentTime();
        for (int i = 0; i < n; ++i) {
            long l2 = SystemTime.getCurrentTime();
            if (l2 < l) {
                l = l2;
            } else if (l2 - l > 1000L) {
                l = l2;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for reads to complete - " + (n - i) + " remaining"));
                }
            }
            this.async_read_sem.reserve();
        }
    }

    public DiskManagerReadRequest createReadRequest(int n, int n2, int n3) {
        return new DiskManagerReadRequestImpl(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasOutstandingReadRequestForPiece(int n) {
        boolean bl;
        try {
            this.this_mon.enter();
            Iterator iterator = this.read_requests.iterator();
            while (iterator.hasNext()) {
                DiskManagerReadRequest diskManagerReadRequest = (DiskManagerReadRequest)((Object[])iterator.next())[0];
                if (diskManagerReadRequest.getPieceNumber() != n) continue;
                boolean bl2 = true;
                Object var6_6 = null;
                this.this_mon.exit();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var6_7 = null;
        this.this_mon.exit();
        return bl;
    }

    public long[] getStats() {
        return new long[]{this.total_read_ops, this.total_read_bytes};
    }

    public DirectByteBuffer readBlock(int n, int n2, int n3) {
        DiskManagerReadRequest diskManagerReadRequest = this.createReadRequest(n, n2, n3);
        final AESemaphore aESemaphore = new AESemaphore("DMReader:readBlock");
        final DirectByteBuffer[] directByteBufferArray = new DirectByteBuffer[]{null};
        this.readBlock(diskManagerReadRequest, new DiskManagerReadRequestListener(){

            public void readCompleted(DiskManagerReadRequest diskManagerReadRequest, DirectByteBuffer directByteBuffer) {
                directByteBufferArray[0] = directByteBuffer;
                aESemaphore.release();
            }

            public void readFailed(DiskManagerReadRequest diskManagerReadRequest, Throwable throwable) {
                aESemaphore.release();
            }

            public int getPriority() {
                return -1;
            }

            public void requestExecuted(long l) {
            }
        });
        aESemaphore.reserve();
        return directByteBufferArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlock(DiskManagerReadRequest diskManagerReadRequest, final DiskManagerReadRequestListener diskManagerReadRequestListener) {
        diskManagerReadRequest.requestStarts();
        final DiskManagerReadRequestListener diskManagerReadRequestListener2 = new DiskManagerReadRequestListener(){

            public void readCompleted(DiskManagerReadRequest diskManagerReadRequest, DirectByteBuffer directByteBuffer) {
                diskManagerReadRequest.requestEnds(true);
                diskManagerReadRequestListener.readCompleted(diskManagerReadRequest, directByteBuffer);
            }

            public void readFailed(DiskManagerReadRequest diskManagerReadRequest, Throwable throwable) {
                diskManagerReadRequest.requestEnds(false);
                diskManagerReadRequestListener.readFailed(diskManagerReadRequest, throwable);
            }

            public int getPriority() {
                return diskManagerReadRequestListener.getPriority();
            }

            public void requestExecuted(long l) {
                diskManagerReadRequestListener.requestExecuted(l);
            }
        };
        DirectByteBuffer directByteBuffer = null;
        try {
            Object[] objectArray;
            int n;
            int n2 = diskManagerReadRequest.getLength();
            directByteBuffer = DirectByteBufferPool.getBuffer((byte)6, n2);
            if (directByteBuffer == null) {
                Debug.out("DiskManager::readBlock:: ByteBufferPool returned null buffer");
                diskManagerReadRequestListener2.readFailed(diskManagerReadRequest, new Exception("Out of memory"));
                return;
            }
            int n3 = diskManagerReadRequest.getPieceNumber();
            int n4 = diskManagerReadRequest.getOffset();
            DMPieceList dMPieceList = this.disk_manager.getPieceList(n3);
            if (dMPieceList.size() == 0) {
                Debug.out("no pieceList entries for " + n3);
                diskManagerReadRequestListener2.readCompleted(diskManagerReadRequest, directByteBuffer);
                return;
            }
            long l = 0L;
            long l2 = dMPieceList.get(0).getOffset();
            for (n = 0; n < dMPieceList.size() && dMPieceList.getCumulativeLengthToPiece(n) < n4; ++n) {
                l = dMPieceList.getCumulativeLengthToPiece(n);
                l2 = 0L;
            }
            l2 += (long)n4 - l;
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            int n5 = 0;
            while (n5 < n2 && n < dMPieceList.size()) {
                objectArray = dMPieceList.get(n);
                int n6 = objectArray.getLength() - (int)(l2 - objectArray.getOffset());
                int n7 = n5 + n6;
                n7 = Math.min(n2, n7);
                arrayList.add(new Object[]{objectArray.getFile().getCacheFile(), new Long(l2), new Integer(n7)});
                n5 = n7;
                ++n;
                l2 = 0L;
            }
            if (arrayList.size() == 0) {
                Debug.out("no chunk reads for " + n3);
                diskManagerReadRequestListener2.readCompleted(diskManagerReadRequest, directByteBuffer);
                return;
            }
            objectArray = new Object[]{diskManagerReadRequest};
            DiskManagerReadRequestListener diskManagerReadRequestListener3 = new DiskManagerReadRequestListener(){

                public void readCompleted(DiskManagerReadRequest diskManagerReadRequest, DirectByteBuffer directByteBuffer) {
                    this.complete();
                    diskManagerReadRequestListener2.readCompleted(diskManagerReadRequest, directByteBuffer);
                }

                public void readFailed(DiskManagerReadRequest diskManagerReadRequest, Throwable throwable) {
                    this.complete();
                    diskManagerReadRequestListener2.readFailed(diskManagerReadRequest, throwable);
                }

                public int getPriority() {
                    return diskManagerReadRequestListener.getPriority();
                }

                public void requestExecuted(long l) {
                    diskManagerReadRequestListener.requestExecuted(l);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void complete() {
                    try {
                        DMReaderImpl.this.this_mon.enter();
                        DMReaderImpl.this.async_reads--;
                        if (!DMReaderImpl.this.read_requests.remove(objectArray)) {
                            Debug.out("request not found");
                        }
                        if (DMReaderImpl.this.stopped) {
                            DMReaderImpl.this.async_read_sem.release();
                        }
                        Object var2_1 = null;
                        DMReaderImpl.this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        DMReaderImpl.this.this_mon.exit();
                        throw throwable;
                    }
                }
            };
            try {
                this.this_mon.enter();
                if (this.stopped) {
                    directByteBuffer.returnToPool();
                    diskManagerReadRequestListener2.readFailed(diskManagerReadRequest, new Exception("Disk reader has been stopped"));
                    Object var20_19 = null;
                    this.this_mon.exit();
                    return;
                }
                ++this.async_reads;
                this.read_requests.add(objectArray);
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                this.this_mon.exit();
                throw throwable;
            }
            Object var20_20 = null;
            this.this_mon.exit();
            new requestDispatcher(diskManagerReadRequest, diskManagerReadRequestListener3, directByteBuffer, arrayList);
        }
        catch (Throwable throwable) {
            if (directByteBuffer != null) {
                directByteBuffer.returnToPool();
            }
            this.disk_manager.setFailed("Disk read error - " + Debug.getNestedExceptionMessage(throwable));
            Debug.printStackTrace(throwable);
            diskManagerReadRequestListener2.readFailed(diskManagerReadRequest, throwable);
        }
    }

    protected class requestDispatcher
    implements DiskAccessRequestListener {
        private DiskManagerReadRequest dm_request;
        private DiskManagerReadRequestListener listener;
        private DirectByteBuffer buffer;
        private List chunks;
        private int buffer_length;
        private int chunk_index;
        private int chunk_limit;

        protected requestDispatcher(DiskManagerReadRequest diskManagerReadRequest, DiskManagerReadRequestListener diskManagerReadRequestListener, DirectByteBuffer directByteBuffer, List list) {
            this.dm_request = diskManagerReadRequest;
            this.listener = diskManagerReadRequestListener;
            this.buffer = directByteBuffer;
            this.chunks = list;
            this.buffer_length = this.buffer.limit((byte)7);
            this.dispatch();
        }

        protected void dispatch() {
            try {
                if (this.chunk_index == this.chunks.size()) {
                    this.buffer.limit((byte)7, this.buffer_length);
                    this.buffer.position((byte)7, 0);
                    this.listener.readCompleted(this.dm_request, this.buffer);
                } else if (this.chunk_index == 1 && this.chunks.size() > 32) {
                    for (int i = 1; i < this.chunks.size(); ++i) {
                        final AESemaphore aESemaphore = new AESemaphore("DMR:dispatch:asyncReq");
                        final Throwable[] throwableArray = new Throwable[]{null};
                        this.doRequest(new DiskAccessRequestListener(){

                            public void requestComplete(DiskAccessRequest diskAccessRequest) {
                                aESemaphore.release();
                            }

                            public void requestCancelled(DiskAccessRequest diskAccessRequest) {
                                Debug.out("shouldn't get here");
                            }

                            public void requestFailed(DiskAccessRequest diskAccessRequest, Throwable throwable) {
                                throwableArray[0] = throwable;
                                aESemaphore.release();
                            }

                            public int getPriority() {
                                return requestDispatcher.this.listener.getPriority();
                            }

                            public void requestExecuted(long l) {
                                if (l > 0L) {
                                    DMReaderImpl.this.total_read_bytes += l;
                                    DMReaderImpl.this.total_read_ops++;
                                }
                                requestDispatcher.this.listener.requestExecuted(l);
                            }
                        });
                        aESemaphore.reserve();
                        if (throwableArray[0] == null) continue;
                        throw throwableArray[0];
                    }
                    this.buffer.limit((byte)7, this.buffer_length);
                    this.buffer.position((byte)7, 0);
                    this.listener.readCompleted(this.dm_request, this.buffer);
                } else {
                    this.doRequest(this);
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }

        protected void doRequest(DiskAccessRequestListener diskAccessRequestListener) {
            short s;
            Object[] objectArray = (Object[])this.chunks.get(this.chunk_index++);
            if (this.chunk_index > 0) {
                this.buffer.position((byte)7, this.chunk_limit);
            }
            this.chunk_limit = (Integer)objectArray[2];
            this.buffer.limit((byte)7, this.chunk_limit);
            short s2 = s = this.dm_request.getUseCache() ? (short)1 : 0;
            if (this.dm_request.getFlush()) {
                s = (short)(s | 2);
            }
            DMReaderImpl.this.disk_access.queueReadRequest((CacheFile)objectArray[0], (Long)objectArray[1], this.buffer, s, diskAccessRequestListener);
        }

        public void requestComplete(DiskAccessRequest diskAccessRequest) {
            this.dispatch();
        }

        public void requestCancelled(DiskAccessRequest diskAccessRequest) {
            Debug.out("shouldn't get here");
        }

        public void requestFailed(DiskAccessRequest diskAccessRequest, Throwable throwable) {
            this.failed(throwable);
        }

        public int getPriority() {
            return this.listener.getPriority();
        }

        public void requestExecuted(long l) {
            if (l > 0L) {
                DMReaderImpl.this.total_read_bytes += l;
                DMReaderImpl.this.total_read_ops++;
            }
            this.listener.requestExecuted(l);
        }

        protected void failed(Throwable throwable) {
            this.buffer.returnToPool();
            DMReaderImpl.this.disk_manager.setFailed("Disk read error - " + Debug.getNestedExceptionMessage(throwable));
            Debug.printStackTrace(throwable);
            this.listener.readFailed(this.dm_request, throwable);
        }
    }
}

