/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.PriorityParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;

public final class TransferSpeedValidator {
    public static final String AUTO_UPLOAD_ENABLED_CONFIGKEY = "Auto Upload Speed Enabled";
    public static final String AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY = "Auto Upload Speed Seeding Enabled";
    public static final String UPLOAD_CONFIGKEY = "Max Upload Speed KBs";
    public static final String UPLOAD_SEEDING_CONFIGKEY = "Max Upload Speed Seeding KBs";
    public static final String DOWNLOAD_CONFIGKEY = "Max Download Speed KBs";
    public static final String UPLOAD_SEEDING_ENABLED_CONFIGKEY = "enable.seedingonly.upload.rate";
    public static final String[] CONFIG_PARAMS = new String[]{"Auto Upload Speed Enabled", "Auto Upload Speed Seeding Enabled", "Max Upload Speed KBs", "Max Upload Speed Seeding KBs", "Max Download Speed KBs", "enable.seedingonly.upload.rate"};
    private final String configKey;
    private final Number configValue;
    private static boolean auto_upload_enabled;
    private static boolean auto_upload_seeding_enabled;
    private static boolean seeding_upload_enabled;

    public TransferSpeedValidator(String string, Number number) {
        this.configKey = string;
        this.configValue = number;
    }

    private static Object validate(String string, Number number) {
        int n = number.intValue();
        if (n < 0) {
            n = 0;
        }
        if (string == UPLOAD_CONFIGKEY) {
            int n2 = COConfigurationManager.getIntParameter(DOWNLOAD_CONFIGKEY);
            if (n != 0 && n < 5 && (n2 == 0 || n2 > n * 2)) {
                n = (n2 + 1) / 2;
            }
        } else if (string == DOWNLOAD_CONFIGKEY) {
            int n3 = COConfigurationManager.getIntParameter(UPLOAD_CONFIGKEY);
            if (n3 != 0 && n3 < 5) {
                if (n > n3 * 2) {
                    n = n3 * 2;
                } else if (n == 0) {
                    n = n3 * 2;
                }
            }
        } else if (string != UPLOAD_SEEDING_CONFIGKEY) {
            throw new IllegalArgumentException("Invalid Configuation Key; use key for max upload and max download");
        }
        return new Integer(n);
    }

    public Object getValue() {
        return TransferSpeedValidator.validate(this.configKey, this.configValue);
    }

    public static String getActiveUploadParameter(GlobalManager globalManager) {
        if (seeding_upload_enabled && globalManager.isSeedingOnly()) {
            return UPLOAD_SEEDING_CONFIGKEY;
        }
        return UPLOAD_CONFIGKEY;
    }

    public static String getDownloadParameter() {
        return DOWNLOAD_CONFIGKEY;
    }

    public static int getGlobalDownloadRateLimitBytesPerSecond() {
        return COConfigurationManager.getIntParameter(TransferSpeedValidator.getDownloadParameter()) * 1024;
    }

    public static void setGlobalDownloadRateLimitBytesPerSecond(int n) {
        COConfigurationManager.setParameter(TransferSpeedValidator.getDownloadParameter(), (n + 1023) / 1024);
    }

    public static boolean isAutoUploadAvailable(AzureusCore azureusCore) {
        SpeedManager speedManager = azureusCore.getSpeedManager();
        return speedManager == null ? false : speedManager.isAvailable();
    }

    public static boolean isAutoSpeedActive(GlobalManager globalManager) {
        if (auto_upload_enabled) {
            return auto_upload_enabled;
        }
        if (globalManager.isSeedingOnly()) {
            return auto_upload_seeding_enabled;
        }
        return auto_upload_enabled;
    }

    public static String getActiveAutoUploadParameter(GlobalManager globalManager) {
        if (!auto_upload_enabled && globalManager.isSeedingOnly()) {
            return AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY;
        }
        return AUTO_UPLOAD_ENABLED_CONFIGKEY;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{UPLOAD_SEEDING_ENABLED_CONFIGKEY, AUTO_UPLOAD_ENABLED_CONFIGKEY, AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY}, new PriorityParameterListener(){

            public void parameterChanged(String string) {
                if (string == null || string.equals(TransferSpeedValidator.UPLOAD_SEEDING_ENABLED_CONFIGKEY)) {
                    seeding_upload_enabled = COConfigurationManager.getBooleanParameter(TransferSpeedValidator.UPLOAD_SEEDING_ENABLED_CONFIGKEY);
                }
                if (string == null || string.equals(TransferSpeedValidator.AUTO_UPLOAD_ENABLED_CONFIGKEY)) {
                    auto_upload_enabled = COConfigurationManager.getBooleanParameter(TransferSpeedValidator.AUTO_UPLOAD_ENABLED_CONFIGKEY);
                }
                if (string == null || string.equals(TransferSpeedValidator.AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY)) {
                    auto_upload_seeding_enabled = COConfigurationManager.getBooleanParameter(TransferSpeedValidator.AUTO_UPLOAD_SEEDING_ENABLED_CONFIGKEY);
                }
            }
        });
    }
}

