/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitConfidence;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;

public class ConfigurationDefaults {
    private static final Long ZERO = new Long(0L);
    private static final Long ONE = new Long(1L);
    private static final Long FALSE = ZERO;
    private static final Long TRUE = ONE;
    private static ConfigurationDefaults configdefaults;
    private static AEMonitor class_mon;
    private Map def = null;
    public static final int def_int = 0;
    public static final long def_long = 0L;
    public static final float def_float = 0.0f;
    public static final int def_boolean = 0;
    public static final String def_String = "";
    public static final byte[] def_bytes;
    private Hashtable parameter_verifiers = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationDefaults getInstance() {
        try {
            class_mon.enter();
            if (configdefaults == null) {
                try {
                    configdefaults = new ConfigurationDefaults();
                }
                catch (Throwable throwable) {
                    System.out.println("Falling back to default defaults as environment is restricted");
                    configdefaults = new ConfigurationDefaults(new HashMap());
                }
            }
            ConfigurationDefaults configurationDefaults = configdefaults;
            Object var2_2 = null;
            class_mon.exit();
            return configurationDefaults;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected ConfigurationDefaults() {
        int n;
        this.def = new HashMap();
        this.def.put("Override Ip", def_String);
        this.def.put("Enable incremental file creation", FALSE);
        this.def.put("Enable reorder storage mode", FALSE);
        this.def.put("Reorder storage mode min MB", new Long(10L));
        this.def.put("TCP.Listen.Port", new Long(6881L));
        this.def.put("TCP.Listen.Port.Enable", TRUE);
        this.def.put("TCP.Listen.Port.Override", def_String);
        this.def.put("UDP.Listen.Port", new Long(6881L));
        this.def.put("UDP.Listen.Port.Enable", TRUE);
        this.def.put("UDP.NonData.Listen.Port", new Long(6881L));
        this.def.put("UDP.NonData.Listen.Port.Same", TRUE);
        this.def.put("HTTP.Data.Listen.Port", new Long(Constants.isWindows ? 80L : 8080L));
        this.def.put("HTTP.Data.Listen.Port.Override", ZERO);
        this.def.put("HTTP.Data.Listen.Port.Enable", FALSE);
        this.def.put("IPV6 Enable Support", FALSE);
        this.def.put("IPV6 Prefer Addresses", FALSE);
        this.def.put("max active torrents", new Long(4L));
        this.def.put("max downloads", new Long(4L));
        this.def.put("min downloads", ONE);
        this.def.put("Newly Seeding Torrents Get First Priority", TRUE);
        this.def.put("Max.Peer.Connections.Per.Torrent", new Long(50L));
        this.def.put("Max.Peer.Connections.Per.Torrent.When.Seeding", new Long(25L));
        this.def.put("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", TRUE);
        this.def.put("Max.Peer.Connections.Total", new Long(250L));
        this.def.put("Peer.Fast.Initial.Unchoke.Enabled", FALSE);
        this.def.put("File Max Open", new Long(50L));
        this.def.put("Use Config File Backups", TRUE);
        this.def.put("Max Uploads", new Long(4L));
        this.def.put("Max Uploads Seeding", new Long(4L));
        this.def.put("enable.seedingonly.maxuploads", FALSE);
        this.def.put("max.uploads.when.busy.inc.min.secs", new Long(30L));
        this.def.put("Max Download Speed KBs", ZERO);
        this.def.put("Use Request Limiting", TRUE);
        this.def.put("Use Request Limiting Priorities", TRUE);
        this.def.put("Max Upload Speed KBs", ZERO);
        this.def.put("Max Upload Speed Seeding KBs", ZERO);
        this.def.put("enable.seedingonly.upload.rate", FALSE);
        this.def.put("Max Seeds Per Torrent", ZERO);
        this.def.put("Auto Upload Speed Enabled", FALSE);
        this.def.put("Auto Upload Speed Seeding Enabled", FALSE);
        this.def.put("AutoSpeed Available", FALSE);
        this.def.put("AutoSpeed Min Upload KBs", ZERO);
        this.def.put("AutoSpeed Max Upload KBs", ZERO);
        this.def.put("AutoSpeed Max Increment KBs", ONE);
        this.def.put("AutoSpeed Max Decrement KBs", new Long(4L));
        this.def.put("AutoSpeed Choking Ping Millis", new Long(200L));
        this.def.put("AutoSpeed Download Adj Enable", FALSE);
        this.def.put("AutoSpeed Download Adj Ratio", "1.0");
        this.def.put("AutoSpeed Latency Factor", new Long(50L));
        this.def.put("AutoSpeed Forced Min KBs", new Long(4L));
        this.def.put("Auto Upload Speed Debug Enabled", FALSE);
        this.def.put("Auto Adjust Transfer Defaults", TRUE);
        this.def.put("Bias Upload Enable", TRUE);
        this.def.put("Bias Upload Slack KBs", new Long(5L));
        this.def.put("Bias Upload Handle No Limit", TRUE);
        this.def.put("ASN Autocheck Performed Time", ZERO);
        this.def.put("LAN Speed Enabled", TRUE);
        this.def.put("Max LAN Download Speed KBs", ZERO);
        this.def.put("Max LAN Upload Speed KBs", ZERO);
        this.def.put("Use Resume", TRUE);
        this.def.put("On Resume Recheck All", FALSE);
        this.def.put("Save Resume Interval", new Long(5L));
        this.def.put("Check Pieces on Completion", TRUE);
        this.def.put("Stop Ratio", new Float(0.0f));
        this.def.put("Stop Peers Ratio", ZERO);
        this.def.put("Disconnect Seed", TRUE);
        this.def.put("Seeding Piece Check Recheck Enable", TRUE);
        this.def.put("priorityExtensions", def_String);
        this.def.put("priorityExtensionsIgnoreCase", FALSE);
        this.def.put("Rename Incomplete Files", FALSE);
        this.def.put("Rename Incomplete Files Extension", ".az!");
        this.def.put("Ip Filter Enabled", TRUE);
        this.def.put("Ip Filter Allow", FALSE);
        this.def.put("Ip Filter Enable Banning", TRUE);
        this.def.put("Ip Filter Ban Block Limit", new Long(4L));
        this.def.put("Ip Filter Ban Discard Ratio", "5.0");
        this.def.put("Ip Filter Ban Discard Min KB", new Long(128L));
        this.def.put("Ip Filter Banning Persistent", TRUE);
        this.def.put("Ip Filter Enable Description Cache", TRUE);
        this.def.put("Ip Filter Autoload File", def_String);
        this.def.put("Ip Filter Clear On Reload", TRUE);
        this.def.put("Allow Same IP Peers", FALSE);
        this.def.put("Use Super Seeding", FALSE);
        this.def.put("Start On Login", FALSE);
        this.def.put("Pause Downloads On Exit", FALSE);
        this.def.put("Resume Downloads On Start", FALSE);
        this.def.put("On Downloading Complete Do", "Nothing");
        this.def.put("On Seeding Complete Do", "Nothing");
        this.def.put("Stop Triggers Auto Reset", TRUE);
        this.def.put("User Mode", ZERO);
        this.def.put("Use default data dir", FALSE);
        String string = SystemProperties.getDocPath();
        File file = new File(string, "Azureus Downloads");
        if (!file.exists()) {
            file = new File(string, "Vuze Downloads");
        }
        this.def.put("Default save path", file.getAbsolutePath());
        this.def.put("update.start", TRUE);
        this.def.put("update.periodic", TRUE);
        this.def.put("update.opendialog", TRUE);
        this.def.put("update.autodownload", FALSE);
        this.def.put("Send Version Info", TRUE);
        this.def.put("Logger.Enabled", FALSE);
        this.def.put("Logging Enable", FALSE);
        this.def.put("Logging Dir", def_String);
        this.def.put("Logging Timestamp", "HH:mm:ss.SSS");
        this.def.put("Logging Max Size", new Long(5L));
        int[] nArray = new int[]{0, 1, 2, 4};
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i <= 3; ++i) {
                this.def.put("bLog" + nArray[n] + "-" + i, TRUE);
            }
        }
        this.def.put("Logger.DebugFiles.Enabled", TRUE);
        this.def.put("Logger.DebugFiles.Enabled.Force", FALSE);
        this.def.put("Logging Enable UDP Transport", FALSE);
        this.def.put("Enable.Proxy", FALSE);
        this.def.put("Enable.SOCKS", FALSE);
        this.def.put("Proxy.Host", def_String);
        this.def.put("Proxy.Port", def_String);
        this.def.put("Proxy.Username", "<none>");
        this.def.put("Proxy.Password", def_String);
        this.def.put("Proxy.Check.On.Start", TRUE);
        this.def.put("Proxy.Data.Enable", FALSE);
        this.def.put("Proxy.Data.SOCKS.version", "V4");
        this.def.put("Proxy.Data.SOCKS.inform", TRUE);
        this.def.put("Proxy.Data.Same", TRUE);
        this.def.put("Proxy.Data.Host", def_String);
        this.def.put("Proxy.Data.Port", def_String);
        this.def.put("Proxy.Data.Username", "<none>");
        this.def.put("Proxy.Data.Password", def_String);
        this.def.put("Start Num Peers", new Long(-1L));
        this.def.put("Max Upload Speed", new Long(-1L));
        this.def.put("Max Clients", new Long(-1L));
        this.def.put("Server.shared.port", TRUE);
        this.def.put("Low Port", new Long(6881L));
        this.def.put("Already_Migrated", FALSE);
        this.def.put("ID", def_String);
        this.def.put("Play Download Finished", FALSE);
        this.def.put("Play Download Finished File", def_String);
        this.def.put("Watch Torrent Folder", FALSE);
        this.def.put("Watch Torrent Folder Interval", ONE);
        this.def.put("Start Watched Torrents Stopped", FALSE);
        this.def.put("Watch Torrent Folder Path", def_String);
        this.def.put("Prioritize First Piece", FALSE);
        this.def.put("Prioritize Most Completed Files", FALSE);
        this.def.put("Piece Picker Request Hint Enabled", TRUE);
        this.def.put("Use Lazy Bitfield", FALSE);
        this.def.put("Zero New", FALSE);
        this.def.put("XFS Allocation", FALSE);
        this.def.put("Copy And Delete Data Rather Than Move", FALSE);
        this.def.put("File.save.peers.enable", TRUE);
        this.def.put("File.strict.locking", TRUE);
        this.def.put("Move Deleted Data To Recycle Bin", TRUE);
        this.def.put("Popup Download Finished", FALSE);
        this.def.put("Popup File Finished", FALSE);
        this.def.put("Popup Download Added", FALSE);
        this.def.put("Show Timestamp For Alerts", FALSE);
        this.def.put("Save Torrent Files", TRUE);
        this.def.put("General_sDefaultTorrent_Directory", SystemProperties.getUserPath() + "torrents");
        this.def.put("Bind IP", def_String);
        this.def.put("Enforce Bind IP", FALSE);
        this.def.put("Stats Export Peer Details", FALSE);
        this.def.put("Stats Export File Details", FALSE);
        this.def.put("Stats XSL File", def_String);
        this.def.put("Stats Enable", FALSE);
        this.def.put("Stats Period", new Long(30000L));
        this.def.put("Stats Dir", def_String);
        this.def.put("Stats File", "Azureus_Stats.xml");
        this.def.put("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
        this.def.put("File.save.peers.max", new Long(512L));
        this.def.put("Tracker Compact Enable", TRUE);
        this.def.put("Tracker Key Enable Client", TRUE);
        this.def.put("Tracker Key Enable Server", TRUE);
        this.def.put("Tracker Separate Peer IDs", FALSE);
        this.def.put("Tracker Client Connect Timeout", new Long(120L));
        this.def.put("Tracker Client Read Timeout", new Long(60L));
        this.def.put("Tracker Client Send OS and Java Version", TRUE);
        this.def.put("Tracker Client Show Warnings", TRUE);
        this.def.put("Tracker Client Min Announce Interval", ZERO);
        this.def.put("Tracker Client Numwant Limit", new Long(100L));
        this.def.put("Tracker Client No Port Announce", FALSE);
        this.def.put("Tracker Public Enable", FALSE);
        this.def.put("Tracker Log Enable", FALSE);
        this.def.put("Tracker Port Enable", FALSE);
        this.def.put("Tracker Port", new Long(6969L));
        this.def.put("Tracker Port Backups", def_String);
        this.def.put("Tracker Port SSL Enable", FALSE);
        this.def.put("Tracker Port SSL", new Long(7000L));
        this.def.put("Tracker Port SSL Backups", def_String);
        this.def.put("Tracker Port Force External", FALSE);
        this.def.put("Tracker Host Add Our Announce URLs", TRUE);
        this.def_put("Tracker IP", def_String, new IPVerifier());
        this.def.put("Tracker Port UDP Enable", FALSE);
        this.def.put("Tracker Port UDP Version", new Long(2L));
        this.def.put("Tracker Send Peer IDs", TRUE);
        this.def.put("Tracker Max Peers Returned", new Long(100L));
        this.def.put("Tracker Scrape Cache", new Long(5000L));
        this.def.put("Tracker Announce Cache", new Long(500L));
        this.def.put("Tracker Announce Cache Min Peers", new Long(500L));
        this.def.put("Tracker Poll Interval Min", new Long(120L));
        this.def.put("Tracker Poll Interval Max", new Long(3600L));
        this.def.put("Tracker Poll Seed Interval Mult", new Long(1L));
        this.def.put("Tracker Scrape Retry Percentage", new Long(200L));
        this.def.put("Tracker Password Enable Web", FALSE);
        this.def.put("Tracker Password Web HTTPS Only", FALSE);
        this.def.put("Tracker Password Enable Torrent", FALSE);
        this.def.put("Tracker Username", def_String);
        this.def.put("Tracker Password", null);
        this.def.put("Tracker Poll Inc By", new Long(60L));
        this.def.put("Tracker Poll Inc Per", new Long(10L));
        this.def.put("Tracker NAT Check Enable", TRUE);
        this.def.put("Tracker NAT Check Timeout", new Long(15L));
        this.def.put("Tracker Max Seeds Retained", ZERO);
        this.def.put("Tracker Max Seeds", ZERO);
        this.def.put("Tracker Max GET Time", new Long(20L));
        this.def.put("Tracker Max POST Time Multiplier", ONE);
        this.def.put("Tracker Max Threads", new Long(48L));
        this.def.put("Tracker TCP NonBlocking", FALSE);
        this.def.put("Tracker TCP NonBlocking Restrict Request Types", TRUE);
        this.def.put("Tracker TCP NonBlocking Conc Max", new Long(2048L));
        this.def.put("Tracker TCP NonBlocking Immediate Close", FALSE);
        this.def.put("Tracker Client Scrape Enable", TRUE);
        this.def.put("Tracker Client Scrape Total Disable", FALSE);
        this.def.put("Tracker Client Scrape Stopped Enable", TRUE);
        this.def.put("Tracker Client Scrape Single Only", FALSE);
        this.def.put("Tracker Server Full Scrape Enable", TRUE);
        this.def.put("Tracker Server Not Found Redirect", def_String);
        this.def.put("Tracker Server Support Experimental Extensions", FALSE);
        this.def.put("Network Selection Prompt", FALSE);
        this.def.put("Network Selection Default.Public", TRUE);
        this.def.put("Network Selection Default.I2P", FALSE);
        this.def.put("Network Selection Default.Tor", FALSE);
        this.def.put("Tracker Network Selection Default.Public", TRUE);
        this.def.put("Tracker Network Selection Default.I2P", TRUE);
        this.def.put("Tracker Network Selection Default.Tor", TRUE);
        this.def.put("Peer Source Selection Default.Tracker", TRUE);
        this.def.put("Peer Source Selection Default.DHT", TRUE);
        this.def.put("Peer Source Selection Default.PeerExchange", TRUE);
        this.def.put("Peer Source Selection Default.Plugin", TRUE);
        this.def.put("Peer Source Selection Default.Incoming", TRUE);
        this.def.put("config.style.useSIUnits", FALSE);
        this.def.put("config.style.forceSIValues", Constants.isOSX_10_6_OrHigher ? FALSE : TRUE);
        this.def.put("config.style.useUnitsRateBits", FALSE);
        this.def.put("config.style.separateProtDataStats", FALSE);
        this.def.put("config.style.dataStatsOnly", FALSE);
        this.def.put("config.style.doNotUseGB", FALSE);
        this.def.put("Save Torrent Backup", FALSE);
        this.def.put("Sharing Protocol", "DHT");
        this.def.put("Sharing Add Hashes", FALSE);
        this.def.put("Sharing Rescan Enable", FALSE);
        this.def.put("Sharing Rescan Period", new Long(60L));
        this.def.put("Sharing Torrent Comment", def_String);
        this.def.put("Sharing Permit DHT", TRUE);
        this.def.put("Sharing Torrent Private", FALSE);
        this.def.put("File.Decoder.Prompt", FALSE);
        this.def.put("File.Decoder.Default", def_String);
        this.def.put("File.Decoder.ShowLax", FALSE);
        this.def.put("File.Decoder.ShowAll", FALSE);
        this.def.put("Password enabled", FALSE);
        this.def.put("Password", null);
        this.def.put("config.interface.checkassoc", TRUE);
        this.def.put("confirmationOnExit", FALSE);
        this.def.put("locale", Locale.getDefault().toString());
        this.def.put("locale.set.complete.count", ZERO);
        this.def.put("Password Confirm", null);
        this.def.put("Auto Update", TRUE);
        this.def.put("Alert on close", FALSE);
        this.def.put("diskmanager.friendly.hashchecking", FALSE);
        this.def.put("diskmanager.hashchecking.smallestfirst", TRUE);
        this.def.put("Default Start Torrents Stopped", FALSE);
        this.def.put("Server Enable UDP", TRUE);
        this.def.put("diskmanager.perf.cache.enable", TRUE);
        this.def.put("diskmanager.perf.cache.enable.read", FALSE);
        this.def.put("diskmanager.perf.cache.enable.write", TRUE);
        this.def.put("diskmanager.perf.cache.size", new Long(4L));
        this.def.put("diskmanager.perf.cache.notsmallerthan", new Long(1024L));
        this.def.put("diskmanager.perf.read.maxthreads", new Long(32L));
        this.def.put("diskmanager.perf.read.maxmb", new Long(5L));
        this.def.put("diskmanager.perf.write.maxthreads", new Long(32L));
        this.def.put("diskmanager.perf.write.maxmb", new Long(5L));
        this.def.put("diskmanager.perf.cache.trace", FALSE);
        this.def.put("diskmanager.perf.cache.flushpieces", TRUE);
        this.def.put("diskmanager.perf.read.aggregate.enable", FALSE);
        this.def.put("diskmanager.perf.read.aggregate.request.limit", ZERO);
        this.def.put("diskmanager.perf.read.aggregate.byte.limit", ZERO);
        this.def.put("diskmanager.perf.write.aggregate.enable", FALSE);
        this.def.put("diskmanager.perf.write.aggregate.request.limit", ZERO);
        this.def.put("diskmanager.perf.write.aggregate.byte.limit", ZERO);
        this.def.put("diskmanager.perf.checking.read.priority", FALSE);
        this.def.put("diskmanager.perf.checking.fully.async", FALSE);
        this.def.put("diskmanager.perf.queue.torrent.bias", TRUE);
        this.def.put("peercontrol.udp.fallback.connect.fail", TRUE);
        this.def.put("peercontrol.udp.fallback.connect.drop", TRUE);
        this.def.put("peercontrol.udp.probe.enable", FALSE);
        this.def.put("peercontrol.hide.piece", FALSE);
        this.def.put("peercontrol.scheduler.use.priorities", TRUE);
        this.def.put("peercontrol.prefer.udp", FALSE);
        this.def.put("File.truncate.if.too.large", FALSE);
        this.def.put("Enable System Tray", TRUE);
        this.def.put("config.style.table.defaultSortOrder", ZERO);
        this.def.put("Ignore.peer.ports", "0");
        this.def.put("Security.JAR.tools.dir", def_String);
        n = Constants.isWindows && !Constants.isWindowsVistaSP2OrHigher && !Constants.isWindows7OrHigher ? 1 : 0;
        this.def.put("network.max.simultaneous.connect.attempts", new Long(n != 0 ? 8L : 24L));
        this.def.put("network.tcp.max.connections.outstanding", new Long(2048L));
        this.def.put("network.tcp.mtu.size", new Long(1500L));
        this.def.put("network.udp.mtu.size", new Long(1500L));
        this.def.put("network.tcp.socket.SO_SNDBUF", ZERO);
        this.def.put("network.tcp.socket.SO_RCVBUF", ZERO);
        this.def.put("network.tcp.socket.IPDiffServ", def_String);
        this.def.put("network.tcp.read.select.time", new Long(25L));
        this.def.put("network.tcp.read.select.min.time", new Long(0L));
        this.def.put("network.tcp.write.select.time", new Long(25L));
        this.def.put("network.tcp.write.select.min.time", new Long(0L));
        this.def.put("network.control.write.idle.time", new Long(50L));
        this.def.put("network.control.write.aggressive", FALSE);
        this.def.put("network.control.read.idle.time", new Long(50L));
        this.def.put("network.control.read.aggressive", FALSE);
        this.def.put("network.control.read.processor.count", new Long(1L));
        this.def.put("network.control.write.processor.count", new Long(1L));
        this.def.put("peermanager.schedule.time", new Long(100L));
        this.def.put("enable_small_osx_fonts", TRUE);
        this.def.put("Play Download Finished Announcement", FALSE);
        this.def.put("Play Download Finished Announcement Text", "Download Complete");
        this.def.put("Play File Finished", FALSE);
        this.def.put("Play File Finished File", def_String);
        this.def.put("Play File Finished Announcement", FALSE);
        this.def.put("Play File Finished Announcement Text", "File Complete");
        this.def.put("filechannel.rt.buffer.millis", new Long(60000L));
        this.def.put("filechannel.rt.buffer.pieces", new Long(5L));
        this.def.put("BT Request Max Block Size", new Long(65536L));
        this.def.put("network.tcp.enable_safe_selector_mode", FALSE);
        this.def.put("network.tcp.safe_selector_mode.chunk_size", new Long(60L));
        this.def.put("network.transport.encrypted.require", FALSE);
        this.def.put("network.transport.encrypted.min_level", "RC4");
        this.def.put("network.transport.encrypted.fallback.outgoing", FALSE);
        this.def.put("network.transport.encrypted.fallback.incoming", FALSE);
        this.def.put("network.transport.encrypted.use.crypto.port", FALSE);
        this.def.put("network.transport.encrypted.allow.incoming", TRUE);
        this.def.put("network.bind.local.port", ZERO);
        this.def.put("crypto.keys.system.managed", FALSE);
        this.def.put("peer.nat.traversal.request.conc.max", new Long(3L));
        this.def.put("memory.slice.limit.multiplier", new Long(1L));
        this.def.put("Move Completed When Done", FALSE);
        this.def.put("Completed Files Directory", def_String);
        this.def.put("Move Only When In Default Save Dir", TRUE);
        this.def.put("Move Torrent When Done", TRUE);
        this.def.put("File.move.subdir_is_default", TRUE);
        this.def.put("Set Completion Flag For Completed Downloads On Start", TRUE);
        this.def.put("File.move.download.removed.enabled", FALSE);
        this.def.put("File.move.download.removed.path", def_String);
        this.def.put("File.move.download.removed.only_in_default", TRUE);
        this.def.put("File.move.download.removed.move_torrent", TRUE);
        this.def.put("File.move.download.removed.move_partial", FALSE);
        this.def.put("File.delete.include_files_outside_save_dir", FALSE);
        this.def.put("FilesView.show.full.path", FALSE);
        this.def.put("MyTorrentsView.menu.show_parent_folder_enabled", FALSE);
        this.def.put("FileBrowse.usePathFinder", FALSE);
        this.def.put("Beta Programme Enabled", FALSE);
        this.def.put("def.deletetorrent", TRUE);
        this.def.put("confirm.delete.content", TRUE);
        try {
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", new Long(61440L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", new Long(30720L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.dht.good.setpoint", new Long(50L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.dht.good.tolerance", new Long(100L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.dht.bad.setpoint", new Long(900L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.dht.bad.tolerance", new Long(500L));
            this.def.put("Auto Upload Speed Version", new Long(2L));
            this.def.put("SpeedLimitMonitor.setting.download.limit.conf", SpeedLimitConfidence.NONE.getString());
            this.def.put("SpeedLimitMonitor.setting.upload.limit.conf", SpeedLimitConfidence.NONE.getString());
            this.def.put("SpeedLimitMonitor.setting.choke.ping.count", new Long(1L));
            this.def.put("SpeedLimitMonitor.setting.upload.used.seeding.mode", new Long(90L));
            this.def.put("SpeedLimitMonitor.setting.upload.used.download.mode", new Long(60L));
            this.def.put("SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust", TRUE);
            this.def.put("SpeedManagerAlgorithmProviderV2.intervals.between.adjust", new Long(2L));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.def.put("subscriptions.max.non.deleted.results", new Long(512L));
        this.def.put("subscriptions.auto.start.downloads", TRUE);
        this.def.put("subscriptions.auto.start.min.mb", ZERO);
        this.def.put("subscriptions.auto.start.max.mb", ZERO);
    }

    protected ConfigurationDefaults(Map map) {
        this.def = map;
    }

    protected void def_put(String string, String string2, COConfigurationManager.ParameterVerifier parameterVerifier) {
        this.def.put(string, string2);
        ArrayList<COConfigurationManager.ParameterVerifier> arrayList = (ArrayList<COConfigurationManager.ParameterVerifier>)this.parameter_verifiers.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<COConfigurationManager.ParameterVerifier>(1);
            this.parameter_verifiers.put(string, arrayList);
        }
        arrayList.add(parameterVerifier);
    }

    private void checkParameterExists(String string) throws ConfigurationParameterNotFoundException {
        if (!this.def.containsKey(string)) {
            ConfigurationParameterNotFoundException configurationParameterNotFoundException = new ConfigurationParameterNotFoundException(string);
            throw configurationParameterNotFoundException;
        }
    }

    public String getStringParameter(String string) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(string);
        Object v = this.def.get(string);
        if (v instanceof Number) {
            return ((Number)v).toString();
        }
        return (String)v;
    }

    public int getIntParameter(String string) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(string);
        return ((Long)this.def.get(string)).intValue();
    }

    public long getLongParameter(String string) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(string);
        return (Long)this.def.get(string);
    }

    public float getFloatParameter(String string) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(string);
        return ((Float)this.def.get(string)).floatValue();
    }

    public byte[] getByteParameter(String string) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(string);
        return (byte[])this.def.get(string);
    }

    public boolean getBooleanParameter(String string) throws ConfigurationParameterNotFoundException {
        this.checkParameterExists(string);
        return ((Long)this.def.get(string)).equals(TRUE);
    }

    public boolean hasParameter(String string) {
        return this.def.containsKey(string);
    }

    public Object getDefaultValueAsObject(String string) {
        return this.def.get(string);
    }

    public Set getAllowedParameters() {
        return this.def.keySet();
    }

    public void addParameter(String string, String string2) {
        this.def.put(string, string2);
    }

    public void addParameter(String string, int n) {
        this.def.put(string, new Long(n));
    }

    public void addParameter(String string, byte[] byArray) {
        this.def.put(string, byArray);
    }

    public void addParameter(String string, boolean bl) {
        Long l = new Long(bl ? 1L : 0L);
        this.def.put(string, l);
    }

    public void addParameter(String string, long l) {
        this.def.put(string, new Long(l));
    }

    public void addParameter(String string, float f) {
        this.def.put(string, new Float(f));
    }

    public void registerExternalDefaults(Map map) {
        this.def.putAll(map);
    }

    public boolean doesParameterDefaultExist(String string) {
        return this.def.containsKey(string);
    }

    public Object getParameter(String string) {
        return this.def.get(string);
    }

    public List getVerifiers(String string) {
        return (List)this.parameter_verifiers.get(string);
    }

    protected void runVerifiers() {
        for (Map.Entry entry : this.parameter_verifiers.entrySet()) {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                COConfigurationManager.ParameterVerifier parameterVerifier = (COConfigurationManager.ParameterVerifier)list.get(i);
                Object object = this.getDefaultValueAsObject(string);
                if (object == null) continue;
                if (!(object instanceof String)) {
                    Debug.out("Unsupported verifier type for parameter '" + string + "' - " + object);
                    continue;
                }
                String string2 = COConfigurationManager.getStringParameter(string);
                if (string2 == null || parameterVerifier.verify(string, string2)) continue;
                Debug.out("Parameter '" + string + "', value '" + string2 + "' failed verification - setting back to default '" + object + "'");
                COConfigurationManager.removeParameter(string);
            }
        }
    }

    static {
        class_mon = new AEMonitor("ConfigDef");
        def_bytes = null;
    }

    protected class IPVerifier
    implements COConfigurationManager.ParameterVerifier {
        protected IPVerifier() {
        }

        public boolean verify(String string, Object object) {
            String string2 = (String)object;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == ':' || c == '~') continue;
                return false;
            }
            return true;
        }
    }
}

