/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class PRUDPPacket {
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int DEFAULT_UDP_TIMEOUT = 30000;
    private static int next_id = new Random(SystemTime.getCurrentTime()).nextInt();
    private static AEMonitor class_mon = new AEMonitor("PRUDPPacket");
    private InetSocketAddress address;
    private int type;
    private int transaction_id;
    private PRUDPPacket previous_packet;
    private int serialised_size;

    protected PRUDPPacket(int n, int n2) {
        this.type = n;
        this.transaction_id = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PRUDPPacket(int n) {
        this.type = n;
        try {
            class_mon.enter();
            this.transaction_id = next_id++;
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public void setSerialisedSize(int n) {
        this.serialised_size = n;
    }

    public int getSerialisedSize() {
        return this.serialised_size;
    }

    public boolean hasContinuation() {
        return false;
    }

    public void setPreviousPacket(PRUDPPacket pRUDPPacket) {
        this.previous_packet = pRUDPPacket;
    }

    public PRUDPPacket getPreviousPacket() {
        return this.previous_packet;
    }

    public void setAddress(InetSocketAddress inetSocketAddress) {
        this.address = inetSocketAddress;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getAction() {
        return this.type;
    }

    public int getTransactionId() {
        return this.transaction_id;
    }

    public abstract void serialise(DataOutputStream var1) throws IOException;

    public String getString() {
        return "type=" + this.type + ",addr=" + this.address;
    }
}

