/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.magneturi.impl;

import com.aelitis.azureus.core.util.HTTPUtils;
import com.aelitis.azureus.core.util.png.PNG;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;

public class MagnetURIHandlerImpl
extends MagnetURIHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private static MagnetURIHandlerImpl singleton;
    private static AEMonitor class_mon;
    private static final int DOWNLOAD_TIMEOUT = 180000;
    protected static final String NL = "\r\n";
    private static final boolean DEBUG = false;
    private int port;
    private List listeners = new ArrayList();
    private Map info_map = new HashMap();
    private Map<String, MagnetURIHandler.ResourceProvider> resources = new HashMap<String, MagnetURIHandler.ResourceProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagnetURIHandler getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new MagnetURIHandlerImpl();
            }
            MagnetURIHandlerImpl magnetURIHandlerImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return magnetURIHandlerImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected MagnetURIHandlerImpl() {
        ServerSocket serverSocket = null;
        for (int i = 45100; i <= 45199; ++i) {
            try {
                serverSocket = new ServerSocket(i, 50, InetAddress.getByName("127.0.0.1"));
                this.port = i;
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        if (serverSocket == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "MagnetURI: no free sockets, giving up"));
            }
        } else {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MagnetURI: bound on " + serverSocket.getLocalPort()));
            }
            final ServerSocket serverSocket2 = serverSocket;
            AEThread aEThread = new AEThread("MagnetURIHandler"){

                public void runSupport() {
                    int n = 0;
                    int n2 = 0;
                    while (true) {
                        try {
                            while (true) {
                                final Socket socket = serverSocket2.accept();
                                ++n2;
                                n = 0;
                                new AEThread2("MagnetURIHandler:processor", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * Loose catch block
                                     */
                                    public void run() {
                                        block18: {
                                            boolean bl;
                                            block17: {
                                                bl = true;
                                                String string = socket.getInetAddress().getHostAddress();
                                                if (string.equals("localhost") || string.equals("127.0.0.1")) {
                                                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF8"));
                                                    String string2 = bufferedReader.readLine();
                                                    if (string2 != null) {
                                                        if (string2.toUpperCase().startsWith("GET ")) {
                                                            Logger.log(new LogEvent(LOGID, "MagnetURIHandler: processing '" + string2 + "'"));
                                                            string2 = string2.substring(4);
                                                            int n = string2.lastIndexOf(32);
                                                            string2 = string2.substring(0, n);
                                                            bl = MagnetURIHandlerImpl.this.process(string2, bufferedReader, socket.getOutputStream());
                                                        } else {
                                                            Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + string2 + "'"));
                                                        }
                                                    } else {
                                                        Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from '" + string + "': no data read"));
                                                    }
                                                    break block17;
                                                }
                                                Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from invalid address '" + string + "'"));
                                            }
                                            Object var7_7 = null;
                                            try {
                                                if (bl) {
                                                    socket.close();
                                                }
                                                break block18;
                                            }
                                            catch (Throwable throwable) {}
                                            break block18;
                                            {
                                                catch (Throwable throwable) {
                                                    if (!(throwable instanceof IOException) && !(throwable instanceof SocketException)) {
                                                        Debug.printStackTrace(throwable);
                                                    }
                                                    Object var7_8 = null;
                                                    try {
                                                        if (bl) {
                                                            socket.close();
                                                        }
                                                        break block18;
                                                    }
                                                    catch (Throwable throwable2) {}
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var7_9 = null;
                                                try {
                                                    if (bl) {
                                                        socket.close();
                                                    }
                                                }
                                                catch (Throwable throwable3) {
                                                    // empty catch block
                                                }
                                                throw throwable;
                                            }
                                        }
                                    }
                                }.start();
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                            if (++n <= 100 || !Logger.isEnabled()) continue;
                            Logger.log(new LogEvent(LOGID, "MagnetURIHandler: bailing out, too many socket errors"));
                            continue;
                        }
                        break;
                    }
                }
            };
            aEThread.setDaemon(true);
            aEThread.start();
        }
    }

    public void process(final String string, final InputStream inputStream, final OutputStream outputStream) throws IOException {
        new AEThread2("MagnetProcessor", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block25: {
                    Throwable throwable2222;
                    boolean bl;
                    block21: {
                        bl = false;
                        bl = MagnetURIHandlerImpl.this.process(string, new BufferedReader(new InputStreamReader(inputStream)), outputStream);
                        Object var4_2 = null;
                        if (!bl) break block21;
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2222) {
                            Debug.out(throwable2222);
                        }
                    }
                    try {
                        outputStream.flush();
                    }
                    catch (Throwable throwable2222) {
                        Debug.out(throwable2222);
                    }
                    if (bl) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2222) {
                            Debug.out(throwable2222);
                        }
                    }
                    break block25;
                    {
                        catch (Throwable throwable3) {
                            Throwable throwable42222;
                            Debug.out("Magnet processing failed", throwable3);
                            Object var4_3 = null;
                            if (bl) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable42222) {
                                    Debug.out(throwable42222);
                                }
                            }
                            try {
                                outputStream.flush();
                            }
                            catch (Throwable throwable42222) {
                                Debug.out(throwable42222);
                            }
                            if (bl) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable42222) {
                                    Debug.out(throwable42222);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        Throwable throwable62222;
                        Object var4_4 = null;
                        if (bl) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable62222) {
                                Debug.out(throwable62222);
                            }
                        }
                        try {
                            outputStream.flush();
                        }
                        catch (Throwable throwable62222) {
                            Debug.out(throwable62222);
                        }
                        if (bl) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable62222) {
                                Debug.out(throwable62222);
                            }
                        }
                        throw throwable5;
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(String string, BufferedReader bufferedReader, OutputStream outputStream) throws IOException {
        Object object;
        ArrayList<Object> arrayList;
        Object object2;
        Object object3;
        Object object4;
        String string2;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = string.indexOf(63);
        if (n == -1) {
            string2 = "";
        } else {
            string2 = string.substring(n + 1);
            if ((n = string2.lastIndexOf(32)) >= 0) {
                string2 = string2.substring(0, n).trim();
            }
            object4 = new StringTokenizer(string2, "&");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                object3 = ((StringTokenizer)object4).nextToken();
                n = object3.indexOf(61);
                if (n == -1) {
                    object2 = object3.trim();
                    hashMap.put(object2, "");
                    hashMap2.put(((String)object2).toLowerCase(MessageText.LOCALE_ENGLISH), "");
                    continue;
                }
                try {
                    object2 = object3.substring(0, n).trim();
                    arrayList = ((String)object2).toLowerCase(MessageText.LOCALE_ENGLISH);
                    object = URLDecoder.decode(object3.substring(n + 1).trim(), "UTF8");
                    hashMap.put(object2, (String)object);
                    hashMap2.put((String)((Object)arrayList), object);
                    if (!((String)((Object)arrayList)).equals("xsource")) continue;
                    arrayList2.add(object);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.printStackTrace(unsupportedEncodingException);
                }
            }
        }
        if (string.startsWith("/magnet10/badge.img")) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                object3 = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                if (object3 == null) continue;
                this.writeReply(outputStream, "image/gif", (byte[])object3);
                return true;
            }
            this.writeNotFound(outputStream);
            return true;
        }
        if (string.startsWith("/magnet10/canHandle.img?")) {
            object4 = (String)hashMap2.get("xt");
            if (object4 != null && ((String)object4).toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    object2 = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                    if (object2 == null) continue;
                    this.writeReply(outputStream, "image/gif", (byte[])object2);
                    return true;
                }
            }
            this.writeNotFound(outputStream);
            return true;
        }
        if (string.startsWith("/azversion")) {
            this.writeReply(outputStream, "text/plain", "4.5.0.4");
            return true;
        }
        if (string.startsWith("/magnet10/options.js?") || string.startsWith("/magnet10/default.js?")) {
            object4 = "";
            object4 = (String)object4 + this.getJS("magnetOptionsPreamble");
            object4 = (String)object4 + this.getJSS("<a href=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/select/?\"+magnetQueryString+\"\\\" target=\\\"_blank\\\">");
            object4 = (String)object4 + this.getJSS("<img src=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/magnet10/badge.img\\\">");
            object4 = (String)object4 + this.getJSS("Download with Azureus");
            object4 = (String)object4 + this.getJSS("</a>");
            object4 = (String)object4 + this.getJS("magnetOptionsPostamble");
            object4 = (String)object4 + "magnetOptionsPollSuccesses++";
            this.writeReply(outputStream, "application/x-javascript", (String)object4);
            return true;
        }
        if (string.startsWith("/magnet10/pause")) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writeNotFound(outputStream);
            return true;
        }
        if (string.startsWith("/select/")) {
            object4 = "";
            boolean bl = false;
            object2 = (String)hashMap2.get("xt");
            if (object2 == null) {
                object4 = "xt missing";
            } else {
                arrayList = ((String)object2).toLowerCase(MessageText.LOCALE_ENGLISH);
                try {
                    object = ((String)((Object)arrayList)).startsWith("http:") || ((String)((Object)arrayList)).startsWith("https:") ? new URL((String)object2) : new URL("magnet:?xt=" + object2);
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        if (!((MagnetURIHandlerListener)this.listeners.get(i)).download((URL)object)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        object4 = "No listeners accepted the operation";
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    object4 = Debug.getNestedExceptionMessage(throwable);
                }
            }
            if (bl) {
                if ("image".equalsIgnoreCase((String)hashMap2.get("result"))) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        object = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                        if (object == null) continue;
                        this.writeReply(outputStream, "image/gif", (byte[])object);
                        return true;
                    }
                }
                this.writeReply(outputStream, "text/plain", "Download initiated");
            } else {
                this.writeReply(outputStream, "text/plain", "Download initiation failed: " + (String)object4);
            }
        } else {
            if (string.startsWith("/download/")) {
                object4 = (String)hashMap2.get("xt");
                if (object4 == null || !((String)object4).toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:sha1:") && !((String)object4).toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + string + "'"));
                    }
                    return true;
                }
                object3 = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                try {
                    Object object5;
                    Object object6;
                    object3.print("HTTP/1.0 200 OK\r\n");
                    object3.flush();
                    object2 = ((String)object4).substring(9);
                    arrayList = new ArrayList<Object>();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        object6 = (String)arrayList2.get(i);
                        int n2 = ((String)object6).indexOf(58);
                        if (n2 == -1) continue;
                        try {
                            object5 = new InetSocketAddress(((String)object6).substring(0, n2), Integer.parseInt(((String)object6).substring(n2 + 1)));
                            arrayList.add(object5);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                    InetSocketAddress[] inetSocketAddressArray = arrayList.toArray(new InetSocketAddress[arrayList.size()]);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "MagnetURIHandler: download of '" + (String)object2 + "' starts (initial sources=" + inetSocketAddressArray.length + ")"));
                    }
                    if ((object6 = (Object)UrlUtils.decodeSHA1Hash((String)object2)) == null) {
                        throw new Exception("Invalid info hash '" + (String)object2 + "'");
                    }
                    byte[] byArray = null;
                    object5 = (String)hashMap2.get("verbose");
                    boolean bl = object5 != null && ((String)object5).equalsIgnoreCase("true");
                    for (int i = 0; i < this.listeners.size() && (byArray = ((MagnetURIHandlerListener)this.listeners.get(i)).download(new MagnetURIHandlerProgressListener((PrintWriter)object3, bl){
                        final /* synthetic */ PrintWriter val$pw;
                        final /* synthetic */ boolean val$verbose;
                        {
                            this.val$pw = printWriter;
                            this.val$verbose = bl;
                        }

                        public void reportSize(long l) {
                            this.val$pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("torrent_size", String.valueOf(l)) + MagnetURIHandlerImpl.NL);
                            this.val$pw.flush();
                        }

                        public void reportActivity(String string) {
                            this.val$pw.print("X-Report: " + string + MagnetURIHandlerImpl.NL);
                            this.val$pw.flush();
                        }

                        public void reportCompleteness(int n) {
                            this.val$pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("percent", String.valueOf(n)) + MagnetURIHandlerImpl.NL);
                            this.val$pw.flush();
                        }

                        public boolean verbose() {
                            return this.val$verbose;
                        }
                    }, (byte[])object6, string2, inetSocketAddressArray, 180000L)) == null; ++i) {
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "MagnetURIHandler: download of '" + (String)object2 + "' completes, data " + (byArray == null ? "not found" : "found, length = " + byArray.length)));
                    }
                    if (byArray == null) {
                        object3.print("X-Report: error: " + this.getMessageText("no_sources") + NL);
                        object3.flush();
                        return !hashMap2.containsKey("pause_on_error");
                    }
                    object3.print("Content-Length: " + byArray.length + NL + NL);
                    object3.flush();
                    outputStream.write(byArray);
                    outputStream.flush();
                }
                catch (Throwable throwable) {
                    object3.print("X-Report: error: " + this.getMessageText("error", Debug.getNestedExceptionMessage(throwable)) + NL);
                    object3.flush();
                    return !hashMap2.containsKey("pause_on_error");
                }
            }
            if (string.startsWith("/getinfo?")) {
                object4 = (String)hashMap2.get("name");
                if (object4 != null) {
                    String string3;
                    object3 = (Integer)this.info_map.get(object4);
                    int n3 = Integer.MIN_VALUE;
                    if (object3 != null) {
                        n3 = object3.intValue();
                    } else {
                        for (int i = 0; i < this.listeners.size() && n3 == Integer.MIN_VALUE; ++i) {
                            object = new HashMap<Object, String>();
                            ((HashMap)object).putAll(hashMap);
                            n3 = ((MagnetURIHandlerListener)this.listeners.get(i)).get((String)object4, (Map)object);
                        }
                    }
                    if (n3 == Integer.MIN_VALUE) {
                        string3 = (String)hashMap2.get("default");
                        if (string3 != null) {
                            try {
                                n3 = Integer.parseInt(string3);
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    } else {
                        string3 = (String)hashMap2.get("max");
                        if (string3 != null) {
                            try {
                                int n4 = Integer.parseInt(string3);
                                if (n3 > n4) {
                                    n3 = n4;
                                }
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }
                    if (n3 != Integer.MIN_VALUE) {
                        Object object7;
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        if (n3 > 0x100000) {
                            n3 = 0x100000;
                        }
                        int n5 = n3;
                        int n6 = 1;
                        String string4 = (String)hashMap2.get("divmod");
                        if (string4 != null) {
                            int n7 = Integer.parseInt(string4);
                            n5 = n3 / n7 + 1;
                            n6 = n3 % n7 + 1;
                        } else {
                            String string5 = (String)hashMap2.get("div");
                            if (string5 != null) {
                                n5 = n3 / Integer.parseInt(string5);
                            } else {
                                object7 = (String)hashMap2.get("mod");
                                if (object7 != null) {
                                    n5 = n3 % Integer.parseInt((String)object7);
                                }
                            }
                        }
                        String string6 = (String)hashMap2.get("img_type");
                        if (string6 != null && string6.equals("png")) {
                            object7 = PNG.getPNGBytesForSize(n5, n6);
                            this.writeReply(outputStream, "image/png", (byte[])object7);
                        } else {
                            object7 = new ByteArrayOutputStream();
                            this.writeImage((OutputStream)object7, n5, n6);
                            byte[] byArray = ((ByteArrayOutputStream)object7).toByteArray();
                            this.writeReply(outputStream, "image/bmp", byArray);
                        }
                        return true;
                    }
                }
                this.writeNotFound(outputStream);
                return true;
            }
            if (string.startsWith("/setinfo?")) {
                object4 = (String)hashMap2.get("name");
                if (object4 != null) {
                    int n8;
                    boolean bl = false;
                    for (n8 = 0; n8 < this.listeners.size() && !bl; ++n8) {
                        arrayList = new HashMap();
                        ((HashMap)((Object)arrayList)).putAll(hashMap);
                        bl = ((MagnetURIHandlerListener)this.listeners.get(n8)).set((String)object4, (Map)((Object)arrayList));
                    }
                    n8 = bl ? 20 : 10;
                    int n9 = bl ? 20 : 10;
                    object = (String)hashMap2.get("img_type");
                    if (object != null && ((String)object).equals("png")) {
                        byte[] byArray = PNG.getPNGBytesForSize(n8, n9);
                        this.writeReply(outputStream, "image/png", byArray);
                    } else {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        this.writeImage(byteArrayOutputStream, n8, n9);
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        this.writeReply(outputStream, "image/bmp", byArray);
                    }
                    return true;
                }
            } else if (string.equals("/browserheaders.js")) {
                object4 = "";
                while ((object3 = bufferedReader.readLine()) != null && (object3 = object3.trim()).length() != 0) {
                    object4 = (String)object4 + (((String)object4).length() == 0 ? "" : "\n") + (String)object3;
                }
                object3 = "var headers = \"" + new String(Base64.encode(((String)object4).getBytes("UTF-8"))) + "\";";
                this.writeReply(outputStream, "application/x-javascript", (String)object3);
            } else if (string.startsWith("/resource.")) {
                object4 = (String)hashMap2.get("rid");
                object2 = this.resources;
                synchronized (object2) {
                    object3 = this.resources.get(object4);
                }
                if (object3 != null) {
                    object2 = object3.getData();
                    if (object2 != null) {
                        this.writeReply(outputStream, HTTPUtils.guessContentTypeFromFileType(object3.getFileType()), (byte[])object2);
                    } else {
                        this.writeNotFound(outputStream);
                    }
                } else {
                    this.writeNotFound(outputStream);
                }
            }
        }
        return true;
    }

    private void writeImage(OutputStream outputStream, int n, int n2) {
        int n3 = n / 8;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        int n4 = n3 * n2;
        int n5 = 54 + n4;
        try {
            outputStream.write(new byte[]{66, 77});
            this.write4Bytes(outputStream, n5);
            this.write4Bytes(outputStream, 0L);
            this.write4Bytes(outputStream, 54L);
            this.write4Bytes(outputStream, 40L);
            this.write4Bytes(outputStream, n);
            this.write4Bytes(outputStream, n2);
            this.write4Bytes(outputStream, 65537L);
            this.write4Bytes(outputStream, 0L);
            this.write4Bytes(outputStream, n4);
            this.write4Bytes(outputStream, 0L);
            this.write4Bytes(outputStream, 0L);
            this.write4Bytes(outputStream, 0L);
            this.write4Bytes(outputStream, 0L);
            byte[] byArray = new byte[n4];
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            Debug.out(iOException);
        }
    }

    private void write4Bytes(OutputStream outputStream, long l) {
        try {
            outputStream.write((int)(l & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 24 & 0xFFL));
        }
        catch (IOException iOException) {
            Debug.out(iOException);
        }
    }

    protected String getMessageText(String string) {
        return MessageText.getString("MagnetURLHandler.report." + string);
    }

    protected String getMessageText(String string, String string2) {
        return MessageText.getString("MagnetURLHandler.report." + string, new String[]{string2});
    }

    protected String getJS(String string) {
        return "document.write(" + string + ");" + NL;
    }

    protected String getJSS(String string) {
        return "document.write(\"" + string + "\");" + NL;
    }

    protected void writeReply(OutputStream outputStream, String string, String string2) throws IOException {
        this.writeReply(outputStream, string, string2.getBytes());
    }

    protected void writeReply(OutputStream outputStream, String string, byte[] byArray) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.print("HTTP/1.1 200 OK\r\n");
        printWriter.print("Cache-Control: no-cache\r\n");
        printWriter.print("Pragma: no-cache\r\n");
        printWriter.print("Content-Type: " + string + NL);
        printWriter.print("Content-Length: " + byArray.length + NL + NL);
        printWriter.flush();
        outputStream.write(byArray);
    }

    protected void writeNotFound(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.print("HTTP/1.0 404 Not Found\r\n\r\n");
        printWriter.flush();
    }

    public int getPort() {
        return this.port;
    }

    public void addInfo(String string, int n) {
        this.info_map.put(string, new Integer(n));
        Logger.log(new LogEvent(LOGID, 0, "MagnetURIHandler: global info registered: " + string + " -> " + n));
    }

    public void addListener(MagnetURIHandlerListener magnetURIHandlerListener) {
        this.listeners.add(magnetURIHandlerListener);
    }

    public void removeListener(MagnetURIHandlerListener magnetURIHandlerListener) {
        this.listeners.remove(magnetURIHandlerListener);
    }

    public static void main(String[] stringArray) {
        new MagnetURIHandlerImpl();
        try {
            Thread.sleep(1000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL registerResource(MagnetURIHandler.ResourceProvider resourceProvider) {
        try {
            String string = URLEncoder.encode(resourceProvider.getUID(), "UTF-8");
            Map<String, MagnetURIHandler.ResourceProvider> map = this.resources;
            synchronized (map) {
                this.resources.put(string, resourceProvider);
            }
            return new URL("http://127.0.0.1:" + this.port + "/resource." + resourceProvider.getFileType() + "?rid=" + string);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return null;
        }
    }

    static {
        class_mon = new AEMonitor("MagnetURLHandler:class");
    }
}

