/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;

public class LocalResourceHTTPServer
implements TrackerWebPageGenerator {
    private static final String my_ip = "127.0.0.1";
    private int my_port;
    private LoggerChannel logger;
    private int resource_id_next;
    private Map published_resources = new HashMap();

    public LocalResourceHTTPServer(PluginInterface pluginInterface, LoggerChannel loggerChannel) throws Exception {
        this.logger = loggerChannel;
        this.resource_id_next = new Random().nextInt(0x3FFFFFFF);
        InetAddress inetAddress = InetAddress.getByName(my_ip);
        TrackerWebContext trackerWebContext = pluginInterface.getTracker().createWebContext("Director:localResource", 0, 1, inetAddress);
        this.my_port = trackerWebContext.getURLs()[0].getPort();
        if (this.logger != null) {
            this.logger.log("Local resource publisher running on 127.0.0.1:" + this.my_port);
        }
        trackerWebContext.addPageGenerator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate(TrackerWebPageRequest trackerWebPageRequest, TrackerWebPageResponse trackerWebPageResponse) throws IOException {
        File file;
        String string = trackerWebPageRequest.getURL();
        LocalResourceHTTPServer localResourceHTTPServer = this;
        synchronized (localResourceHTTPServer) {
            file = (File)this.published_resources.get(string);
        }
        if (file == null) {
            return false;
        }
        return trackerWebPageResponse.useFile(file.getParent(), "/" + file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL publishResource(File file) throws Exception {
        LocalResourceHTTPServer localResourceHTTPServer = this;
        synchronized (localResourceHTTPServer) {
            file = file.getCanonicalFile();
            URL uRL = new URL("http://127.0.0.1:" + this.my_port + "/" + this.resource_id_next++ + "/" + file.getName());
            this.published_resources.put(uRL.getPath(), file);
            if (this.logger != null) {
                this.logger.log("Local resource added: " + file + " -> " + uRL);
            }
            return uRL;
        }
    }
}

