/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesFPListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;

public class StartStopRulesDefaultPlugin
implements Plugin,
COConfigurationListener,
AEDiagnosticsEvidenceGenerator {
    private static final String sStates = " WPRDS.XEQ";
    public static final int RANK_NONE = 0;
    public static final int RANK_SPRATIO = 1;
    public static final int RANK_SEEDCOUNT = 2;
    public static final int RANK_TIMED = 3;
    public static final int RANK_PEERCOUNT = 4;
    private static final int FORCE_CHECK_PERIOD = 60000;
    private static final int CHECK_FOR_GROSS_CHANGE_PERIOD = 30000;
    private static final int PROCESS_CHECK_PERIOD = 1500;
    private static final int MIN_SEEDING_STARTUP_WAIT = 20000;
    private static final int MIN_FIRST_SCRAPE_WAIT = 90000;
    private static final float IGNORE_SLOT_THRESHOLD_FACTOR = 0.9f;
    private AEMonitor this_mon = new AEMonitor("StartStopRules");
    private PluginInterface pi;
    protected PluginConfig plugin_config;
    private DownloadManager download_manager;
    protected LoggerChannel log;
    private RecalcSeedingRanksTask recalcSeedingRanksTask;
    private static Map<Download, DefaultRankCalculator> downloadDataMap = Collections.synchronizedMap(new HashMap());
    private volatile DefaultRankCalculator[] sortedArrayCache;
    private volatile boolean closingDown;
    private volatile boolean somethingChanged;
    private Set ranksToRecalc = new LightHashSet();
    private AEMonitor ranksToRecalc_mon = new AEMonitor("ranksToRecalc");
    private long startedOn;
    protected boolean bDebugLog;
    private int iRankType = -1;
    private int minSpeedForActiveSeeding;
    private int maxStalledSeeding;
    private int numPeersAsFullCopy;
    private int iFakeFullCopySeedStart;
    private int _maxActive;
    private boolean _maxActiveWhenSeedingEnabled;
    private int _maxActiveWhenSeeding;
    private int globalDownloadLimit;
    private int globalUploadLimit;
    private int globalUploadWhenSeedingLimit;
    private int maxDownloads;
    private int minDownloads;
    private boolean bAutoReposition;
    private long minTimeAlive;
    private boolean bAutoStart0Peers;
    private boolean bStopOnceBandwidthMet = false;
    private static boolean bAlreadyInitialized = false;
    private boolean bSWTUI = false;
    private CopyOnWriteList listenersFP = new CopyOnWriteList();
    public static boolean pauseChangeFlagChecker = false;
    private volatile boolean immediateProcessingScheduled = false;
    private long changeCheckCount = 0L;
    private long changeCheckTotalMS = 0L;
    private long changeCheckMaxMS = 0L;
    private long processCount = 0L;
    private long processTotalMS = 0L;
    private long processMaxMS = 0L;
    private long processLastComplete = 0L;
    private long processTotalGap = 0L;
    private long processTotalRecalcs = 0L;
    private long processTotalZeroRecalcs = 0L;
    private long processMergeCount = 0L;

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", "Start/Stop Rules");
    }

    public void initialize(PluginInterface pluginInterface) {
        if (bAlreadyInitialized) {
            System.err.println("StartStopRulesDefaultPlugin Already initialized!!");
        } else {
            bAlreadyInitialized = true;
        }
        AEDiagnostics.addEvidenceGenerator(this);
        this.startedOn = SystemTime.getCurrentTime();
        this.pi = pluginInterface;
        this.plugin_config = this.pi.getPluginconfig();
        this.plugin_config.setPluginConfigKeyPrefix("");
        this.download_manager = this.pi.getDownloadManager();
        UIManager uIManager = this.pi.getUIManager();
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("root", "Q");
        this.setupConfigModel(basicPluginConfigModel);
        this.pi.addListener(new PluginListener(){

            public void initializationComplete() {
            }

            public void closedownInitiated() {
                StartStopRulesDefaultPlugin.this.closingDown = true;
                COConfigurationManager.removeListener(StartStopRulesDefaultPlugin.this);
            }

            public void closedownComplete() {
            }
        });
        Runnable runnable = new Runnable(){

            public void run() {
                StartStopRulesDefaultPlugin.this.download_manager.addListener(new StartStopDMListener());
                SimpleTimer.addPeriodicEvent("StartStop:gross", 30000L, new ChangeCheckerTimerTask());
                SimpleTimer.addPeriodicEvent("StartStop:check", 1500L, new ChangeFlagCheckerTask());
            }
        };
        this.pi.getUtilities().createDelayedTask(runnable).queue();
        this.log = this.pi.getLogger().getTimeStampedChannel("StartStopRules");
        this.log.log(1, "Default StartStopRules Plugin Initialisation");
        COConfigurationManager.addListener(this);
        try {
            this.pi.getUIManager().createLoggingViewModel(this.log, true);
            this.pi.getUIManager().addUIListener(new UIManagerListener(){

                public void UIAttached(UIInstance uIInstance) {
                }

                public void UIDetached(UIInstance uIInstance) {
                }
            });
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        this.reloadConfigParams();
    }

    private void setupConfigModel(BasicPluginConfigModel basicPluginConfigModel) {
        String string = "ConfigView.label.seeding.";
        basicPluginConfigModel.addIntParameter2("StartStopManager_iRankType", "ConfigView.label.seeding.rankType", 1);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iRankTypeSeedFallback", "ConfigView.label.seeding.rankType.seed.fallback", 0);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bAutoReposition", "ConfigView.label.seeding.autoReposition", false);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMinSeedingTime", "ConfigView.label.minSeedingTime", 600);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bIgnore0Peers", "ConfigView.label.seeding.ignore0Peers", true);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iIgnoreSeedCount", "ConfigView.label.ignoreSeeds", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iIgnoreRatioPeersSeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iIgnoreShareRatioSeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 0);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bPreferLargerSwarms", "ConfigView.label.seeding.preferLargerSwarms", true);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bAutoStart0Peers", "ConfigView.label.seeding.autoStart0Peers", false);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMinPeersToBoostNoSeeds", "ConfigView.label.minPeersToBoostNoSeeds", 1);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMinSpeedForActiveDL", "ConfigView.label.minSpeedForActiveDL", 512);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMinSpeedForActiveSeeding", "ConfigView.label.minSpeedForActiveSeeding", 512);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMaxStalledSeeding", "ConfigView.label.maxStalledSeeding", 5);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bDebugLog", "ConfigView.label.queue.debuglog", false);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bNewSeedsMoveTop", "ConfigView.label.queue.newseedsmovetop", true);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iMaxActiveTorrentsWhenSeeding", "ConfigView.label.queue.maxactivetorrentswhenseeding", 0);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled", "ConfigView.label.queue.maxactivetorrentswhenseeding", false);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bStopOnceBandwidthMet", "ConfigView.label.queue.stoponcebandwidthmet", true);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_Type", "ConfigView.label.seeding.firstPriority", 1);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_ShareRatio", "ConfigView.label.seeding.firstPriority.shareRatio", 500);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_SeedingMinutes", "ConfigView.label.seeding.firstPriority.seedingMinutes", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_DLMinutes", "ConfigView.label.seeding.firstPriority.DLMinutes", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_ignoreSPRatio", "ConfigView.label.seeding.firstPriority.ignoreSPRatio", 0);
        basicPluginConfigModel.addBooleanParameter2("StartStopManager_bFirstPriority_ignore0Peer", "ConfigView.label.seeding.firstPriority.ignore0Peer", !COConfigurationManager.getStringParameter("ui", "").equals("az2"));
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFirstPriority_ignoreIdleHours", "ConfigView.label.seeding.firstPriority.ignoreIdleHours", 24);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iAddForSeedingDLCopyCount", "ConfigView.label.seeding.addForSeedingDLCopyCount", 1);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iNumPeersAsFullCopy", string + "numPeersAsFullCopy", 0);
        basicPluginConfigModel.addIntParameter2("StartStopManager_iFakeFullCopySeedStart", string + "fakeFullCopySeedStart", 1);
        basicPluginConfigModel.destroy();
    }

    public static DefaultRankCalculator getRankCalculator(Download download) {
        return downloadDataMap.get(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcAllSeedingRanks(boolean bl) {
        if (this.closingDown) {
            return;
        }
        try {
            DefaultRankCalculator[] defaultRankCalculatorArray;
            this.this_mon.enter();
            Map<Download, DefaultRankCalculator> map = downloadDataMap;
            synchronized (map) {
                defaultRankCalculatorArray = downloadDataMap.values().toArray(new DefaultRankCalculator[0]);
            }
            for (int i = 0; i < defaultRankCalculatorArray.length; ++i) {
                if (bl) {
                    defaultRankCalculatorArray[i].getDownloadObject().setSeedingRank(0);
                }
                defaultRankCalculatorArray[i].recalcSeedingRank();
            }
            Object var6_6 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void configurationSaved() {
        new AEThread2("reloadConfigParams", true){

            public void run() {
                StartStopRulesDefaultPlugin.this.reloadConfigParams();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigParams() {
        try {
            this.this_mon.enter();
            int n = this.plugin_config.getIntParameter("StartStopManager_iRankType");
            this.minSpeedForActiveSeeding = this.plugin_config.getIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
            this.maxStalledSeeding = this.plugin_config.getIntParameter("StartStopManager_iMaxStalledSeeding");
            if (this.maxStalledSeeding <= 0) {
                this.maxStalledSeeding = 999;
            }
            this._maxActive = this.plugin_config.getIntParameter("max active torrents");
            this._maxActiveWhenSeedingEnabled = this.plugin_config.getBooleanParameter("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
            this._maxActiveWhenSeeding = this.plugin_config.getIntParameter("StartStopManager_iMaxActiveTorrentsWhenSeeding");
            this.minDownloads = this.plugin_config.getIntParameter("min downloads");
            this.maxDownloads = this.plugin_config.getIntParameter("max downloads");
            this.numPeersAsFullCopy = this.plugin_config.getIntParameter("StartStopManager_iNumPeersAsFullCopy");
            this.iFakeFullCopySeedStart = this.plugin_config.getIntParameter("StartStopManager_iFakeFullCopySeedStart");
            this.bAutoReposition = this.plugin_config.getBooleanParameter("StartStopManager_bAutoReposition");
            this.minTimeAlive = this.plugin_config.getIntParameter("StartStopManager_iMinSeedingTime") * 1000;
            this.bDebugLog = this.plugin_config.getBooleanParameter("StartStopManager_bDebugLog");
            this.bAutoStart0Peers = this.plugin_config.getBooleanParameter("StartStopManager_bAutoStart0Peers");
            this.globalDownloadLimit = this.plugin_config.getIntParameter("Max Download Speed KBs", 0);
            this.globalUploadLimit = this.plugin_config.getIntParameter("Max Upload Speed KBs", 0);
            this.globalUploadWhenSeedingLimit = this.plugin_config.getBooleanParameter("enable.seedingonly.upload.rate") ? this.plugin_config.getIntParameter("Max Upload Speed Seeding KBs", 0) : this.globalUploadLimit;
            this.bStopOnceBandwidthMet = this.plugin_config.getBooleanParameter("StartStopManager_bStopOnceBandwidthMet");
            boolean bl = this.plugin_config.getBooleanParameter("StartStopManager_bNewSeedsMoveTop");
            this.plugin_config.setBooleanParameter("Newly Seeding Torrents Get First Priority", bl);
            if (n != this.iRankType) {
                this.iRankType = n;
                if (this.iRankType == 3) {
                    if (this.recalcSeedingRanksTask == null) {
                        this.recalcSeedingRanksTask = new RecalcSeedingRanksTask();
                        SimpleTimer.addPeriodicEvent("StartStop:recalcSR", 1000L, this.recalcSeedingRanksTask);
                    }
                } else if (this.recalcSeedingRanksTask != null) {
                    this.recalcSeedingRanksTask.cancel();
                    this.recalcSeedingRanksTask = null;
                }
            }
            Collection<DefaultRankCalculator> collection = downloadDataMap.values();
            DefaultRankCalculator[] defaultRankCalculatorArray = collection.toArray(new DefaultRankCalculator[0]);
            for (int i = 0; i < defaultRankCalculatorArray.length; ++i) {
                defaultRankCalculatorArray[i].getDownloadObject().setSeedingRank(0);
            }
            try {
                this.ranksToRecalc_mon.enter();
                Map<Download, DefaultRankCalculator> map = downloadDataMap;
                synchronized (map) {
                    this.ranksToRecalc.addAll(collection);
                }
                Object var8_8 = null;
                this.ranksToRecalc_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.ranksToRecalc_mon.exit();
                throw throwable;
            }
            this.requestProcessCycle(null);
            if (this.bDebugLog) {
                // empty if block
            }
            Object var10_11 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    private int calcMaxSeeders(int n) {
        int n2 = this.getMaxActive();
        if (n2 == 0) {
            return 999999;
        }
        return n2 - n;
    }

    protected int getMaxActive() {
        if (!this._maxActiveWhenSeedingEnabled) {
            return this._maxActive;
        }
        if (this.download_manager.isSeedingOnly()) {
            if (this._maxActiveWhenSeeding <= this._maxActive) {
                return this._maxActiveWhenSeeding;
            }
            Download[] downloadArray = this.download_manager.getDownloads();
            boolean bl = false;
            block0: for (int i = 0; i < downloadArray.length && !bl; ++i) {
                Download download = downloadArray[i];
                int n = download.getState();
                if (n == 4 || n == 5 || n == 7 || n == 6 || n == 8) continue;
                DiskManagerFileInfo[] diskManagerFileInfoArray = download.getDiskManagerFileInfo();
                for (int j = 0; j < diskManagerFileInfoArray.length; ++j) {
                    DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[j];
                    if (diskManagerFileInfo.isSkipped() || diskManagerFileInfo.getDownloaded() == diskManagerFileInfo.getLength()) continue;
                    bl = true;
                    continue block0;
                }
            }
            if (!bl) {
                return this._maxActiveWhenSeeding;
            }
        }
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        block35: {
            long l = 0L;
            try {
                Object[] objectArray;
                Object object;
                Object[] objectArray2;
                this.this_mon.enter();
                l = SystemTime.getCurrentTime();
                this.somethingChanged = false;
                try {
                    this.ranksToRecalc_mon.enter();
                    objectArray2 = this.ranksToRecalc.toArray();
                    this.ranksToRecalc.clear();
                    object = null;
                    this.ranksToRecalc_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.ranksToRecalc_mon.exit();
                    throw throwable;
                }
                for (int i = 0; i < objectArray2.length; ++i) {
                    object = (DefaultRankCalculator)objectArray2[i];
                    if (this.bDebugLog) {
                        long l2 = ((DefaultRankCalculator)object).dl.getSeedingRank();
                        ((DefaultRankCalculator)object).recalcSeedingRank();
                        String string = "recalc seeding rank.  old/new=" + l2 + "/" + ((DefaultRankCalculator)object).dl.getSeedingRank();
                        this.log.log((Object)((DefaultRankCalculator)object).dl.getTorrent(), 1, string);
                        continue;
                    }
                    ((DefaultRankCalculator)object).recalcSeedingRank();
                }
                this.processTotalRecalcs += (long)objectArray2.length;
                if (objectArray2.length == 0) {
                    ++this.processTotalZeroRecalcs;
                }
                if (this.sortedArrayCache != null && this.sortedArrayCache.length == downloadDataMap.size()) {
                    objectArray = this.sortedArrayCache;
                } else {
                    object = downloadDataMap;
                    synchronized (object) {
                        this.sortedArrayCache = downloadDataMap.values().toArray(new DefaultRankCalculator[downloadDataMap.size()]);
                        objectArray = this.sortedArrayCache;
                    }
                }
                object = new TotalsStats((DefaultRankCalculator[])objectArray);
                String[] stringArray = null;
                if (this.bDebugLog) {
                    this.log.log(1, ">>process()");
                    stringArray = new String[]{"ok2Start=" + this.boolDebug(((TotalsStats)object).bOkToStartSeeding), "tFrcdCding=" + ((TotalsStats)object).forcedSeeding, "actvCDs=" + ((TotalsStats)object).activelyCDing, "tW8tingToCd=" + ((TotalsStats)object).waitingToSeed, "tDLing=" + ((TotalsStats)object).downloading, "actvDLs=" + ((TotalsStats)object).activelyDLing, "tW8tingToDL=" + ((TotalsStats)object).waitingToDL, "tCom=" + ((TotalsStats)object).complete, "tIncQd=" + ((TotalsStats)object).incompleteQueued, "mxCdrs=" + ((TotalsStats)object).maxSeeders, "tFP=" + ((TotalsStats)object).firstPriority, "maxT=" + ((TotalsStats)object).maxTorrents, "maxA=" + ((TotalsStats)object).maxActive};
                }
                Arrays.sort(objectArray);
                ProcessVars processVars = new ProcessVars();
                processVars.numWaitingOrSeeding = ((TotalsStats)object).forcedSeeding;
                processVars.numWaitingOrDLing = 0;
                processVars.higherCDtoStart = false;
                processVars.higherDLtoStart = false;
                processVars.posComplete = 0;
                processVars.stalledSeeders = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    int n;
                    Object object2 = objectArray[i];
                    Download download = ((DefaultRankCalculator)object2).getDownloadObject();
                    processVars.bStopAndQueued = false;
                    ((DefaultRankCalculator)object2).sTrace = "";
                    if (download.getState() == 1) {
                        try {
                            download.initialize();
                            String string = "initialize: state is waiting";
                            this.log.log((Object)download.getTorrent(), 1, string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.bDebugLog && download.getState() == 1) {
                            ((DefaultRankCalculator)object2).sTrace = ((DefaultRankCalculator)object2).sTrace + "still in waiting state after initialize!\n";
                        }
                    }
                    if (this.bAutoReposition && this.iRankType != 0 && download.isComplete() && (((TotalsStats)object).bOkToStartSeeding || ((TotalsStats)object).firstPriority > 0)) {
                        download.setPosition(++processVars.posComplete);
                    }
                    if ((n = download.getState()) == 6 || n == 7 || n == 8) continue;
                    if (download.isForceStart()) {
                        String string;
                        if (n == 7 || n == 9) {
                            try {
                                download.restart();
                                string = "restart: isForceStart";
                                this.log.log((Object)download.getTorrent(), 1, string);
                                ((DefaultRankCalculator)object2).sTrace = ((DefaultRankCalculator)object2).sTrace + string + "\n";
                            }
                            catch (DownloadException downloadException) {
                                // empty catch block
                            }
                            n = download.getState();
                        }
                        if (n == 3) {
                            try {
                                download.start();
                                string = "Start: isForceStart";
                                this.log.log((Object)download.getTorrent(), 1, string);
                                ((DefaultRankCalculator)object2).sTrace = ((DefaultRankCalculator)object2).sTrace + string + "\n";
                            }
                            catch (DownloadException downloadException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!download.isComplete()) {
                        this.handleInCompleteDownload((DefaultRankCalculator)object2, processVars, (TotalsStats)object);
                        continue;
                    }
                    this.handleCompletedDownload((DefaultRankCalculator[])objectArray, (DefaultRankCalculator)object2, processVars, (TotalsStats)object);
                }
                if (this.bDebugLog) {
                    String[] stringArray2 = new String[]{"ok2Start=" + this.boolDebug(((TotalsStats)object).bOkToStartSeeding), "tFrcdCding=" + ((TotalsStats)object).forcedSeeding, "actvCDs=" + ((TotalsStats)object).activelyCDing, "tW8tingToCd=" + ((TotalsStats)object).waitingToSeed, "tDLing=" + ((TotalsStats)object).downloading, "actvDLs=" + ((TotalsStats)object).activelyDLing, "tW8tingToDL=" + ((TotalsStats)object).waitingToDL, "tCom=" + ((TotalsStats)object).complete, "tIncQd=" + ((TotalsStats)object).incompleteQueued, "mxCdrs=" + ((TotalsStats)object).maxSeeders, "tFP=" + ((TotalsStats)object).firstPriority, "maxT=" + ((TotalsStats)object).maxTorrents, "maxA=" + ((TotalsStats)object).maxActive};
                    this.printDebugChanges("<<process() ", stringArray, stringArray2, "", "", true, null);
                }
                Object var14_23 = null;
                if (l <= 0L) break block35;
                ++this.processCount;
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                if (l > 0L) {
                    ++this.processCount;
                    long l3 = SystemTime.getCurrentTime() - l;
                    if (this.bDebugLog) {
                        this.log.log(1, "process() took " + l3);
                    }
                    this.processTotalMS += l3;
                    if (l3 > this.processMaxMS) {
                        this.processMaxMS = l3;
                    }
                    if (this.processLastComplete > 0L) {
                        this.processTotalGap += l - this.processLastComplete;
                    }
                    this.processLastComplete = l;
                }
                this.immediateProcessingScheduled = false;
                this.this_mon.exit();
                throw throwable;
            }
            long l4 = SystemTime.getCurrentTime() - l;
            if (this.bDebugLog) {
                this.log.log(1, "process() took " + l4);
            }
            this.processTotalMS += l4;
            if (l4 > this.processMaxMS) {
                this.processMaxMS = l4;
            }
            if (this.processLastComplete > 0L) {
                this.processTotalGap += l - this.processLastComplete;
            }
            this.processLastComplete = l;
            {
            }
        }
        this.immediateProcessingScheduled = false;
        this.this_mon.exit();
    }

    private void handleInCompleteDownload(DefaultRankCalculator defaultRankCalculator, ProcessVars processVars, TotalsStats totalsStats) {
        int n;
        boolean bl;
        int n2;
        boolean bl2;
        boolean bl3;
        int n3;
        Download download = defaultRankCalculator.dl;
        int n4 = download.getState();
        if (download.isForceStart()) {
            if (this.bDebugLog) {
                String string = "isForceStart.. rules skipped";
                this.log.log((Object)download.getTorrent(), 1, string);
                defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
            }
            return;
        }
        if (n4 == 2) {
            ++processVars.numWaitingOrDLing;
            if (this.bDebugLog) {
                String string = "ST_PREPARING.. rules skipped. numW8tngorDLing=" + processVars.numWaitingOrDLing;
                this.log.log((Object)download.getTorrent(), 1, string);
                defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
            }
            return;
        }
        int n5 = 0;
        if (totalsStats.maxActive == 0) {
            n5 = this.maxDownloads;
        } else {
            n3 = 0;
            n3 = totalsStats.stalledFPSeeders + totalsStats.forcedActive + totalsStats.maxActive - totalsStats.firstPriority - totalsStats.forcedSeedingNonFP;
            int n6 = n3 <= 0 ? 0 : (n5 = this.maxDownloads - n3 <= 0 ? this.maxDownloads : n3);
        }
        if (n5 < this.minDownloads) {
            n5 = this.minDownloads;
        }
        n3 = defaultRankCalculator.getActivelyDownloading();
        if (this.bStopOnceBandwidthMet) {
            bl3 = download.getState() == 4;
            bl2 = this.globalDownloadLimit > 0 && (float)(processVars.accumulatedDownloadSpeed / 1024L) > (float)this.globalDownloadLimit * 0.9f;
            n2 = n3 != 0 || bl3 && bl2 ? 1 : 0;
            boolean bl4 = bl = n2 != 0 && n3 == 0;
            if (bl) {
                ++totalsStats.activelyDLing;
                totalsStats.maxSeeders = this.calcMaxSeeders(totalsStats.activelyDLing + totalsStats.waitingToDL);
            }
        } else {
            bl2 = false;
            n2 = n3;
            bl = false;
        }
        if (this.bDebugLog) {
            String string = ">> DL state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + processVars.numWaitingOrDLing + ";maxCDrs=" + totalsStats.maxSeeders + ";forced=" + this.boolDebug(download.isForceStart()) + ";actvDLs=" + totalsStats.activelyDLing + ";maxDLs=" + n5 + ";ActDLing=" + this.boolDebug(n3 != 0) + ";globDwnRchd=" + this.boolDebug(bl2) + ";hgherQd=" + this.boolDebug(processVars.higherDLtoStart) + ";isCmplt=" + this.boolDebug(download.isComplete());
            this.log.log((Object)download.getTorrent(), 1, string);
            defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
        }
        if (n4 == 4 && n2 != 0 || n4 == 3 || n4 == 1 || n4 == 2) {
            ++processVars.numWaitingOrDLing;
        }
        if (n4 == 3 || n4 == 4 || n4 == 1) {
            boolean bl5;
            bl3 = processVars.numWaitingOrDLing > n5 || processVars.numWaitingOrDLing >= n5 && processVars.higherDLtoStart;
            boolean bl6 = bl5 = n4 == 4;
            if (this.maxDownloads != 0 && bl3 && (n2 != 0 || !bl5 || bl5 && totalsStats.maxActive != 0 && n2 == 0 && totalsStats.activelyCDing + totalsStats.activelyDLing >= totalsStats.maxActive)) {
                try {
                    if (this.bDebugLog) {
                        String string = "   stopAndQueue: " + processVars.numWaitingOrDLing + " waiting or downloading, when limit is " + n5 + "(" + this.maxDownloads + ")";
                        if (processVars.higherDLtoStart) {
                            string = string + " and higher DL is starting";
                        }
                        this.log.log((Object)download.getTorrent(), 1, string);
                        defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
                    }
                    download.stopAndQueue();
                    --processVars.numWaitingOrDLing;
                    if (n4 == 4) {
                        --totalsStats.downloading;
                        if (n3 != 0 || bl) {
                            --totalsStats.activelyDLing;
                        }
                    } else {
                        --totalsStats.waitingToDL;
                    }
                    totalsStats.maxSeeders = this.calcMaxSeeders(totalsStats.activelyDLing + totalsStats.waitingToDL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n4 = download.getState();
            } else if (this.bDebugLog) {
                String string = "NOT queuing: ";
                string = this.maxDownloads == 0 ? string + "maxDownloads = " + this.maxDownloads : (!bl3 ? string + "not over limit.  numWaitingOrDLing(" + processVars.numWaitingOrDLing + ") <= maxDLs(" + n5 + ")" : (n3 == 0 || bl5 ? string + "not actively downloading" : (totalsStats.maxActive == 0 ? string + "unlimited active allowed (set)" : string + "# active(" + (totalsStats.activelyCDing + totalsStats.activelyDLing) + ") < maxActive(" + totalsStats.maxActive + ")")));
                this.log.log((Object)download.getTorrent(), 1, string);
                defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
            }
        }
        if (n4 == 3 && (this.maxDownloads == 0 || totalsStats.activelyDLing < n5)) {
            try {
                if (this.bDebugLog) {
                    String string = "   start: READY && activelyDLing (" + totalsStats.activelyDLing + ") < maxDLs (" + this.maxDownloads + ")";
                    this.log.log((Object)download.getTorrent(), 1, string);
                    defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
                }
                download.start();
                --totalsStats.waitingToDL;
                ++totalsStats.activelyDLing;
                totalsStats.maxSeeders = this.calcMaxSeeders(totalsStats.activelyDLing + totalsStats.waitingToDL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n4 = download.getState();
        }
        if (n4 == 9 && (this.maxDownloads == 0 || processVars.numWaitingOrDLing < n5)) {
            try {
                if (this.bDebugLog) {
                    String string = "   restart: QUEUED && numWaitingOrDLing (" + processVars.numWaitingOrDLing + ") < maxDLS (" + n5 + ")";
                    this.log.log(1, string);
                    defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
                }
                download.restart();
                ++processVars.numWaitingOrDLing;
                ++totalsStats.waitingToDL;
                totalsStats.maxSeeders = this.calcMaxSeeders(totalsStats.activelyDLing + totalsStats.waitingToDL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n4 = download.getState();
        }
        if ((n = n4) != (n4 = download.getState())) {
            if (this.bDebugLog) {
                this.log.log(1, ">> somethingChanged: state");
            }
            this.somethingChanged = true;
        }
        if (download.getSeedingRank() >= 0 && (n4 == 9 || n4 == 3 || n4 == 1 || n4 == 2)) {
            processVars.higherDLtoStart = true;
        }
        if (this.bDebugLog) {
            String string = "<< DL state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + processVars.numWaitingOrDLing + ";maxCDrs=" + totalsStats.maxSeeders + ";forced=" + this.boolDebug(download.isForceStart()) + ";actvDLs=" + totalsStats.activelyDLing + ";hgherQd=" + this.boolDebug(processVars.higherDLtoStart) + ";ActDLing=" + this.boolDebug(defaultRankCalculator.getActivelyDownloading());
            this.log.log((Object)download.getTorrent(), 1, string);
            defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string + "\n";
        }
        if (this.bStopOnceBandwidthMet) {
            processVars.accumulatedDownloadSpeed += download.getStats().getDownloadAverage();
            processVars.accumulatedUploadSpeed += download.getStats().getUploadAverage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCompletedDownload(DefaultRankCalculator[] defaultRankCalculatorArray, DefaultRankCalculator defaultRankCalculator, ProcessVars processVars, TotalsStats totalsStats) {
        boolean bl;
        String string;
        String[] stringArray;
        Download download;
        block73: {
            block72: {
                block71: {
                    if (!totalsStats.bOkToStartSeeding) {
                        return;
                    }
                    download = defaultRankCalculator.dl;
                    int n = download.getState();
                    boolean bl2 = n == 3 || n == 5;
                    stringArray = null;
                    string = "";
                    int n2 = defaultRankCalculator.lastModifiedScrapeResultPeers;
                    bl = false;
                    if (this.bDebugLog) {
                        bl = defaultRankCalculator.isFirstPriority();
                        stringArray = new String[]{"CD state=" + sStates.charAt(n), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + processVars.numWaitingOrSeeding, "nWorDLing=" + processVars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(processVars.higherCDtoStart), "maxCDrs=" + totalsStats.maxSeeders, "FP=" + this.boolDebug(bl), "nActCDing=" + totalsStats.activelyCDing, "ActCDing=" + this.boolDebug(defaultRankCalculator.getActivelySeeding()), "nSeeds=" + defaultRankCalculator.lastModifiedScrapeResultSeeds, "nPeers=" + defaultRankCalculator.lastModifiedScrapeResultPeers};
                    }
                    try {
                        int n3;
                        int n4;
                        block74: {
                            boolean bl3;
                            boolean bl4;
                            boolean bl5;
                            boolean bl6;
                            block77: {
                                block75: {
                                    boolean bl7;
                                    block76: {
                                        block78: {
                                            boolean bl8;
                                            boolean bl9;
                                            boolean bl10;
                                            boolean bl11 = defaultRankCalculator.lastScrapeResultOk;
                                            if (this.bAutoStart0Peers && n2 == 0 && bl11) {
                                                if (n == 9) {
                                                    try {
                                                        if (this.bDebugLog) {
                                                            string = string + "\nrestart() 0Peers";
                                                        }
                                                        download.restart();
                                                        ++totalsStats.waitingToSeed;
                                                        ++processVars.numWaitingOrSeeding;
                                                        n = download.getState();
                                                        if (n == 3) {
                                                            if (this.bDebugLog) {
                                                                string = string + "\nstart(); 0Peers";
                                                            }
                                                            download.start();
                                                            ++totalsStats.activelyCDing;
                                                        }
                                                    }
                                                    catch (Exception exception) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (n == 3) {
                                                    try {
                                                        if (this.bDebugLog) {
                                                            string = string + "\nstart(); 0Peers";
                                                        }
                                                        download.start();
                                                        ++totalsStats.activelyCDing;
                                                        ++processVars.numWaitingOrSeeding;
                                                    }
                                                    catch (Exception exception) {
                                                    }
                                                }
                                                Object var25_16 = null;
                                                if (!this.bDebugLog) {
                                                    return;
                                                }
                                                break block71;
                                            }
                                            n4 = download.getSeedingRank();
                                            if (!(n4 >= -1 || download.isForceStart() || bl2 || this.bAutoStart0Peers)) {
                                                if (!this.bDebugLog) break block72;
                                                string = string + "\n  Skip !forceStart";
                                                int n5 = n4 * -1;
                                                if (n5 < DefaultRankCalculator.SR_NEGATIVE_DEBUG.length) {
                                                    string = string + " && " + DefaultRankCalculator.SR_NEGATIVE_DEBUG[n5];
                                                }
                                                break block72;
                                            }
                                            if (processVars.higherCDtoStart && !download.isForceStart() && !this.bAutoStart0Peers && !bl2) {
                                                string = string + " a torrent with a higher rank is queued or starting";
                                            }
                                            if (this.bDebugLog && this.bAutoStart0Peers && n2 == 0 && !bl11 && (n == 9 || n == 3)) {
                                                string = string + "\n  NOT starting 0 Peer torrent because scrape isn't ok";
                                            }
                                            if (!this.bDebugLog) {
                                                bl = defaultRankCalculator.isFirstPriority();
                                            }
                                            bl6 = defaultRankCalculator.getActivelySeeding();
                                            if (this.bStopOnceBandwidthMet) {
                                                bl10 = download.getState() == 5;
                                                bl9 = totalsStats.maxUploadSpeed() > 0 && (float)(processVars.accumulatedUploadSpeed / 1024L) > (float)totalsStats.maxUploadSpeed() * 0.9f;
                                                bl8 = this.globalDownloadLimit > 0 && (float)(processVars.accumulatedDownloadSpeed / 1024L) > (float)this.globalDownloadLimit * 0.9f;
                                                bl5 = bl6 || bl10 && (bl9 || bl8);
                                                boolean bl12 = bl4 = bl5 && !bl6;
                                                if (bl4) {
                                                    ++totalsStats.activelyCDing;
                                                }
                                            } else {
                                                bl9 = false;
                                                bl5 = bl6;
                                                bl8 = false;
                                                bl4 = false;
                                            }
                                            if (n == 5 && !bl6) {
                                                ++processVars.stalledSeeders;
                                            }
                                            boolean bl13 = bl10 = bl2 && (!bl || bl && totalsStats.maxActive != 0 && processVars.numWaitingOrSeeding >= totalsStats.maxActive - this.minDownloads) && !download.isForceStart();
                                            if (bl10 && n == 5 && this.iRankType != 3) {
                                                long l = SystemTime.getCurrentTime() - download.getStats().getTimeStarted();
                                                boolean bl14 = bl10 = l >= this.minTimeAlive;
                                                if (!bl10 && this.bDebugLog) {
                                                    string = string + "\n  Torrent can't be stopped yet, timeAlive(" + l + ") < minTimeAlive(" + this.minTimeAlive + ")";
                                                }
                                            }
                                            if (n != 9 && (n == 3 || n == 1 || n == 2 || n == 5 && bl5 && !download.isForceStart())) {
                                                ++processVars.numWaitingOrSeeding;
                                                if (this.bDebugLog) {
                                                    string = string + "\n  Torrent is waiting or seeding";
                                                }
                                            }
                                            if (!(bl10 || n != 9 || totalsStats.maxActive != 0 && processVars.numWaitingOrSeeding >= totalsStats.maxSeeders || n4 < -1 || processVars.stalledSeeders >= this.maxStalledSeeding || processVars.higherCDtoStart)) {
                                                try {
                                                    if (this.bDebugLog) {
                                                        string = string + "\n  restart: ok2Q=" + bl10 + "; QUEUED && numWaitingOrSeeding( " + processVars.numWaitingOrSeeding + ") < maxSeeders (" + totalsStats.maxSeeders + ")";
                                                    }
                                                    download.restart();
                                                    bl10 = false;
                                                    ++totalsStats.waitingToSeed;
                                                    ++processVars.numWaitingOrSeeding;
                                                    if (this.iRankType == 3) {
                                                        defaultRankCalculator.recalcSeedingRank();
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                n = download.getState();
                                            } else if (this.bDebugLog && n == 9) {
                                                string = string + "\n  NOT restarting:";
                                                if (n4 < -1) {
                                                    string = string + " torrent is being ignored";
                                                    int n6 = n4 * -1;
                                                    if (n6 < DefaultRankCalculator.SR_NEGATIVE_DEBUG.length) {
                                                        string = string + ": " + DefaultRankCalculator.SR_NEGATIVE_DEBUG[n6];
                                                    }
                                                } else if (processVars.higherCDtoStart) {
                                                    string = string + " a torrent with a higher rank is queued or starting";
                                                } else {
                                                    if (bl10) {
                                                        string = string + " no starting of okToQueue'd;";
                                                    }
                                                    string = processVars.numWaitingOrSeeding >= totalsStats.maxSeeders ? string + " at limit, numWaitingOrSeeding(" + processVars.numWaitingOrSeeding + ") >= maxSeeders(" + totalsStats.maxSeeders + ")" : (processVars.stalledSeeders >= this.maxStalledSeeding ? string + " at limit, stalledSeeders(" + processVars.stalledSeeders + ") >= maxStalledSeeding(" + this.maxStalledSeeding + ") " : string + "huh? qd=" + (n == 9) + "; " + totalsStats.maxActive + ";" + (processVars.numWaitingOrSeeding < totalsStats.maxSeeders) + ";" + (processVars.stalledSeeders <= this.maxStalledSeeding) + ";ignore?" + (n4 >= -1));
                                                }
                                            }
                                            boolean bl15 = false;
                                            if (n == 3 && totalsStats.activelyCDing < totalsStats.maxSeeders) {
                                                if (n4 >= -1 || download.isForceStart()) {
                                                    try {
                                                        if (this.bDebugLog) {
                                                            string = string + "\n  start: READY && total activelyCDing(" + totalsStats.activelyCDing + ") < maxSeeders(" + totalsStats.maxSeeders + ")";
                                                        }
                                                        download.start();
                                                        bl10 = false;
                                                    }
                                                    catch (Exception exception) {
                                                        // empty catch block
                                                    }
                                                    n = download.getState();
                                                    ++totalsStats.activelyCDing;
                                                    bl6 = true;
                                                    bl5 = true;
                                                    ++processVars.numWaitingOrSeeding;
                                                } else if (bl10) {
                                                    bl15 = true;
                                                }
                                            }
                                            if (!bl10 && !bl15) break block74;
                                            bl3 = bl15;
                                            if (bl3) break block75;
                                            bl7 = processVars.numWaitingOrSeeding > totalsStats.maxSeeders || !bl6 && processVars.stalledSeeders > this.maxStalledSeeding || processVars.numWaitingOrSeeding >= totalsStats.maxSeeders && processVars.higherCDtoStart;
                                            n3 = n == 5 ? 1 : 0;
                                            boolean bl16 = bl3 = !download.isChecking() && (bl7 || n4 < -1) && (bl5 || n3 == 0 || !bl5 && n3 != 0);
                                            if (!this.bDebugLog) break block76;
                                            if (!bl3) break block77;
                                            string = string + "\n  stopAndQueue: ";
                                            if (bl7) {
                                                string = processVars.higherCDtoStart ? string + "higherQueued (it should be seeding instead of this one)" : (!bl6 && processVars.stalledSeeders > totalsStats.maxSeeders ? string + "over stale seeds limit" : string + "over limit");
                                            } else if (n4 < -1) {
                                                string = string + "ignoreRule met";
                                            }
                                            string = string + " && ";
                                            if (!bl6) break block78;
                                            string = string + "activelySeeding";
                                            break block77;
                                        }
                                        if (n3 == 0) {
                                            string = string + "not SEEDING";
                                            break block77;
                                        } else if (!bl6 && n3 != 0) {
                                            string = string + "SEEDING, but not actively";
                                        }
                                        break block77;
                                    }
                                    string = string + "\n  NOT queuing: ";
                                    string = download.isChecking() ? string + "can't auto-queue a checking torrent" : (!bl7 ? string + "not over limit.  numWaitingOrSeeding(" + processVars.numWaitingOrSeeding + ") <= maxSeeders(" + totalsStats.maxSeeders + ")" : string + "bActivelySeeding=" + bl6 + ";bSeeding" + (n3 != 0));
                                    break block77;
                                }
                                if (this.bDebugLog) {
                                    string = string + "\n  Forcing a stop..";
                                }
                            }
                            if (bl3) {
                                try {
                                    if (n == 3) {
                                        --totalsStats.waitingToSeed;
                                    }
                                    download.stopAndQueue();
                                    processVars.bStopAndQueued = true;
                                    if (bl6 || bl4) {
                                        --totalsStats.activelyCDing;
                                        bl6 = false;
                                    }
                                    if (bl5) {
                                        --processVars.numWaitingOrSeeding;
                                        bl5 = false;
                                    }
                                    if (n == 3) {
                                        --totalsStats.waitingToSeed;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                n = download.getState();
                            }
                        }
                        if (processVars.bStopAndQueued && this.iRankType == 3) {
                            for (int i = 0; i < defaultRankCalculatorArray.length; ++i) {
                                Download download2 = defaultRankCalculatorArray[i].getDownloadObject();
                                n3 = download2.getSeedingRank();
                                if (n3 <= 0 || n3 >= 999999) continue;
                                download2.setSeedingRank(n3 + 1);
                            }
                            n4 = 999999 - totalsStats.complete;
                            download.setSeedingRank(n4);
                        }
                        n = download.getState();
                        if (n4 >= 0 && (n == 9 || n == 3 || n == 1 || n == 2)) {
                            processVars.higherCDtoStart = true;
                        }
                        break block73;
                    }
                    catch (Throwable throwable) {
                        Object var25_19 = null;
                        if (!this.bDebugLog) throw throwable;
                        String[] stringArray2 = new String[]{"CD state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + processVars.numWaitingOrSeeding, "nWorDLing=" + processVars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(processVars.higherCDtoStart), "maxCDrs=" + totalsStats.maxSeeders, "FP=" + this.boolDebug(bl), "nActCDing=" + totalsStats.activelyCDing, "ActCDing=" + this.boolDebug(defaultRankCalculator.getActivelySeeding()), "nSeeds=" + defaultRankCalculator.lastModifiedScrapeResultSeeds, "nPeers=" + defaultRankCalculator.lastModifiedScrapeResultPeers};
                        this.printDebugChanges("", stringArray, stringArray2, string, "  ", true, defaultRankCalculator);
                        throw throwable;
                    }
                }
                String[] stringArray3 = new String[]{"CD state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + processVars.numWaitingOrSeeding, "nWorDLing=" + processVars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(processVars.higherCDtoStart), "maxCDrs=" + totalsStats.maxSeeders, "FP=" + this.boolDebug(bl), "nActCDing=" + totalsStats.activelyCDing, "ActCDing=" + this.boolDebug(defaultRankCalculator.getActivelySeeding()), "nSeeds=" + defaultRankCalculator.lastModifiedScrapeResultSeeds, "nPeers=" + defaultRankCalculator.lastModifiedScrapeResultPeers};
                this.printDebugChanges("", stringArray, stringArray3, string, "  ", true, defaultRankCalculator);
                return;
            }
            Object var25_17 = null;
            if (!this.bDebugLog) return;
            String[] stringArray4 = new String[]{"CD state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + processVars.numWaitingOrSeeding, "nWorDLing=" + processVars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(processVars.higherCDtoStart), "maxCDrs=" + totalsStats.maxSeeders, "FP=" + this.boolDebug(bl), "nActCDing=" + totalsStats.activelyCDing, "ActCDing=" + this.boolDebug(defaultRankCalculator.getActivelySeeding()), "nSeeds=" + defaultRankCalculator.lastModifiedScrapeResultSeeds, "nPeers=" + defaultRankCalculator.lastModifiedScrapeResultPeers};
            this.printDebugChanges("", stringArray, stringArray4, string, "  ", true, defaultRankCalculator);
            return;
        }
        Object var25_18 = null;
        if (this.bDebugLog) {
            String[] stringArray5 = new String[]{"CD state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + processVars.numWaitingOrSeeding, "nWorDLing=" + processVars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(processVars.higherCDtoStart), "maxCDrs=" + totalsStats.maxSeeders, "FP=" + this.boolDebug(bl), "nActCDing=" + totalsStats.activelyCDing, "ActCDing=" + this.boolDebug(defaultRankCalculator.getActivelySeeding()), "nSeeds=" + defaultRankCalculator.lastModifiedScrapeResultSeeds, "nPeers=" + defaultRankCalculator.lastModifiedScrapeResultPeers};
            this.printDebugChanges("", stringArray, stringArray5, string, "  ", true, defaultRankCalculator);
        }
        if (!this.bStopOnceBandwidthMet) return;
        processVars.accumulatedUploadSpeed += download.getStats().getUploadAverage();
    }

    private String boolDebug(boolean bl) {
        return bl ? "Y" : "N";
    }

    private void printDebugChanges(String string, String[] stringArray, String[] stringArray2, String string2, String string3, boolean bl, DefaultRankCalculator defaultRankCalculator) {
        boolean bl2 = false;
        String string4 = string;
        StringBuffer stringBuffer = new StringBuffer(120);
        StringBuffer stringBuffer2 = new StringBuffer(120);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) {
                string4 = string4 + stringArray[i] + ";";
                continue;
            }
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(";");
            stringBuffer2.append(stringArray2[i]);
            stringBuffer2.append(";");
            bl2 = true;
        }
        String string5 = (bl || bl2 ? string4 : "") + (bl2 ? "\nOld:" + stringBuffer + "\nNew:" + stringBuffer2 : "") + string2;
        if (!string5.equals("")) {
            String[] stringArray3 = string5.split("\n");
            for (int i = 0; i < stringArray3.length; ++i) {
                String string6 = string3 + (i > 0 ? "  " : "") + stringArray3[i];
                if (defaultRankCalculator == null) {
                    this.log.log(1, string6);
                    continue;
                }
                this.log.log((Object)defaultRankCalculator.dl.getTorrent(), 1, string6);
                defaultRankCalculator.sTrace = defaultRankCalculator.sTrace + string6 + "\n";
            }
        }
    }

    public int calcPeersNoUs(Download download) {
        int n = 0;
        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
        if (downloadScrapeResult.getScrapeStartTime() > 0L && (n = downloadScrapeResult.getNonSeedCount()) > 0 && download.getState() == 4 && downloadScrapeResult.getScrapeStartTime() > download.getStats().getTimeStarted()) {
            --n;
        }
        if (n == 0) {
            DownloadActivationEvent downloadActivationEvent;
            DownloadAnnounceResult downloadAnnounceResult = download.getLastAnnounceResult();
            if (downloadAnnounceResult != null && downloadAnnounceResult.getResponseType() == 1) {
                n = downloadAnnounceResult.getNonSeedCount();
            }
            if (n == 0 && (downloadActivationEvent = download.getActivationState()) != null) {
                n = downloadActivationEvent.getActivationCount();
            }
        }
        return n;
    }

    private boolean scrapeResultOk(Download download) {
        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
        return downloadScrapeResult.getResponseType() == 1;
    }

    public int calcSeedsNoUs(Download download) {
        return this.calcSeedsNoUs(download, this.calcPeersNoUs(download));
    }

    public int calcSeedsNoUs(Download download, int n) {
        DownloadAnnounceResult downloadAnnounceResult;
        int n2 = 0;
        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
        if (downloadScrapeResult.getScrapeStartTime() > 0L) {
            long l = download.getStats().getTimeStartedSeeding();
            n2 = downloadScrapeResult.getSeedCount();
            if (n2 > 0 && l > 0L && download.getState() == 5 && downloadScrapeResult.getScrapeStartTime() > l) {
                --n2;
            }
        }
        if (n2 == 0 && (downloadAnnounceResult = download.getLastAnnounceResult()) != null && downloadAnnounceResult.getResponseType() == 1) {
            n2 = downloadAnnounceResult.getSeedCount();
        }
        if (this.numPeersAsFullCopy != 0 && n2 >= this.iFakeFullCopySeedStart) {
            n2 += n / this.numPeersAsFullCopy;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestProcessCycle(DefaultRankCalculator defaultRankCalculator) {
        if (defaultRankCalculator != null) {
            try {
                this.ranksToRecalc_mon.enter();
                this.ranksToRecalc.add(defaultRankCalculator);
                Object var3_2 = null;
                this.ranksToRecalc_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.ranksToRecalc_mon.exit();
                throw throwable;
            }
        }
        if (this.somethingChanged) {
            ++this.processMergeCount;
        } else {
            this.somethingChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("StartStopRules Manager");
        try {
            block6: {
                try {
                    indentWriter.indent();
                    indentWriter.println("Started " + TimeFormatter.format100ths(SystemTime.getCurrentTime() - this.startedOn) + " ago");
                    indentWriter.println("debugging = " + this.bDebugLog);
                    indentWriter.println("downloadDataMap size = " + downloadDataMap.size());
                    if (this.changeCheckCount > 0L) {
                        indentWriter.println("changeCheck CPU ms: avg=" + this.changeCheckTotalMS / this.changeCheckCount + "; max = " + this.changeCheckMaxMS);
                    }
                    if (this.processCount <= 0L) break block6;
                    indentWriter.println("# process cycles: " + this.processCount);
                    indentWriter.println("process CPU ms: avg=" + this.processTotalMS / this.processCount + "; max = " + this.processMaxMS);
                    if (this.processCount > 1L) {
                        indentWriter.println("process avg gap: " + this.processTotalGap / (this.processCount - 1L) + "ms");
                    }
                    indentWriter.println("Avg # recalcs per process cycle: " + this.processTotalRecalcs / this.processCount);
                    if (this.processTotalZeroRecalcs <= 0L) break block6;
                    indentWriter.println("# process cycle with 0 recalcs: " + this.processTotalZeroRecalcs);
                }
                catch (Exception exception) {
                    Object var4_3 = null;
                    indentWriter.exdent();
                }
            }
            Object var4_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    public void addListener(StartStopRulesFPListener startStopRulesFPListener) {
        this.listenersFP.add(startStopRulesFPListener);
    }

    public void removeListener(StartStopRulesFPListener startStopRulesFPListener) {
        this.listenersFP.remove(startStopRulesFPListener);
    }

    public List getFPListeners() {
        return this.listenersFP.getList();
    }

    static /* synthetic */ DefaultRankCalculator[] access$1102(StartStopRulesDefaultPlugin startStopRulesDefaultPlugin, DefaultRankCalculator[] defaultRankCalculatorArray) {
        startStopRulesDefaultPlugin.sortedArrayCache = defaultRankCalculatorArray;
        return defaultRankCalculatorArray;
    }

    public class ProcessVars {
        int numWaitingOrSeeding;
        int numWaitingOrDLing;
        long accumulatedDownloadSpeed;
        long accumulatedUploadSpeed;
        boolean higherCDtoStart;
        boolean higherDLtoStart;
        int posComplete;
        boolean bStopAndQueued;
        int stalledSeeders;
    }

    private class TotalsStats {
        int forcedSeeding = 0;
        int forcedSeedingNonFP = 0;
        int waitingToSeed = 0;
        int waitingToDL = 0;
        int downloading = 0;
        int activelyDLing = 0;
        int activelyCDing = 0;
        int complete = 0;
        int incompleteQueued = 0;
        int firstPriority = 0;
        int stalledSeeders = 0;
        int stalledFPSeeders = 0;
        int forcedActive = 0;
        boolean bOkToStartSeeding;
        int maxSeeders;
        int maxActive;
        int maxTorrents;

        public int maxUploadSpeed() {
            return this.downloading == 0 ? StartStopRulesDefaultPlugin.this.globalUploadWhenSeedingLimit : StartStopRulesDefaultPlugin.this.globalUploadLimit;
        }

        public TotalsStats(DefaultRankCalculator[] defaultRankCalculatorArray) {
            int n;
            this.bOkToStartSeeding = StartStopRulesDefaultPlugin.this.iRankType == 0 || StartStopRulesDefaultPlugin.this.iRankType == 3 || SystemTime.getCurrentTime() - StartStopRulesDefaultPlugin.this.startedOn > 90000L;
            int n2 = 0;
            for (n = 0; n < defaultRankCalculatorArray.length; ++n) {
                Download download;
                int n3;
                DefaultRankCalculator defaultRankCalculator = defaultRankCalculatorArray[n];
                if (defaultRankCalculator == null || (n3 = (download = defaultRankCalculator.getDownloadObject()).getState()) == 8 || n3 == 7) continue;
                boolean bl = download.isComplete();
                boolean bl2 = false;
                if (!bl && download.isForceStart()) continue;
                if (bl) {
                    boolean bl3 = true;
                    if (!this.bOkToStartSeeding) {
                        bl3 = StartStopRulesDefaultPlugin.this.scrapeResultOk(download);
                        if (StartStopRulesDefaultPlugin.this.calcSeedsNoUs(download) == 0 && bl3) {
                            this.bOkToStartSeeding = true;
                        } else if (download.getSeedingRank() > 0 && (n3 == 9 || n3 == 3) && SystemTime.getCurrentTime() - StartStopRulesDefaultPlugin.this.startedOn > 20000L) {
                            this.bOkToStartSeeding = true;
                        }
                    }
                    ++this.complete;
                    if (!this.bOkToStartSeeding && bl3) {
                        ++n2;
                    }
                    if (defaultRankCalculator.isFirstPriority()) {
                        if (!this.bOkToStartSeeding) {
                            this.bOkToStartSeeding = true;
                        }
                        ++this.firstPriority;
                        bl2 = true;
                    }
                    if (defaultRankCalculator.getActivelySeeding()) {
                        if (defaultRankCalculator.isForceActive()) {
                            ++this.forcedActive;
                        }
                        ++this.activelyCDing;
                        if (download.isForceStart()) {
                            ++this.forcedSeeding;
                            if (!bl2) {
                                ++this.forcedSeedingNonFP;
                            }
                        }
                    } else if (n3 == 5) {
                        if (bl2) {
                            ++this.stalledFPSeeders;
                        }
                        ++this.stalledSeeders;
                    }
                    if (n3 != 3 && n3 != 1 && n3 != 2) continue;
                    ++this.waitingToSeed;
                    continue;
                }
                if (n3 == 4) {
                    ++this.downloading;
                    if (defaultRankCalculator.getActivelyDownloading()) {
                        ++this.activelyDLing;
                    }
                }
                if (n3 == 3 || n3 == 1 || n3 == 2) {
                    ++this.waitingToDL;
                    continue;
                }
                if (n3 != 9) continue;
                ++this.incompleteQueued;
            }
            if (!this.bOkToStartSeeding && n2 == this.complete) {
                this.bOkToStartSeeding = true;
            }
            this.maxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(this.activelyDLing + this.waitingToDL);
            this.maxActive = StartStopRulesDefaultPlugin.this.getMaxActive();
            if (this.maxActive == 0) {
                this.maxTorrents = 9999;
            } else if (this.maxUploadSpeed() == 0) {
                this.maxTorrents = this.maxActive + 4;
            } else {
                n = StartStopRulesDefaultPlugin.this.minSpeedForActiveSeeding * 2 / 1024;
                if (n < 3) {
                    n = 3;
                }
                this.maxTorrents = this.maxUploadSpeed() / n;
                if (this.maxTorrents < this.maxActive) {
                    this.maxTorrents = this.maxActive;
                }
            }
        }
    }

    private class ChangeCheckerTimerTask
    implements TimerEventPerformer {
        long lLastRunTime = 0L;

        private ChangeCheckerTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform(TimerEvent timerEvent2) {
            long l;
            block16: {
                block14: {
                    block15: {
                        l = 0L;
                        try {
                            int n;
                            DefaultRankCalculator[] defaultRankCalculatorArray;
                            StartStopRulesDefaultPlugin.this.this_mon.enter();
                            l = SystemTime.getCurrentTime();
                            if (l > this.lLastRunTime && l - this.lLastRunTime < 1000L) {
                                Object var9_3 = null;
                                if (l <= 0L) break block14;
                                break block15;
                            }
                            this.lLastRunTime = l;
                            Map map = downloadDataMap;
                            synchronized (map) {
                                defaultRankCalculatorArray = downloadDataMap.values().toArray(new DefaultRankCalculator[0]);
                            }
                            int n2 = 0;
                            int n3 = 0;
                            for (n = 0; n < defaultRankCalculatorArray.length; ++n) {
                                if (defaultRankCalculatorArray[n].changeChecker()) {
                                    StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculatorArray[n]);
                                }
                                if (defaultRankCalculatorArray[n].getActivelyDownloading()) {
                                    ++n2;
                                }
                                if (!defaultRankCalculatorArray[n].getActivelySeeding()) continue;
                                ++n3;
                            }
                            n = StartStopRulesDefaultPlugin.this.calcMaxSeeders(n2);
                            if (n3 <= n) break block16;
                            StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                                StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: More Seeding than limit");
                            }
                            break block16;
                        }
                        catch (Throwable throwable) {
                            Object var9_5 = null;
                            if (l > 0L) {
                                StartStopRulesDefaultPlugin.this.changeCheckCount++;
                                long l2 = SystemTime.getCurrentTime() - l;
                                StartStopRulesDefaultPlugin.this.changeCheckTotalMS += l2;
                                if (l2 > StartStopRulesDefaultPlugin.this.changeCheckMaxMS) {
                                    StartStopRulesDefaultPlugin.this.changeCheckMaxMS = l2;
                                }
                            }
                            StartStopRulesDefaultPlugin.this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    StartStopRulesDefaultPlugin.this.changeCheckCount++;
                    long l3 = SystemTime.getCurrentTime() - l;
                    StartStopRulesDefaultPlugin.this.changeCheckTotalMS += l3;
                    if (l3 > StartStopRulesDefaultPlugin.this.changeCheckMaxMS) {
                        StartStopRulesDefaultPlugin.this.changeCheckMaxMS = l3;
                    }
                }
                StartStopRulesDefaultPlugin.this.this_mon.exit();
                return;
            }
            Object var9_4 = null;
            if (l > 0L) {
                StartStopRulesDefaultPlugin.this.changeCheckCount++;
                long l4 = SystemTime.getCurrentTime() - l;
                StartStopRulesDefaultPlugin.this.changeCheckTotalMS += l4;
                if (l4 > StartStopRulesDefaultPlugin.this.changeCheckMaxMS) {
                    StartStopRulesDefaultPlugin.this.changeCheckMaxMS = l4;
                }
            }
            StartStopRulesDefaultPlugin.this.this_mon.exit();
        }
    }

    private class StartStopDMListener
    implements DownloadManagerListener {
        private DownloadTrackerListener download_tracker_listener;
        private DownloadListener download_listener;
        private DownloadActivationListener download_activation_listener;

        public StartStopDMListener() {
            this.download_tracker_listener = new StartStopDMTrackerListener();
            this.download_listener = new StartStopDownloadListener();
            this.download_activation_listener = new StartStopDownloadActivationListener();
        }

        public void downloadAdded(Download download) {
            DefaultRankCalculator defaultRankCalculator = null;
            if (downloadDataMap.containsKey(download)) {
                defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            } else {
                defaultRankCalculator = new DefaultRankCalculator(StartStopRulesDefaultPlugin.this, download);
                StartStopRulesDefaultPlugin.access$1102(StartStopRulesDefaultPlugin.this, null);
                downloadDataMap.put(download, defaultRankCalculator);
                download.addListener(this.download_listener);
                download.addTrackerListener(this.download_tracker_listener, false);
                download.addActivationListener(this.download_activation_listener);
            }
            if (defaultRankCalculator != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadAdded, state: " + StartStopRulesDefaultPlugin.sStates.charAt(download.getState()));
                }
            }
        }

        public void downloadRemoved(Download download) {
            download.removeListener(this.download_listener);
            download.removeTrackerListener(this.download_tracker_listener);
            download.removeActivationListener(this.download_activation_listener);
            if (downloadDataMap.containsKey(download)) {
                StartStopRulesDefaultPlugin.access$1102(StartStopRulesDefaultPlugin.this, null);
                downloadDataMap.remove(download);
            }
            StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadRemoved");
            }
        }
    }

    private class StartStopDownloadActivationListener
    implements DownloadActivationListener {
        private StartStopDownloadActivationListener() {
        }

        public boolean activationRequested(DownloadActivationEvent downloadActivationEvent) {
            DownloadScrapeResult downloadScrapeResult;
            int n;
            Download download = downloadActivationEvent.getDownload();
            DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download, 1, ">> somethingChanged: ActivationRequest");
            }
            StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
            return download.isComplete() && (n = (downloadScrapeResult = downloadActivationEvent.getDownload().getLastScrapeResult()).getNonSeedCount()) <= 0;
        }
    }

    private class StartStopDMTrackerListener
    implements DownloadTrackerListener {
        private StartStopDMTrackerListener() {
        }

        public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
            Download download = downloadScrapeResult.getDownload();
            DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            if (downloadScrapeResult.getResponseType() == 2) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "Ignored somethingChanged: new scrapeResult (RT_ERROR)");
                }
                if (defaultRankCalculator != null) {
                    defaultRankCalculator.lastScrapeResultOk = false;
                }
                return;
            }
            if (defaultRankCalculator != null) {
                defaultRankCalculator.lastScrapeResultOk = true;
                StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: new scrapeResult S:" + downloadScrapeResult.getSeedCount() + ";P:" + downloadScrapeResult.getNonSeedCount());
                }
            }
        }

        public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
        }
    }

    private class StartStopDownloadListener
    implements DownloadListener {
        private StartStopDownloadListener() {
        }

        public void stateChanged(Download download, int n, int n2) {
            DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            if (defaultRankCalculator != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                if (n2 == 3 || n2 == 1) {
                    if (StartStopRulesDefaultPlugin.this.immediateProcessingScheduled) {
                        StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                    } else {
                        StartStopRulesDefaultPlugin.this.immediateProcessingScheduled = true;
                        new AEThread2("processReady", true){

                            public void run() {
                                StartStopRulesDefaultPlugin.this.process();
                            }
                        }.start();
                    }
                }
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)defaultRankCalculator.dl.getTorrent(), 1, "somethingChanged: stateChange from " + StartStopRulesDefaultPlugin.sStates.charAt(n) + " (" + n + ") to " + StartStopRulesDefaultPlugin.sStates.charAt(n2) + " (" + n2 + ")");
                }
            }
        }

        public void positionChanged(Download download, int n, int n2) {
            DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)downloadDataMap.get(download);
            if (defaultRankCalculator != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(defaultRankCalculator);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)defaultRankCalculator.dl.getTorrent(), 1, "somethingChanged: positionChanged from " + n + " to " + n2);
                }
            }
        }
    }

    private class ChangeFlagCheckerTask
    implements TimerEventPerformer {
        final long FORCE_CHECK_CYCLES = 40L;
        long cycleNo = 0L;

        private ChangeFlagCheckerTask() {
        }

        public void perform(TimerEvent timerEvent2) {
            if (StartStopRulesDefaultPlugin.this.closingDown || pauseChangeFlagChecker) {
                return;
            }
            ++this.cycleNo;
            if (this.cycleNo > 40L) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, ">>force process");
                }
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
            }
            if (StartStopRulesDefaultPlugin.this.somethingChanged) {
                try {
                    this.cycleNo = 0L;
                    StartStopRulesDefaultPlugin.this.process();
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
            }
        }
    }

    private class RecalcSeedingRanksTask
    implements TimerEventPerformer {
        boolean bCancel = false;

        private RecalcSeedingRanksTask() {
        }

        public void perform(TimerEvent timerEvent2) {
            if (this.bCancel) {
                timerEvent2.cancel();
                return;
            }
            StartStopRulesDefaultPlugin.this.recalcAllSeedingRanks(false);
        }

        public void cancel() {
            this.bCancel = true;
        }
    }
}

