/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.sharing.hoster;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceEvent;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.plugins.utils.DelayedTask;

public class ShareHosterPlugin
implements Plugin,
PluginListener,
ShareManagerListener {
    protected PluginInterface plugin_interface;
    protected LoggerChannel log;
    protected Tracker tracker;
    protected ShareManager share_manager;
    protected DownloadManager download_manager;
    protected Map resource_dl_map = new HashMap();
    protected Map resource_tt_map = new HashMap();
    protected Download download_being_removed;
    protected TrackerTorrent torrent_being_removed;

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", "Share Hoster");
    }

    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.log = this.plugin_interface.getLogger().getChannel("ShareHosterPlugin");
        this.log.log(1, "ShareHosterPlugin: initialisation starts");
        this.plugin_interface.addListener(this);
    }

    public void initializationComplete() {
        DelayedTask delayedTask = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            public void run() {
                ShareHosterPlugin.this.initialise();
            }
        });
        delayedTask.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise() {
        this.log.log(1, "ShareHosterPlugin: initialisation complete");
        Thread.currentThread().setPriority(1);
        try {
            try {
                this.tracker = this.plugin_interface.getTracker();
                this.download_manager = this.plugin_interface.getDownloadManager();
                this.share_manager = this.plugin_interface.getShareManager();
                this.share_manager.addListener(this);
                this.share_manager.initialise();
            }
            catch (ShareException shareException) {
                Debug.printStackTrace(shareException);
                this.log.log(shareException);
                Object var3_2 = null;
                this.plugin_interface.getPluginManager().firePluginEvent(5);
            }
            Object var3_1 = null;
            this.plugin_interface.getPluginManager().firePluginEvent(5);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.plugin_interface.getPluginManager().firePluginEvent(5);
            throw throwable;
        }
    }

    public void closedownInitiated() {
    }

    public void closedownComplete() {
    }

    public void resourceAdded(final ShareResource shareResource) {
        this.log.log(1, "Resource added:".concat(shareResource.getName()));
        try {
            Object object;
            Torrent torrent;
            TorrentAttribute[] torrentAttributeArray;
            ShareResource shareResource2;
            shareResource.addDeletionListener(new ShareResourceWillBeDeletedListener(){

                public void resourceWillBeDeleted(ShareResource shareResource) throws ShareResourceDeletionVetoException {
                    ShareHosterPlugin.this.canResourceBeDeleted(shareResource);
                }
            });
            Download download = null;
            int n = shareResource.getType();
            if (n == 1) {
                shareResource2 = (ShareResourceFile)shareResource;
                torrentAttributeArray = shareResource2.getItem();
                torrent = torrentAttributeArray.getTorrent();
                object = this.download_manager.getDownload(torrent);
                if (object == null) {
                    download = this.download_manager.addNonPersistentDownload(torrent, torrentAttributeArray.getTorrentFile(), shareResource2.getFile());
                }
            } else if (n == 2 && (object = this.download_manager.getDownload(torrent = (torrentAttributeArray = (shareResource2 = (ShareResourceDir)shareResource).getItem()).getTorrent())) == null) {
                download = this.download_manager.addNonPersistentDownload(torrent, torrentAttributeArray.getTorrentFile(), shareResource2.getDir());
            }
            if (download != null) {
                shareResource2 = download;
                this.resource_dl_map.put(shareResource, download);
                shareResource.addChangeListener(new ShareResourceListener((Download)((Object)shareResource2)){
                    final /* synthetic */ Download val$f_new_download;
                    {
                        this.val$f_new_download = download;
                    }

                    public void shareResourceChanged(ShareResource shareResource, ShareResourceEvent shareResourceEvent) {
                        if (shareResourceEvent.getType() == 1) {
                            TorrentAttribute torrentAttribute = (TorrentAttribute)shareResourceEvent.getData();
                            this.val$f_new_download.setAttribute(torrentAttribute, shareResource.getAttribute(torrentAttribute));
                        }
                    }
                });
                torrentAttributeArray = shareResource.getAttributes();
                for (int i = 0; i < torrentAttributeArray.length; ++i) {
                    object = torrentAttributeArray[i];
                    download.setAttribute((TorrentAttribute)object, shareResource.getAttribute((TorrentAttribute)object));
                }
                download.addAttributeListener(new DownloadAttributeListener(){

                    public void attributeEventOccurred(Download download, TorrentAttribute torrentAttribute, int n) {
                        shareResource.setAttribute(torrentAttribute, download.getAttribute(torrentAttribute));
                    }
                }, this.plugin_interface.getTorrentManager().getAttribute("Category"), 1);
                Torrent torrent2 = download.getTorrent();
                if (torrent2 != null) {
                    object = this.tracker.host(torrent2, false);
                    object.addRemovalListener(new TrackerTorrentWillBeRemovedListener(){

                        public void torrentWillBeRemoved(TrackerTorrent trackerTorrent) throws TrackerTorrentRemovalVetoException {
                            if (trackerTorrent != ShareHosterPlugin.this.torrent_being_removed) {
                                throw new TrackerTorrentRemovalVetoException(MessageText.getString("plugin.sharing.torrent.remove.veto"));
                            }
                        }
                    });
                    this.resource_tt_map.put(shareResource, object);
                }
                download.addDownloadWillBeRemovedListener(new DownloadWillBeRemovedListener(){

                    public void downloadWillBeRemoved(Download download) throws DownloadRemovalVetoException {
                        if (download != ShareHosterPlugin.this.download_being_removed) {
                            throw new DownloadRemovalVetoException(MessageText.getString("plugin.sharing.download.remove.veto"));
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected void canResourceBeDeleted(ShareResource shareResource) throws ShareResourceDeletionVetoException {
        TrackerTorrent trackerTorrent;
        Download download = (Download)this.resource_dl_map.get(shareResource);
        if (download != null) {
            try {
                try {
                    this.download_being_removed = download;
                    download.canBeRemoved();
                }
                catch (DownloadRemovalVetoException downloadRemovalVetoException) {
                    throw new ShareResourceDeletionVetoException(downloadRemovalVetoException.getMessage());
                }
                Object var5_3 = null;
                this.download_being_removed = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.download_being_removed = null;
                throw throwable;
            }
        }
        if ((trackerTorrent = (TrackerTorrent)this.resource_tt_map.get(shareResource)) != null) {
            try {
                try {
                    this.torrent_being_removed = trackerTorrent;
                    trackerTorrent.canBeRemoved();
                }
                catch (TrackerTorrentRemovalVetoException trackerTorrentRemovalVetoException) {
                    throw new ShareResourceDeletionVetoException(trackerTorrentRemovalVetoException.getMessage());
                }
                Object var7_9 = null;
                this.torrent_being_removed = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.torrent_being_removed = null;
                throw throwable;
            }
        }
    }

    public void resourceModified(ShareResource shareResource, ShareResource shareResource2) {
        this.log.log(1, "Resource modified:".concat(shareResource.getName()));
        this.resourceDeleted(shareResource);
        this.resourceAdded(shareResource2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceDeleted(ShareResource shareResource) {
        TrackerTorrent trackerTorrent;
        this.log.log(1, "Resource deleted:".concat(shareResource.getName()));
        Download download = (Download)this.resource_dl_map.get(shareResource);
        if (download != null) {
            try {
                try {
                    this.download_being_removed = download;
                    try {
                        download.stop();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    download.remove();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    Object var5_7 = null;
                    this.download_being_removed = null;
                }
                Object var5_6 = null;
                this.download_being_removed = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.download_being_removed = null;
                throw throwable;
            }
            this.resource_dl_map.remove(shareResource);
        }
        if ((trackerTorrent = (TrackerTorrent)this.resource_tt_map.get(shareResource)) != null) {
            try {
                try {
                    this.torrent_being_removed = trackerTorrent;
                    trackerTorrent.remove();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    Object var7_12 = null;
                    this.torrent_being_removed = null;
                }
                Object var7_11 = null;
                this.torrent_being_removed = null;
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                this.torrent_being_removed = null;
                throw throwable;
            }
            this.resource_tt_map.remove(shareResource);
        }
    }

    public void reportProgress(int n) {
    }

    public void reportCurrentTask(String string) {
        this.log.log(1, "Current Task:".concat(string));
    }
}

