/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus;

import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTester;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterBT;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterListener;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;

public class NetStatusPlugin
implements Plugin {
    public static final String VIEW_ID = "aznetstatus";
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private StringParameter ping_target;
    private ActionParameter test_button;
    private StringParameter test_address;
    private NetStatusProtocolTester protocol_tester;
    private AESemaphore protocol_tester_sem = new AESemaphore("ProtTestSem");

    public static void load(PluginInterface pluginInterface) {
        String string = pluginInterface.getUtilities().getLocaleUtilities().getLocalisedMessageText("Views.plugins.aznetstatus.title");
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", string);
    }

    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.logger = this.plugin_interface.getLogger().getChannel("NetStatus");
        this.logger.setDiagnostic();
        BasicPluginConfigModel basicPluginConfigModel = this.plugin_interface.getUIManager().createBasicPluginConfigModel("Views.plugins.aznetstatus.title");
        this.ping_target = basicPluginConfigModel.addStringParameter2("plugin.aznetstatus.pingtarget", "plugin.aznetstatus.pingtarget", "www.google.com");
        if (Constants.isCVSVersion()) {
            this.test_address = basicPluginConfigModel.addStringParameter2("plugin.aznetstatus.test_address", "plugin.aznetstatus.test_address", "");
            this.test_button = basicPluginConfigModel.addActionParameter2("test", "test ");
            this.test_button.setEnabled(false);
            this.test_button.addListener(new ParameterListener(){

                public void parameterChanged(Parameter parameter) {
                    NetStatusPlugin.this.protocol_tester.runTest(NetStatusPlugin.this.test_address.getValue().trim(), new NetStatusProtocolTesterListener(){

                        public void sessionAdded(NetStatusProtocolTesterBT.Session session) {
                        }

                        public void complete(NetStatusProtocolTesterBT netStatusProtocolTesterBT) {
                        }

                        public void log(String string) {
                            NetStatusPlugin.this.logger.log(string);
                        }

                        public void logError(String string) {
                            NetStatusPlugin.this.logger.log(string);
                        }

                        public void logError(String string, Throwable throwable) {
                            NetStatusPlugin.this.logger.log(string, throwable);
                        }
                    });
                }
            });
        }
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance uIInstance) {
            }

            public void UIDetached(UIInstance uIInstance) {
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                new AEThread2("NetstatusPlugin:init", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            NetStatusPlugin.this.protocol_tester = new NetStatusProtocolTester(NetStatusPlugin.this, NetStatusPlugin.this.plugin_interface);
                            if (NetStatusPlugin.this.test_button != null) {
                                NetStatusPlugin.this.test_button.setEnabled(true);
                            }
                            Object var2_1 = null;
                            NetStatusPlugin.this.protocol_tester_sem.releaseForever();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            NetStatusPlugin.this.protocol_tester_sem.releaseForever();
                            throw throwable;
                        }
                    }
                }.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    public NetStatusProtocolTester getProtocolTester() {
        this.protocol_tester_sem.reserve();
        return this.protocol_tester;
    }

    public String getPingTarget() {
        return this.ping_target.getValue();
    }

    public void setBooleanParameter(String string, boolean bl) {
        this.plugin_interface.getPluginconfig().setPluginParameter(string, bl);
    }

    public boolean getBooleanParameter(String string, boolean bl) {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter(string, bl);
    }

    public void log(String string) {
        this.logger.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.logger.log(string);
        this.logger.log(throwable);
    }
}

