/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht.impl;

import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImpl;
import java.net.InetSocketAddress;
import java.util.Map;

public class DHTPluginContactImpl
implements DHTPluginContact {
    private DHTPluginImpl plugin;
    private DHTTransportContact contact;

    protected DHTPluginContactImpl(DHTPluginImpl dHTPluginImpl, DHTTransportContact dHTTransportContact) {
        this.plugin = dHTPluginImpl;
        this.contact = dHTTransportContact;
    }

    public DHTPluginImpl getDHT() {
        return this.plugin;
    }

    protected DHTTransportContact getContact() {
        return this.contact;
    }

    public String getName() {
        return this.contact.getName();
    }

    public byte getProtocolVersion() {
        return this.contact.getProtocolVersion();
    }

    public InetSocketAddress getAddress() {
        return this.contact.getAddress();
    }

    public boolean isAlive(long l) {
        return this.contact.isAlive(l);
    }

    public void isAlive(long l, final DHTPluginOperationListener dHTPluginOperationListener) {
        this.contact.isAlive(new DHTTransportReplyHandlerAdapter(){

            public void pingReply(DHTTransportContact dHTTransportContact) {
                dHTPluginOperationListener.complete(null, false);
            }

            public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                dHTPluginOperationListener.complete(null, true);
            }
        }, l);
    }

    public boolean isOrHasBeenLocal() {
        return this.plugin.isRecentAddress(this.contact.getAddress().getAddress().getHostAddress());
    }

    public Map openTunnel() {
        DHTNATPuncher dHTNATPuncher = this.plugin.getDHT().getNATPuncher();
        if (dHTNATPuncher == null) {
            return null;
        }
        return dHTNATPuncher.punch("Tunnel", this.contact, null, null);
    }

    public byte[] read(DHTPluginProgressListener dHTPluginProgressListener, byte[] byArray, byte[] byArray2, long l) {
        return this.plugin.read(dHTPluginProgressListener, this, byArray, byArray2, l);
    }
}

