/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.clientid;

import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class ClientIDPlugin {
    private static boolean send_os;

    public static void initialize() {
        COConfigurationManager.addAndFireParameterListener("Tracker Client Send OS and Java Version", new ParameterListener(){

            public void parameterChanged(String string) {
                send_os = COConfigurationManager.getBooleanParameter(string);
            }
        });
        ClientIDManagerImpl.getSingleton().setGenerator(new ClientIDGenerator(){

            public byte[] generatePeerID(Torrent torrent, boolean bl) {
                return PeerUtils.createPeerID();
            }

            public void generateHTTPProperties(Properties properties) {
                ClientIDPlugin.doHTTPProperties(properties);
            }

            public String[] filterHTTP(String[] stringArray) {
                return stringArray;
            }
        }, false);
    }

    protected static void doHTTPProperties(Properties properties) {
        String string = "4.5.0.4";
        int n = string.indexOf(95);
        if (n != -1) {
            string = string.substring(0, n);
        }
        String string2 = "Azureus " + string;
        if (send_os) {
            string2 = string2 + ";" + Constants.OSName;
            string2 = string2 + ";Java " + Constants.JAVA_VERSION;
        }
        properties.put("User-Agent", string2);
    }
}

