/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.loopcontrol.impl;

import com.aelitis.azureus.core.util.loopcontrol.LoopControler;

public class PIDLoopControler
implements LoopControler {
    double pGain;
    double iGain;
    double dGain;
    double iState;
    double iMin = -5000.0;
    double iMax = 5000.0;
    double dState;

    public PIDLoopControler(double d, double d2, double d3) {
        this.pGain = d;
        this.iGain = d2;
        this.dGain = d3;
    }

    public double updateControler(double d, double d2) {
        double d3 = this.pGain * d;
        this.iState += d;
        if (this.iState > this.iMax) {
            this.iState = this.iMax;
        }
        if (this.iState < this.iMin) {
            this.iState = this.iMin;
        }
        double d4 = this.iGain * this.iState;
        double d5 = this.dState - d2;
        double d6 = this.dGain * d5;
        this.dState = d2;
        double d7 = d3 + d4 - d6;
        System.out.println("PID p,i,d (" + this.pGain + "," + this.iGain + "," + this.dGain + ") : is,ds (" + this.iState + "," + d5 + ") p,i,d (" + d3 + "," + d4 + "," + d6 + ") => " + d7);
        return d7;
    }

    public void reset() {
        this.dState = 0.0;
        this.iState = 0.0;
    }
}

