/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.http;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.http.HTTPAuthHelperListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.ThreadPool;

public class HTTPAuthHelper {
    public static final boolean TRACE = false;
    public static final int MAX_PROCESSORS = 32;
    public static final int CONNECT_TIMEOUT = 30000;
    public static final int READ_TIMEOUT = 30000;
    private HTTPAuthHelper parent;
    private Map children = new HashMap();
    private URL delegate_to;
    private String delegate_to_host;
    private int delegate_to_port;
    private boolean delegate_is_https;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private int port;
    private ServerSocket server_socket;
    private boolean http_only_detected;
    private Map cookie_names_set = new HashMap();
    private ThreadPool thread_pool = new ThreadPool("HTTPSniffer", 32, true);
    private List processors = new ArrayList();
    private volatile boolean destroyed;

    public HTTPAuthHelper(URL uRL) throws Exception {
        this(null, uRL);
    }

    protected HTTPAuthHelper(HTTPAuthHelper hTTPAuthHelper, URL uRL) throws Exception {
        this.parent = hTTPAuthHelper;
        this.delegate_to = uRL;
        this.delegate_to_host = this.delegate_to.getHost();
        this.delegate_is_https = this.delegate_to.getProtocol().toLowerCase().equals("https");
        this.delegate_to_port = this.delegate_to.getPort() == -1 ? this.delegate_to.getDefaultPort() : this.delegate_to.getPort();
        this.server_socket = new ServerSocket();
        this.server_socket.setReuseAddress(true);
        this.server_socket.bind(new InetSocketAddress("127.0.0.1", 0));
        this.port = this.server_socket.getLocalPort();
    }

    public void start() {
        new AEThread2("HTTPSniffingProxy: " + this.delegate_to_host + ":" + this.delegate_to_port + "/" + this.delegate_is_https + "/" + this.port, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    while (!HTTPAuthHelper.this.destroyed) {
                        Socket socket = HTTPAuthHelper.this.server_socket.accept();
                        socket.setSoTimeout(30000);
                        HTTPAuthHelper hTTPAuthHelper = HTTPAuthHelper.this;
                        synchronized (hTTPAuthHelper) {
                            if (HTTPAuthHelper.this.processors.size() >= 32) {
                                try {
                                    Debug.out("Too many processors");
                                    socket.close();
                                }
                                catch (Throwable throwable) {}
                            } else {
                                processor processor2 = new processor(socket);
                                HTTPAuthHelper.this.processors.add(processor2);
                                processor2.start();
                            }
                        }
                    }
                    return;
                }
                catch (Throwable throwable) {
                    if (HTTPAuthHelper.this.destroyed) return;
                    Debug.printStackTrace(throwable);
                }
            }
        }.start();
    }

    public int getPort() {
        return this.port;
    }

    public boolean wasHTTPOnlyCookieDetected() {
        return this.http_only_detected;
    }

    protected void setHTTPOnlyCookieDetected() {
        this.http_only_detected = true;
        if (this.parent != null) {
            this.parent.setHTTPOnlyCookieDetected();
        }
    }

    protected String getKey(URL uRL) {
        int n = uRL.getPort() == -1 ? uRL.getDefaultPort() : uRL.getPort();
        String string = uRL.getProtocol() + ":" + uRL.getHost() + ":" + n;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPAuthHelper getChild(String string, boolean bl) throws Exception {
        if (this.parent != null) {
            return this.parent.getChild(string, bl);
        }
        String string2 = string.toLowerCase();
        if (string2.startsWith("http://") || string2.startsWith("https://")) {
            URL uRL = new URL(string);
            String string3 = this.getKey(uRL);
            if (string3.equals(this.getKey(this.delegate_to))) {
                return this;
            }
            HTTPAuthHelper hTTPAuthHelper = this;
            synchronized (hTTPAuthHelper) {
                if (this.destroyed) {
                    throw new Exception("Destroyed");
                }
                HTTPAuthHelper hTTPAuthHelper2 = (HTTPAuthHelper)this.children.get(string3);
                if (bl) {
                    String string4;
                    String string5 = this.delegate_to.getHost();
                    String string6 = uRL.getHost();
                    int n = string5.lastIndexOf(46);
                    n = string5.lastIndexOf(46, n - 1);
                    int n2 = string6.lastIndexOf(46);
                    n2 = string6.lastIndexOf(46, n2 - 1);
                    String string7 = string5.substring(n, string5.length());
                    if (string7.equals(string4 = string6.substring(n2, string6.length()))) {
                        bl = false;
                    }
                }
                if (hTTPAuthHelper2 == null && !bl) {
                    hTTPAuthHelper2 = new HTTPAuthHelper(this, new URL(string));
                    this.children.put(string3, hTTPAuthHelper2);
                    hTTPAuthHelper2.start();
                }
                return hTTPAuthHelper2;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSetCookieName(String string, String string2) {
        if (this.parent != null) {
            this.parent.addSetCookieName(string, string2);
        } else {
            boolean bl;
            Object object = this.cookie_names_set;
            synchronized (object) {
                this.trace("SetCookieName: " + string);
                String string3 = this.cookie_names_set.put(string, string2);
                bl = string3 == null || !string3.equals(string2);
            }
            if (bl) {
                object = this.listeners.iterator();
                while (object.hasNext()) {
                    try {
                        ((HTTPAuthHelperListener)object.next()).cookieFound(this, string, string2);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasSetCookieName(String string) {
        if (this.parent != null) {
            return this.parent.hasSetCookieName(string);
        }
        Map map = this.cookie_names_set;
        synchronized (map) {
            this.trace("GetCookieName: " + string);
            return this.cookie_names_set.containsKey(string);
        }
    }

    public void addListener(HTTPAuthHelperListener hTTPAuthHelperListener) {
        this.listeners.add(hTTPAuthHelperListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        int n;
        ArrayList arrayList;
        ArrayList arrayList2;
        HTTPAuthHelper hTTPAuthHelper = this;
        synchronized (hTTPAuthHelper) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            arrayList2 = new ArrayList(this.children.values());
            this.children.clear();
            arrayList = new ArrayList(this.processors);
            this.processors.clear();
            try {
                this.server_socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            try {
                ((HTTPAuthHelper)arrayList2.get(n)).destroy();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            try {
                ((processor)arrayList.get(n)).destroy();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void trace(String string) {
    }

    public static void main(String[] stringArray) {
        try {
            HTTPAuthHelper hTTPAuthHelper = new HTTPAuthHelper(new URL("http://www.sf.net/"));
            hTTPAuthHelper.start();
            System.out.println("port=" + hTTPAuthHelper.getPort());
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    protected class processor {
        private static final String NL = "\r\n";
        private Socket socket_in;
        private Socket socket_out;
        private volatile boolean destroyed;

        protected processor(Socket socket) {
            this.socket_in = socket;
        }

        protected void start() {
            HTTPAuthHelper.this.thread_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    HTTPAuthHelper hTTPAuthHelper;
                    try {
                        processor.this.sniff();
                        Object var2_1 = null;
                        hTTPAuthHelper = HTTPAuthHelper.this;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        HTTPAuthHelper hTTPAuthHelper2 = HTTPAuthHelper.this;
                        synchronized (hTTPAuthHelper2) {
                            HTTPAuthHelper.this.processors.remove(processor.this);
                        }
                        throw throwable;
                    }
                    synchronized (hTTPAuthHelper) {
                        HTTPAuthHelper.this.processors.remove(processor.this);
                    }
                }
            });
        }

        protected void sniff() {
            try {
                InputStream inputStream = this.socket_in.getInputStream();
                String string = this.readHeader(inputStream);
                this.connectToDelegate();
                this.process(string);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof IOException)) {
                    Debug.out(throwable);
                }
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void connectToDelegate() throws IOException {
            block25: {
                processor processor2;
                try {
                    block24: {
                        if (HTTPAuthHelper.this.delegate_is_https) {
                            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                                public X509Certificate[] getAcceptedIssuers() {
                                    return null;
                                }

                                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                                }

                                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                                }
                            }};
                            SSLContext sSLContext = SSLContext.getInstance("SSL");
                            sSLContext.init(null, trustManagerArray, RandomUtils.SECURE_RANDOM);
                            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                            try {
                                this.socket_out = sSLSocketFactory.createSocket();
                                this.socket_out.connect(new InetSocketAddress(HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port), 30000);
                            }
                            catch (SSLException sSLException) {
                                sSLSocketFactory = SESecurityManager.installServerCertificates("AZ-sniffer:" + HTTPAuthHelper.this.delegate_to_host + ":" + HTTPAuthHelper.this.port, HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port);
                                this.socket_out = sSLSocketFactory.createSocket();
                                this.socket_out.connect(new InetSocketAddress(HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port), 30000);
                            }
                            break block24;
                        }
                        this.socket_out = new Socket();
                        this.socket_out.connect(new InetSocketAddress(HTTPAuthHelper.this.delegate_to_host, HTTPAuthHelper.this.delegate_to_port), 30000);
                    }
                    Object var6_6 = null;
                    if (this.socket_out == null) break block25;
                    processor2 = this;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (this.socket_out != null) {
                        processor processor3 = this;
                        synchronized (processor3) {
                            if (this.destroyed) {
                                try {
                                    this.socket_out.close();
                                }
                                catch (Throwable throwable2) {
                                    Object var10_15 = null;
                                    this.socket_out = null;
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (processor2) {
                    if (this.destroyed) {
                        try {
                            this.socket_out.close();
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            this.socket_out = null;
                            throw throwable;
                        }
                    }
                }
                {
                    catch (Throwable throwable) {
                        if (throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        throw new IOException(throwable.toString());
                    }
                }
            }
        }

        protected void process(String string) throws Exception {
            Object object;
            int n;
            Object object2;
            String string2;
            int n2;
            String string3;
            Object object3;
            CharSequence charSequence;
            String string4;
            String string5;
            int n3;
            String string6;
            String string7;
            String[] stringArray;
            String string8;
            Object object4;
            final OutputStream outputStream = this.socket_out.getOutputStream();
            String[] stringArray2 = this.splitHeader(string);
            String string9 = stringArray2[0];
            int n4 = string9.indexOf(32);
            string9 = string9.substring(n4).trim();
            n4 = string9.indexOf(32);
            string9 = string9.substring(0, n4).trim();
            HTTPAuthHelper.this.trace("Page request for " + string9);
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
            for (int i = 0; i < stringArray2.length; ++i) {
                object4 = stringArray2[i];
                string8 = ((String)object4).trim().toLowerCase();
                stringArray = string8.split(":");
                if (stringArray.length >= 2) {
                    string7 = stringArray[0].trim();
                    if (string7.equals("host")) {
                        string6 = HTTPAuthHelper.this.delegate_to_port == 80 || HTTPAuthHelper.this.delegate_to_port == 443 ? "" : ":" + HTTPAuthHelper.this.delegate_to_port;
                        object4 = "Host: " + HTTPAuthHelper.this.delegate_to_host + string6;
                    } else if (string7.equals("connection")) {
                        object4 = "Connection: close";
                    } else if (string7.equals("referer")) {
                        string6 = ((String)object4).substring(((String)object4).indexOf(58) + 1).trim();
                        n3 = (string6 = string6.substring(string6.indexOf("://") + 3)).indexOf(47);
                        string6 = n3 >= 0 ? string6.substring(n3) : "/";
                        string5 = HTTPAuthHelper.this.delegate_to_port == 80 || HTTPAuthHelper.this.delegate_to_port == 443 ? "" : ":" + HTTPAuthHelper.this.delegate_to_port;
                        object4 = "Referer: http" + (HTTPAuthHelper.this.delegate_is_https ? "s" : "") + "://" + HTTPAuthHelper.this.delegate_to_host + string5 + string6;
                    } else if (string7.equals("cookie")) {
                        string6 = ((String)object4).substring(((String)object4).indexOf(58) + 1).trim();
                        String[] stringArray3 = string6.split(";");
                        string5 = "";
                        for (int j = 0; j < stringArray3.length; ++j) {
                            string4 = stringArray3[j];
                            charSequence = string4.split("=")[0].trim();
                            if (HTTPAuthHelper.this.hasSetCookieName((String)charSequence)) {
                                string5 = string5 + (string5.length() == 0 ? "" : "; ") + string4;
                                continue;
                            }
                            arrayList.add(charSequence);
                        }
                        object4 = string5.length() > 0 ? "Cookie: " + string5 : null;
                    }
                }
                if (object4 == null) continue;
                HTTPAuthHelper.this.trace("-> " + (String)object4);
                outputStream.write(((String)object4 + NL).getBytes());
            }
            outputStream.write(NL.getBytes());
            outputStream.flush();
            new AEThread2("HTTPSniffingProxy:proc:2", true){

                public void run() {
                    try {
                        int n;
                        InputStream inputStream = processor.this.socket_in.getInputStream();
                        byte[] byArray = new byte[32000];
                        while (!processor.this.destroyed && (n = inputStream.read(byArray)) > 0) {
                            outputStream.write(byArray, 0, n);
                            HTTPAuthHelper.this.trace("POST:" + new String(byArray, 0, n));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }.start();
            InputStream inputStream = this.socket_out.getInputStream();
            object4 = this.socket_in.getOutputStream();
            string8 = this.readHeader(inputStream);
            stringArray = this.splitHeader(string8);
            string7 = null;
            string6 = "ISO-8859-1";
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                int n5;
                string5 = stringArray[n3].trim().toLowerCase();
                String[] stringArray4 = string5.split(":");
                if (stringArray4.length < 2 || !(string4 = stringArray4[0].trim()).equals("content-type")) continue;
                charSequence = stringArray[n3].substring(string5.indexOf(58) + 1).trim();
                object3 = ((String)charSequence).split(";");
                string7 = object3[0];
                if (((String[])object3).length <= 1 || (n5 = ((String)charSequence).toLowerCase().indexOf("charset")) < 0 || (n5 = (string3 = ((String)charSequence).substring(n5 + 1)).indexOf(61)) == -1 || !Charset.isSupported(string3 = string3.substring(n5 + 1).trim())) continue;
                string6 = string3;
            }
            n3 = 0;
            boolean bl = false;
            String string10 = null;
            if (string7 == null) {
                n3 = 1;
            } else if ((string7 = string7.toLowerCase()).indexOf("text/") != -1) {
                n3 = 1;
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                charSequence = stringArray[n2];
                object3 = ((String)charSequence).trim().toLowerCase();
                String[] stringArray5 = ((String)object3).split(":");
                if (stringArray5.length >= 2) {
                    String string11;
                    String string12;
                    int n6;
                    int n7;
                    Object object5;
                    Object object6;
                    String string13;
                    string3 = stringArray5[0].trim();
                    if (string3.equals("set-cookie")) {
                        string13 = ((String)charSequence).substring(((String)charSequence).indexOf(58) + 1);
                        object6 = string13.toLowerCase().indexOf("expires") == -1 ? string13.split(",") : new String[]{string13};
                        object5 = "";
                        for (n7 = 0; n7 < ((String[])object6).length; ++n7) {
                            string2 = object6[n7];
                            String[] stringArray6 = string2.split(";");
                            object2 = "";
                            for (n = 0; n < stringArray6.length; n += 1) {
                                object = stringArray6[n].trim();
                                if (((String)object).equalsIgnoreCase("httponly")) {
                                    HTTPAuthHelper.this.setHTTPOnlyCookieDetected();
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("secure") || ((String)object).toLowerCase().startsWith("domain") || ((String)object).toLowerCase().startsWith("expires")) continue;
                                if (!n) {
                                    n6 = ((String)object).indexOf(61);
                                    string12 = ((String)object).substring(0, n6).trim();
                                    string11 = ((String)object).substring(n6 + 1).trim();
                                    HTTPAuthHelper.this.addSetCookieName(string12, string11);
                                }
                                object2 = (String)object2 + (((String)object2).length() == 0 ? "" : "; ") + (String)object;
                            }
                            object5 = (String)object5 + (n7 == 0 ? "" : ", ") + (String)object2;
                        }
                        charSequence = "Set-Cookie: " + (String)object5;
                    } else if (string3.equals("set-cookie2")) {
                        string13 = ((String)charSequence).substring(((String)charSequence).indexOf(58) + 1);
                        object6 = string13.split(",");
                        object5 = "";
                        for (n7 = 0; n7 < ((String[])object6).length; ++n7) {
                            string2 = object6[n7];
                            String[] stringArray7 = string2.split(";");
                            object2 = "";
                            for (n = 0; n < stringArray7.length; n += 1) {
                                object = stringArray7[n].trim();
                                if (((String)object).equalsIgnoreCase("secure") || ((String)object).equalsIgnoreCase("discard") || ((String)object).toLowerCase().startsWith("domain") || ((String)object).toLowerCase().startsWith("port")) continue;
                                if (!n) {
                                    n6 = ((String)object).indexOf(61);
                                    string12 = ((String)object).substring(0, n6).trim();
                                    string11 = ((String)object).substring(n6 + 1).trim();
                                    HTTPAuthHelper.this.addSetCookieName(string12, string11);
                                }
                                object2 = (String)object2 + (((String)object2).length() == 0 ? "" : "; ") + (String)object;
                            }
                            object5 = (String)object5 + (n7 == 0 ? "" : ", ") + (String)object2 + "; Discard";
                        }
                        charSequence = "Set-Cookie2: " + (String)object5;
                    } else if (string3.equals("connection")) {
                        charSequence = "Connection: close";
                    } else if (string3.equals("location")) {
                        string13 = ((String)charSequence).substring(((String)charSequence).indexOf(58) + 1).trim();
                        object6 = string13.trim();
                        object5 = HTTPAuthHelper.this.getChild((String)object6, false);
                        n7 = string13.indexOf("://");
                        if (n7 >= 0) {
                            string13 = (n7 = (string13 = string13.substring(n7 + 3)).indexOf(47)) >= 0 ? string13.substring(n7) : "/";
                        } else if (!string13.startsWith("/")) {
                            string2 = string9;
                            int n8 = string2.indexOf("://");
                            if (n8 != -1) {
                                string2 = (n8 = (string2 = string2.substring(n8 + 3)).indexOf("/")) == -1 ? "/" : string2.substring(n8);
                            } else if (!string2.startsWith("/")) {
                                string2 = "/" + string2;
                            }
                            n8 = string2.lastIndexOf("/");
                            if (n8 >= 0) {
                                string2 = string2.substring(0, n8 + 1);
                            }
                            string13 = string2 + string13;
                        }
                        charSequence = "Location: http://127.0.0.1:" + ((HTTPAuthHelper)object5).getPort() + string13;
                    } else if (string3.equals("content-encoding")) {
                        if (n3 != 0 && ((string13 = stringArray5[1].trim()).equalsIgnoreCase("gzip") || string13.equalsIgnoreCase("deflate"))) {
                            string10 = string13;
                            charSequence = null;
                        }
                    } else if (string3.equals("content-length")) {
                        if (n3 != 0) {
                            charSequence = null;
                        }
                    } else if (string3.equals("transfer-encoding") && stringArray5[1].indexOf("chunked") != -1) {
                        bl = true;
                        if (n3 != 0) {
                            charSequence = null;
                        }
                    }
                }
                if (charSequence == null) continue;
                HTTPAuthHelper.this.trace("<- " + (String)charSequence);
                ((OutputStream)object4).write(((String)charSequence + NL).getBytes());
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                charSequence = (String)arrayList.get(n2);
                if (HTTPAuthHelper.this.hasSetCookieName((String)charSequence)) continue;
                object3 = "Set-Cookie: " + (String)charSequence + "=X; expires=Sun, 01 Jan 2000 01:00:00 GMT";
                HTTPAuthHelper.this.trace("<- (cookie removal) " + (String)object3);
                ((OutputStream)object4).write(((String)object3 + NL).getBytes());
                object3 = "Set-Cookie2: " + (String)charSequence + "=X; Max-Age=0; Version=1";
                HTTPAuthHelper.this.trace("<- (cookie removal) " + (String)object3);
                ((OutputStream)object4).write(((String)object3 + NL).getBytes());
            }
            byte[] byArray = new byte[32000];
            if (n3 != 0) {
                int n9;
                charSequence = new StringBuffer();
                if (bl) {
                    int n10;
                    while ((n10 = inputStream.read(byArray)) > 0) {
                        ((StringBuffer)charSequence).append(new String(byArray, 0, n10, "ISO-8859-1"));
                    }
                    object3 = new StringBuffer(((StringBuffer)charSequence).length());
                    String string14 = "";
                    int n11 = 0;
                    int n12 = 0;
                    while (n12 < ((StringBuffer)charSequence).length()) {
                        int n13;
                        if (!(string14 = string14 + ((StringBuffer)charSequence).charAt(n12++)).endsWith(NL) || string14.length() <= 2) continue;
                        int n14 = string14.indexOf(59);
                        if (n14 != -1) {
                            string14 = string14.substring(0, n14);
                        }
                        if ((n13 = Integer.parseInt(string14 = string14.trim(), 16)) <= 0) break;
                        if ((n11 += n13) > 0x200000) {
                            throw new IOException("Chunk size " + n13 + " too large");
                        }
                        char[] cArray = new char[n13];
                        ((StringBuffer)charSequence).getChars(n12, n12 + n13, cArray, 0);
                        ((StringBuffer)object3).append(cArray);
                        n12 += n13;
                        string14 = "";
                    }
                    inputStream = new ByteArrayInputStream(((StringBuffer)object3).toString().getBytes("ISO-8859-1"));
                }
                if (string10 != null) {
                    if (string10.equalsIgnoreCase("gzip")) {
                        inputStream = new GZIPInputStream(inputStream);
                    } else if (string10.equalsIgnoreCase("deflate")) {
                        inputStream = new InflaterInputStream(inputStream);
                    }
                }
                ((StringBuffer)charSequence).setLength(0);
                while (!this.destroyed && (n9 = inputStream.read(byArray)) > 0) {
                    ((StringBuffer)charSequence).append(new String(byArray, 0, n9, string6));
                }
                String string15 = ((StringBuffer)charSequence).toString();
                String string16 = string15.toLowerCase();
                StringBuffer stringBuffer = null;
                int n15 = 0;
                while (true) {
                    int n16;
                    int n17 = n16 = string15.length() - n15 >= 10 ? string16.indexOf("http", n15) : -1;
                    if (n16 == -1) break;
                    int n18 = string16.charAt(n16 + 4) == 's' ? n16 + 5 : n16 + 4;
                    if (string16.substring(n18, n18 + 3).equals("://")) {
                        char c;
                        int n19 = -1;
                        int n20 = n18 + 3;
                        while (true) {
                            if ((c = string16.charAt(n20)) == '/') {
                                n19 = n20 + 1;
                                break;
                            }
                            if (!(c == '.' || c == '-' || c == ':' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z')) {
                                n19 = n20;
                                break;
                            }
                            if (n20 == string16.length() - 1) {
                                n19 = n20;
                            }
                            ++n20;
                        }
                        if (n19 <= n16) break;
                        string2 = string15.substring(n16, n19);
                        c = '\u0000';
                        try {
                            object2 = new URL(string2);
                            if (((URL)object2).getHost().length() > 0) {
                                String string17;
                                n = 1;
                                for (int i = n16 - 1; i >= 0 && n16 - i < 512; --i) {
                                    if (string16.charAt(i) != '<') continue;
                                    string17 = string16.substring(i, n16);
                                    if (string17.indexOf("form") != -1) {
                                        n = 0;
                                        break;
                                    }
                                    if (string17.indexOf("meta") == -1 || string17.indexOf("http-equiv") == -1) break;
                                    n = 0;
                                    break;
                                }
                                if ((object = HTTPAuthHelper.this.getChild(string2, n != 0)) != null) {
                                    string17 = "http://127.0.0.1:" + ((HTTPAuthHelper)object).getPort();
                                    if (string2.endsWith("/")) {
                                        string17 = string17 + "/";
                                    }
                                    if (stringBuffer == null) {
                                        stringBuffer = new StringBuffer(string15.length());
                                        if (n16 > 0) {
                                            stringBuffer.append(string15.subSequence(0, n16));
                                        }
                                    } else if (n16 > n15) {
                                        stringBuffer.append(string15.subSequence(n15, n16));
                                    }
                                    HTTPAuthHelper.this.trace("Replacing " + string2 + " with " + string17);
                                    stringBuffer.append(string17);
                                    c = '\u0001';
                                } else {
                                    HTTPAuthHelper.this.trace("    No child for " + string2);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (stringBuffer != null && c == '\u0000') {
                            stringBuffer.append(string15.subSequence(n15, n19));
                        }
                        n15 = n19;
                        continue;
                    }
                    if (stringBuffer != null) {
                        stringBuffer.append(string15.subSequence(n15, n18));
                    }
                    n15 = n18;
                }
                if (stringBuffer != null) {
                    if (n15 < string15.length()) {
                        stringBuffer.append(string15.subSequence(n15, string15.length()));
                    }
                    charSequence = stringBuffer;
                }
                ((OutputStream)object4).write(("Content-Length: " + ((StringBuffer)charSequence).length() + NL).getBytes());
                ((OutputStream)object4).write(NL.getBytes());
                ((OutputStream)object4).write(((StringBuffer)charSequence).toString().getBytes(string6));
            } else {
                int n21;
                ((OutputStream)object4).write(NL.getBytes());
                while (!this.destroyed && (n21 = inputStream.read(byArray)) > 0) {
                    ((OutputStream)object4).write(byArray, 0, n21);
                }
            }
        }

        protected String readHeader(InputStream inputStream) throws IOException {
            String string = "";
            byte[] byArray = new byte[1];
            while (inputStream.read(byArray) == 1 && !(string = string + (char)byArray[0]).endsWith("\r\n\r\n")) {
            }
            return string;
        }

        protected String[] splitHeader(String string) {
            String[] stringArray = string.split(NL);
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            processor processor2 = this;
            synchronized (processor2) {
                if (this.destroyed) {
                    return;
                }
                this.destroyed = true;
            }
            if (this.socket_out != null) {
                try {
                    this.socket_out.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.socket_in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

