/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.AEThread2;

public class LaunchManager {
    private static LaunchManager singleton = new LaunchManager();
    private CopyOnWriteList<LaunchController> controllers = new CopyOnWriteList();

    public static LaunchManager getManager() {
        return singleton;
    }

    public void launchRequest(final LaunchTarget launchTarget, final LaunchAction launchAction) {
        new AEThread2("LaunchManager:request"){

            public void run() {
                for (LaunchController launchController : LaunchManager.this.controllers) {
                    try {
                        launchController.handleRequest(launchTarget);
                    }
                    catch (Throwable throwable) {
                        launchAction.actionDenied(throwable);
                        return;
                    }
                }
                launchAction.actionAllowed();
            }
        }.start();
    }

    public LaunchTarget createTarget(DownloadManager downloadManager) {
        return new LaunchTarget(downloadManager);
    }

    public LaunchTarget createTarget(DiskManagerFileInfo diskManagerFileInfo) {
        return new LaunchTarget(diskManagerFileInfo);
    }

    public void addController(LaunchController launchController) {
        this.controllers.add(launchController);
    }

    public void removeController(LaunchController launchController) {
        this.controllers.remove(launchController);
    }

    public static interface LaunchAction {
        public void actionAllowed();

        public void actionDenied(Throwable var1);
    }

    public static interface LaunchController {
        public void handleRequest(LaunchTarget var1) throws Throwable;
    }

    public class LaunchTarget {
        private DownloadManager dm;
        private DiskManagerFileInfo file_info;

        private LaunchTarget(DownloadManager downloadManager) {
            this.dm = downloadManager;
        }

        private LaunchTarget(DiskManagerFileInfo diskManagerFileInfo) {
            this.file_info = diskManagerFileInfo;
            this.dm = this.file_info.getDownloadManager();
        }

        public DownloadManager getDownload() {
            return this.dm;
        }

        public DiskManagerFileInfo getFile() {
            return this.file_info;
        }
    }
}

