/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gudy.azureus2.core3.util.Debug;

public class DeleteFileOnCloseInputStream
extends InputStream {
    private InputStream in;
    private File file;
    private boolean closed;
    private long pos;
    private long mark;

    public DeleteFileOnCloseInputStream(File file) throws IOException {
        this.file = file;
        this.in = new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.in.close();
            Object var2_1 = null;
            if (this.file.delete()) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.file.delete()) throw throwable;
            Debug.out("Failed to delete file '" + this.file + "'");
            throw throwable;
        }
        Debug.out("Failed to delete file '" + this.file + "'");
    }

    public int read() throws IOException {
        int n = this.in.read();
        ++this.pos;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.read(byArray, 0, byArray.length);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.pos += (long)n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        this.pos += l2;
        return l2;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public synchronized void mark(int n) {
        this.mark = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.in.close();
        this.in = new FileInputStream(this.file);
        this.in.skip(this.mark);
        this.pos = this.mark;
    }

    public boolean markSupported() {
        return true;
    }

    public File getFile() {
        return this.file;
    }
}

